/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class Signatures {
    public static String signAndEnvelop(String data, PrivateKey key, X509Certificate cert) throws IOException, SignatureException {
        String envelopedText = "<SignedData>" + data.trim() + "</SignedData>";
        Document document = Signatures.fromString(envelopedText);
        Element docRoot = document.getDocumentElement();
        docRoot.setAttribute("ContentElement", docRoot.getFirstChild().getNodeName());
        DOMSignContext signingContext = new DOMSignContext(key, (Node)docRoot);
        XMLSignatureFactory sigFactory = XMLSignatureFactory.getInstance("DOM");
        Reference sigRef = null;
        try {
            DigestMethod digest = sigFactory.newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256", null);
            TransformParameterSpec transformSpec = null;
            Transform transform = sigFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", transformSpec);
            sigRef = sigFactory.newReference("", digest, Collections.singletonList(transform), null, null);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalStateException("Failed to resolve algorithm", nsae);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new IllegalStateException("Failed to use algorhtm", iape);
        }
        SignedInfo info = null;
        try {
            C14NMethodParameterSpec methodSpec = null;
            CanonicalizationMethod canonicalizer = sigFactory.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", methodSpec);
            SignatureMethod sigMethod = sigFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null);
            info = sigFactory.newSignedInfo(canonicalizer, sigMethod, Collections.singletonList(sigRef));
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalStateException("Failed to resolve algorithm", nsae);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new IllegalStateException("Failed to use algorithm", iape);
        }
        KeyInfoFactory infoFactory = sigFactory.getKeyInfoFactory();
        X509IssuerSerial keySerial = infoFactory.newX509IssuerSerial(cert.getIssuerX500Principal().getName(), cert.getSerialNumber());
        X509Data keyData = infoFactory.newX509Data(Collections.singletonList(keySerial));
        KeyInfo keyInfo = infoFactory.newKeyInfo(Collections.singletonList(keyData));
        XMLSignature signature = sigFactory.newXMLSignature(info, keyInfo);
        try {
            signature.sign(signingContext);
        }
        catch (MarshalException me) {
            throw new SignatureException("Failed to construct signed data", me);
        }
        catch (XMLSignatureException xmlse) {
            throw new SignatureException("Failed to sign data", xmlse);
        }
        return Signatures.toString(docRoot, true);
    }

    public static String verifyAndExtract(String data, Collection<X509Certificate> certs) throws IOException, SignatureException {
        Document document = Signatures.fromString(data);
        Element docRoot = document.getDocumentElement();
        if (!docRoot.getTagName().equals("SignedData")) {
            throw new IllegalArgumentException("Unexpecetd XML structure");
        }
        String contentRootName = docRoot.getAttribute("ContentElement");
        if (contentRootName.isEmpty()) {
            throw new IllegalArgumentException("No content element reference");
        }
        NodeList nl = document.getElementsByTagName(contentRootName);
        if (nl.getLength() != 1) {
            throw new IllegalArgumentException("Failed to resolve content root");
        }
        Element contentRoot = (Element)nl.item(0);
        nl = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nl.getLength() != 1) {
            throw new IllegalArgumentException("Cannot find Signature element");
        }
        DOMValidateContext validatingContext = new DOMValidateContext(new IssuerKeySelector(certs), nl.item(0));
        XMLSignatureFactory sigFactory = XMLSignatureFactory.getInstance("DOM");
        XMLSignature signature = null;
        try {
            signature = sigFactory.unmarshalXMLSignature(validatingContext);
        }
        catch (MarshalException me) {
            throw new IOException("Failed to demarshal signature content", me);
        }
        try {
            if (!signature.validate(validatingContext)) {
                throw new SignatureException("Signature validation failed");
            }
        }
        catch (XMLSignatureException xmlse) {
            throw new SignatureException("Signature validation failed", xmlse);
        }
        return Signatures.toString(contentRoot, false);
    }

    public static String extract(String data) throws IOException {
        Document document = Signatures.fromString(data);
        Element docRoot = document.getDocumentElement();
        if (!docRoot.getTagName().equals("SignedData")) {
            throw new IllegalArgumentException("Unexpecetd XML structure");
        }
        String contentRootName = docRoot.getAttribute("ContentElement");
        if (contentRootName.isEmpty()) {
            throw new IllegalArgumentException("No content element reference");
        }
        NodeList nl = document.getElementsByTagName(contentRootName);
        if (nl.getLength() != 1) {
            throw new IllegalArgumentException("Failed to resolve content root");
        }
        Element contentRoot = (Element)nl.item(0);
        return Signatures.toString(contentRoot, false);
    }

    private static Document fromString(String data) throws IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try (ByteArrayInputStream input = new ByteArrayInputStream(data.getBytes());){
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document document = builder.parse(input);
            return document;
        }
    }

    private static String toString(Element element, boolean includeHeader) throws IOException {
        StringWriter output = new StringWriter();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerException te) {
            throw new IOException("Failed to create XML transformer", te);
        }
        if (!includeHeader) {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        transformer.setOutputProperty("standalone", "yes");
        try {
            transformer.transform(new DOMSource(element), new StreamResult(output));
        }
        catch (TransformerException te) {
            throw new IOException("Failed to transform XML to a string", te);
        }
        return output.toString();
    }

    private static class KeySelectorResultImpl
    implements KeySelectorResult {
        private final Key key;

        KeySelectorResultImpl(Key key) {
            this.key = key;
        }

        @Override
        public Key getKey() {
            return this.key;
        }
    }

    private static class IssuerKeySelector
    extends KeySelector {
        private final Map<String, X509Certificate> certificates = new HashMap<String, X509Certificate>();

        IssuerKeySelector(Collection<X509Certificate> certs) {
            for (X509Certificate cert : certs) {
                this.addCertificate(cert);
            }
        }

        void addCertificate(X509Certificate certificate) {
            String issuer = certificate.getIssuerX500Principal().getName();
            BigInteger serial = certificate.getSerialNumber();
            this.certificates.put(IssuerKeySelector.getIdString(issuer, serial), certificate);
        }

        @Override
        public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
            if (keyInfo == null || purpose != KeySelector.Purpose.VERIFY) {
                throw new KeySelectorException("Cannot supply a result");
            }
            for (XMLStructure xmlStructure : keyInfo.getContent()) {
                if (!(xmlStructure instanceof X509Data)) continue;
                for (Object data : ((X509Data)xmlStructure).getContent()) {
                    X509IssuerSerial issuerSerial;
                    String key;
                    X509Certificate cert;
                    if (!(data instanceof X509IssuerSerial) || (cert = this.certificates.get(key = IssuerKeySelector.getIdString((issuerSerial = (X509IssuerSerial)data).getIssuerName(), issuerSerial.getSerialNumber()))) == null) continue;
                    return new KeySelectorResultImpl(cert.getPublicKey());
                }
            }
            throw new KeySelectorException("No applicable keys were found");
        }

        private static String getIdString(String issuer, BigInteger serial) {
            return issuer + "/" + serial.toString();
        }
    }
}

