/*
 * Decompiled with CFR 0.152.
 */
package com.onseven.dbvis;

import com.onseven.dbvis.eb.h;
import com.onseven.dbvis.eb.k;
import com.onseven.dbvis.eb.l;
import com.onseven.dbvis.eb.m;
import com.onseven.dbvis.fb.b;
import com.onseven.dbvis.fb.c.b.b;
import com.onseven.dbvis.fb.d;
import com.onseven.dbvis.fb.n;
import com.onseven.dbvis.fb.r;
import com.onseven.dbvis.g;
import com.onseven.dbvis.l.c.j;
import com.onseven.dbvis.l.d.c.b.b.w;
import com.onseven.dbvis.l.d.c.b.e;
import com.onseven.dbvis.l.d.c.f;
import com.onseven.dbvis.l.d.c.i;
import com.onseven.dbvis.l.d.d.c.c;
import com.onseven.dbvis.l.d.t;
import com.onseven.dbvis.sql.q;
import com.onseven.dbvis.util.ab;
import com.onseven.dbvis.util.h.p;
import com.onseven.dbvis.util.h.s;
import com.onseven.dbvis.util.o;
import com.onseven.dbvis.util.x;
import java.io.Console;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public class DbVisualizerCmd
extends g {
    private static DbVisualizerCmd instance;
    private com.onseven.dbvis.db.j.i dbConnection;
    private PrintWriter outputWriter;
    private static final Logger LOG;
    private static final boolean DO_NOT_CATCH_SYSTEM_STREAMS = true;
    private File currentFile;

    public static void main(String[] stringArray) {
        DbVisualizerCmd dbVisualizerCmd = new DbVisualizerCmd(new com.onseven.dbvis.util.q(stringArray));
        dbVisualizerCmd.runCmd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runCmd() {
        int n2;
        com.onseven.dbvis.util.q q2 = (com.onseven.dbvis.util.q)DbVisualizerCmd.getArgumentParser();
        if (q2.jc()) {
            int n3 = this.convertDson(q2);
            this.exit(n3);
            return;
        }
        if (q2.pb()) {
            int n4 = this.formatDson(q2);
            this.exit(n4);
            return;
        }
        if (q2.pc()) {
            int n5 = this.listDson(q2);
            this.exit(n5);
            return;
        }
        try {
            this.initialize();
        }
        catch (Throwable throwable) {
            System.err.println("DbVisualizerCmd - Initialize Error: " + o.n(throwable.getMessage()));
            this.cleanUpForExit();
            this.exit(2);
        }
        if (q2.bc()) {
            Iterator<com.onseven.dbvis.sql.p> iterator = this.getConnections().iterator();
            System.out.println("Connections:\n");
            while (iterator.hasNext()) {
                System.out.println(iterator.next());
            }
            this.exit(0);
            return;
        }
        try {
            this.connect();
        }
        catch (Throwable throwable) {
            System.err.println("DbVisualizerCmd - Connect Error: " + o.n(throwable.getMessage()));
            this.cleanUpForExit();
            this.exit(2);
        }
        try {
            n2 = this.execute();
        }
        catch (Throwable throwable) {
            System.err.println("DbVisualizerCmd - " + throwable);
            this.cleanUpForExit();
            try {
                this.disconnect();
            }
            finally {
                n2 = 2;
                this.exit(2);
            }
        }
        try {
            this.disconnect();
        }
        catch (Throwable throwable) {
            System.err.println("DbVisualizerCmd - Disconnect Error: " + o.n(throwable.getMessage()));
            this.cleanUpForExit();
            n2 = 2;
            this.exit(2);
        }
        this.shutdown(n2);
    }

    public DbVisualizerCmd(ab ab2) {
        super(ab2, false);
        instance = this;
    }

    public static DbVisualizerCmd getApplication() {
        return instance;
    }

    public void shutdown(int n2) {
        this.cleanUpForExit();
        this.exit(n2);
    }

    @Override
    protected void initialize() {
        b.b(false);
        super.initialize();
        if (!r.c().r().fc()) {
            throw new IllegalStateException("The DbVisualizer command line interface is available only in DbVisualizer Pro");
        }
        d.ifb();
        r.c().d().q().b(new _c(r.c().d().q()));
        r.c().e().b(this);
    }

    @Override
    protected void showEULA() {
    }

    @Override
    protected void initLogging(int n2) {
        com.onseven.dbvis.util.q q2 = (com.onseven.dbvis.util.q)DbVisualizerCmd.getArgumentParser();
        String string = q2.lc();
        boolean bl = q2.sb();
        boolean bl2 = true;
        if (this.canUseLogFile(string)) {
            bl2 = false;
        }
        String string2 = p.g(p.j);
        if (bl) {
            string2 = p.g(p.e);
        }
        Level level = Level.parse(string2);
        try {
            String string3 = q2.vb();
            if (!x.f(string3)) {
                string3 = null;
            }
            com.onseven.dbvis.util.h.h.b().b(level, bl2, string, n2, true, string3);
        }
        catch (s s2) {
            System.err.println("DbVisualizerCmd - Could not initiate logging. Note that this will not affect the functionality. Reason(s):");
            StringBuilder stringBuilder = new StringBuilder();
            int n3 = 0;
            Iterator iterator = ExceptionUtils.getThrowableList((Throwable)s2).iterator();
            while (iterator.hasNext()) {
                Throwable throwable = (Throwable)iterator.next();
                stringBuilder.append(n3).append(": ").append(throwable);
                if (iterator.hasNext()) {
                    stringBuilder.append("\n");
                }
                ++n3;
            }
            System.err.println(stringBuilder.toString());
            ExceptionUtils.printRootCauseStackTrace((Throwable)s2, (PrintStream)System.err);
        }
    }

    private boolean canUseLogFile(String string) {
        if (x.f(string)) {
            File file = new File(string);
            File file2 = file.getParentFile();
            if (file2 == null) {
                file2 = new File(System.getProperty("user.dir"));
            }
            return file2.isDirectory();
        }
        return false;
    }

    protected void connect() {
        com.onseven.dbvis.util.q q2 = (com.onseven.dbvis.util.q)DbVisualizerCmd.getArgumentParser();
        try {
            this.dbConnection = this.connect(q2);
        }
        catch (q q3) {
            throw new IllegalStateException("Connecting: " + q3.getMessage());
        }
        if (this.dbConnection == null) {
            throw new IllegalStateException("Connecting: The '" + q2.rb() + "' connection was not found. Use the -listconnections option to see available connections or specify appropriate options to establish an anonymous connection");
        }
    }

    private int execute() {
        com.onseven.dbvis.l.d.d.t t2;
        l l2;
        int n2 = 0;
        com.onseven.dbvis.util.q q2 = (com.onseven.dbvis.util.q)DbVisualizerCmd.getArgumentParser();
        try {
            l2 = this.getScriptSources(q2);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Reading the script: " + iOException.getMessage());
        }
        try {
            this.outputWriter = this.createOutPutWriter(q2);
            t2 = this.createExecutionLogHandler(q2);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Log file \"" + q2.lc() + "\" is not writable");
        }
        String string = this.dbConnection.oc().b().e();
        String string2 = q2.mc();
        boolean bl = this.dbConnection.oc().t().getBool("SQLCommanderStripComments");
        boolean bl2 = string2 != null ? Boolean.parseBoolean(string2) : bl;
        h h2 = new h(string);
        h2.d(bl2);
        h2.c(l2);
        long l3 = q2.wb();
        int n3 = q2.ob();
        String string3 = this.getCatalog(q2, this.dbConnection);
        String string4 = q2.ub() != null ? q2.ub() : this.dbConnection.sb();
        i._c _c2 = i._c.l;
        String string5 = this.dbConnection.x();
        boolean bl3 = q2.mb();
        boolean bl4 = q2.zb();
        boolean bl5 = q2.tb();
        com.onseven.dbvis.s.i i2 = new com.onseven.dbvis.s.i();
        boolean bl6 = q2.rc().equals("result") || q2.rc().equals("all");
        _b _b2 = this.createCallback(l3, n3, bl6);
        i i3 = new i(false, _b2, null, t2, 0L);
        i3.b(f._b.c);
        i3.b(this.dbConnection, string3, string4, h2, _c2, string5, false, bl3, bl4, bl5, true, i2, this.currentFile, "Executing Command Line");
        try {
            i3.s();
            t t3 = i3.mxb();
            if (t3.x()) {
                n2 = 3;
            } else if (t3.u() > 0) {
                n2 = 4;
            }
        }
        catch (com.onseven.dbvis.l.d.r r2) {
            LOG.log(Level.WARNING, "Exception when running script", r2);
            throw new IllegalStateException("Executing script: " + r2.getMessage());
        }
        finally {
            if (t2 != null) {
                try {
                    t2.close();
                }
                catch (IOException iOException) {}
            }
            if (this.outputWriter != null) {
                this.outputWriter.close();
                this.outputWriter = null;
            }
        }
        return n2;
    }

    protected _b createCallback(long l2, int n2, boolean bl) {
        return new _b(l2, n2, bl);
    }

    protected void exit(int n2) {
        System.exit(n2);
    }

    protected void disconnect() {
        try {
            if (this.dbConnection != null) {
                this.dbConnection.oc().m().f(false);
                this.dbConnection = null;
            }
        }
        catch (q q2) {
            throw new IllegalStateException("Disconnecting: " + q2.getMessage());
        }
    }

    private String getCatalog(com.onseven.dbvis.util.q q2, com.onseven.dbvis.db.j.i i2) {
        String string = q2.fc() != null ? q2.fc() : i2.qc();
        return string;
    }

    private List<com.onseven.dbvis.sql.p> getConnections() {
        return r.c().d().u().vwb();
    }

    private PrintWriter createOutPutWriter(com.onseven.dbvis.util.q q2) throws IOException {
        PrintWriter printWriter;
        if (q2.rc().equals("none")) {
            return null;
        }
        if (q2.qc() != null) {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(q2.qc()));
            printWriter = new PrintWriter(fileOutputStream);
        } else {
            printWriter = new PrintWriter((Writer)new OutputStreamWriter(System.out), true);
        }
        return printWriter;
    }

    private com.onseven.dbvis.l.d.d.t createExecutionLogHandler(com.onseven.dbvis.util.q q2) throws IOException {
        com.onseven.dbvis.l.d.d.r r2 = new com.onseven.dbvis.l.d.d.r();
        r2.d(true);
        com.onseven.dbvis.l.d.d.t t2 = com.onseven.dbvis.l.d.d.k.c().b("dbviscmd", r2, "");
        if (this.shallLogCommands(q2)) {
            com.onseven.dbvis.l.d.d.c.g g2 = this.initLogTextOptions(q2);
            c c2 = new c(this.getLogHandlerPrintWriter(), r2, g2);
            t2.c(c2);
        }
        return t2;
    }

    protected PrintWriter getLogHandlerPrintWriter() throws IOException {
        return this.outputWriter;
    }

    protected com.onseven.dbvis.l.d.d.c.g initLogTextOptions(com.onseven.dbvis.util.q q2) {
        return com.onseven.dbvis.l.d.c.b.b.s.md();
    }

    protected boolean shallLogCommands(com.onseven.dbvis.util.q q2) {
        String string = q2.rc();
        return !string.equals("none") && !string.equals("result");
    }

    private l getScriptSources(com.onseven.dbvis.util.q q2) throws IOException {
        Object object;
        String string;
        l l2;
        com.onseven.dbvis.eb.i i2;
        String string2 = null;
        String string3 = System.getProperty("user.dir");
        String string4 = q2.cc();
        if (string4 != null) {
            if (string4.trim().isEmpty()) {
                throw new IllegalStateException("The command for the -sql parameter must not be empty");
            }
            i2 = new m(string4);
            l2 = new l(string4);
        } else {
            string = q2.gc();
            object = new File(string);
            if (!((File)object).exists()) {
                throw new IllegalStateException("The -sqlfile parameter refers '" + string + "' that doesn't exist");
            }
            if (((File)object).length() == 0L) {
                throw new IllegalStateException("The -sqlfile parameter requires a file with content");
            }
            this.currentFile = object;
            string2 = q2.oc();
            i2 = new com.onseven.dbvis.eb.g((File)object, string2);
            l2 = new l(i2);
            string3 = ((File)object).getParent();
        }
        string = this.dbConnection.oc().b().e();
        object = new h(string, i2);
        Vector<k> vector = ((h)object).f();
        if (i2 instanceof com.onseven.dbvis.eb.g) {
            ((com.onseven.dbvis.eb.g)i2).r();
            if (vector.size() > 50000) {
                System.out.println("\nIf the file you specified with -sqlfile does not contain any @run commands, it will be processed much faster if you use -sql \"@run <fileName>\". Use Ctrl-C to stop and rerun with -sql\n");
            }
        }
        ArrayList<com.onseven.dbvis.eb.g> arrayList = null;
        int n2 = 0;
        f f2 = new f();
        Enumeration<k> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            k k2 = enumeration.nextElement();
            String string5 = k2.f();
            com.onseven.dbvis.l.d.c.b.c c2 = e.c();
            com.onseven.dbvis.l.d.c.b.d d2 = c2.b(null, string5, f2);
            com.onseven.dbvis.eb.g g2 = null;
            if (d2 != null) {
                if (d2.qc().b(com.onseven.dbvis.l.d.c.b.f.cb.c())) {
                    string3 = d2.oc();
                } else if (d2.qc().b(com.onseven.dbvis.l.d.c.b.f.j.c())) {
                    String string6 = n.j().getProperty("VariableIdentifierPrefix");
                    w w2 = (w)d2;
                    g2 = w2.b(string6, string3, string2);
                }
            }
            if (g2 != null) {
                if (arrayList == null) {
                    arrayList = new ArrayList<com.onseven.dbvis.eb.g>();
                    l2.b(arrayList);
                }
                arrayList.add(g2);
            }
            if (++n2 % 10000 != 0) continue;
            System.out.println("Scanned " + (n2 - 1) + " of " + vector.size() + " statements for @run commands");
        }
        return l2;
    }

    private com.onseven.dbvis.db.j.i connect(com.onseven.dbvis.util.q q2) throws q {
        com.onseven.dbvis.db.j.i i2;
        Object object;
        Object object2;
        if (q2.ec()) {
            object2 = this.createTmpAlias();
            object = q2.nc();
            String string = q2.dc();
            String string2 = q2.nb();
            if (object == null && string != null && string2 != null) {
                object = (String)object2 + "-driver";
            }
            i2 = com.onseven.dbvis.db.j.i.b((String)object, string, q2.hc(), (String)object2, string2, q2.qb(), q2.xb(), "jdbc");
        } else {
            i2 = com.onseven.dbvis.db.j.i.b(null, null, null, q2.rb(), null, q2.qb(), q2.xb(), "jdbc");
            if (i2 != null && q2.xb() != null && (object2 = i2.oc()) != null) {
                ((com.onseven.dbvis.sql.p)object2).t().setProperty("ConnectionPassword", "ClearAtDisconnect");
            }
        }
        if (i2 != null) {
            i2.e(false);
            object2 = this.getCatalog(q2, i2);
            Object object3 = object = object2 != null ? i2.oc().f((String)object2) : i2.oc();
            if (!i2.equals(((com.onseven.dbvis.sql.p)object).m())) {
                ((com.onseven.dbvis.sql.p)object).b(false);
                i2 = ((com.onseven.dbvis.sql.p)object).m();
            }
        }
        return i2;
    }

    protected String createTmpAlias() {
        return "dbviscommand-" + r.c().s();
    }

    private int listDson(com.onseven.dbvis.util.q q2) {
        final boolean bl = q2.yb();
        String string = q2.sc();
        File file = new File(string);
        if (!file.isDirectory()) {
            System.out.println("Not an accessible directory " + string);
            return 2;
        }
        final FastDateFormat fastDateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
        com.onseven.dbvis.util.l.g g2 = new com.onseven.dbvis.util.l.g(){

            @Override
            protected void b(File file, com.onseven.dbvis.util.l.k k2) {
                long l2 = file.lastModified();
                String string = fastDateFormat.format(l2);
                String string2 = bl ? file.getAbsolutePath() : file.getName();
                String string3 = k2.f().name();
                System.out.println(String.format("%-12s %-5s %-7s", string, string3, string2));
            }
        };
        Path path = Paths.get(string, new String[0]);
        try {
            g2.b(path, bl);
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, "Got exception when listing DSON files file", iOException);
        }
        return 0;
    }

    private int convertDson(com.onseven.dbvis.util.q q2) {
        int n2 = 2;
        PrintWriter printWriter = new PrintWriter(System.out);
        String string = q2.kc();
        File file = new File(string);
        if (!file.isFile()) {
            System.out.println("Not an accessible file " + string);
            return n2;
        }
        com.onseven.dbvis.l.d.d.c.g g2 = new com.onseven.dbvis.l.d.d.c.g(null);
        g2.e(true);
        g2.c(true);
        g2.b(false);
        g2.u();
        try {
            com.onseven.dbvis.l.d.d.k.c().b(file, printWriter, null, g2);
            n2 = 0;
        }
        catch (Exception exception) {
            LOG.log(Level.INFO, "Got exception when converting json file", exception);
        }
        return n2;
    }

    private int formatDson(com.onseven.dbvis.util.q q2) {
        int n2 = 2;
        PrintWriter printWriter = new PrintWriter(System.out);
        String string = q2.lb();
        File file = new File(string);
        if (!file.isFile()) {
            System.out.println("Not an accessible file: " + string);
            return n2;
        }
        com.onseven.dbvis.util.l.c c2 = new com.onseven.dbvis.util.l.c();
        try {
            c2.b(file.getAbsolutePath(), printWriter);
            printWriter.flush();
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, "Got exception when formatting json file", iOException);
        }
        return n2;
    }

    static {
        LOG = Logger.getLogger(DbVisualizerCmd.class.getName());
    }

    private static class _c
    extends b._b._b {
        _c(b._b _b2) {
            super(_b2);
        }

        @Override
        public void b() {
            char[] cArray;
            com.onseven.dbvis.util.q q2 = (com.onseven.dbvis.util.q)DbVisualizerCmd.getArgumentParser();
            String string = q2.ic();
            if (string != null) {
                cArray = string.toCharArray();
                if (!this.b(cArray)) {
                    throw new IllegalArgumentException("Invalid Master Password provided with -masterpw");
                }
            } else {
                System.out.println("Please enter the Master Password: ");
                Console console = System.console();
                cArray = console.readPassword();
                while (!this.b(cArray)) {
                    System.out.println("Invalid Master Password. Please try again: ");
                    cArray = console.readPassword();
                }
            }
            this.c.b(cArray);
            Arrays.fill(cArray, ' ');
        }
    }

    protected class _b
    implements com.onseven.dbvis.l.d.c {
        private long c;
        private int e;
        private final boolean d;

        _b(long l2, int n2, boolean bl) {
            this.c = l2;
            this.e = n2;
            this.d = bl;
        }

        @Override
        public long b() {
            return this.c;
        }

        @Override
        public int c() {
            return this.e;
        }

        @Override
        public void b(com.onseven.dbvis.l.c.d d2) {
            if (d2 != null && d2.getRowCount() > 0 && DbVisualizerCmd.this.outputWriter != null && this.d) {
                this.b(d2, DbVisualizerCmd.this.outputWriter);
            }
        }

        @Override
        public void b(com.onseven.dbvis.sql.b.b b2) {
            throw new UnsupportedOperationException("Not supported.");
        }

        private void b(com.onseven.dbvis.l.c.d d2, PrintWriter printWriter) {
            j j2 = new j(d2, true);
            while (j2.hasNext()) {
                StringBuffer stringBuffer = j2.f();
                if (stringBuffer == null) continue;
                printWriter.println(stringBuffer);
            }
        }
    }
}

