/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.macos.macho;

import com.install4j.runtime.installer.platform.macos.macho.SegmentCommand;
import java.io.IOException;
import java.nio.ByteBuffer;

class Segment32Command
extends SegmentCommand {
    private int vmaddr;
    private int vmsize;
    private int fileoff;
    private int filesize;
    private int maxprot;
    private int initprot;
    private int nsects;
    private int flags;

    public Segment32Command(int length) {
        super(length);
    }

    @Override
    public void readData(ByteBuffer buf, boolean bit64) throws IOException {
        buf.get(this.segmentName);
        this.vmaddr = buf.getInt();
        this.vmsize = buf.getInt();
        this.fileoff = buf.getInt();
        this.filesize = buf.getInt();
        this.maxprot = buf.getInt();
        this.initprot = buf.getInt();
        this.nsects = buf.getInt();
        this.flags = buf.getInt();
    }

    @Override
    public void writeData(ByteBuffer buf, boolean bit64) throws IOException {
        buf.put(this.segmentName);
        buf.putInt(this.vmaddr);
        buf.putInt(this.vmsize);
        buf.putInt(this.fileoff);
        buf.putInt(this.filesize);
        buf.putInt(this.maxprot);
        buf.putInt(this.initprot);
        buf.putInt(this.nsects);
        buf.putInt(this.flags);
    }

    @Override
    public long getVmsize() {
        return this.vmsize;
    }

    @Override
    public void setVmsize(long vmsize) {
        this.vmsize = (int)vmsize;
    }

    @Override
    public long getFilesize() {
        return this.filesize;
    }

    @Override
    public void setFilesize(long filesize) {
        this.filesize = (int)filesize;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public String toString() {
        return "Segment32Command{segmentName=" + this.getSegmentName() + ", vmaddr=" + this.vmaddr + ", vmsize=" + this.vmsize + ", fileoff=" + this.fileoff + ", filesize=" + this.filesize + ", maxprot=" + this.maxprot + ", initprot=" + this.initprot + ", nsects=" + this.nsects + ", flags=" + this.flags + '}';
    }
}

