/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.fileinst;

import com.install4j.api.context.UninstallMode;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class InstallFile
extends File {
    private boolean shared = false;
    private UninstallMode uninstallMode = UninstallMode.IF_CREATED;
    private int rollbackId;
    private List<Command> preUninstallCommands;

    public InstallFile(File file, boolean shared) {
        super(file.getParent(), file.getName());
        this.shared = shared;
    }

    public InstallFile(File file, boolean shared, UninstallMode uninstallMode) {
        super(file.getParent(), file.getName());
        this.shared = shared;
        this.uninstallMode = uninstallMode;
    }

    public InstallFile(String pathname, boolean shared, UninstallMode uninstallMode) {
        super(pathname);
        this.shared = shared;
        this.uninstallMode = uninstallMode;
    }

    public InstallFile(String parent, String child, boolean shared, UninstallMode uninstallMode) {
        super(parent, child);
        this.shared = shared;
        this.uninstallMode = uninstallMode;
    }

    public InstallFile(File parent, String child, boolean shared, UninstallMode uninstallMode) {
        super(parent, child);
        this.shared = shared;
        this.uninstallMode = uninstallMode;
    }

    public InstallFile(String pathname) {
        super(pathname);
    }

    public InstallFile(String parent, String child) {
        super(parent, child);
    }

    public InstallFile(File parent, String child) {
        super(parent, child);
    }

    public int getRollbackId() {
        return this.rollbackId;
    }

    public void setRollbackId(int rollbackId) {
        this.rollbackId = rollbackId;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public UninstallMode getUninstallMode() {
        return this.uninstallMode;
    }

    public void setUninstallMode(UninstallMode uninstallMode) {
        this.uninstallMode = uninstallMode;
    }

    public boolean checkUninstall(boolean uninstallForUpgrade) {
        if (this.uninstallMode == UninstallMode.NEVER) {
            return false;
        }
        return !uninstallForUpgrade || this.uninstallMode != UninstallMode.IF_CREATED_BUT_NOT_FOR_UPDATE && this.uninstallMode != UninstallMode.ALWAYS_BUT_NOT_FOR_UPDATE;
    }

    public List<Command> getPreUninstallCommands() {
        return this.preUninstallCommands == null ? Collections.emptyList() : this.preUninstallCommands;
    }

    public void addPreUninstallCommand(Command command) {
        if (this.preUninstallCommands == null) {
            this.preUninstallCommands = new ArrayList<Command>();
        }
        if (!this.preUninstallCommands.contains(command)) {
            this.preUninstallCommands.add(command);
        }
    }

    public void updatePreUninstallCommands(List<Command> preUninstallCommands) {
        this.preUninstallCommands = preUninstallCommands != null && preUninstallCommands.isEmpty() ? null : preUninstallCommands;
    }

    public static class Command {
        private final boolean adminRights;
        private final String executable;
        @NotNull
        private final String[] arguments;

        public Command(boolean adminRights, String executable, @NotNull String[] arguments) {
            this.adminRights = adminRights;
            this.executable = executable;
            this.arguments = arguments;
        }

        public boolean isAdminRights() {
            return this.adminRights;
        }

        public String getExecutable() {
            return this.executable;
        }

        @NotNull
        public String[] getArguments() {
            return this.arguments;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Command command = (Command)o;
            if (this.adminRights != command.adminRights) {
                return false;
            }
            if (!this.executable.equals(command.executable)) {
                return false;
            }
            return Arrays.equals(this.arguments, command.arguments);
        }

        public int hashCode() {
            int result = this.adminRights ? 1 : 0;
            result = 31 * result + this.executable.hashCode();
            result = 31 * result + Arrays.hashCode(this.arguments);
            return result;
        }
    }
}

