/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.config;

import com.install4j.api.Util;
import com.install4j.api.beans.Bean;
import com.install4j.api.beans.ReplacementMode;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.AbstractConfig;
import com.install4j.runtime.installer.config.ActionBeanConfig;
import com.install4j.runtime.installer.config.GroupBeanConfig;
import com.install4j.runtime.installer.config.LinkActionBeanConfig;
import com.install4j.runtime.installer.config.LinkBeanConfig;
import com.install4j.runtime.installer.config.LinkGroupBeanConfig;
import com.install4j.runtime.installer.config.WrapperBeanConfig;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.helper.Install4jClassLoader;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.XmlHelper;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractBeanConfig
extends AbstractConfig
implements Cloneable {
    private static final String ELEMENT_STRING = "string";
    private static final String PROPERTY_SAX_PARSER_FACTORY = "javax.xml.parsers.SAXParserFactory";
    private static String oldSaxParserFactory;
    private static List<AbstractBeanConfig> batch;
    private static WeakHashMap<Bean, AbstractBeanConfig> allBeanConfigs;
    private static Map<String, List<AbstractBeanConfig>> actionsLists;
    @NotNull
    protected String id = "";
    protected String customizedId = "";
    protected String idNamespace = "";
    private Element javaElement;
    private String conditionClassName = "";
    private boolean rollbackBarrier = false;
    private int rollbackBarrierExitCode = 0;
    private Map<String, String> textOverrides = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finishBatch() {
        AbstractBeanConfig.forceInternalSaxParserFactory();
        try {
            final XMLDecoder xmlDecoder = AbstractBeanConfig.createBatchXmlDecoder();
            if (xmlDecoder == null) {
                return;
            }
            if (Util.isAix()) {
                xmlDecoder.setExceptionListener(new ExceptionListener(){

                    @Override
                    public void exceptionThrown(Exception e) {
                    }
                });
            }
            for (AbstractBeanConfig beanConfig : batch) {
                try {
                    Bean bean = GUIHelper.invokeOnEDT(new Callable<Bean>(){

                        @Override
                        public Bean call() throws Exception {
                            return (Bean)xmlDecoder.readObject();
                        }
                    });
                    allBeanConfigs.put(bean, beanConfig);
                    beanConfig.setBean(bean);
                }
                catch (Throwable e) {
                    Logger.getInstance().error(null, "Exception during instantiation of bean ID " + beanConfig.id);
                    InstallerUtil.reportException(e);
                    InstallerUtil.exit(1);
                }
            }
            batch.clear();
        }
        finally {
            AbstractBeanConfig.resetSaxParserFactory();
        }
    }

    private static XMLDecoder createBatchXmlDecoder() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<java class=\"java.beans.XMLDecoder\">");
        Iterator<AbstractBeanConfig> it = batch.iterator();
        while (it.hasNext()) {
            AbstractBeanConfig beanConfig = it.next();
            if (!beanConfig.isInstantiated()) {
                String javaElementString;
                try {
                    beanConfig.replaceRuntimeVariables();
                    javaElementString = XmlHelper.getString(XmlHelper.findChild(beanConfig.javaElement, null));
                }
                catch (IOException e) {
                    Logger.getInstance().error(null, "Exception during instantiation of bean ID " + beanConfig.id);
                    InstallerUtil.reportException(e);
                    InstallerUtil.exit(1);
                    return null;
                }
                javaElementString = InstallerVariables.replaceVariables(javaElementString, ReplacementMode.I18N_ONLY);
                buffer.append(javaElementString);
                continue;
            }
            it.remove();
        }
        buffer.append("</java>");
        return AbstractBeanConfig.createXMLDecoder(new ByteArrayInputStream(buffer.toString().getBytes(StandardCharsets.UTF_8)));
    }

    private static XMLDecoder createXMLDecoder(InputStream in) {
        return new XMLDecoder(in, null, null, (ClassLoader)Install4jClassLoader.getInstance());
    }

    public static void registerBean(@NotNull Bean bean, @NotNull AbstractBeanConfig beanConfig) {
        allBeanConfigs.put(bean, beanConfig);
    }

    public static void clearBeans() {
        batch.clear();
        allBeanConfigs.clear();
    }

    public static List<AbstractBeanConfig> getActionListBeans(String id) {
        return actionsLists.get(id);
    }

    public static AbstractBeanConfig readNestedBeanConfig(Element beanElement) {
        AbstractBeanConfig beanConfig = AbstractBeanConfig.createNestedBeanConfig(beanElement);
        if (beanConfig != null) {
            beanConfig.read(beanElement);
        }
        return beanConfig;
    }

    private static AbstractBeanConfig createNestedBeanConfig(Element beanElement) {
        String beanElementName = beanElement.getTagName();
        if (beanElementName.equalsIgnoreCase("action")) {
            return new ActionBeanConfig();
        }
        if (beanElementName.equalsIgnoreCase("group")) {
            return new GroupBeanConfig(false);
        }
        if (beanElementName.equalsIgnoreCase("overriddenBean")) {
            return new WrapperBeanConfig();
        }
        if (beanElementName.equalsIgnoreCase("link")) {
            if (AbstractBeanConfig.readAttribute(beanElement, "group", false)) {
                return new LinkGroupBeanConfig(false);
            }
            return new LinkActionBeanConfig();
        }
        return null;
    }

    public static String getId(Bean bean) {
        AbstractBeanConfig beanConfig = AbstractBeanConfig.getBeanConfig(bean);
        if (beanConfig != null) {
            return beanConfig.getDisplayedId();
        }
        return null;
    }

    public static AbstractBeanConfig getBeanConfig(Bean bean) {
        return allBeanConfigs.get(bean);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    public String getQualifiedId() {
        return this.getIdInNamespace(this.getId());
    }

    public String getCustomizedId() {
        return this.customizedId;
    }

    public String getDisplayedId() {
        return this.customizedId.length() == 0 ? this.id : this.customizedId;
    }

    public String getQualifiedDisplayedId() {
        return this.getIdInNamespace(this.getDisplayedId());
    }

    public String getIdNamespace() {
        return this.idNamespace;
    }

    public String getConditionClassName() {
        return this.conditionClassName;
    }

    public boolean isRollbackBarrier() {
        return this.rollbackBarrier;
    }

    public int getRollbackBarrierExitCode() {
        return this.rollbackBarrierExitCode;
    }

    public Map<String, String> getTextOverrides() {
        return this.textOverrides;
    }

    public abstract boolean isInstantiated();

    protected abstract void clearInstance();

    protected void setBean(Bean bean) {
    }

    public void batchInstantiate() {
        AbstractBeanConfig actualBeanConfig = null;
        if (this instanceof LinkBeanConfig) {
            actualBeanConfig = ((LinkBeanConfig)((Object)this)).getDelegate();
        } else if (!this.isInstantiated()) {
            actualBeanConfig = this;
        }
        if (actualBeanConfig != null) {
            batch.add(actualBeanConfig);
        }
    }

    public String getClassName() {
        Element objectElement = XmlHelper.findChild(this.javaElement, "object");
        if (objectElement != null) {
            return XmlHelper.readAttribute(objectElement, "class", "");
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bean instantiateBean(boolean suppressErrors) {
        AbstractBeanConfig.forceInternalSaxParserFactory();
        try {
            this.replaceRuntimeVariables();
            String javaElementString = XmlHelper.getString(this.javaElement);
            XMLDecoder xmlDecoder = AbstractBeanConfig.createXMLDecoder(new ByteArrayInputStream(javaElementString.getBytes(StandardCharsets.UTF_8)));
            Bean bean = (Bean)xmlDecoder.readObject();
            allBeanConfigs.put(bean, this);
            Bean bean2 = bean;
            return bean2;
        }
        catch (Throwable e) {
            if (!suppressErrors) {
                Logger.getInstance().error(null, "Exception during instantiation of bean ID " + this.getDisplayedId());
                InstallerUtil.reportException(e);
                InstallerUtil.exit(1);
            }
            Bean bean = null;
            return bean;
        }
        finally {
            AbstractBeanConfig.resetSaxParserFactory();
        }
    }

    private static void forceInternalSaxParserFactory() {
        oldSaxParserFactory = System.getProperty(PROPERTY_SAX_PARSER_FACTORY);
        System.setProperty(PROPERTY_SAX_PARSER_FACTORY, "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
    }

    private static void resetSaxParserFactory() {
        if (oldSaxParserFactory == null) {
            System.getProperties().remove(PROPERTY_SAX_PARSER_FACTORY);
        } else {
            System.setProperty(PROPERTY_SAX_PARSER_FACTORY, oldSaxParserFactory);
        }
    }

    private void replaceRuntimeVariables() {
        this.replaceRuntimeVariables(this.javaElement);
    }

    private void replaceRuntimeVariables(Element javaElement) {
        if (Objects.equals(javaElement.getTagName(), ELEMENT_STRING)) {
            Node textNode = javaElement.getFirstChild();
            if (textNode != null) {
                String content = InstallerVariables.replaceVariables(textNode.getNodeValue(), ReplacementMode.I18N_ONLY);
                textNode.setNodeValue(content);
            }
        } else {
            for (Element childElement : AbstractBeanConfig.childElements(javaElement)) {
                this.replaceRuntimeVariables(childElement);
            }
        }
    }

    @Override
    protected void read(Element element) {
        this.id = AbstractBeanConfig.readAttribute(element, "id", this.id);
        this.customizedId = AbstractBeanConfig.readAttribute(element, "customizedId", this.customizedId);
        this.idNamespace = AbstractBeanConfig.readAttribute(element, "idNamespace", this.idNamespace);
        this.rollbackBarrier = AbstractBeanConfig.readAttribute(element, "rollbackBarrier", this.rollbackBarrier);
        this.rollbackBarrierExitCode = AbstractBeanConfig.readAttribute(element, "rollbackBarrierExitCode", this.rollbackBarrierExitCode);
        this.conditionClassName = AbstractBeanConfig.readAttribute(element, "conditionClass", this.conditionClassName);
        this.javaElement = AbstractBeanConfig.findChild(element, "java");
        this.readTextOverrides(element);
        this.readActionLists(element);
    }

    private void readTextOverrides(Element element) {
        Element textOverridesElement = AbstractBeanConfig.findChild(element, "textOverrides");
        if (textOverridesElement != null) {
            for (Element propertyElement : AbstractBeanConfig.childElements(textOverridesElement)) {
                String propertyName = AbstractBeanConfig.readAttribute(propertyElement, "name", "");
                String propertyValue = AbstractBeanConfig.readAttribute(propertyElement, "value", "");
                if (propertyName.isEmpty()) continue;
                this.textOverrides.put(propertyName, propertyValue);
            }
        }
    }

    private void readActionLists(Element element) {
        Element actionListsElement = AbstractBeanConfig.findChild(element, "actionLists");
        if (actionListsElement != null) {
            for (Element actionListElement : AbstractBeanConfig.childElements(actionListsElement)) {
                String id = AbstractBeanConfig.readAttribute(actionListElement, "id", "");
                ArrayList<AbstractBeanConfig> actionBeanConfigs = new ArrayList<AbstractBeanConfig>();
                for (Element actionElement : AbstractBeanConfig.childElements(actionListElement)) {
                    AbstractBeanConfig beanConfig = AbstractBeanConfig.readNestedBeanConfig(actionElement);
                    if (beanConfig == null) continue;
                    actionBeanConfigs.add(beanConfig);
                }
                actionsLists.put(id, actionBeanConfigs);
            }
        }
    }

    public void addAllTo(Map<String, AbstractBeanConfig> id2BeanConfig) {
        String qualifiedId = this.getQualifiedId();
        String qualifiedDisplayedId = this.getQualifiedDisplayedId();
        id2BeanConfig.put(qualifiedId, this);
        if (!Objects.equals(qualifiedDisplayedId, qualifiedId)) {
            id2BeanConfig.put(qualifiedDisplayedId, this);
        }
    }

    protected String getIdInNamespace(String id) {
        if (this.idNamespace.length() > 0) {
            return this.idNamespace + ":" + id;
        }
        return id;
    }

    public AbstractBeanConfig clone() {
        try {
            AbstractBeanConfig clone = (AbstractBeanConfig)super.clone();
            clone.clearInstance();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        batch = new LinkedList<AbstractBeanConfig>();
        allBeanConfigs = new WeakHashMap();
        actionsLists = new HashMap<String, List<AbstractBeanConfig>>();
    }
}

