/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer;

import com.install4j.api.Util;
import com.install4j.api.beans.Bean;
import com.install4j.api.beans.ReplacementMode;
import com.install4j.api.beans.UndefinedVariableException;
import com.install4j.api.beans.VariableErrorHandling;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.context.Context;
import com.install4j.api.windows.WinFileSystem;
import com.install4j.runtime.beans.actions.misc.OverwriteStrategy;
import com.install4j.runtime.beans.actions.misc.VariableSelectionMode;
import com.install4j.runtime.beans.actions.properties.PropertiesFileEncoding;
import com.install4j.runtime.beans.actions.properties.PropertiesFileHelper;
import com.install4j.runtime.beans.actions.properties.PropertiesFileParameters;
import com.install4j.runtime.beans.actions.properties.TextProperties;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.VariableReplacer;
import com.install4j.runtime.installer.config.AbstractBeanConfig;
import com.install4j.runtime.installer.config.ApplicationBeanConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.VariableResourceBundleWrapper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.MsiHelper;
import com.install4j.runtime.installer.helper.VariableEncoding;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchBooleanAction;
import com.install4j.runtime.installer.helper.comm.actions.FetchObjectAction;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.platform.macos.VolumeInfo;
import com.install4j.runtime.installer.platform.unix.UnixSpecialDirs;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import com.install4j.runtime.launcher.integration.AutomaticUpdate;
import com.install4j.runtime.util.StringUtil;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallerVariables {
    private static final String RESPONSE_FILE_HEADER = "# install4j response file for ";
    private static final String MODULE_NAME = System.getProperty("exe4j.moduleName");
    private static final ThreadLocal<Object> LAST_VARIABLE_VALUE = new ThreadLocal();
    private static final VariableReplacer VARIABLE_REPLACER = new VariableReplacer(){

        @Override
        public Object getVariable(String variableName) {
            return InstallerVariables.getVariable(variableName);
        }

        @Override
        public String replaceVariables(String content, ReplacementMode replacementMode, VariableErrorHandlingDescriptor variableErrorHandlingDescriptor) {
            return InstallerVariables.replaceVariables(content, replacementMode, variableErrorHandlingDescriptor);
        }
    };
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");
    public static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("kkmmss");
    private static final Map<String, VariableReplacer> VARIABLE_REPLACERS = InstallerVariables.createVariableReplacers();
    public static final String INSTALLER_VARIABLE_VERBOSE = "installer variable";
    public static final String COMPILER_VARIABLE_VERBOSE = "compiler variable";
    public static final String I18N_KEY_VERBOSE = "i18n key";
    private static Map<String, Object> props = Collections.synchronizedMap(new TreeMap());
    private static Map<String, VariableProvider> variableProviders = Collections.synchronizedMap(new HashMap());
    private static Set<String> hiddenVariables = Collections.synchronizedSet(new HashSet());
    private static Set<String> responseFileVariables = Collections.synchronizedSet(new HashSet());
    private static Map<String, String> responseFileComments = Collections.synchronizedMap(new HashMap());
    private static boolean replaceInstallerAndCompilerVariables = false;
    private static boolean replaceI18nVariables = false;
    private static DesignTimeVariableProcessor designTimeVariableProcessor;
    private static DesignTimeTextOverrideProcessor designTimeTextOverrideProcessor;
    public static final String INSTALLER_PREFIX = "installer:";
    public static final String FORM_PREFIX = "form:";
    public static final String COMPILER_PREFIX = "compiler:";
    public static final String I18N_PREFIX = "i18n:";
    private static final List<String> RUNTIME_PREFIXES;
    private static final String VARFILE_SUFFIX = ".varfile";
    public static final String VARIABLE_PATHLIST_SEPARATOR = "sys.pathlistSeparator";
    public static final String VARIABLE_FILE_SEPARATOR = "sys.fileSeparator";
    public static final String VARIABLE_USER_HOME = "sys.userHome";
    public static final String VARIABLE_USER_NAME = "sys.userName";
    public static final String VARIABLE_TEMP_DIR = "sys.tempDir";
    public static final String VARIABLE_WORKING_DIR = "sys.workingDir";
    public static final String VARIABLE_WINDOWS_DIR = "sys.windowsDir";
    public static final String VARIABLE_SYSTEM32_DIR = "sys.system32Dir";
    public static final String VARIABLE_COMMON_DIR = "sys.commonDir";
    public static final String VARIABLE_PROGRAM_FILES_DIR = "sys.programFilesDir";
    public static final String VARIABLE_PROGRAM_DATA_DIR = "sys.programDataDir";
    public static final String VARIABLE_DESKTOP_DIR = "sys.desktopDir";
    public static final String VARIABLE_STARTMENU_DIR = "sys.startMenuDir";
    public static final String VARIABLE_PROGRAMS_DIR = "sys.programsDir";
    public static final String VARIABLE_STARTUP_DIR = "sys.startupDir";
    public static final String VARIABLE_SENDTO_DIR = "sys.sendToDir";
    public static final String VARIABLE_FONTS_DIR = "sys.fontsDir";
    public static final String VARIABLE_APPDATA_DIR = "sys.appdataDir";
    public static final String VARIABLE_DOCS_DIR = "sys.docsDir";
    public static final String VARIABLE_DOWNLOADS_DIR = "sys.downloadsDir";
    public static final String VARIABLE_TEMPLATES_DIR = "sys.templatesDir";
    public static final String VARIABLE_FAVORITES_DIR = "sys.favoritesDir";
    public static final String VARIABLE_LOCAL_APPDATA_DIR = "sys.localAppdataDir";
    public static final String VARIABLE_UPDATE_STORAGE_DIR = "sys.updateStorageDir";
    public static final String VARIABLE_AUTOMATIC_UPDATE = "sys.automaticUpdate";
    public static final String VARIABLE_INSTALLATION_DIR = "sys.installationDir";
    public static final String VARIABLE_CONTENT_DIR = "sys.contentDir";
    public static final String VARIABLE_RESOURCE_DIR = "sys.resourceDir";
    public static final String VARIABLE_MEDIA_FILE = "sys.mediaFile";
    public static final String VARIABLE_MEDIA_DIR = "sys.mediaDir";
    public static final String VARIABLE_INSTALLER_DIR = "sys.installerDir";
    public static final String VARIABLE_INSTALLER_FILE = "sys.installerFile";
    public static final String VARIABLE_INSTALLER_APPLICATION_MODE = "sys.installerApplicationMode";
    public static final String VARIABLE_PROGRAM_GROUP_DIR = "sys.programGroupDir";
    public static final String VARIABLE_PROGRAM_GROUP_NAME = "sys.programGroupName";
    public static final String VARIABLE_PROGRAM_GROUP_DISABLED = "sys.programGroupDisabled";
    public static final String VARIABLE_PROGRAM_GROUP_ALL_USERS = "sys.programGroupAllUsers";
    public static final String VARIABLE_SYMLINK_DIR = "sys.symlinkDir";
    public static final String VARIABLE_REBOOT_REQUIRED = "sys.rebootRequired";
    public static final String VARIABLE_PREFERRED_JRE = "sys.preferredJre";
    public static final String VARIABLE_INSTALLATION_TYPE_ID = "sys.installationTypeId";
    public static final String VARIABLE_VERSION = "sys.version";
    public static final String VARIABLE_LANGUAGE_ID = "sys.languageId";
    public static final String VARIABLE_LOGFILE = "sys.logFile";
    public static final String VARIABLE_RESPONSE_FILE = "sys.responseFile";
    public static final String VARIABLE_JAVA_HOME = "sys.javaHome";
    public static final String VARIABLE_JAVA_VERSION = "sys.javaVersion";
    public static final String VARIABLE_CONFIRMED_UPDATE_INSTALLATION = "sys.confirmedUpdateInstallation";
    public static final String VARIABLE_ADMIN_RIGHTS = "sys.adminRights";
    public static final String VARIABLE_UNDELETED_UNINSTALL_FILES = "sys.undeletedUninstallFiles";
    public static final String VARIABLE_OVERRIDDEN_TARGET_DIR = "sys.overriddenTargetDir";
    public static final String VARIABLE_ACTION_SUPPRESS_ROLLBACK = "sys.actionSuppressRollback";
    public static final String VARIABLE_FILE_RETRY_ALLOW_NO = "sys.fileRetryAllowNo";
    public static final String VARIABLE_ACTION_RETRY_DISABLE_IGNORE = "sys.actionRetryDisableIgnore";
    public static final String VARIABLE_ACTION_ERROR_MESSAGE_PREFIX = "sys.actionErrorMessagePrefix";
    public static final String VARIABLE_ACTION_FAILURE_UNATTENDED_QUIT = "sys.actionFailureUnattendedQuit";
    public static final String VARIABLE_RESOLVE_USER_SPECIFIC = "sys.resolveUserSpecificInstallationDir";
    public static final String VARIABLE_DATE = "sys.date";
    public static final String VARIABLE_TIME = "sys.time";
    public static final String VARIABLE_TIMESTAMP = "sys.timestamp";
    public static final String VARIABLE_MSI_ALL_USERS = "sys.msiAllUsers";
    private static boolean installationDirectoryFromCommandLine;
    private static Collection<String> commandLineVariableNames;
    private static boolean replaceHiddenVariables;
    private static List<String> replacementRecording;
    private static boolean adminRightsSetByPrivilegesAction;
    private static boolean adminRights;
    private static final StringUtil.ReplacementCallback REMOVAL_CALLBACK;
    private static final StringUtil.ReplacementCallback PLAIN_CALLBACK;
    private static final StringUtil.ReplacementCallback I18N_ONLY_CALLBACK;
    private static final StringUtil.ReplacementCallback REGEXP_MATCH_CALLBACK;
    private static final StringUtil.ReplacementCallback REGEXP_REPLACEMENT_CALLBACK;
    private static final StringUtil.ReplacementCallback PROPERTIES_FILE_CALLBACK;
    private static volatile File macosMediaFileCache;

    private static Map<String, VariableReplacer> createVariableReplacers() {
        HashMap<String, VariableReplacer> map = new HashMap<String, VariableReplacer>();
        map.put(INSTALLER_PREFIX, VARIABLE_REPLACER);
        return Collections.unmodifiableMap(map);
    }

    public static void setDesignTimeVariableProcessor(DesignTimeVariableProcessor designTimeVariableProcessor) {
        InstallerVariables.designTimeVariableProcessor = designTimeVariableProcessor;
        InstallerVariables.setReplaceI18nVariables(designTimeVariableProcessor != null);
    }

    public static void setDesignTimeTextOverrideProcessor(DesignTimeTextOverrideProcessor designTimeTextOverrideProcessor) {
        InstallerVariables.designTimeTextOverrideProcessor = designTimeTextOverrideProcessor;
    }

    public static DesignTimeVariableProcessor getDesignTimeVariableProcessor() {
        return designTimeVariableProcessor;
    }

    public static String quoteRegexpSearch(String text) {
        int slashEIndex = text.indexOf("\\E");
        if (slashEIndex == -1) {
            return "\\Q" + text + "\\E";
        }
        StringBuilder buffer = new StringBuilder(text.length() * 2);
        buffer.append("\\Q");
        int current = 0;
        while ((slashEIndex = text.indexOf("\\E", current)) != -1) {
            buffer.append(text, current, slashEIndex);
            current = slashEIndex + 2;
            buffer.append("\\E\\\\E\\Q");
        }
        buffer.append(text, current, text.length());
        buffer.append("\\E");
        return buffer.toString();
    }

    private static String quoteRegexpReplacement(String text) {
        if (text.indexOf(92) == -1 && text.indexOf(36) == -1) {
            return text;
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\\') {
                buffer.append('\\');
                buffer.append('\\');
                continue;
            }
            if (c == '$') {
                buffer.append('\\');
                buffer.append('$');
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static String[] getArguments(String argumentsLine) {
        ArrayList<String> argumentsList = new ArrayList<String>();
        StringUtil.splitupQuotedList(argumentsList, argumentsLine, ",");
        ListIterator<String> it = argumentsList.listIterator();
        while (it.hasNext()) {
            String argument = (String)it.next();
            if (!argument.startsWith("\"") || !argument.endsWith("\"")) continue;
            argument = argument.substring(1, argument.length() - 1);
            it.set(argument);
        }
        return argumentsList.toArray(new String[0]);
    }

    public static boolean getBooleanVariable(String variableName) {
        return Boolean.valueOf(InstallerVariables.getStringVariable(variableName));
    }

    public static String getStringVariable(String variableName) {
        Object value = InstallerVariables.getVariable(variableName);
        return value == null ? null : value.toString();
    }

    public static void setReplacementRecording(List<String> replacementRecording) {
        InstallerVariables.replacementRecording = replacementRecording;
    }

    public static void clearVariables() {
        props.clear();
        variableProviders.clear();
        hiddenVariables.clear();
        responseFileVariables.clear();
        responseFileComments.clear();
    }

    public static int getIntValue(Object value, int defaultValue) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value != null) {
            try {
                return Integer.parseInt(String.valueOf(value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static Object getVariable(final String variableName) {
        Object value;
        if (replacementRecording != null) {
            replacementRecording.add(INSTALLER_PREFIX + variableName);
        }
        if ((value = HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, new FetchObjectAction<Object>(){

            @Override
            protected Object fetchValue(Context context) {
                if (hiddenVariables.contains(variableName) && !replaceHiddenVariables) {
                    return "[suppressed]";
                }
                VariableProvider variableProvider = (VariableProvider)variableProviders.get(variableName);
                if (variableProvider != null) {
                    return variableProvider.getVariable();
                }
                return props.get(variableName);
            }
        })) != null) {
            LAST_VARIABLE_VALUE.set(value);
        }
        return value;
    }

    public static void setVariable(final String variableName, final Object value) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            @Override
            protected void run(Context context) {
                VariableProvider variableProvider = (VariableProvider)variableProviders.get(variableName);
                if (variableProvider != null) {
                    variableProvider.setVariable(value);
                } else {
                    props.put(variableName, value);
                }
            }
        });
    }

    public static void registerVariableProvider(String variableName, VariableProvider provider) {
        HelperCommunication.helperUnsupported();
        variableProviders.put(variableName, provider);
        if (props.containsKey(variableName)) {
            provider.setVariable(props.remove(variableName));
        }
    }

    public static void setReplaceInstallerAndCompilerVariables(final boolean replaceInstallerAndCompilerVariables) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.ALL, new RunAction(){

            @Override
            protected void run(Context context) {
                replaceInstallerAndCompilerVariables = replaceInstallerAndCompilerVariables;
            }
        });
    }

    public static boolean isReplaceInstallerAndCompilerVariables() {
        return replaceInstallerAndCompilerVariables;
    }

    public static void setReplaceI18nVariables(final boolean replaceI18nVariables) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.ALL, new RunAction(){

            @Override
            protected void run(Context context) {
                replaceI18nVariables = replaceI18nVariables;
            }
        });
    }

    public static boolean isReplaceI18nVariables() {
        return replaceI18nVariables;
    }

    public static void setReplaceHiddenVariables(final boolean replaceHiddenVariables) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.ALL, new RunAction(){

            @Override
            protected void run(Context context) {
                replaceHiddenVariables = replaceHiddenVariables;
            }
        });
    }

    public static String removeVariables(String content) {
        return StringUtil.replaceVariable(content, REMOVAL_CALLBACK, null);
    }

    public static String replaceVariables(String content) {
        return InstallerVariables.replaceVariables(content, ReplacementMode.PLAIN);
    }

    public static String replaceVariables(String content, ReplacementMode replacementMode) {
        return InstallerVariables.replaceVariables(content, replacementMode, VariableErrorHandlingDescriptor.DEFAULT);
    }

    public static String replaceVariables(String content, ReplacementMode replacementMode, VariableErrorHandlingDescriptor variableErrorHandlingDescriptor) {
        if (replaceInstallerAndCompilerVariables || replaceI18nVariables) {
            if (content == null) {
                return null;
            }
            if (designTimeVariableProcessor != null) {
                content = designTimeVariableProcessor.replaceDesignTimeVariables(content);
            }
            return StringUtil.replaceVariable(content, InstallerVariables.getCallback(replacementMode), variableErrorHandlingDescriptor);
        }
        return content;
    }

    private static StringUtil.ReplacementCallback getCallback(ReplacementMode replacementMode) {
        if (replacementMode == ReplacementMode.REGEXP_MATCH) {
            return REGEXP_MATCH_CALLBACK;
        }
        if (replacementMode == ReplacementMode.REGEXP_REPLACEMENT) {
            return REGEXP_REPLACEMENT_CALLBACK;
        }
        if (replacementMode == ReplacementMode.I18N_ONLY) {
            return I18N_ONLY_CALLBACK;
        }
        if (replacementMode == ReplacementMode.PROPERTIES_FILE) {
            return PROPERTIES_FILE_CALLBACK;
        }
        return PLAIN_CALLBACK;
    }

    public static File replaceVariables(File file) {
        if (replaceInstallerAndCompilerVariables || replaceI18nVariables) {
            if (file == null) {
                return null;
            }
            return new File(InstallerVariables.replaceVariables(file.getPath()));
        }
        return file;
    }

    public static String[] replaceVariables(Object[] values, VariableErrorHandlingDescriptor errorHandlingDescriptor) {
        return InstallerVariables.replaceVariables(values, errorHandlingDescriptor, VARIABLE_REPLACERS);
    }

    public static String[] replaceVariables(Object[] values, VariableErrorHandlingDescriptor errorHandlingDescriptor, Map<String, VariableReplacer> variableReplacers) {
        if (values == null) {
            return null;
        }
        ArrayList<String> expandedValues = new ArrayList<String>();
        for (Object value : values) {
            String argument = value.toString();
            VariableSpec variableSpec = InstallerVariables.getSingleRuntimeVariableSpec(argument);
            VariableReplacer variableReplacer = InstallerVariables.getVariableReplacer(variableSpec, variableReplacers);
            if (variableSpec != null) {
                Object variableValue = variableReplacer.getVariable(variableSpec.getVariableName());
                if (variableValue instanceof Object[]) {
                    Object[] variableValues = (Object[])variableValue;
                    for (Object valueElement : variableValues) {
                        InstallerVariables.addIfNotEmpty(expandedValues, variableReplacer.replaceVariables(valueElement.toString(), ReplacementMode.PLAIN, errorHandlingDescriptor));
                    }
                    continue;
                }
                if (variableValue instanceof Collection) {
                    Collection collection = (Collection)variableValue;
                    for (Object valueElement : collection) {
                        InstallerVariables.addIfNotEmpty(expandedValues, variableReplacer.replaceVariables(valueElement.toString(), ReplacementMode.PLAIN, errorHandlingDescriptor));
                    }
                    continue;
                }
                InstallerVariables.addIfNotEmpty(expandedValues, variableReplacer.replaceVariables(argument, ReplacementMode.PLAIN, errorHandlingDescriptor));
                continue;
            }
            InstallerVariables.addIfNotEmpty(expandedValues, variableReplacer.replaceVariables(argument, ReplacementMode.PLAIN, errorHandlingDescriptor));
        }
        return expandedValues.toArray(new String[0]);
    }

    private static VariableReplacer getVariableReplacer(VariableSpec variableSpec, Map<String, VariableReplacer> variableReplacers) {
        VariableReplacer variableReplacer;
        if (variableSpec != null && (variableReplacer = variableReplacers.get(variableSpec.getVariablePrefix())) != null) {
            return variableReplacer;
        }
        return VARIABLE_REPLACER;
    }

    @Nullable
    private static VariableSpec getSingleRuntimeVariableSpec(@NotNull String argument) {
        for (String variablePrefix : RUNTIME_PREFIXES) {
            String prefix = "${" + variablePrefix;
            if (!argument.startsWith(prefix) || argument.indexOf(125) != argument.length() - 1) continue;
            return new VariableSpec(variablePrefix, argument.substring(prefix.length(), argument.length() - 1));
        }
        return null;
    }

    private static void addIfNotEmpty(List<String> values, String value) {
        if (value != null && value.length() > 0) {
            values.add(value);
        }
    }

    public static Set<String> getVariableNames() {
        return HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, new FetchObjectAction<Set<String>>(){

            @Override
            protected Set<String> fetchValue(Context context) {
                HashSet<String> ret = new HashSet<String>();
                ret.addAll(props.keySet());
                ret.addAll(variableProviders.keySet());
                return ret;
            }
        });
    }

    public static <T> T getTextOverrideValue(Bean bean, String propertyName, Class<T> resultType) {
        String overrideText = null;
        if (designTimeTextOverrideProcessor != null) {
            overrideText = designTimeTextOverrideProcessor.getTextOverrides(bean, propertyName);
        } else {
            AbstractBeanConfig beanConfig = AbstractBeanConfig.getBeanConfig(bean);
            if (beanConfig != null) {
                overrideText = beanConfig.getTextOverrides().get(propertyName);
            }
        }
        if (overrideText != null) {
            if (InstallerVariables.isSingleInstallerVariableExpression(overrideText)) {
                LAST_VARIABLE_VALUE.set(null);
                InstallerVariables.replaceVariables(overrideText);
                Object value = LAST_VARIABLE_VALUE.get();
                if (value != null) {
                    if (resultType.isAssignableFrom(value.getClass())) {
                        return resultType.cast(value);
                    }
                    return InstallerVariables.convertToResultType(value, resultType);
                }
            } else {
                return InstallerVariables.convertToResultType(InstallerVariables.replaceVariables(overrideText), resultType);
            }
        }
        return null;
    }

    private static <T> T convertToResultType(Object value, Class<T> resultType) {
        T enumValue;
        if (resultType.isEnum() && (enumValue = InstallerVariables.convertToEnumValue(value, resultType)) != null) {
            return enumValue;
        }
        return InstallerVariables.convertStringToResultType(value.toString(), resultType);
    }

    private static <T> T convertStringToResultType(String text, Class<T> resultType) {
        if (text.isEmpty()) {
            return null;
        }
        if (resultType == Boolean.class) {
            return resultType.cast(Boolean.parseBoolean(text));
        }
        if (resultType == Byte.class) {
            return resultType.cast(Byte.parseByte(text));
        }
        if (resultType == Character.class) {
            return resultType.cast(Character.valueOf(text.charAt(0)));
        }
        if (resultType == Short.class) {
            return resultType.cast(Short.parseShort(text));
        }
        if (resultType == Integer.class) {
            return resultType.cast(Integer.parseInt(text));
        }
        if (resultType == Long.class) {
            return resultType.cast(Long.parseLong(text));
        }
        if (resultType == Float.class) {
            return resultType.cast(Float.valueOf(Float.parseFloat(text)));
        }
        if (resultType == Double.class) {
            return resultType.cast(Double.parseDouble(text));
        }
        if (resultType == Color.class) {
            return resultType.cast(Color.decode(text));
        }
        throw new RuntimeException("The replacement value \"" + text + "\" cannot be converted to the result type " + resultType.getName());
    }

    private static <T> T convertToEnumValue(Object value, Class<T> resultType) {
        String text = value.toString();
        for (T enumConstant : resultType.getEnumConstants()) {
            Enum e = (Enum)enumConstant;
            try {
                if (value instanceof Number && ((Number)value).intValue() == e.ordinal()) {
                    return resultType.cast(e);
                }
                if (!e.name().equals(text) && Integer.parseInt(text) != e.ordinal()) continue;
                return resultType.cast(e);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean isSingleInstallerVariableExpression(String text) {
        if (text.startsWith("${installer:") && text.endsWith("}") && StringUtil.countNonOverlappingSubstrings("${", text) == StringUtil.countNonOverlappingSubstrings("}", text)) {
            int firstVariableEndIndex;
            int lastVariableStartIndex = text.lastIndexOf("${");
            return lastVariableStartIndex < (firstVariableEndIndex = text.indexOf("}"));
        }
        return false;
    }

    public static void initUserVars() {
        InstallerVariables.initUserVars(props);
    }

    public static void initHelperState() {
        replaceI18nVariables = HelperCommunication.getInstance().fetchBoolean(ExecutionContext.UNELEVATED, new FetchBooleanAction(){

            @Override
            protected boolean fetchValue(Context context) {
                return replaceI18nVariables;
            }
        });
        replaceInstallerAndCompilerVariables = HelperCommunication.getInstance().fetchBoolean(ExecutionContext.UNELEVATED, new FetchBooleanAction(){

            @Override
            protected boolean fetchValue(Context context) {
                return replaceInstallerAndCompilerVariables;
            }
        });
    }

    public static void initUserVars(Map<String, Object> variables) {
        String userHomeDir = System.getProperty("user.home");
        variables.put(VARIABLE_USER_HOME, userHomeDir);
        variables.put(VARIABLE_USER_NAME, System.getProperty("user.name"));
        if (InstallerConfig.getCurrentApplication() != null) {
            variables.put(VARIABLE_INSTALLER_APPLICATION_MODE, InstallerConfig.getCurrentApplication().getApplicationMode());
        }
        try {
            if (InstallerUtil.isWindows()) {
                variables.put(VARIABLE_APPDATA_DIR, InstallerVariables.getUserFolderPath(7));
                variables.put(VARIABLE_LOCAL_APPDATA_DIR, InstallerVariables.getUserFolderPath(11));
                variables.put(VARIABLE_FONTS_DIR, InstallerVariables.getUserFolderPath(6));
                variables.put(VARIABLE_PROGRAMS_DIR, InstallerVariables.getUserFolderPath(3));
                variables.put(VARIABLE_FAVORITES_DIR, InstallerVariables.getUserFolderPath(10));
                variables.put(VARIABLE_SENDTO_DIR, InstallerVariables.getUserFolderPath(5));
                variables.put(VARIABLE_STARTMENU_DIR, InstallerVariables.getUserFolderPath(2));
                variables.put(VARIABLE_STARTUP_DIR, InstallerVariables.getUserFolderPath(4));
                variables.put(VARIABLE_TEMPLATES_DIR, InstallerVariables.getUserFolderPath(9));
            } else if (InstallerUtil.isMacOS()) {
                variables.put(VARIABLE_APPDATA_DIR, new File(userHomeDir, "Library/Application Support").getAbsolutePath());
                variables.put(VARIABLE_FONTS_DIR, "/Library/Fonts");
                variables.put(VARIABLE_PROGRAMS_DIR, "/Applications");
            }
            variables.put(VARIABLE_LOCAL_APPDATA_DIR, InstallerVariables.getLocalAppDataDir());
            variables.put(VARIABLE_DESKTOP_DIR, InstallerVariables.getDesktopDir());
            variables.put(VARIABLE_DOCS_DIR, InstallerVariables.getDocsDir());
            variables.put(VARIABLE_DOWNLOADS_DIR, InstallerVariables.getDownloadsDir());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        InstallerVariables.registerVariableProvider(VARIABLE_UPDATE_STORAGE_DIR, new VariableProvider(){

            @Override
            public Object getVariable() {
                return AutomaticUpdate.getUpdateDir().getAbsolutePath();
            }

            @Override
            public void setVariable(Object value) {
                throw new UnsupportedOperationException();
            }
        });
    }

    protected static String getUserFolderPath(int folderType) {
        File file = FolderInfo.getSpecialFolder(folderType, false);
        if (file != null) {
            return file.getAbsolutePath();
        }
        return null;
    }

    private static String getDesktopDir() {
        if (Util.isWindows()) {
            String userFolder = InstallerVariables.getUserFolderPath(1);
            if (userFolder != null) {
                return userFolder;
            }
            return new File(System.getProperty("user.home"), "Desktop").getAbsolutePath();
        }
        if (Util.isMacOS()) {
            return new File(System.getProperty("user.home"), "Desktop").getAbsolutePath();
        }
        return InstallerVariables.getPath(UnixSpecialDirs.getDirectory("XDG_DESKTOP_DIR"));
    }

    public static File getInstall4jCacheDir() {
        String localAppDataDirName = InstallerVariables.getLocalAppDataDir();
        File localAppDataDir = localAppDataDirName != null ? new File(localAppDataDirName) : new File(System.getProperty("user.home"), ".cache");
        return new File(localAppDataDir, "install4j");
    }

    public static String getLocalAppDataDir() {
        if (Util.isWindows()) {
            return InstallerVariables.getUserFolderPath(11);
        }
        if (Util.isMacOS()) {
            return new File(System.getProperty("user.home"), "Library/Caches").getAbsolutePath();
        }
        String cacheDir = System.getenv("XDG_CACHE_HOME");
        if (cacheDir != null) {
            return new File(cacheDir).getAbsolutePath();
        }
        return new File(System.getProperty("user.home"), ".cache").getAbsolutePath();
    }

    private static String getPath(File file) {
        if (file == null) {
            return null;
        }
        return file.getAbsolutePath();
    }

    private static String getDocsDir() {
        String docsDir = InstallerVariables.getDocsDirUnguarded();
        if (docsDir != null) {
            return docsDir;
        }
        return new File(System.getProperty("user.home"), "Documents").getAbsolutePath();
    }

    private static String getDocsDirUnguarded() {
        if (Util.isWindows()) {
            return InstallerVariables.getUserFolderPath(8);
        }
        if (Util.isMacOS()) {
            return new File(System.getProperty("user.home"), "Documents").getAbsolutePath();
        }
        return InstallerVariables.getPath(UnixSpecialDirs.getDirectory("XDG_DOCUMENTS_DIR"));
    }

    private static String getDownloadsDir() {
        String downloadsDir = InstallerVariables.getDownloadsDirUnguarded();
        if (downloadsDir != null && new File(downloadsDir).isDirectory()) {
            return downloadsDir;
        }
        File file = new File(System.getProperty("user.home"), "Downloads");
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        return file.getAbsolutePath();
    }

    private static String getDownloadsDirUnguarded() {
        if (Util.isWindows()) {
            File downloadsDirectory = FolderInfo.getDownloadsDirectory();
            if (downloadsDirectory != null) {
                return downloadsDirectory.getAbsolutePath();
            }
            return null;
        }
        if (Util.isMacOS()) {
            return new File(System.getProperty("user.home"), "Downloads").getAbsolutePath();
        }
        return InstallerVariables.getPath(UnixSpecialDirs.getDirectory("XDG_DOWNLOAD_DIR"));
    }

    public static void initSystemVars(Map<String, Object> variables) {
        HelperCommunication.helperUnsupported();
        variables.put(VARIABLE_PATHLIST_SEPARATOR, File.pathSeparator);
        variables.put(VARIABLE_FILE_SEPARATOR, File.separator);
        variables.put(VARIABLE_JAVA_HOME, System.getProperty("java.home"));
        variables.put(VARIABLE_JAVA_VERSION, System.getProperty("java.version"));
        variables.put(VARIABLE_RESOURCE_DIR, InstallerUtil.getInstallerFile("user").getAbsolutePath());
        variables.put(VARIABLE_PROGRAM_FILES_DIR, InstallerUtil.getStandardApplicationsDirectory(false));
        Date date = new Date();
        variables.put(VARIABLE_DATE, DATE_FORMAT.format(date));
        variables.put(VARIABLE_TIME, TIME_FORMAT.format(date));
        variables.put(VARIABLE_TIMESTAMP, String.valueOf(date.getTime()));
        try {
            variables.put(VARIABLE_WORKING_DIR, new File(".").getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            variables.put(VARIABLE_TEMP_DIR, new File(System.getProperty("java.io.tmpdir")).getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (InstallerUtil.isWindows()) {
            try {
                variables.put(VARIABLE_SYSTEM32_DIR, WinFileSystem.getSystemDirectory().getAbsolutePath());
                variables.put(VARIABLE_COMMON_DIR, WinFileSystem.getCommonFilesDirectory().getAbsolutePath());
                variables.put(VARIABLE_PROGRAM_DATA_DIR, WinFileSystem.getProgramDataDirectory().getAbsolutePath());
                variables.put(VARIABLE_WINDOWS_DIR, WinFileSystem.getWindowsDirectory().getAbsolutePath());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void setAdminRightsFromPrivilegesAction(boolean adminRights) {
        InstallerVariables.adminRights = adminRights;
        adminRightsSetByPrivilegesAction = true;
    }

    private static void initAdminRights() {
        adminRights = Util.isAdminGroup() && Util.hasFullAdminRights();
        InstallerVariables.registerVariableProvider(VARIABLE_ADMIN_RIGHTS, new VariableProvider(){

            @Override
            public Object getVariable() {
                return adminRights;
            }

            @Override
            public void setVariable(Object value) {
                if (!adminRightsSetByPrivilegesAction) {
                    adminRights = (Boolean)value;
                }
            }
        });
        InstallerVariables.registerResponseFileVariable(VARIABLE_ADMIN_RIGHTS);
    }

    public static void initCommandLine(String varFileName, Map<String, String> commandLineProps) {
        block10: {
            int lastDot;
            HelperCommunication.helperUnsupported();
            ApplicationBeanConfig applicationBeanConfig = InstallerConfig.getCurrentInstance().getApplicationConfigById(InstallerConfig.getCurrentApplicationId());
            InstallerVariables.addVariables(applicationBeanConfig.getInstallerVariables(), false, Collections.emptyList());
            hiddenVariables.addAll(applicationBeanConfig.getHiddenVariableNames());
            responseFileVariables.addAll(applicationBeanConfig.getResponseFileVariableNames());
            responseFileComments.putAll(applicationBeanConfig.getResponseFileComments());
            props.put(VARIABLE_REBOOT_REQUIRED, Boolean.FALSE);
            props.put(VARIABLE_VERSION, InstallerConfig.getCurrentInstance().getApplicationVersion());
            if (MODULE_NAME != null) {
                props.put(VARIABLE_MEDIA_FILE, InstallerVariables.getMediaFile().getAbsolutePath());
                props.put(VARIABLE_MEDIA_DIR, InstallerVariables.getMediaDir().getAbsolutePath());
                File installerFile = new File(MODULE_NAME);
                props.put(VARIABLE_INSTALLER_FILE, installerFile.getAbsolutePath());
                props.put(VARIABLE_INSTALLER_DIR, installerFile.getParentFile().getAbsolutePath());
            } else {
                props.put(VARIABLE_MEDIA_DIR, new File(System.getProperty("user.dir")).getAbsolutePath());
                props.put(VARIABLE_INSTALLER_DIR, new File(System.getProperty("user.dir")).getAbsolutePath());
            }
            InstallerVariables.initAdminRights();
            InstallerVariables.initSystemVars(props);
            boolean failForVarFile = true;
            if (varFileName == null && MODULE_NAME != null && (lastDot = MODULE_NAME.lastIndexOf(46)) > -1) {
                String mediaFilePath;
                File autoVarFile = new File(MODULE_NAME.substring(0, lastDot) + VARFILE_SUFFIX);
                if (autoVarFile.exists() && autoVarFile.isFile()) {
                    varFileName = autoVarFile.getPath();
                    failForVarFile = false;
                }
                if (varFileName == null && (mediaFilePath = (String)props.get(VARIABLE_MEDIA_FILE)) != null && (lastDot = mediaFilePath.lastIndexOf(46)) > -1 && (autoVarFile = new File(mediaFilePath.substring(0, lastDot) + VARFILE_SUFFIX)).exists() && autoVarFile.isFile()) {
                    varFileName = autoVarFile.getPath();
                    failForVarFile = false;
                }
            }
            if (varFileName != null) {
                File varFile = new File(varFileName);
                if (!varFile.isAbsolute()) {
                    varFile = new File((String)props.get(VARIABLE_MEDIA_DIR), varFileName);
                }
                try {
                    InstallerVariables.loadResponseFile(varFile, false, Collections.emptyList(), OverwriteStrategy.ON, true);
                    props.put(VARIABLE_RESPONSE_FILE, varFile.getPath());
                }
                catch (IOException e) {
                    if (!failForVarFile) break block10;
                    System.err.println("Could not read file " + varFile.getAbsolutePath());
                    InstallerUtil.exit(1);
                }
            }
        }
        if (commandLineProps != null) {
            commandLineVariableNames = Collections.unmodifiableCollection(InstallerVariables.addVariables(commandLineProps, false, Collections.emptyList()));
        }
    }

    public static void setInstallationDirectoryFromCommandLine(boolean installationDirectoryFromCommandLine) {
        InstallerVariables.installationDirectoryFromCommandLine = installationDirectoryFromCommandLine;
    }

    public static void loadResponseFile(File responseFile, boolean fireChangeEvents, List<String> excludedVariableNames, OverwriteStrategy overwriteStrategy, boolean registerForResponseFile) throws IOException {
        TextProperties properties = new TextProperties();
        properties.read(responseFile, new PropertiesFileParameters(PropertiesFileEncoding.JAVA_PROPERTIES));
        HashMap<String, String> decodedNameToName = new HashMap<String, String>();
        for (String variableName : properties.keySet()) {
            String decodedVariableName = InstallerVariables.decodeVariableName(variableName);
            decodedNameToName.put(decodedVariableName, variableName);
            if (!registerForResponseFile || excludedVariableNames.contains(decodedVariableName) || decodedVariableName.startsWith("sys.")) continue;
            InstallerVariables.registerResponseFileVariable(decodedVariableName);
        }
        switch (overwriteStrategy) {
            case OFF: {
                InstallerVariables.removeVariables(ContextImpl.getCurrentContext().getVariableNames(), decodedNameToName, properties);
                break;
            }
            case NOT_COMMAND_LINE: {
                InstallerVariables.removeVariables(commandLineVariableNames, decodedNameToName, properties);
            }
        }
        InstallerVariables.addVariables(properties, fireChangeEvents, excludedVariableNames);
    }

    protected static void removeVariables(Collection<String> variableNames, Map<String, String> decodedNameToName, TextProperties properties) {
        for (String variableName : variableNames) {
            String encodedVariableName = decodedNameToName.get(variableName);
            if (encodedVariableName == null) continue;
            properties.remove(encodedVariableName);
        }
    }

    private static String decodeVariableName(String variableName) {
        if (variableName.contains("$")) {
            return variableName.substring(0, variableName.lastIndexOf(36));
        }
        return variableName;
    }

    public static File getMediaDir() {
        String mediaDir = (String)props.get(VARIABLE_MEDIA_DIR);
        if (mediaDir == null) {
            File mediaFile = InstallerVariables.getMediaFile();
            if (mediaFile == null) {
                return new File(System.getProperty("user.dir"));
            }
            return mediaFile.getParentFile();
        }
        return new File(mediaDir);
    }

    public static File getMediaFile() {
        String mediaFile = (String)props.get(VARIABLE_MEDIA_FILE);
        if (mediaFile == null) {
            String msiFile = MsiHelper.getMsiFile();
            if (msiFile != null) {
                return new File(msiFile);
            }
            if (MODULE_NAME != null) {
                File installerFile = new File(MODULE_NAME);
                if (Util.isMacOS()) {
                    if (macosMediaFileCache == null) {
                        String diskFile;
                        Map<String, String> mountPointToDiskFile = VolumeInfo.getMountPointToDiskFile();
                        if (mountPointToDiskFile != null && (diskFile = mountPointToDiskFile.get(installerFile.getParentFile().getAbsolutePath())) != null) {
                            macosMediaFileCache = new File(diskFile);
                        }
                        if (macosMediaFileCache == null) {
                            macosMediaFileCache = installerFile;
                        }
                    }
                    return macosMediaFileCache;
                }
                return installerFile;
            }
            return null;
        }
        return new File(mediaFile);
    }

    private static List<String> addVariables(Map<String, String> loadedProps, boolean fireChangeEvents, List<String> excludedVariableNames) {
        HashSet<String> usedExcludes = new HashSet<String>(excludedVariableNames);
        if (installationDirectoryFromCommandLine) {
            usedExcludes.add(VARIABLE_INSTALLATION_DIR);
        }
        Map<String, Object> decodedMap = VariableEncoding.decodeVariables(loadedProps, false);
        ArrayList<String> modifiedVariableNames = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : decodedMap.entrySet()) {
            String variableName = entry.getKey();
            if (Objects.equals(variableName, "sys.programGroup.name")) {
                variableName = VARIABLE_PROGRAM_GROUP_NAME;
            }
            if (usedExcludes.contains(variableName)) continue;
            modifiedVariableNames.add(variableName);
            Object variableValue = entry.getValue();
            if (fireChangeEvents) {
                ContextImpl.getSingleContextInt().setVariable(variableName, variableValue);
                continue;
            }
            InstallerVariables.setVariable(variableName, variableValue);
        }
        return modifiedVariableNames;
    }

    public static void registerHiddenVariable(final String variableName) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            @Override
            protected void run(Context context) {
                hiddenVariables.add(variableName);
            }
        });
    }

    public static Set<String> getHiddenVariables() {
        return HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, new FetchObjectAction<Set<String>>(){

            @Override
            protected Set<String> fetchValue(Context context) {
                return hiddenVariables;
            }
        });
    }

    public static void registerResponseFileVariable(final String variableName) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            @Override
            protected void run(Context context) {
                responseFileVariables.add(variableName);
            }
        });
    }

    public static void unregisterResponseFileVariable(final String variableName) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            @Override
            protected void run(Context context) {
                responseFileVariables.remove(variableName);
            }
        });
    }

    public static void registerResponseFileComment(final String variableName, final String comment) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            @Override
            protected void run(Context context) {
                if (comment != null) {
                    responseFileComments.put(variableName, comment);
                } else {
                    responseFileComments.remove(variableName);
                }
            }
        });
    }

    public static byte[] getResponseFileContent(VariableSelectionMode variableSelectionMode, String[] variables) throws IOException {
        return InstallerVariables.getResponseFileContent(variableSelectionMode, variables, new TextProperties());
    }

    public static byte[] getResponseFileContent(final VariableSelectionMode variableSelectionMode, final String[] variables, final TextProperties previousProperties) {
        return HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, new FetchObjectAction<byte[]>(){

            @Override
            protected byte[] fetchValue(Context context) throws Exception {
                HashSet<String> variableSet = new HashSet<String>();
                if (variables != null) {
                    variableSet.addAll(Arrays.asList(variables));
                }
                TextProperties encodedResponse = new TextProperties();
                ArrayList sortedVariableNames = new ArrayList();
                sortedVariableNames.addAll(responseFileVariables);
                sortedVariableNames.addAll(previousProperties.keySet());
                Collections.sort(sortedVariableNames);
                for (String variableName : sortedVariableNames) {
                    String encodedVariableName;
                    if (!previousProperties.containsKey(variableName) && !variableSelectionMode.isIncluded(variableName, variableSet)) continue;
                    Object variableValue = InstallerVariables.getVariable(variableName);
                    String previousEncodedValue = (String)previousProperties.get(variableName);
                    if (variableValue == null && previousEncodedValue != null) {
                        encodedVariableName = variableName;
                        encodedResponse.put(variableName, previousEncodedValue);
                    } else {
                        encodedVariableName = VariableEncoding.getEncodedVariableName(variableName, variableValue);
                        VariableEncoding.encodeVariable(encodedResponse, variableName, variableValue);
                    }
                    String comment = (String)responseFileComments.get(variableName);
                    String previousComment = previousProperties.getPrefix(variableName);
                    if (comment == null && previousComment != null && (comment = previousComment).startsWith(InstallerVariables.RESPONSE_FILE_HEADER)) {
                        int firstLineBreakIndex = comment.indexOf(10);
                        comment = firstLineBreakIndex > -1 ? comment.substring(firstLineBreakIndex + 1) : null;
                    }
                    if (comment == null || comment.trim().isEmpty()) continue;
                    encodedResponse.setPrefix(encodedVariableName, InstallerVariables.makeComment(comment));
                }
                encodedResponse.setHeader(InstallerVariables.RESPONSE_FILE_HEADER + InstallerConfig.getCurrentInstance().getApplicationNameWithVersion());
                return encodedResponse.convertToPropertiesString().getBytes();
            }
        });
    }

    private static String makeComment(String comment) {
        StringBuilder buffer = new StringBuilder();
        for (String line : comment.split("\r?\n", -1)) {
            String trimmedLine = line.trim();
            if (!trimmedLine.isEmpty() && !trimmedLine.startsWith("#")) {
                line = "# " + trimmedLine;
            }
            if (buffer.length() > 0) {
                buffer.append('\n');
            }
            buffer.append(InstallerVariables.replaceVariables(line));
        }
        return buffer.toString();
    }

    public static String replaceI18n(String token, ResourceBundle messages, VariableErrorHandlingDescriptor variableErrorHandlingDescriptor, boolean hasFallback, ArgumentsProcessor argumentsProcessor) {
        String key = token.substring(I18N_PREFIX.length());
        String[] arguments = null;
        int index = key.indexOf(40);
        if (index > 0 && key.endsWith(")")) {
            String argumentsLine = key.substring(index + 1, key.length() - 1);
            arguments = InstallerVariables.getArguments(argumentsLine);
            key = key.substring(0, index);
        }
        try {
            String message = messages.getString(key);
            if (arguments == null) {
                return message;
            }
            if (argumentsProcessor != null) {
                argumentsProcessor.process(arguments);
            }
            return Messages.format(message, arguments);
        }
        catch (MissingResourceException e) {
            if (hasFallback) {
                return null;
            }
            return InstallerVariables.handleError(I18N_KEY_VERBOSE, key, token, variableErrorHandlingDescriptor.getI18nKeys());
        }
    }

    public static String handleError(String name, String key, String token, VariableErrorHandling variableErrorHandling) {
        if (variableErrorHandling == VariableErrorHandling.ERROR_MESSAGE) {
            return InstallerVariables.getUnresolvedErrorMessage(name, key);
        }
        if (variableErrorHandling == VariableErrorHandling.EXCEPTION) {
            throw new UndefinedVariableException(token);
        }
        return null;
    }

    public static String getUnresolvedErrorMessage(String name, String key) {
        return "ERROR: Unresolved " + name + " \"" + key + "\"";
    }

    static {
        RUNTIME_PREFIXES = Arrays.asList(INSTALLER_PREFIX, FORM_PREFIX);
        installationDirectoryFromCommandLine = false;
        commandLineVariableNames = Collections.emptyList();
        replaceHiddenVariables = true;
        adminRightsSetByPrivilegesAction = false;
        REMOVAL_CALLBACK = new VariableRemovalCallback();
        PLAIN_CALLBACK = new InstallerReplacementCallback();
        I18N_ONLY_CALLBACK = new InstallerReplacementCallback(){

            @Override
            protected boolean isReplaceInstallerVariables() {
                return false;
            }
        };
        REGEXP_MATCH_CALLBACK = new StringUtil.ReplacementCallback(){

            @Override
            public String getReplacement(String token, Object memento, boolean hasFallback) {
                String replacement = PLAIN_CALLBACK.getReplacement(token, memento, hasFallback);
                if (replacement != null) {
                    return InstallerVariables.quoteRegexpSearch(replacement);
                }
                return null;
            }
        };
        REGEXP_REPLACEMENT_CALLBACK = new StringUtil.ReplacementCallback(){

            @Override
            public String getReplacement(String token, Object memento, boolean hasFallback) {
                String replacement = PLAIN_CALLBACK.getReplacement(token, memento, hasFallback);
                if (replacement != null) {
                    return InstallerVariables.quoteRegexpReplacement(replacement);
                }
                return null;
            }
        };
        PROPERTIES_FILE_CALLBACK = new StringUtil.ReplacementCallback(){

            @Override
            public String getReplacement(String token, Object memento, boolean hasFallback) {
                String replacement = PLAIN_CALLBACK.getReplacement(token, memento, hasFallback);
                if (replacement != null) {
                    return PropertiesFileHelper.escapeForPropertyFile(replacement, false, null, false);
                }
                return null;
            }
        };
    }

    private static class VariableSpec {
        private String variablePrefix;
        private String variableName;

        public VariableSpec(String variablePrefix, String variableName) {
            this.variablePrefix = variablePrefix;
            this.variableName = variableName;
        }

        public String getVariablePrefix() {
            return this.variablePrefix;
        }

        public String getVariableName() {
            return this.variableName;
        }
    }

    public static interface ArgumentsProcessor {
        public void process(String[] var1);
    }

    private static class InstallerReplacementCallback
    implements StringUtil.SkippableReplacementCallback {
        private InstallerReplacementCallback() {
        }

        @Override
        public boolean isSkipReplacement(String token) {
            return token.startsWith(InstallerVariables.I18N_PREFIX) && !this.isReplaceI18nVariables() || token.startsWith(InstallerVariables.INSTALLER_PREFIX) && !this.isReplaceInstallerVariables() || token.startsWith(InstallerVariables.COMPILER_PREFIX) && !this.isReplaceCompilerVariables();
        }

        @Override
        public String getReplacement(String token, Object memento, boolean hasFallback) {
            VariableErrorHandlingDescriptor variableErrorHandlingDescriptor = (VariableErrorHandlingDescriptor)memento;
            if (token.startsWith(InstallerVariables.I18N_PREFIX) && this.isReplaceI18nVariables()) {
                VariableResourceBundleWrapper messages = Messages.getMessages();
                if (!this.isReplaceInstallerVariables()) {
                    messages.setNextReplacementMode(ReplacementMode.I18N_ONLY);
                }
                return InstallerVariables.replaceI18n(token, messages, variableErrorHandlingDescriptor, hasFallback, null);
            }
            if (token.startsWith(InstallerVariables.INSTALLER_PREFIX) && this.isReplaceInstallerVariables()) {
                String key = token.substring(InstallerVariables.INSTALLER_PREFIX.length());
                String value = InstallerVariables.getStringVariable(key);
                if (value == null && !hasFallback) {
                    return InstallerVariables.handleError(InstallerVariables.INSTALLER_VARIABLE_VERBOSE, key, token, variableErrorHandlingDescriptor.getInstallerVariables());
                }
                return value;
            }
            if (token.startsWith(InstallerVariables.COMPILER_PREFIX) && this.isReplaceCompilerVariables()) {
                String key = token.substring(InstallerVariables.COMPILER_PREFIX.length());
                String value = ContextImpl.getSingleContextInt().getCompilerVariable(key);
                if (value == null && !hasFallback) {
                    return InstallerVariables.handleError(InstallerVariables.COMPILER_VARIABLE_VERBOSE, key, token, variableErrorHandlingDescriptor.getCompilerVariables());
                }
                return value;
            }
            return null;
        }

        protected boolean isReplaceI18nVariables() {
            return replaceI18nVariables;
        }

        protected boolean isReplaceInstallerVariables() {
            return replaceInstallerAndCompilerVariables;
        }

        protected boolean isReplaceCompilerVariables() {
            return replaceInstallerAndCompilerVariables;
        }
    }

    private static class VariableRemovalCallback
    implements StringUtil.ReplacementCallback {
        private VariableRemovalCallback() {
        }

        @Override
        public String getReplacement(String token, Object memento, boolean hasFallback) {
            if (token.startsWith(InstallerVariables.I18N_PREFIX) || token.startsWith(InstallerVariables.INSTALLER_PREFIX) || token.startsWith(InstallerVariables.FORM_PREFIX) || token.startsWith(InstallerVariables.COMPILER_PREFIX)) {
                return "";
            }
            return null;
        }
    }

    public static abstract class ReadOnlyVariableProvider
    implements VariableProvider {
        @Override
        public void setVariable(Object value) {
        }
    }

    public static interface VariableProvider {
        public Object getVariable();

        public void setVariable(Object var1);
    }

    public static interface DesignTimeTextOverrideProcessor {
        public String getTextOverrides(Bean var1, String var2);
    }

    public static interface DesignTimeVariableProcessor {
        public String replaceDesignTimeVariables(String var1);
    }
}

