/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.jydocking.DockingEvent;
import de.javasoft.swing.jydocking.DockingManager;
import de.javasoft.swing.jydocking.DockingPath;
import de.javasoft.swing.jydocking.DockingState;
import de.javasoft.swing.jydocking.DockingStrategy;
import de.javasoft.swing.jydocking.DockingUtility;
import de.javasoft.swing.jydocking.FloatingDialog;
import de.javasoft.swing.jydocking.FloatingFrame;
import de.javasoft.swing.jydocking.IDockable;
import de.javasoft.swing.jydocking.IDockingEventListener;
import de.javasoft.swing.jydocking.IDockingPort;
import de.javasoft.swing.jydocking.Perspective;
import de.javasoft.swing.jydocking.RootWindow;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

class DockingStateListener
implements IDockingEventListener {
    private boolean isEnabled = true;

    DockingStateListener() {
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void updateState(IDockable iDockable) {
        RootWindow rootWindow = RootWindow.getRootWindow(iDockable.getComponent());
        if (iDockable == null || !iDockable.getComponent().isValid() || !DockingManager.isDocked(iDockable)) {
            return;
        }
        if (!this.updateFloating(rootWindow, iDockable)) {
            this.updateCenterPoint(iDockable);
            this.updateRelative(iDockable);
            if (!DockingManager.isMaximized(iDockable)) {
                this.updateDockingPath(iDockable);
            }
        }
    }

    private boolean updateFloating(RootWindow rootWindow, IDockable iDockable) {
        boolean bl;
        Component component = rootWindow == null ? null : rootWindow.getRootComponent();
        boolean bl2 = bl = component instanceof FloatingDialog || component instanceof FloatingFrame;
        if (bl) {
            if (component instanceof FloatingDialog) {
                DockingManager.addToFloatingGroup(iDockable, ((FloatingDialog)rootWindow.getRootComponent()).getGroupID());
            } else if (component instanceof FloatingFrame) {
                DockingManager.addToFloatingGroup(iDockable, ((FloatingFrame)rootWindow.getRootComponent()).getGroupID());
            }
        } else {
            DockingManager.removeFromFloatingGroup(iDockable);
        }
        return bl;
    }

    private void updateCenterPoint(IDockable iDockable) {
        JComponent jComponent = iDockable.getComponent();
        Point point = new Point(((Component)jComponent).getWidth() / 2, ((Component)jComponent).getHeight() / 2);
        RootWindow rootWindow = RootWindow.getRootWindow(jComponent);
        Container container = rootWindow.getContentPane();
        point = SwingUtilities.convertPoint(jComponent, point, container);
        float f = (float)point.x / (float)container.getWidth() * 100.0f;
        float f2 = (float)point.y / (float)container.getHeight() * 100.0f;
        point.x = Math.round(f);
        point.y = Math.round(f2);
        DockingState dockingState = this.getDockingState(iDockable, null);
        dockingState.setCenter(point);
    }

    private void updateDockingPath(IDockable iDockable) {
        DockingState dockingState = this.getDockingState(iDockable, null);
        DockingPath dockingPath = DockingPath.create(iDockable);
        dockingState.setPath(dockingPath);
    }

    private void updateRelative(IDockable iDockable) {
        IDockable iDockable2;
        DockingState dockingState = this.getDockingState(iDockable, null);
        IDockingPort iDockingPort = iDockable.getDockingPort();
        if (iDockingPort.getDockedComponent() != iDockable.getComponent()) {
            return;
        }
        Container container = iDockingPort.getComponent().getParent();
        if (!(container instanceof JSplitPane)) {
            this.setNullRelative(dockingState);
            return;
        }
        JSplitPane jSplitPane = (JSplitPane)container;
        Component component = this.getOtherComponent(jSplitPane, iDockingPort.getComponent());
        if (!(component instanceof IDockingPort)) {
            this.setNullRelative(dockingState);
            return;
        }
        JComponent jComponent = ((IDockingPort)((Object)component)).getDockedComponent();
        IDockable iDockable3 = iDockable2 = jComponent instanceof JSplitPane || jComponent instanceof JTabbedPane ? null : DockingManager.getDockable(jComponent);
        if (iDockable2 == null) {
            this.setNullRelative(dockingState);
            return;
        }
        String string = DockingStrategy.findRegion(iDockable.getComponent());
        float f = DockingUtility.calcSplitRatio(jSplitPane);
        dockingState.setRelativeParentID(iDockable2.getID());
        dockingState.setRegion(string);
        dockingState.setSplitRatio(f);
        dockingState = this.getDockingState(iDockable2, null);
        dockingState.setRelativeParentID(iDockable.getID());
        dockingState.setRegion(DockingUtility.flipRegion(string));
        dockingState.setSplitRatio(f);
    }

    private Component getOtherComponent(JSplitPane jSplitPane, Component component) {
        if (jSplitPane == null || component == null) {
            return null;
        }
        Component component2 = jSplitPane.getLeftComponent();
        if (component2 == component) {
            component2 = jSplitPane.getRightComponent();
        }
        return component2;
    }

    private void setNullRelative(DockingState dockingState) {
        dockingState.setRelativeParentID(null);
        dockingState.setSplitRatio(-1.0f);
        dockingState.setRegion("CENTER");
    }

    private DockingState getDockingState(IDockable iDockable, Perspective perspective) {
        if (perspective == null) {
            perspective = DockingManager.getPerspectiveManager().getCurrentPerspective();
        }
        return perspective.getDockingState(iDockable, true);
    }

    public void dockableRegistered(DockingEvent dockingEvent) {
    }

    public void dockableUnregistered(DockingEvent dockingEvent) {
    }

    public void dockingCanceled(DockingEvent dockingEvent) {
    }

    public void dockingCompleted(DockingEvent dockingEvent) {
        if (!this.isEnabled()) {
            return;
        }
        final IDockable iDockable = dockingEvent.getDockable();
        DockingState dockingState = this.getDockingState(iDockable, dockingEvent.getPerspective());
        dockingState.setPlacement(-1);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                DockingStateListener.this.updateState(iDockable);
            }
        });
    }

    public void undockingStarted(DockingEvent dockingEvent) {
        if (this.isEnabled()) {
            this.updateState(dockingEvent.getDockable());
        }
    }

    public void undockingCompleted(DockingEvent dockingEvent) {
    }

    public void dragStarted(DockingEvent dockingEvent) {
    }

    public void dropStarted(DockingEvent dockingEvent) {
    }
}

