/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLLocator;
import oracle.xml.parser.v2.XMLOutputStream;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class XMLSAXSerializer
extends DefaultHandler
implements XMLConstants,
ContentHandler,
LexicalHandler,
DeclHandler,
DTDHandler,
EntityResolver,
ErrorHandler {
    public static final String ENCODING = "oracle.xml.parser.v2.XMLSAXSerializer.encoding";
    public static final String INDENT = "oracle.xml.parser.v2.XMLSAXSerializer.indent";
    public static final String OMIT_XML_DECL = "oracle.xml.parser.v2.XMLSAXSerializer.omit-xml-decl";
    private final XMLOutputStream out;
    private StringBuffer attrDeclBuf = null;
    private String elemAttrName = null;
    private boolean elemEmpty = true;
    private boolean textPrinted = false;
    private boolean firstElement = true;
    private Boolean printXMLDecl = null;
    private boolean inCDATA = false;
    private boolean intSubset = false;
    private boolean isInDTDScope = false;
    private int entityDepth = 0;
    private String encoding = null;
    private Locator locator = null;

    public XMLSAXSerializer(PrintWriter printWriter) {
        this.out = new XMLOutputStream(printWriter);
    }

    public XMLSAXSerializer(OutputStream outputStream) {
        this.out = new XMLOutputStream(outputStream);
    }

    public void setProperty(String string, Object object) {
        if (ENCODING.equals(string)) {
            try {
                this.out.setEncoding((String)object, true, true);
                this.encoding = (String)object;
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.getMessage());
            }
        } else if (INDENT.equals(string)) {
            if (Boolean.TRUE.equals(object)) {
                this.out.setOutputStyle(1);
            } else {
                this.out.setOutputStyle(2);
            }
        } else if (OMIT_XML_DECL.equals(string)) {
            this.printXMLDecl = Boolean.TRUE.equals(object) ? Boolean.FALSE : Boolean.TRUE;
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void flush() throws IOException {
        this.out.flush();
        this.out.finalFlush();
    }

    @Override
    public void startDocument() throws SAXException {
        String string = null;
        if (this.locator != null && this.locator instanceof XMLLocator) {
            XMLLocator xMLLocator = (XMLLocator)this.locator;
            String string2 = xMLLocator.getXMLVersion();
            if (string2 != null && this.printXMLDecl != Boolean.FALSE) {
                this.printXMLDecl = Boolean.TRUE;
            }
            string = xMLLocator.getStandalone();
            if (this.encoding == null) {
                this.encoding = xMLLocator.getEncoding();
                if (this.encoding != null) {
                    if (this.encoding.equals("")) {
                        this.encoding = "UTF-8";
                    }
                    try {
                        this.out.setEncoding(this.encoding, true, true);
                    }
                    catch (IOException iOException) {
                        throw new SAXException(iOException.getMessage());
                    }
                }
            }
        }
        try {
            if (this.printXMLDecl == Boolean.TRUE) {
                this.out.writeChars("<?xml version = '1.0'");
                if (this.encoding != null) {
                    this.out.writeChars(" encoding = '" + this.encoding + "'");
                }
                if (string != null) {
                    this.out.writeChars(" standalone = '" + string + "'");
                }
                this.out.writeChars("?>");
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        try {
            if (!this.textPrinted && !this.firstElement) {
                this.out.writeNewLine();
                this.out.writeIndent();
            }
            this.firstElement = false;
            this.elemEmpty = true;
            this.textPrinted = false;
            this.out.writeChars("<");
            this.out.writeChars(string3);
            this.printAttributes(string2, attributes);
            this.out.writeChars(">");
            this.out.addIndent(1);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        try {
            this.out.addIndent(-1);
            if (this.elemEmpty) {
                this.out.pop(1);
                this.out.writeChars("/>");
            } else {
                if (!this.textPrinted) {
                    this.out.writeNewLine();
                    this.out.writeIndent();
                }
                this.out.writeChars("</" + string3 + ">");
            }
            this.elemEmpty = false;
            this.textPrinted = false;
            return;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        try {
            if (!this.textPrinted && !this.firstElement) {
                this.out.writeNewLine();
                this.out.writeIndent();
            }
            this.firstElement = false;
            this.elemEmpty = false;
            this.textPrinted = false;
            this.out.writeChars("<?");
            this.out.writeChars(string + " " + string2);
            this.out.writeChars("?>");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        this.elemEmpty = false;
        this.textPrinted = true;
        try {
            this.printAttributeDecl();
            int n3 = n + n2;
            for (int i = n; i < n3; ++i) {
                if (!this.inCDATA && cArray[i] == '&') {
                    this.out.writeChars("&amp;");
                    continue;
                }
                if (!this.inCDATA && cArray[i] == '<') {
                    this.out.writeChars("&lt;");
                    continue;
                }
                if (!this.inCDATA && cArray[i] == '\n') {
                    this.out.writeNewLineChars();
                    continue;
                }
                this.out.write(cArray[i]);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        try {
            this.printAttributeDecl();
            this.out.writeChars("<!DOCTYPE ");
            this.out.writeChars(string);
            if (string2 != null) {
                this.out.writeChars(" PUBLIC ");
                this.out.writeQuotedString(string2);
                this.out.writeChars(" ");
                this.out.writeQuotedString(string3);
            } else if (string3 != null) {
                this.out.writeChars(" SYSTEM ");
                this.out.writeQuotedString(string3);
            }
            this.isInDTDScope = true;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    void intSubset() throws IOException {
        if (!this.intSubset) {
            this.intSubset = true;
            this.out.writeChars(" [");
            this.out.writeNewLine();
        }
    }

    @Override
    public void endDTD() throws SAXException {
        this.printAttributeDecl();
        if (this.entityDepth > 0) {
            return;
        }
        try {
            if (this.intSubset) {
                this.out.writeChars("]");
            }
            this.intSubset = false;
            this.out.writeChars(">");
            this.out.writeNewLine();
            this.isInDTDScope = false;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    @Override
    public void startEntity(String string) throws SAXException {
        this.printAttributeDecl();
        if (this.entityDepth == 0 && !string.equals("[dtd]")) {
            try {
                this.out.writeChars("&" + string + ";");
            }
            catch (IOException iOException) {
                throw new SAXException(iOException.getMessage());
            }
        }
        ++this.entityDepth;
    }

    @Override
    public void endEntity(String string) throws SAXException {
        this.printAttributeDecl();
        --this.entityDepth;
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        try {
            this.inCDATA = true;
            this.out.writeChars("<![CDATA[");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        try {
            this.inCDATA = false;
            this.out.writeChars("]]>");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        try {
            this.printAttributeDecl();
            if (this.isInDTDScope) {
                this.intSubset();
            }
            if (!this.textPrinted && !this.firstElement) {
                this.out.writeNewLine();
                this.out.writeIndent();
            }
            this.firstElement = false;
            this.elemEmpty = false;
            this.textPrinted = false;
            this.out.writeChars("<!--");
            int n3 = n + n2;
            for (int i = n; i < n3; ++i) {
                this.out.write(cArray[i]);
            }
            this.out.writeChars("-->");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    @Override
    public void elementDecl(String string, String string2) throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        try {
            this.printAttributeDecl();
            this.intSubset();
            this.out.writeChars("<!ELEMENT ");
            this.out.writeChars(string + " ");
            this.out.writeChars(string2);
            this.out.writeChars(">");
            this.out.writeNewLine();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    @Override
    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        if (this.attrDeclBuf == null) {
            this.attrDeclBuf = new StringBuffer();
        } else if (this.attrDeclBuf.length() != 0 && !string.equals(this.elemAttrName)) {
            this.printAttributeDecl();
            this.attrDeclBuf = new StringBuffer();
        }
        this.elemAttrName = string;
        this.attrDeclBuf.append(" ");
        this.attrDeclBuf.append(string2 + " ");
        this.attrDeclBuf.append(string3);
        if (string4 != null) {
            this.attrDeclBuf.append(" " + string4);
        }
        if (string5 != null) {
            this.attrDeclBuf.append(" ");
            this.attrDeclBuf.append("\"" + string5 + "\"");
        }
    }

    @Override
    public void internalEntityDecl(String string, String string2) throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        try {
            this.printAttributeDecl();
            this.intSubset();
            this.out.writeChars("<!ENTITY ");
            if (string.startsWith("%")) {
                this.out.writeChars("% " + string.substring(1, string.length()) + " ");
            } else {
                this.out.writeChars(string + " ");
            }
            this.out.writeQuotedString(string2);
            this.out.writeChars(">");
            this.out.writeNewLine();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    @Override
    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        try {
            this.printAttributeDecl();
            this.intSubset();
            this.out.writeChars("<!ENTITY ");
            if (string.startsWith("%")) {
                this.out.writeChars("% " + string.substring(1, string.length()) + " ");
            } else {
                this.out.writeChars(string + " ");
            }
            if (string2 != null) {
                this.out.writeChars(" PUBLIC ");
                this.out.writeQuotedString(string2);
                this.out.writeChars(" ");
                this.out.writeQuotedString(string3);
            } else if (string3 != null) {
                this.out.writeChars(" SYSTEM ");
                this.out.writeQuotedString(string3);
            }
            this.out.writeChars(">");
            this.out.writeNewLine();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    @Override
    public void notationDecl(String string, String string2, String string3) throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        try {
            this.printAttributeDecl();
            this.intSubset();
            this.out.writeChars("<!NOTATION ");
            this.out.writeChars(string);
            if (string2 != null) {
                this.out.writeChars(" PUBLIC ");
                this.out.writeQuotedString(string2);
                if (string3 != null) {
                    this.out.writeChars(" ");
                    this.out.writeQuotedString(string3);
                }
            } else if (string3 != null) {
                this.out.writeChars(" SYSTEM ");
                this.out.writeQuotedString(string3);
            }
            this.out.writeChars(">");
            this.out.writeNewLine();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        try {
            this.printAttributeDecl();
            this.intSubset();
            this.out.writeChars("<!ENTITY ");
            this.out.writeChars(string);
            if (string2 != null) {
                this.out.writeChars(" PUBLIC ");
                this.out.writeQuotedString(string2);
                this.out.writeChars(" ");
                this.out.writeQuotedString(string3);
            } else if (string3 != null) {
                this.out.writeChars(" SYSTEM ");
                this.out.writeQuotedString(string3);
            }
            this.out.writeChars(" NDATA ");
            this.out.writeChars(string4);
            this.out.writeChars(">");
            this.out.writeNewLine();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    private void printAttributes(String string, Attributes attributes) throws SAXException, IOException {
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            this.out.writeChars(" ");
            this.out.writeChars(attributes.getQName(i));
            XMLAttr.print1(this.out, attributes.getValue(i));
        }
    }

    private void printAttributeDecl() throws SAXException {
        try {
            if (this.attrDeclBuf == null || this.attrDeclBuf.length() == 0) {
                return;
            }
            this.intSubset();
            this.out.writeChars("<!ATTLIST ");
            this.out.writeChars(this.elemAttrName + " ");
            this.out.writeChars(this.attrDeclBuf.toString());
            this.out.writeChars(">");
            this.out.writeNewLine();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
        finally {
            this.attrDeclBuf = null;
            this.elemAttrName = null;
        }
    }
}

