/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pivot;

import com.jidesoft.pivot.DataTable;
import com.jidesoft.pivot.FieldArea;
import com.jidesoft.pivot.FieldBox;
import com.jidesoft.pivot.HeaderTable;
import com.jidesoft.pivot.HeaderTableModel;
import com.jidesoft.pivot.PivotDataModel;
import com.jidesoft.pivot.PivotField;
import com.jidesoft.pivot.PivotTablePane;
import com.jidesoft.pivot.UnassignedFieldsArea;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.ShadowFactory;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class FieldBoxInputListener
implements MouseListener,
MouseMotionListener,
KeyListener,
ActionListener {
    private PivotTablePane \u0106;
    private static final int \u0111 = 2;
    private int \u0105 = 0;
    private int \u0104 = 0;
    private int \u0110 = 0;
    private int \u010f = 0;
    boolean \u0109 = false;
    private boolean \u010a = true;
    private boolean \u0114 = true;
    private int \u0108;
    private int \u0107;
    private BufferedImage \u0102;
    private BufferedImage \u010e;
    boolean \u0101 = false;
    private Point \u0103;
    private Rectangle \u010c = null;
    private Container \u010d = null;
    private int \u0113 = -1;
    private static final float \u010b = 90.0f;
    private static final int \u0112 = 5;

    public FieldBoxInputListener(PivotTablePane pivotTablePane) {
        this.\u0106 = pivotTablePane;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            Point point = mouseEvent.getPoint();
            point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, this.\u0106);
            this.\u0106.showPopup(point);
            return;
        }
        if (!this.\u0106.isRearrangable()) {
            return;
        }
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && !this.\u0101 && !this.\u0109) {
            this.\u0101 = true;
            this.\u0103 = mouseEvent.getPoint();
            this.\u0103 = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), this.\u0103, this.\u0106);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            Point point = mouseEvent.getPoint();
            point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, this.\u0106);
            this.\u0106.showPopup(point);
            return;
        }
        if (!this.\u0106.isRearrangable()) {
            return;
        }
        if (this.\u0109) {
            this.\u0101((Component)mouseEvent.getSource());
        } else {
            this.\u0102();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof FieldBox) {
            final FieldBox fieldBox = (FieldBox)mouseEvent.getSource();
            if (!this.\u0101 && !this.\u0109 && fieldBox.isFilterButtonVisible() && this.\u0106.isShowFilterButtonsOnMouseOver()) {
                fieldBox.\u0105(true);
            }
            if (this.\u0106.isShowFilterButtonsOnMouseOver()) {
                JideSwingUtilities.setRecursively(fieldBox.getParent(), new JideSwingUtilities.Handler(){

                    @Override
                    public boolean condition(Component component) {
                        return component instanceof FieldBox;
                    }

                    @Override
                    public void action(Component component) {
                        if (!fieldBox.equals(component)) {
                            ((FieldBox)component).\u0105(false);
                        }
                    }

                    @Override
                    public void postAction(Component component) {
                    }
                });
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof FieldBox) {
            FieldBox fieldBox = (FieldBox)mouseEvent.getSource();
            if (!(this.\u0101 || this.\u0109 || !fieldBox.isFilterButtonVisible() || !this.\u0106.isShowFilterButtonsOnMouseOver() || fieldBox.isPopupVisible() || mouseEvent.getX() >= 0 && mouseEvent.getX() < fieldBox.getWidth() && mouseEvent.getY() >= 0 && mouseEvent.getY() < fieldBox.getHeight())) {
                fieldBox.\u0105(false);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.\u0106.isRearrangable()) {
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        Point point = mouseEvent.getPoint();
        point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, this.\u0106);
        if (this.\u0101) {
            if (Math.abs(point.x - this.\u0103.x) > 2 || Math.abs(point.y - this.\u0103.y) > 2) {
                this.\u0109 = true;
                this.\u0102((Component)mouseEvent.getSource(), this.\u0103);
                this.\u0101 = false;
            }
        } else if (this.\u0109) {
            this.\u0101((Component)mouseEvent.getSource(), point);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.\u0103();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    public boolean isDragging() {
        return this.\u0109;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void \u0102(Component component, Point point) {
        Point point2 = component.getLocation();
        point2 = SwingUtilities.convertPoint(component.getParent(), point2, this.\u0106);
        this.\u0110 = point2.x;
        this.\u010f = point2.y;
        this.\u0108 = point.x - this.\u0110;
        this.\u0107 = point.y - this.\u010f;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        this.\u0102 = graphicsConfiguration.createCompatibleImage(component.getWidth(), component.getHeight(), 3);
        boolean bl = false;
        if (component instanceof JComponent && component.isDoubleBuffered()) {
            bl = true;
            ((JComponent)component).setDoubleBuffered(false);
        }
        try {
            component.paint(this.\u0102.getGraphics());
        }
        finally {
            if (bl) {
                ((JComponent)component).setDoubleBuffered(true);
            }
        }
        ShadowFactory shadowFactory = new ShadowFactory(5, 0.5f, Color.BLACK);
        this.\u010e = shadowFactory.createShadow(this.\u0102);
        this.\u0109 = true;
    }

    protected boolean isDropAllowed(Component component, Rectangle rectangle, int n2, Container container) {
        return true;
    }

    private void \u0101(Component component, Point point) {
        Serializable serializable;
        Serializable serializable2;
        int n2 = this.\u0110;
        int n3 = this.\u010f;
        Rectangle rectangle = this.\u010c;
        this.\u0110 = point.x - this.\u0108;
        this.\u010f = point.y - this.\u0107;
        Component component2 = this.\u0106.findComponentAt(point);
        Container container = PivotTablePane.\u0104(component, component2);
        boolean bl = this.\u010a = component == container;
        if (container instanceof JViewport) {
            container = (Container)((JViewport)container).getView();
        }
        if (component == container) {
            container = null;
        }
        if (container != null) {
            Insets insets;
            if (container instanceof DataTable) {
                container = this.\u0106.getDataFieldsArea();
            } else if (container instanceof HeaderTable && (serializable2 = ((HeaderTable)container).getHeaderTableModel()) != null) {
                container = ((HeaderTableModel)serializable2).isRowHeader() ? this.\u0106.getRowFieldsArea() : this.\u0106.getColumnFieldsArea();
            }
            serializable2 = container.getBounds();
            if (container instanceof FieldArea) {
                insets = container.getInsets();
                ((Rectangle)serializable2).x += insets.left;
                ((Rectangle)serializable2).y += insets.top;
                ((Rectangle)serializable2).width -= insets.left + insets.right;
                ((Rectangle)serializable2).height -= insets.top + insets.bottom;
            }
            serializable2 = SwingUtilities.convertRectangle(container.getParent(), (Rectangle)serializable2, this.\u0106);
            if (container instanceof FieldBox) {
                if (component instanceof FieldBox && ((FieldBox)component).getField().isAllowedAsField(((FieldBox)container).getField().getAreaType())) {
                    int n4 = FieldBoxInputListener.\u0101(point, (Rectangle)serializable2);
                    switch (n4) {
                        case 3: {
                            this.\u010c = new Rectangle(((Rectangle)serializable2).x + ((Rectangle)serializable2).width / 2, ((Rectangle)serializable2).y, ((Rectangle)serializable2).width / 2, ((Rectangle)serializable2).height);
                            this.\u0113 = n4;
                            this.\u010d = container;
                            break;
                        }
                        case 7: {
                            this.\u010c = new Rectangle(((Rectangle)serializable2).x, ((Rectangle)serializable2).y, ((Rectangle)serializable2).width / 2, ((Rectangle)serializable2).height);
                            this.\u0113 = n4;
                            this.\u010d = container;
                            break;
                        }
                        default: {
                            this.\u0101();
                            break;
                        }
                    }
                } else {
                    this.\u0101();
                }
            } else if (container instanceof UnassignedFieldsArea) {
                if (container.getComponentCount() > 0) {
                    insets = container.getInsets();
                    serializable = container.getComponent(container.getComponentCount() - 1);
                    this.\u010c = new Rectangle(((Rectangle)serializable2).x + ((Component)serializable).getX() + ((Component)serializable).getWidth() + 2 - insets.left, ((Rectangle)serializable2).y, component.getPreferredSize().width, ((Component)serializable).getHeight());
                    this.\u0113 = 3;
                    this.\u010d = container;
                } else {
                    this.\u0101();
                }
            } else if (container instanceof FieldArea) {
                if (container.getComponentCount() > 0 && component instanceof FieldBox && ((FieldBox)component).getField().isAllowedAsField(((FieldArea)container).getAreaType())) {
                    insets = container.getInsets();
                    serializable = container.getComponent(container.getComponentCount() - 1);
                    this.\u010c = new Rectangle(((Rectangle)serializable2).x + ((Component)serializable).getX() + ((Component)serializable).getWidth() + 2 - insets.left, ((Rectangle)serializable2).y, component.getPreferredSize().width, ((Component)serializable).getHeight());
                    this.\u0113 = 3;
                    this.\u010d = container;
                } else if (component instanceof FieldBox && ((FieldBox)component).getField().isAllowedAsField(((FieldArea)container).getAreaType())) {
                    this.\u010c = new Rectangle(((Rectangle)serializable2).x, ((Rectangle)serializable2).y, Math.min(((Rectangle)serializable2).width, this.\u0102.getWidth()), ((Rectangle)serializable2).height);
                    this.\u0113 = -1;
                    this.\u010d = container;
                } else {
                    this.\u0101();
                }
            } else {
                this.\u0101();
            }
        } else {
            this.\u0101();
        }
        if (this.\u0106.isFlatLayout() && this.\u0106.getScrollPane() != null) {
            serializable2 = this.\u0106.getScrollPane().getViewport().getBounds();
            Point point2 = SwingUtilities.convertPoint(this.\u0106.getScrollPane().getViewport(), ((Rectangle)serializable2).getLocation(), this.\u0106);
            serializable = SwingUtilities.convertPoint(this.\u0106.getScrollPane().getViewport(), new Point(point2.x + ((Rectangle)serializable2).width, point2.y + ((Rectangle)serializable2).height), this.\u0106);
            Point point3 = this.\u0106.getScrollPane().getViewport().getViewPosition();
            Dimension dimension = this.\u0106.getScrollPane().getViewport().getViewSize();
            if (point.x < point2.x && point3.x > 0) {
                point3.x -= point2.x - point.x;
                if (point3.x < 0) {
                    point3.x = 0;
                }
            } else if (point.x >= ((Point)serializable).x && point3.x < dimension.width - ((Rectangle)serializable2).width) {
                point3.x = Math.min(point3.x + point.x - ((Point)serializable).x, dimension.width - ((Rectangle)serializable2).width);
            }
            if (point.y < point2.y && point3.y > 0) {
                point3.y -= point2.y - point.y;
                if (point3.y < 0) {
                    point3.y = 0;
                }
            } else if (point.y >= ((Point)serializable).y && point3.y < dimension.height - ((Rectangle)serializable2).height) {
                point3.y = Math.min(point3.y + point.y - ((Point)serializable).y, dimension.height - ((Rectangle)serializable2).height);
            }
            this.\u0106.getScrollPane().getViewport().setViewPosition(point3);
        }
        this.\u0114 = this.isDropAllowed(component, this.\u010c, this.\u0113, this.\u010d);
        serializable2 = new Rectangle(n2, n3, this.\u010e.getWidth() + this.\u0105, this.\u010e.getHeight() + this.\u0104);
        Rectangle rectangle2 = new Rectangle(this.\u0110, this.\u010f, this.\u010e.getWidth() + this.\u0105, this.\u010e.getHeight() + this.\u0104);
        this.\u0106.repaint(rectangle2.union((Rectangle)serializable2));
        if (rectangle != null) {
            this.\u0106.repaint(rectangle);
        }
        if (this.\u010c != null) {
            this.\u0106.repaint(this.\u010c);
        }
    }

    private void \u0102() {
        this.\u0106.setCursor(null);
        this.\u0101();
        this.\u0110 = 0;
        this.\u010f = 0;
        this.\u0108 = 0;
        this.\u0107 = 0;
        this.\u0103 = null;
        this.\u0101 = false;
        this.\u0109 = false;
    }

    private void \u0101() {
        this.\u010c = null;
        this.\u0113 = -1;
        this.\u010d = null;
    }

    private void \u0103() {
        if (this.\u010e != null && this.\u0102 != null) {
            Rectangle rectangle = new Rectangle(this.\u0110, this.\u010f, this.\u010e.getWidth() + this.\u0105, this.\u010e.getHeight() + this.\u0104);
            this.\u0106.repaint(rectangle);
        }
        if (this.\u010c != null) {
            this.\u0106.repaint(this.\u010c);
        }
        this.\u0102();
    }

    private void \u0101(Component component) {
        Object object;
        if (this.\u010e != null && this.\u0102 != null) {
            object = new Rectangle(this.\u0110, this.\u010f, this.\u010e.getWidth() + this.\u0105, this.\u010e.getHeight() + this.\u0104);
            this.\u0106.repaint((Rectangle)object);
        }
        if (this.\u010c != null) {
            this.\u0106.repaint(this.\u010c);
        }
        if (!(component instanceof FieldBox) || this.\u010a || !this.\u0114) {
            this.\u0102();
            return;
        }
        if (this.\u010d instanceof FieldBox) {
            object = (FieldBox)this.\u010d;
            FieldBox fieldBox = (FieldBox)component;
            boolean bl = this.\u0106.getComponentOrientation().isLeftToRight();
            int n2 = this.\u0113;
            if (!bl) {
                n2 = this.\u0113 == 3 ? 7 : 3;
            }
            switch (n2) {
                case 3: {
                    if (!this.\u0106.validateFieldBoxDragging(fieldBox, (Component)object, false)) break;
                    this.\u0106.moveFieldBox(fieldBox, (FieldBox)object, false);
                    break;
                }
                case 7: {
                    if (!this.\u0106.validateFieldBoxDragging(fieldBox, (Component)object, true)) break;
                    this.\u0106.moveFieldBox(fieldBox, (FieldBox)object, true);
                }
            }
        } else {
            FieldBox fieldBox;
            object = this.\u0106.getPivotDataModel();
            if (this.\u010d instanceof FieldArea) {
                FieldBox fieldBox2 = (FieldBox)component;
                FieldArea fieldArea = (FieldArea)this.\u010d;
                if (this.\u0106.validateFieldBoxDragging(fieldBox2, fieldArea, false)) {
                    if (object instanceof PivotDataModel) {
                        if (fieldArea.getAreaType() == 3) {
                            fieldBox2.getField().setAreaType(-1);
                            PivotField pivotField = fieldBox2.getField();
                            if (this.\u0106.isDataFieldsDuplicationEnabled() && pivotField.getAreaType() != 3) {
                                pivotField = ((PivotDataModel)object).\u0102(pivotField);
                            }
                            fieldBox2 = this.\u0106.createFieldBox(pivotField, fieldBox2.isSortArrowVisible(), fieldBox2.isFilterButtonVisible());
                        } else if (fieldBox2.getField().getAreaType() == 3 || fieldBox2.getField().getAreaType() == -1) {
                            PivotField pivotField = fieldBox2.getField();
                            int n3 = pivotField.getModelIndex();
                            while (((PivotDataModel)object).\u0101(pivotField)) {
                                pivotField = object.getField(n3);
                            }
                            fieldBox2 = this.\u0106._fieldBoxMap.get(pivotField);
                        }
                    }
                    this.\u0106.addFieldBox(fieldBox2, fieldArea.getAreaType());
                }
            } else if ((this.\u0106.isHideFieldOnDraggingOut() || this.\u010d instanceof UnassignedFieldsArea) && this.\u0106.validateFieldBoxDragging(fieldBox = (FieldBox)component, null, false)) {
                if (fieldBox.getField().getAreaType() == 3 && object instanceof PivotDataModel) {
                    ((PivotDataModel)object).\u0101(fieldBox.getField());
                }
                this.\u0106.hideFieldBox(fieldBox);
            }
        }
        this.\u0102();
    }

    public BufferedImage getImage() {
        return this.\u0102;
    }

    public BufferedImage getShadow() {
        return this.\u010e;
    }

    private void \u0101(double d2) {
        double d3 = Math.toRadians(90.0);
        this.\u0105 = (int)(Math.cos(d3) * d2);
        this.\u0104 = (int)(Math.sin(d3) * d2);
    }

    public void drawItem(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.\u0114) {
            if (this.\u010c != null) {
                graphics2D.setColor(Color.DARK_GRAY);
                graphics2D.drawRect(this.\u010c.x, this.\u010c.y, this.\u010c.width - 1, this.\u010c.height - 1);
                graphics2D.drawRect(this.\u010c.x + 1, this.\u010c.y + 1, this.\u010c.width - 3, this.\u010c.height - 3);
                this.\u0106.setCursor(null);
            } else if (!this.\u010a) {
                this.\u0106.setCursor(this.\u0106.getDragRemoveCursor());
            } else {
                this.\u0106.setCursor(null);
            }
        } else {
            this.\u0106.setCursor(this.\u0106.getDragNoDropCursor());
        }
        int n2 = this.\u010e.getWidth();
        int n3 = this.\u010e.getHeight();
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.3f));
        int n4 = this.\u0110;
        int n5 = this.\u010f;
        this.\u0101(6.0);
        graphics.drawImage(this.\u010e, n4 + this.\u0105, n5 + this.\u0104, n2, n3, null);
        n2 = this.\u0102.getWidth();
        n3 = this.\u0102.getHeight();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.6f));
        graphics.drawImage(this.\u0102, n4, n5, n2, n3, null);
        graphics2D.setComposite(composite);
    }

    private static int \u0101(Point point, Rectangle rectangle) {
        if (rectangle.contains(point)) {
            if (point.x <= rectangle.x + rectangle.width / 2) {
                return 7;
            }
            if (point.x > rectangle.x + rectangle.width / 2) {
                return 3;
            }
        }
        return -1;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        PivotField pivotField = ((FieldBox)actionEvent.getSource()).getField();
        if (pivotField.getAreaType() == -1) {
            this.\u0106.selectFieldBox((FieldBox)actionEvent.getSource());
        }
    }
}

