/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.A;
import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.ColumnGuide;
import com.jidesoft.editor.E;
import com.jidesoft.editor.LazyLoadDocument;
import com.jidesoft.editor.SyntaxStyle;
import com.jidesoft.editor.SyntaxUtils;
import com.jidesoft.editor.caret.CaretPosition;
import com.jidesoft.editor.folding.FoldingSpan;
import com.jidesoft.editor.highlight.Highlighter;
import com.jidesoft.editor.highlight.LayeredHighlighter;
import com.jidesoft.editor.tokenmarker.Token;
import com.jidesoft.editor.tokenmarker.TokenMarker;
import com.jidesoft.marker.Marker;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.HtmlUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;

public class CodeEditorPainter
extends JComponent
implements TabExpander {
    protected int currentLineIndex;
    protected Token currentLineTokens;
    protected Segment currentLine;
    protected CodeEditor _editor;
    protected FontMetrics _fm;
    private int \u0101;
    public TextLayout _composedTextLayout = null;
    public int _composedCaretX = 0;
    private transient FontRenderContext \u0102;

    public CodeEditorPainter(CodeEditor codeEditor) {
        this._editor = codeEditor;
        this.setAutoscrolls(true);
        this.setDoubleBuffered(true);
        this.setOpaque(true);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.currentLine = new Segment();
        this.currentLineIndex = -1;
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.\u0102 = new FontRenderContext(null, false, false);
        this.setForeground(Color.black);
        this.setBackground(Color.white);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (CodeEditorPainter.this._editor.getDocument() == null) {
                    return;
                }
                int n2 = CodeEditorPainter.this._editor.getVisualLineCount();
                int n3 = CodeEditorPainter.this._editor.yToLine(CodeEditorPainter.this.getHeight());
                if (n3 > n2) {
                    int n4 = CodeEditorPainter.this._editor.getFirstLine() - (n3 - n2);
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    CodeEditorPainter.this._editor.setFirstLine(n4);
                }
            }
        });
    }

    @Override
    public final boolean isManagingFocus() {
        return false;
    }

    public FontMetrics getFontMetrics() {
        return this._fm;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this._fm = this.getFontMetrics(this.getFont());
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (!this._editor.isShowToolTipOverMarkedText()) {
            return super.getToolTipText(mouseEvent);
        }
        int n2 = this._editor.xyToOffset(mouseEvent.getX(), mouseEvent.getY());
        List<Marker> list = this._editor.getMarkerModel().getMarkersAt(n2, n2);
        if (list != null && list.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer("<html>");
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Marker marker = list.get(i2);
                String string = marker.getToolTipText();
                stringBuffer.append(HtmlUtils.formatHtmlSubString(string));
                if (i2 == list.size() - 1) continue;
                stringBuffer.append("<br>");
            }
            stringBuffer.append("</html>");
            if (stringBuffer.length() <= "<html>".length() + "</html>".length()) {
                return null;
            }
            return stringBuffer.toString();
        }
        return null;
    }

    @Override
    public void paint(Graphics graphics) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Highlighter highlighter;
        Highlighter highlighter2;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        JideSwingUtilities.setupAntialiasing(this, graphics2D);
        this.\u0102 = graphics2D.getFontRenderContext();
        this.\u0101 = this._fm.charWidth(' ') * this._editor.getTabSize();
        Rectangle rectangle = graphics2D.getClipBounds();
        graphics2D.setColor(this._editor.isEnabled() ? this.getBackground() : UIDefaultsLookup.getColor("TextField.inactiveBackground"));
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (!this._editor.isContentVisible() || this._editor.getDocument() == null) {
            return;
        }
        if (!this._editor.isEnabled()) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
        }
        if ((highlighter2 = this._editor.getHighlighter()) != null) {
            highlighter2.paint(graphics2D);
        }
        if ((highlighter = this._editor.getFixedHighlighter()) != null) {
            highlighter.paint(graphics2D);
        }
        int n7 = this.getLineHeight();
        int n8 = this._editor.getFirstLine();
        int n9 = n8 + rectangle.y / n7;
        int n10 = n8 + (rectangle.y + rectangle.height - 1) / n7;
        int n11 = this._editor.viewToModelLine(n8 - 1);
        int n12 = this._editor.viewToModelLine(Math.min(n10 + 1, this._editor.getLineCount()));
        if (!this._editor.getDocument().isLineLoaded(Math.max(0, n11)) || !this._editor.getDocument().isLineLoaded(Math.max(0, Math.min(n12, this._editor.getLineCount() - 1)))) {
            ((LazyLoadDocument)this._editor.getDocument()).\u0102(Math.max(0, n11), Math.max(0, Math.min(n12, this._editor.getLineCount() - 1)));
            return;
        }
        int n13 = this._editor.getSelectionModel().hasSelection() ? Math.max(this._editor.getSelectionStart(), this._editor.getLineStartOffset(n11 + 1) - 1) : (n6 = this._editor.getCaretModel().getModelPosition().line >= n11 && this._editor.getCaretModel().getModelPosition().line <= n12 ? this._editor.getSelectionStart() : -1);
        int n14 = this._editor.getSelectionModel().hasSelection() ? Math.min(this._editor.getSelectionEnd(), this._editor.getLineEndOffset(n12 - 1) + 1) : (this._editor.getCaretModel().getModelPosition().line >= n11 && this._editor.getCaretModel().getModelPosition().line <= n12 ? this._editor.getSelectionEnd() : -1);
        CaretPosition caretPosition = !this._editor.isEnabled() || n6 < 0 ? new CaretPosition(0, 0) : this._editor.offsetToViewPosition(n6);
        CaretPosition caretPosition2 = !this._editor.isEnabled() || n14 < 0 ? new CaretPosition(0, 0) : this._editor.offsetToViewPosition(n14);
        try {
            int n15;
            TokenMarker tokenMarker = this._editor.getDocument().getTokenMarker();
            n5 = this._editor.getHorizontalOffset();
            n4 = this._editor.getLineStartOffset(this._editor.viewToModelLine(n9));
            E e2 = new E(this._editor, n4);
            n3 = 0;
            if (n12 - 1 < this._editor.getLineCount()) {
                n3 = tokenMarker != null ? tokenMarker.getLastToken(n12 - 1) : 0;
            }
            for (n2 = n9; n2 <= n10; ++n2) {
                n15 = this._editor.viewToModelLine(n2);
                int n16 = this._editor.lineToY(n2);
                this.paintLine(graphics2D, tokenMarker, n15, n2, caretPosition, caretPosition2, n5, n16, e2);
            }
            n2 = 0;
            if (n12 - 1 < this._editor.getLineCount()) {
                int n17 = n2 = tokenMarker != null ? (int)tokenMarker.getLastToken(n12 - 1) : 0;
            }
            if (n3 != n2 && this._editor.getTokenMarker().supportsMultilineTokens() && (n3 == 1 || n3 == 3 || n2 == 1 || n2 == 3)) {
                this._editor.getDocument().\u0101(n12, this._editor.getLineCount() - n12, true, n2 == 1 || n2 == 3);
            }
            if (this._editor.isEnabled()) {
                this.paintCaret(graphics2D, this._editor.getCaretModel().getViewPosition().line);
            }
            if (tokenMarker != null && tokenMarker.isNextLineRequested()) {
                n15 = rectangle.y + rectangle.height;
                this.repaint(0, n15, this.getWidth(), this.getHeight() - n15);
            }
        }
        catch (Exception exception) {
            System.err.println("Error repainting line range {" + n9 + "," + n10 + "}:");
            exception.printStackTrace();
        }
        if (this._composedTextLayout != null) {
            int n18 = this._editor.getLineNumber(this._editor.getSelectionEnd()) - this._editor.getLineNumber(this._editor.getSelectionStart());
            n5 = 1;
            n4 = this._editor.getCaretModel().getModelPosition().line;
            int n19 = this._editor.getLineStartOffset(n4);
            n3 = this._editor.getLineEndOffset(n4);
            n2 = this._editor.lineToY(n4);
            this.paintImeInput(graphics2D, n18, n5, n19, n3, n2);
        }
        this.paintColumnGuides(graphics2D, rectangle);
        graphics2D.dispose();
    }

    FontRenderContext \u0101() {
        return this.\u0102;
    }

    void \u0101(TextLayout textLayout, int n2) {
        this._composedTextLayout = textLayout;
        this._composedCaretX = n2;
    }

    protected void paintImeInput(Graphics2D graphics2D, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        if (this._composedTextLayout != null && n4 <= (n7 = this._editor.getCaretPosition()) && n7 <= n5) {
            FontMetrics fontMetrics = this.getFontMetrics();
            int n8 = this._editor.getCaretLocation().x;
            int n9 = Math.round(this._composedTextLayout.getAdvance());
            int n10 = this.getLineHeight();
            int n11 = n8 + this._composedCaretX;
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(n8, n6, n9, n10 + 1);
            graphics2D.setColor(this.getForeground());
            this._composedTextLayout.draw(graphics2D, n8, n6 + n10 - 1);
            graphics2D.setColor(this._editor.getCaretColor());
            graphics2D.drawLine(n11, n6, n11, n6 + n10 + 1);
        }
    }

    public final void invalidateLine(int n2) {
        this.repaint(0, this._editor.lineToY(n2) + this._fm.getMaxDescent() + this._fm.getLeading(), this.getWidth(), this.getLineHeight());
    }

    public final void invalidateRange(int n2, int n3) {
        int n4 = this._editor.offsetToViewPosition((int)n2).line;
        int n5 = this._editor.offsetToViewPosition((int)n3).line;
        this.invalidateLineRange(n4, n5);
    }

    public final void invalidateLineRange(int n2, int n3) {
        if (n2 > n3) {
            int n4 = n2;
            n2 = n3;
            n3 = n4;
        }
        this.repaint(0, this._editor.lineToY(n2) + this._fm.getMaxDescent() + this._fm.getLeading(), this.getWidth(), (n3 - n2 + 1) * this.getLineHeight());
    }

    public final void invalidateSelectedLines() {
        this.invalidateRange(this._editor.getSelectionStart(), this._editor.getSelectionEnd());
    }

    @Override
    public float nextTabStop(float f2, int n2) {
        if (this.\u0101 <= 0) {
            this.\u0101 = 1;
        }
        int n3 = this._editor.getHorizontalOffset();
        int n4 = ((int)f2 - n3) / this.\u0101;
        return (n4 + 1) * this.\u0101 + n3;
    }

    public int nextTabStop(int n2) {
        if (this.\u0101 <= 0) {
            this.\u0101 = 1;
        }
        this.\u0101 *= this._fm.charWidth(' ');
        int n3 = n2 / this.\u0101;
        return (n3 + 1) * this.\u0101;
    }

    @Override
    public Font getFont() {
        return this._editor.getFont();
    }

    protected void paintLine(Graphics graphics, TokenMarker tokenMarker, int n2, int n3, CaretPosition caretPosition, CaretPosition caretPosition2, int n4, int n5, E e2) {
        int n6 = n4;
        Font font = this.getFont();
        Color color = this.getForeground();
        this.currentLineIndex = n2;
        int n7 = this._editor.getLineStartOffset(n2);
        int n8 = this._editor.getLineEndOffset(n2);
        if (n2 < 0 || n2 >= this._editor.getLineCount()) {
            if (this._editor.isPaintInvalid()) {
                this.paintHighlight(graphics, n2, n3, caretPosition, caretPosition2, n5);
                this.\u0101(graphics, n2, n5);
                this._editor.getStyles().getStyle(10).setGraphicsFlags(graphics, font);
                graphics.drawString("~", 0, n5 + this.getLineHeight());
            }
        } else if (tokenMarker == null) {
            this.paintPlainLine(graphics, n2, n3, caretPosition, caretPosition2, font, color, n6, n5);
        } else {
            if (n8 >= e2.\u0104() && n7 > e2.\u0101()) {
                while (n8 >= e2.\u0104() && (e2.\u0102() == null || n7 >= e2.\u0104()) && e2.\u0104() < this._editor.getDocumentLength()) {
                    e2.\u0103();
                }
            } else if (n8 >= e2.\u0104() && n7 == e2.\u0101() && e2.\u0102() == null) {
                e2.\u0103();
            }
            if (e2.\u0102() == null) {
                this.paintSyntaxLine(graphics, tokenMarker, n2, n3, 0, -1, caretPosition, caretPosition2, font, color, n6, n5, true);
            } else if (e2.\u0101() >= n7 && e2.\u0104() >= n8) {
                n6 = this.paintSyntaxLine(graphics, tokenMarker, n2, n3, 0, e2.\u0101() - n7, caretPosition, caretPosition2, font, color, n6, n5, true);
                n6 = !this.isSpanSelected(e2.\u0102(), n3, e2.\u0101() - n7, caretPosition, caretPosition2) ? this.paintFoldedText(graphics, font, e2.\u0102().getDescription(), n6, n5, this._fm) : this.\u0101(graphics, font, e2.\u0102().getDescription(), n6, n5, this._fm);
                int n9 = this._editor.getLineNumber(e2.\u0104() + 1);
                int n10 = this._editor.modelToViewLine(n9);
                if (n10 == n3) {
                    this.currentLineIndex = n9;
                    this.paintSyntaxLine(graphics, tokenMarker, n9, n10, e2.\u0104() - this._editor.getLineStartOffset(n9), -1, caretPosition, caretPosition2, font, color, n6, n5, false);
                }
            } else if (e2.\u0101() >= n7 && e2.\u0104() < n8) {
                n6 = this.paintSyntaxLine(graphics, tokenMarker, n2, n3, 0, e2.\u0101() - n7, caretPosition, caretPosition2, font, color, n6, n5, true);
                n6 = !this.isSpanSelected(e2.\u0102(), n3, e2.\u0101() - n7, caretPosition, caretPosition2) ? this.paintFoldedText(graphics, font, e2.\u0102().getDescription(), n6, n5, this._fm) : this.\u0101(graphics, font, e2.\u0102().getDescription(), n6, n5, this._fm);
                this.paintSyntaxLine(graphics, tokenMarker, n2, n3, e2.\u0104() - n7, -1, caretPosition, caretPosition2, font, color, n6, n5, false);
            } else if (e2.\u0101() < n7 && e2.\u0104() >= n8) {
                System.out.println("not reached 1");
            } else if (e2.\u0101() < n7 && e2.\u0104() < n8) {
                this.paintSyntaxLine(graphics, tokenMarker, n2, n3, e2.\u0104() - n7, -1, caretPosition, caretPosition2, font, color, n6, n5, true);
            } else {
                System.out.println("not reached 2");
            }
        }
        if (this._editor.isBracketHighlightVisible() && n2 == this._editor.getBracketLine()) {
            this.paintBracketHighlight(graphics, n2, n5);
        }
    }

    protected boolean isSpanSelected(FoldingSpan foldingSpan, int n2, int n3, CaretPosition caretPosition, CaretPosition caretPosition2) {
        boolean bl = true;
        if (caretPosition.line > n2 || caretPosition2.line < n2) {
            bl = false;
        } else if (caretPosition.line == n2 && caretPosition.column >= n3) {
            bl = false;
        } else if (caretPosition2.line == n2 && caretPosition2.column < n3 + A.\u0101(foldingSpan)) {
            bl = false;
        }
        return bl;
    }

    private void \u0101(Graphics graphics, int n2, int n3) {
        int n4 = this._editor.getLineStartOffset(n2);
        List<Marker> list = this._editor.getMarkerModel().getMarkersAt(n4, this._editor.getLineEndOffset(n2));
        if (list != null && list.size() > 0) {
            for (Marker marker : list) {
                SyntaxStyle syntaxStyle;
                if (!marker.isEnabled()) continue;
                int n5 = this._editor.offsetToX(marker.getStartOffset());
                if (this._editor.getLineNumber(marker.getStartOffset()) < n2) {
                    n5 = this._editor.offsetToX(this._editor.getLineStartOffset(n2));
                }
                int n6 = this._editor.offsetToX(Math.min(this._editor.getDocumentLength(), marker.getEndOffset() + 1));
                if (this._editor.getLineNumber(Math.min(this._editor.getDocumentLength(), marker.getEndOffset() + 1)) > n2) {
                    n6 = this._editor.offsetToX(this._editor.getLineStartOffset(n2) + this._editor.\u0106(n2));
                }
                if (marker.getType() == 0) {
                    this._editor.getStyles().getStyle(11).paintMarker(graphics, n5, n6, n3, this._fm);
                    continue;
                }
                if (marker.getType() == 1) {
                    this._editor.getStyles().getStyle(12).paintMarker(graphics, n5, n6, n3, this._fm);
                    continue;
                }
                if (marker.getType() < 128 || (syntaxStyle = this._editor.getStyles().getStyle(marker.getType())) == null) continue;
                syntaxStyle.paintMarker(graphics, n5, n6, n3, this._fm);
            }
        }
    }

    protected void paintPlainLine(Graphics graphics, int n2, int n3, CaretPosition caretPosition, CaretPosition caretPosition2, Font font, Color color, int n4, int n5) {
        this.paintHighlight(graphics, n2, n3, caretPosition, caretPosition2, n5);
        this.\u0101(graphics, n2, n5);
        if (!this._editor.getLineText(n2, this.currentLine)) {
            return;
        }
        graphics.setFont(font);
        graphics.setColor(color);
        n5 += this.getLineHeight();
        if (this.currentLine.count != 0) {
            SyntaxUtils.\u0101(this._editor, this.currentLine, n4, n5, graphics, this, 0);
        }
    }

    protected int paintSyntaxLine(Graphics graphics, TokenMarker tokenMarker, int n2, int n3, int n4, int n5, CaretPosition caretPosition, CaretPosition caretPosition2, Font font, Color color, int n6, int n7, boolean bl) {
        if (!this._editor.getLineText(this.currentLineIndex, this.currentLine)) {
            return n6;
        }
        if (bl) {
            this.paintHighlight(graphics, n2, n3, caretPosition, caretPosition2, n7);
            this.\u0101(graphics, n2, n7);
        }
        this.currentLineTokens = tokenMarker.markTokens(this.currentLine, this.currentLineIndex);
        graphics.setFont(font);
        graphics.setColor(color);
        n7 += this.getLineHeight();
        if (this.currentLine.count != 0) {
            n6 = SyntaxUtils.paintSyntaxLine(this._editor, this.currentLine, n4, n5, this.currentLineTokens, this._editor.getStyles(), this, graphics, n6, n7, this._editor.getLineStartOffset(n2) - this.currentLine.offset);
        }
        return n6;
    }

    protected void paintHighlight(Graphics graphics, int n2, int n3, CaretPosition caretPosition, CaretPosition caretPosition2, int n4) {
        Highlighter highlighter;
        LayeredHighlighter layeredHighlighter;
        Highlighter highlighter2;
        int n5 = caretPosition.line;
        int n6 = caretPosition2.line;
        if (n3 >= Math.min(n5, n6) && n3 <= Math.max(n5, n6)) {
            this.paintLineHighlight(graphics, n2, n3, caretPosition, caretPosition2, n4);
        }
        LayeredHighlighter layeredHighlighter2 = (highlighter2 = this._editor.getHighlighter()) instanceof LayeredHighlighter ? (LayeredHighlighter)highlighter2 : null;
        int n7 = this._editor.getLineStartOffset(n2);
        int n8 = this._editor.getLineEndOffset(n2);
        if (layeredHighlighter2 != null) {
            layeredHighlighter2.paintLayeredHighlights(graphics, n7, n8, new Rectangle(0, n4, this._fm.charWidth('w') * (n8 - n7), this._editor.getLineHeight()), this._editor);
        }
        LayeredHighlighter layeredHighlighter3 = layeredHighlighter = (highlighter = this._editor.getFixedHighlighter()) instanceof LayeredHighlighter ? (LayeredHighlighter)highlighter : null;
        if (layeredHighlighter != null) {
            layeredHighlighter.paintLayeredHighlights(graphics, n7, n8, new Rectangle(0, n4, this._fm.charWidth('w') * (n8 - n7), this._editor.getLineHeight()), this._editor);
        }
    }

    protected void paintLineHighlight(Graphics graphics, int n2, int n3, CaretPosition caretPosition, CaretPosition caretPosition2, int n4) {
        Color color = graphics.getColor();
        int n5 = this.getLineHeight();
        n4 += this._fm.getLeading() + this._fm.getMaxDescent();
        if (caretPosition.equals(caretPosition2)) {
            if (this._editor.isLineHighlightVisible()) {
                graphics.setColor(this._editor.getLineHighlightColor());
                graphics.fillRect(0, n4, this.getWidth(), n5);
            }
        } else {
            this.paintLineSelection(graphics, n3, caretPosition, caretPosition2, n4 - this._fm.getLeading() - this._fm.getMaxDescent());
        }
        graphics.setColor(color);
    }

    protected void paintLineSelection(Graphics graphics, int n2, CaretPosition caretPosition, CaretPosition caretPosition2, int n3) {
        int n4;
        int n5;
        int n6 = caretPosition.line;
        int n7 = caretPosition2.line;
        if (n2 < Math.min(n6, n7) || n2 > Math.max(n6, n7)) {
            return;
        }
        if (caretPosition.equals(caretPosition2)) {
            return;
        }
        Color color = graphics.getColor();
        int n8 = this.getLineHeight();
        n3 += this._fm.getLeading() + this._fm.getMaxDescent();
        graphics.setColor(this._editor.getSelectionColor());
        if (this._editor.isSelectionRectangular()) {
            if (this._editor.getSelectionModel().getSelectionStartViewPosition() == null || this._editor.getSelectionModel().getSelectionEndViewPosition() == null) {
                int n9 = this._editor.getSelectionModel().getSelectionStart();
                int n10 = this._editor.getSelectionModel().getSelectionEnd();
                caretPosition = !this._editor.isEnabled() || n9 < 0 ? new CaretPosition(0, 0) : this._editor.offsetToViewPosition(n9);
                caretPosition2 = !this._editor.isEnabled() || n10 < 0 ? new CaretPosition(0, 0) : this._editor.offsetToViewPosition(n10);
                n5 = this._editor.columnToX(caretPosition.line, caretPosition.column);
                n4 = this._editor.columnToX(caretPosition2.line, this._editor.getCaretModel().getViewPosition().column);
            } else {
                caretPosition = this._editor.getSelectionModel().getSelectionStartViewPosition();
                caretPosition2 = this._editor.getSelectionModel().getSelectionEndViewPosition();
                n5 = this._editor.columnToX(caretPosition.line, caretPosition.column);
                n4 = this._editor.columnToX(caretPosition2.line, caretPosition2.column);
            }
            if (n5 == n4) {
                ++n4;
            }
        } else if (caretPosition.line == caretPosition2.line) {
            n5 = this._editor.columnToX(caretPosition.line, caretPosition.column);
            n4 = this._editor.columnToX(caretPosition2.line, caretPosition2.column);
        } else if (n2 == (caretPosition.line < caretPosition2.line ? caretPosition.line : caretPosition2.line)) {
            CaretPosition caretPosition3 = caretPosition.line < caretPosition2.line ? caretPosition : caretPosition2;
            n5 = this._editor.columnToX(caretPosition3.line, caretPosition3.column);
            n4 = this.getWidth();
        } else if (n2 == (caretPosition.line < caretPosition2.line ? caretPosition2.line : caretPosition.line)) {
            n5 = 0;
            CaretPosition caretPosition4 = caretPosition.line < caretPosition2.line ? caretPosition2 : caretPosition;
            n4 = this._editor.columnToX(caretPosition4.line, caretPosition4.column);
        } else {
            n5 = 0;
            n4 = this.getWidth();
        }
        graphics.fillRect(n5 > n4 ? n4 : n5, n3, n5 > n4 ? n5 - n4 : n4 - n5, n8);
        graphics.setColor(color);
    }

    protected void paintBracketHighlight(Graphics graphics, int n2, int n3) {
        int n4 = this._editor.getBracketPosition();
        if (n4 == -1) {
            return;
        }
        n3 += this._fm.getLeading() + this._fm.getMaxDescent();
        int n5 = this._editor._offsetToX(n2, n4);
        graphics.setColor(this._editor.getBracketHighlightColor());
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
        graphics.fillRect(n5, n3, this._fm.charWidth('('), this.getLineHeight() - 1);
        graphics2D.setComposite(composite);
    }

    protected void paintCaret(Graphics graphics, int n2) {
        if (this._editor.isCaretVisible() && n2 >= this._editor.getFirstLine() && n2 <= this._editor.getFirstLine() + this._editor.getVisibleLines()) {
            CaretPosition caretPosition = this._editor.getCaretModel().getViewPosition();
            int n3 = caretPosition.column;
            int n4 = this._editor.columnToX(n2, n3);
            int n5 = this._editor.isBlockCaret() || this._editor.isOverwriteEnabled() ? this._fm.charWidth('w') : 1;
            int n6 = this.getCaretStartY(n2);
            int n7 = this.getCaretHeight();
            graphics.setColor(this._editor.getCaretColor());
            if (this._editor.isOverwriteEnabled()) {
                graphics.setXORMode(this._editor.getLineHighlightColor());
                graphics.fillRect(n4, n6, n5, n7 - 1);
                graphics.setPaintMode();
            } else {
                graphics.drawRect(n4, n6, n5, n7 - 1);
            }
        }
    }

    protected int getCaretStartY(int n2) {
        int n3 = this._editor.lineToY(n2);
        return n3 += this._fm.getLeading() + this._fm.getMaxDescent();
    }

    protected int getCaretHeight() {
        return this.getLineHeight();
    }

    public int getLineHeight() {
        return this._fm.getHeight();
    }

    public CodeEditor getCodeEditor() {
        return this._editor;
    }

    private int \u0101(Graphics graphics, Font font, String string, int n2, int n3, FontMetrics fontMetrics) {
        if (string == null) {
            return n2;
        }
        SyntaxStyle syntaxStyle = this._editor.getStyles().getStyle(13);
        int n4 = fontMetrics.stringWidth(string);
        Color color = graphics.getColor();
        Font font2 = graphics.getFont();
        graphics.setFont(font);
        graphics.setColor(syntaxStyle.getForeground());
        graphics.drawString(string, n2, n3 + this.getLineHeight());
        graphics.setColor(color);
        graphics.setFont(font2);
        return n2 + n4;
    }

    public int paintFoldedText(Graphics graphics, Font font, String string, int n2, int n3, FontMetrics fontMetrics) {
        if (string == null) {
            return n2;
        }
        SyntaxStyle syntaxStyle = this._editor.getStyles().getStyle(13);
        syntaxStyle.paintMarker(graphics, n2, n2 + fontMetrics.stringWidth(string), n3, fontMetrics);
        int n4 = fontMetrics.stringWidth(string);
        Color color = graphics.getColor();
        Font font2 = graphics.getFont();
        graphics.setFont(font);
        graphics.setColor(syntaxStyle.getForeground());
        graphics.drawString(string, n2, n3 + this.getLineHeight());
        graphics.setColor(color);
        graphics.setFont(font2);
        return n2 + n4;
    }

    public void paintColumnGuides(Graphics graphics, Rectangle rectangle) {
        List<ColumnGuide> list = this.getCodeEditor().internalGetColumnGuides();
        for (ColumnGuide columnGuide : list) {
            columnGuide.paint(this.getCodeEditor(), graphics, rectangle);
        }
    }
}

