/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pane;

import com.jidesoft.icons.ColorFilter;
import com.jidesoft.icons.IconsFactory;
import com.jidesoft.icons.MaskFilter;
import com.jidesoft.pane.CollapsiblePane;
import com.jidesoft.plaf.CollapsiblePaneUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public class CollapsiblePaneTitleButton
extends JButton
implements MouseMotionListener,
MouseListener,
KeyListener {
    private CollapsiblePane \u0101;
    private ThemePainter \u0102;

    public CollapsiblePaneTitleButton(CollapsiblePane collapsiblePane, Icon icon) {
        super(icon);
        this.\u0101 = collapsiblePane;
        this.setRolloverEnabled(true);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    @Override
    public void updateUI() {
        this.\u0102 = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        super.updateUI();
        this.setFocusPainted(false);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setBorder(null);
    }

    public ThemePainter getPainter() {
        return this.\u0102;
    }

    @Override
    public Dimension getPreferredSize() {
        ImageIcon imageIcon = this.getPainter().getCollapsiblePaneTitleButtonBackgroundEmphasized();
        if (imageIcon != null) {
            return new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight());
        }
        return super.getPreferredSize();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        this.paintIcon(graphics);
    }

    protected void paintIcon(Graphics graphics) {
        Color color = null;
        if (this.\u0101.isEmphasized()) {
            color = this.getModel().isRollover() ? this.getPainter().getCollapsiblePaneFocusTitleForegroundEmphasized() : this.getPainter().getCollapsiblePaneTitleForegroundEmphasized();
            ImageIcon imageIcon = this.getPainter().getCollapsiblePaneTitleButtonBackgroundEmphasized();
            this.paintIcon(graphics, color, imageIcon, null);
        } else {
            color = this.getModel().isRollover() ? this.getPainter().getCollapsiblePaneFocusTitleForeground() : this.getPainter().getCollapsiblePaneTitleForeground();
            ImageIcon imageIcon = this.getPainter().getCollapsiblePaneTitleButtonBackground();
            this.paintIcon(graphics, color, imageIcon, null);
        }
    }

    protected void paintIcon(Graphics graphics, Color color, ImageIcon imageIcon, ImageIcon imageIcon2) {
        if (this.\u0101.getStyle() != 0 && this.\u0101.getStyle() != 3) {
            return;
        }
        if (imageIcon == null) {
            imageIcon = (ImageIcon)this.getIcon();
        }
        Dimension dimension = new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight());
        int n2 = dimension.width / 2;
        int n3 = dimension.height / 2;
        int n4 = this.getWidth() / 2 - n2;
        int n5 = this.getHeight() / 2 - n3;
        if (this.isEnabled()) {
            if (this.isRolloverEnabled() && imageIcon2 != null) {
                imageIcon2 = IconsFactory.getOverlayIcon(this, imageIcon2, (ImageIcon)this.getIcon(), 0);
                new ImageIcon(MaskFilter.createImage(imageIcon2.getImage(), Color.black, color)).paintIcon(this, graphics, n4, n5);
            } else {
                imageIcon = IconsFactory.getOverlayIcon(this, imageIcon, (ImageIcon)this.getIcon(), 0);
                new ImageIcon(MaskFilter.createImage(imageIcon.getImage(), Color.black, color)).paintIcon(this, graphics, n4, n5);
            }
        } else if (this.isRolloverEnabled() && imageIcon2 != null) {
            imageIcon2 = IconsFactory.getOverlayIcon(this, imageIcon2, (ImageIcon)this.getIcon(), 0);
            new ImageIcon(ColorFilter.createBrighterImage(MaskFilter.createImage(imageIcon2.getImage(), Color.black, color))).paintIcon(this, graphics, n4, n5);
        } else {
            imageIcon = IconsFactory.getOverlayIcon(this, imageIcon, (ImageIcon)this.getIcon(), 0);
            new ImageIcon(ColorFilter.createBrighterImage(MaskFilter.createImage(imageIcon.getImage(), Color.black, color))).paintIcon(this, graphics, n4, n5);
        }
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void requestFocus() {
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.\u0101.setRollover(false);
        JideSwingUtilities.retargetMouseEvent(506, mouseEvent, this.\u0101);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.\u0101.isEnabled() && this.\u0101.isCollapsible()) {
            this.\u0101.setRollover(true);
        }
        JideSwingUtilities.retargetMouseEvent(503, mouseEvent, this.\u0101);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.\u0101.isEnabled() && this.\u0101.isCollapsible() && SwingUtilities.isLeftMouseButton(mouseEvent) && this.\u0101.isRequestFocusEnabled()) {
            this.\u0101.requestFocus();
        }
        JideSwingUtilities.retargetMouseEvent(500, mouseEvent, this.\u0101);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        JideSwingUtilities.retargetMouseEvent(501, mouseEvent, this.\u0101);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        JideSwingUtilities.retargetMouseEvent(502, mouseEvent, this.\u0101);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        Point point;
        Component component = ((CollapsiblePaneUI)this.\u0101.getUI()).getTitlePane();
        Point point2 = point = mouseEvent.getSource() == component ? mouseEvent.getPoint() : SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), component);
        if (component.contains(point)) {
            if (this.\u0101.isEnabled() && this.\u0101.isCollapsible() && mouseEvent.getModifiers() != 16) {
                this.\u0101.setRollover(true);
            }
            JideSwingUtilities.retargetMouseEvent(504, mouseEvent, this.\u0101);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        Point point;
        Component component = ((CollapsiblePaneUI)this.\u0101.getUI()).getTitlePane();
        Point point2 = point = mouseEvent.getSource() == component ? mouseEvent.getPoint() : SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), component);
        if (!component.contains(point)) {
            if (this.\u0101.isEnabled() && this.\u0101.isCollapsible() && mouseEvent.getModifiers() != 16) {
                this.\u0101.setRollover(false);
            }
            JideSwingUtilities.retargetMouseEvent(505, mouseEvent, this.\u0101);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        Action action;
        if ((keyEvent.getKeyChar() == '\n' || keyEvent.getKeyChar() == ' ') && (action = this.\u0101.getToggleAction()) != null) {
            action.actionPerformed(new ActionEvent(this, keyEvent.getID(), ""));
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    protected Icon getIcon(AbstractButton abstractButton) {
        ButtonModel buttonModel = abstractButton.getModel();
        Icon icon = abstractButton.getIcon();
        Icon icon2 = null;
        if (!buttonModel.isEnabled()) {
            icon2 = buttonModel.isSelected() ? abstractButton.getDisabledSelectedIcon() : abstractButton.getDisabledIcon();
            if (icon2 == null) {
                icon = icon instanceof ImageIcon ? IconsFactory.createGrayImage(((ImageIcon)icon).getImage()) : IconsFactory.createGrayImage(abstractButton, icon);
            }
        } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
            icon2 = abstractButton.getPressedIcon();
        } else if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
            icon2 = buttonModel.isSelected() ? abstractButton.getRolloverSelectedIcon() : abstractButton.getRolloverIcon();
        } else if (buttonModel.isSelected()) {
            icon2 = abstractButton.getSelectedIcon();
        }
        if (icon2 != null) {
            icon = icon2;
        }
        return icon;
    }
}

