/*
 * Decompiled with CFR 0.152.
 */
package com.onseven.dbvis;

import com.onseven.dbvis.Z.J;
import com.onseven.dbvis.Z.r;
import com.onseven.dbvis.Z.v;
import com.onseven.dbvis.db.l.O;
import com.onseven.dbvis.n.B;
import com.onseven.dbvis.n.W;
import com.onseven.dbvis.n.z;
import com.onseven.dbvis.util.L;
import com.onseven.dbvis.util.M;
import com.onseven.dbvis.util.b._;
import com.onseven.dbvis.util.b.b;
import com.onseven.dbvis.util.e;
import com.onseven.dbvis.util.o;
import com.onseven.dbvis.util.v.R;
import com.onseven.dbvis.v.A.l;
import com.onseven.dbvis.v.S.A.O;
import com.onseven.dbvis.v.S.A.W.G;
import com.onseven.dbvis.v.S.A.W.S;
import com.onseven.dbvis.v.S.A.W.W.D;
import com.onseven.dbvis.v.S.A.W.W.j;
import com.onseven.dbvis.v.S.A.W.d;
import com.onseven.dbvis.v.S.A.d;
import com.onseven.dbvis.v.S.X;
import java.io.Console;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public class DbVisualizerCmd
extends com.onseven.dbvis.J {
    private static DbVisualizerCmd instance;
    private O dbConnection;
    private PrintWriter outputWriter;
    private static final Logger LOG;
    private static final boolean DO_NOT_CATCH_SYSTEM_STREAMS = true;
    private File currentFile;

    public static void main(String[] stringArray) {
        DbVisualizerCmd dbVisualizerCmd = new DbVisualizerCmd(new e(stringArray));
        dbVisualizerCmd.runCmd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runCmd() {
        int n2;
        e e2 = (e)DbVisualizerCmd.getArgumentParser();
        if (e2.\u6320()) {
            int n3 = this.convertDson(e2);
            this.exit(n3);
            return;
        }
        if (e2.\u6bca()) {
            int n4 = this.formatDson(e2);
            this.exit(n4);
            return;
        }
        if (e2.\u5eb2()) {
            int n5 = this.listDson(e2);
            this.exit(n5);
            return;
        }
        try {
            this.initialize();
        }
        catch (Throwable throwable) {
            System.err.println("DbVisualizerCmd - Initialize Error: " + M.\u9210(throwable.getMessage()));
            this.cleanUpForExit();
            this.exit(2);
        }
        if (e2.\u8587()) {
            Iterator<com.onseven.dbvis.sql._> iterator = this.getConnections().iterator();
            System.out.println("Connections:\n");
            while (iterator.hasNext()) {
                System.out.println(iterator.next());
            }
            this.exit(0);
            return;
        }
        try {
            this.connect();
        }
        catch (Throwable throwable) {
            System.err.println("DbVisualizerCmd - Connect Error: " + M.\u9210(throwable.getMessage()));
            this.cleanUpForExit();
            this.exit(2);
        }
        try {
            n2 = this.execute();
        }
        catch (Throwable throwable) {
            System.err.println("DbVisualizerCmd - " + throwable);
            this.cleanUpForExit();
            try {
                this.disconnect();
            }
            finally {
                n2 = 2;
                this.exit(2);
            }
        }
        try {
            this.disconnect();
        }
        catch (Throwable throwable) {
            System.err.println("DbVisualizerCmd - Disconnect Error: " + M.\u9210(throwable.getMessage()));
            this.cleanUpForExit();
            n2 = 2;
            this.exit(2);
        }
        this.shutdown(n2);
    }

    public DbVisualizerCmd(L l2) {
        super(l2, false);
        instance = this;
    }

    public static DbVisualizerCmd getApplication() {
        return instance;
    }

    public void shutdown(int n2) {
        this.cleanUpForExit();
        this.exit(n2);
    }

    @Override
    protected void initialize() {
        com.onseven.dbvis.n.A.W.W.\uce9f(false);
        super.initialize();
        if (!z.\u89bb().\u7184().\uc858()) {
            throw new IllegalStateException("The DbVisualizer command line interface is available only in DbVisualizer Pro");
        }
        com.onseven.dbvis.n.S.\u0bb5();
        z.\u89bb().\u505e().\ucb0a().\uce9f(new A(z.\u89bb().\u505e().\ucb0a()));
        z.\u89bb().\u905a().\uce9f(this);
    }

    @Override
    protected void showEULA() {
    }

    @Override
    protected void initLogging(int n2) {
        e e2 = (e)DbVisualizerCmd.getArgumentParser();
        String string = e2.\u5740();
        boolean bl = e2.\u8471();
        boolean bl2 = true;
        if (this.canUseLogFile(string)) {
            bl2 = false;
        }
        String string2 = _.\u7900(_.\ufc32);
        if (bl) {
            string2 = _.\u7900(_.\u905a);
        }
        Level level = Level.parse(string2);
        try {
            String string3 = e2.\u993d();
            if (!o.\u983f(string3)) {
                string3 = null;
            }
            b.\uce9f().\uce9f(level, bl2, string, n2, true, string3);
        }
        catch (com.onseven.dbvis.util.b.j j2) {
            System.err.println("DbVisualizerCmd - Could not initiate logging. Note that this will not affect the functionality. Reason(s):");
            StringBuilder stringBuilder = new StringBuilder();
            int n3 = 0;
            Iterator iterator = ExceptionUtils.getThrowableList((Throwable)j2).iterator();
            while (iterator.hasNext()) {
                Throwable throwable = (Throwable)iterator.next();
                stringBuilder.append(n3).append(": ").append(throwable);
                if (iterator.hasNext()) {
                    stringBuilder.append("\n");
                }
                ++n3;
            }
            System.err.println(stringBuilder.toString());
            ExceptionUtils.printRootCauseStackTrace((Throwable)j2, (PrintStream)System.err);
        }
    }

    private boolean canUseLogFile(String string) {
        if (o.\u983f(string)) {
            File file = new File(string);
            File file2 = file.getParentFile();
            if (file2 == null) {
                file2 = new File(System.getProperty("user.dir"));
            }
            return file2.isDirectory();
        }
        return false;
    }

    protected void connect() {
        e e2 = (e)DbVisualizerCmd.getArgumentParser();
        try {
            this.dbConnection = this.connect(e2);
        }
        catch (com.onseven.dbvis.sql.e e3) {
            throw new IllegalStateException("Connecting: " + e3.getMessage());
        }
        if (this.dbConnection == null) {
            throw new IllegalStateException("Connecting: The '" + e2.\u86f9() + "' connection was not found. Use the -listconnections option to see available connections or specify appropriate options to establish an anonymous connection");
        }
    }

    private int execute() {
        com.onseven.dbvis.v.S.S.X x2;
        v v2;
        int n2 = 0;
        e e2 = (e)DbVisualizerCmd.getArgumentParser();
        try {
            v2 = this.getScriptSources(e2);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Reading the script: " + iOException.getMessage());
        }
        try {
            this.outputWriter = this.createOutPutWriter(e2);
            x2 = this.createExecutionLogHandler(e2);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Log file \"" + e2.\u5740() + "\" is not writable");
        }
        String string = this.dbConnection.\ubc36().\uce9f().\u905a();
        String string2 = e2.\u6396();
        boolean bl = this.dbConnection.\ubc36().\u0f59().getBool("SQLCommanderStripComments");
        boolean bl2 = string2 != null ? Boolean.parseBoolean(string2) : bl;
        com.onseven.dbvis.Z.b b2 = new com.onseven.dbvis.Z.b(string);
        b2.\u505e(bl2);
        b2.\u89bb(v2);
        long l2 = e2.\u662f();
        int n3 = e2.\u86c2();
        String string3 = this.getCatalog(e2, this.dbConnection);
        String string4 = e2.\u4fca() != null ? e2.\u4fca() : this.dbConnection.\u8471();
        O.A a2 = O.A.\u4f94;
        String string5 = this.dbConnection.\u0287();
        boolean bl3 = e2.\u5e37();
        boolean bl4 = e2.\ucf4b();
        boolean bl5 = e2.\uc967();
        com.onseven.dbvis.j.O o2 = new com.onseven.dbvis.j.O();
        boolean bl6 = e2.\u7960().equals("result") || e2.\u7960().equals("all");
        W w2 = this.createCallback(l2, n3, bl6);
        com.onseven.dbvis.v.S.A.O o3 = new com.onseven.dbvis.v.S.A.O(false, w2, null, x2, 0L);
        o3.\uce9f(d.W.\u89bb);
        o3.\uce9f(this.dbConnection, string3, string4, b2, a2, string5, false, bl3, bl4, bl5, true, o2, this.currentFile, "Executing Command Line");
        try {
            o3.\u0579();
            X x3 = o3.\u9473();
            if (x3.\u0287()) {
                n2 = 3;
            } else if (x3.\u823c() > 0) {
                n2 = 4;
            }
        }
        catch (com.onseven.dbvis.v.S.z z2) {
            LOG.log(Level.WARNING, "Exception when running script", z2);
            throw new IllegalStateException("Executing script: " + z2.getMessage());
        }
        finally {
            if (x2 != null) {
                try {
                    x2.close();
                }
                catch (IOException iOException) {}
            }
            if (this.outputWriter != null) {
                this.outputWriter.close();
                this.outputWriter = null;
            }
        }
        return n2;
    }

    protected W createCallback(long l2, int n2, boolean bl) {
        return new W(l2, n2, bl);
    }

    protected void exit(int n2) {
        System.exit(n2);
    }

    protected void disconnect() {
        try {
            if (this.dbConnection != null) {
                this.dbConnection.\ubc36().\ub4ba().\u983f(false);
                this.dbConnection = null;
            }
        }
        catch (com.onseven.dbvis.sql.e e2) {
            throw new IllegalStateException("Disconnecting: " + e2.getMessage());
        }
    }

    private String getCatalog(e e2, O o2) {
        String string = e2.\uc858() != null ? e2.\uc858() : o2.\u1e03();
        return string;
    }

    private List<com.onseven.dbvis.sql._> getConnections() {
        return z.\u89bb().\u505e().\u823c().\u217a();
    }

    private PrintWriter createOutPutWriter(e e2) throws IOException {
        PrintWriter printWriter;
        if (e2.\u7960().equals("none")) {
            return null;
        }
        if (e2.\u1e03() != null) {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(e2.\u1e03()));
            printWriter = new PrintWriter(fileOutputStream);
        } else {
            printWriter = new PrintWriter((Writer)new OutputStreamWriter(System.out), true);
        }
        return printWriter;
    }

    private com.onseven.dbvis.v.S.S.X createExecutionLogHandler(e e2) throws IOException {
        com.onseven.dbvis.v.S.S.z z2 = new com.onseven.dbvis.v.S.S.z();
        z2.\u505e(true);
        com.onseven.dbvis.v.S.S.X x2 = com.onseven.dbvis.v.S.S.R.\u89bb().\uce9f("dbviscmd", z2, "");
        if (this.shallLogCommands(e2)) {
            com.onseven.dbvis.v.S.S.A.J j2 = this.initLogTextOptions(e2);
            com.onseven.dbvis.v.S.S.A.A a2 = new com.onseven.dbvis.v.S.S.A.A(this.getLogHandlerPrintWriter(), z2, j2);
            x2.\u89bb(a2);
        }
        return x2;
    }

    protected PrintWriter getLogHandlerPrintWriter() throws IOException {
        return this.outputWriter;
    }

    protected com.onseven.dbvis.v.S.S.A.J initLogTextOptions(e e2) {
        return j.\u1f71();
    }

    protected boolean shallLogCommands(e e2) {
        String string = e2.\u7960();
        return !string.equals("none") && !string.equals("result");
    }

    private v getScriptSources(e e2) throws IOException {
        Object object;
        String string;
        v v2;
        com.onseven.dbvis.Z.O o2;
        String string2 = null;
        String string3 = System.getProperty("user.dir");
        String string4 = e2.\u8399();
        if (string4 != null) {
            if (string4.trim().isEmpty()) {
                throw new IllegalStateException("The command for the -sql parameter must not be empty");
            }
            o2 = new r(string4);
            v2 = new v(string4);
        } else {
            string = e2.\u9d0d();
            object = new File(string);
            if (!((File)object).exists()) {
                throw new IllegalStateException("The -sqlfile parameter refers '" + string + "' that doesn't exist");
            }
            if (((File)object).length() == 0L) {
                throw new IllegalStateException("The -sqlfile parameter requires a file with content");
            }
            this.currentFile = object;
            string2 = e2.\ubc36();
            o2 = new J((File)object, string2);
            v2 = new v(o2);
            string3 = ((File)object).getParent();
        }
        string = this.dbConnection.\ubc36().\uce9f().\u905a();
        object = new com.onseven.dbvis.Z.b(string, o2);
        Vector<com.onseven.dbvis.Z.R> vector = ((com.onseven.dbvis.Z.b)object).\u983f();
        if (o2 instanceof J) {
            ((J)o2).\u7184();
            if (vector.size() > 50000) {
                System.out.println("\nIf the file you specified with -sqlfile does not contain any @run commands, it will be processed much faster if you use -sql \"@run <fileName>\". Use Ctrl-C to stop and rerun with -sql\n");
            }
        }
        ArrayList<J> arrayList = null;
        int n2 = 0;
        com.onseven.dbvis.v.S.A.d d2 = new com.onseven.dbvis.v.S.A.d();
        Enumeration<com.onseven.dbvis.Z.R> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            com.onseven.dbvis.Z.R r2 = enumeration.nextElement();
            String string5 = r2.\u983f();
            com.onseven.dbvis.v.S.A.W.A a2 = G.\u89bb();
            S s2 = a2.\uce9f(null, string5, d2);
            J j2 = null;
            if (s2 != null) {
                if (s2.\u1e03().\uce9f(d.\u781f.\u89bb())) {
                    string3 = s2.\ubc36();
                } else if (s2.\u1e03().\uce9f(d.\ufc32.\u89bb())) {
                    String string6 = B.\ufc32().getProperty("VariableIdentifierPrefix");
                    D d3 = (D)s2;
                    j2 = d3.\uce9f(string6, string3, string2);
                }
            }
            if (j2 != null) {
                if (arrayList == null) {
                    arrayList = new ArrayList<J>();
                    v2.\uce9f(arrayList);
                }
                arrayList.add(j2);
            }
            if (++n2 % 10000 != 0) continue;
            System.out.println("Scanned " + (n2 - 1) + " of " + vector.size() + " statements for @run commands");
        }
        return v2;
    }

    private O connect(e e2) throws com.onseven.dbvis.sql.e {
        O o2;
        Object object;
        Object object2;
        if (e2.\uc72e()) {
            object2 = this.createTmpAlias();
            object = e2.\ube57();
            String string = e2.\ubd29();
            String string2 = e2.\u6e25();
            if (object == null && string != null && string2 != null) {
                object = (String)object2 + "-driver";
            }
            o2 = O.\uce9f((String)object, string, e2.\uc0ab(), (String)object2, string2, e2.\u9c6c(), e2.\ub397(), "jdbc");
        } else {
            o2 = O.\uce9f(null, null, null, e2.\u86f9(), null, e2.\u9c6c(), e2.\ub397(), "jdbc");
            if (o2 != null && e2.\ub397() != null && (object2 = o2.\ubc36()) != null) {
                ((com.onseven.dbvis.sql._)object2).\u0f59().setProperty("ConnectionPassword", "ClearAtDisconnect");
            }
        }
        if (o2 != null) {
            o2.\u905a(false);
            object2 = this.getCatalog(e2, o2);
            Object object3 = object = object2 != null ? o2.\ubc36().\u983f((String)object2) : o2.\ubc36();
            if (!o2.equals(((com.onseven.dbvis.sql._)object).\ub4ba())) {
                ((com.onseven.dbvis.sql._)object).\uce9f(false);
                o2 = ((com.onseven.dbvis.sql._)object).\ub4ba();
            }
        }
        return o2;
    }

    protected String createTmpAlias() {
        return "dbviscommand-" + z.\u89bb().\u0579();
    }

    private int listDson(e e2) {
        final boolean bl = e2.\u796b();
        String string = e2.\u8de6();
        File file = new File(string);
        if (!file.isDirectory()) {
            System.out.println("Not an accessible directory " + string);
            return 2;
        }
        final FastDateFormat fastDateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
        com.onseven.dbvis.util.v.J j2 = new com.onseven.dbvis.util.v.J(){

            @Override
            protected void \uce9f(File file, R r2) {
                long l2 = file.lastModified();
                String string = fastDateFormat.format(l2);
                String string2 = bl ? file.getAbsolutePath() : file.getName();
                String string3 = r2.\u983f().name();
                System.out.println(String.format("%-12s %-5s %-7s", string, string3, string2));
            }
        };
        Path path = Paths.get(string, new String[0]);
        try {
            j2.\uce9f(path, bl);
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, "Got exception when listing DSON files file", iOException);
        }
        return 0;
    }

    private int convertDson(e e2) {
        int n2 = 2;
        PrintWriter printWriter = new PrintWriter(System.out);
        String string = e2.\u5843();
        File file = new File(string);
        if (!file.isFile()) {
            System.out.println("Not an accessible file " + string);
            return n2;
        }
        com.onseven.dbvis.v.S.S.A.J j2 = new com.onseven.dbvis.v.S.S.A.J(null);
        j2.\u905a(true);
        j2.\u89bb(true);
        j2.\uce9f(false);
        j2.\u823c();
        try {
            com.onseven.dbvis.v.S.S.R.\u89bb().\uce9f(file, printWriter, null, j2);
            n2 = 0;
        }
        catch (Exception exception) {
            LOG.log(Level.INFO, "Got exception when converting json file", exception);
        }
        return n2;
    }

    private int formatDson(e e2) {
        int n2 = 2;
        PrintWriter printWriter = new PrintWriter(System.out);
        String string = e2.\u9007();
        File file = new File(string);
        if (!file.isFile()) {
            System.out.println("Not an accessible file: " + string);
            return n2;
        }
        com.onseven.dbvis.util.v.A a2 = new com.onseven.dbvis.util.v.A();
        try {
            a2.\uce9f(file.getAbsolutePath(), printWriter);
            printWriter.flush();
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, "Got exception when formatting json file", iOException);
        }
        return n2;
    }

    static {
        LOG = Logger.getLogger(DbVisualizerCmd.class.getName());
    }

    private static class A
    extends W.W.W {
        A(W.W w2) {
            super(w2);
        }

        @Override
        public void \uce9f() {
            char[] cArray;
            e e2 = (e)DbVisualizerCmd.getArgumentParser();
            String string = e2.\ubf16();
            if (string != null) {
                cArray = string.toCharArray();
                if (!this.\uce9f(cArray)) {
                    throw new IllegalArgumentException("Invalid Master Password provided with -masterpw");
                }
            } else {
                System.out.println("Please enter the Master Password: ");
                Console console = System.console();
                cArray = console.readPassword();
                while (!this.\uce9f(cArray)) {
                    System.out.println("Invalid Master Password. Please try again: ");
                    cArray = console.readPassword();
                }
            }
            this.\u89bb.\uce9f(cArray);
            Arrays.fill(cArray, ' ');
        }
    }

    protected class W
    implements com.onseven.dbvis.v.S.A {
        private long \u89bb;
        private int \u905a;
        private final boolean \u505e;

        W(long l2, int n2, boolean bl) {
            this.\u89bb = l2;
            this.\u905a = n2;
            this.\u505e = bl;
        }

        @Override
        public long \uce9f() {
            return this.\u89bb;
        }

        @Override
        public int \u89bb() {
            return this.\u905a;
        }

        @Override
        public void \uce9f(com.onseven.dbvis.v.A.S s2) {
            if (s2 != null && s2.getRowCount() > 0 && DbVisualizerCmd.this.outputWriter != null && this.\u505e) {
                this.\uce9f(s2, DbVisualizerCmd.this.outputWriter);
            }
        }

        @Override
        public void \uce9f(com.onseven.dbvis.sql.W.W w2) {
            throw new UnsupportedOperationException("Not supported.");
        }

        private void \uce9f(com.onseven.dbvis.v.A.S s2, PrintWriter printWriter) {
            l l2 = new l(s2, true);
            while (l2.hasNext()) {
                StringBuffer stringBuffer = l2.\u983f();
                if (stringBuffer == null) continue;
                printWriter.println(stringBuffer);
            }
        }
    }
}

