/*
 * Decompiled with CFR 0.152.
 */
package com.exe4j.runtime.util;

import com.exe4j.runtime.util.DisplayTextArea;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class InternalErrorFrame
extends JFrame
implements ActionListener {
    private static final int FRAME_HEIGHT = 300;
    private static final int FRANE_WIDTH = 400;
    private Throwable throwable;
    private DisplayTextArea dtxa;
    private JTextArea txaStackTrace;
    private JScrollPane scpStackTrace;
    private JButton btnOk;

    public InternalErrorFrame(Throwable t) {
        this.init(t);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.btnOk) {
            System.exit(1);
        }
    }

    public Rectangle getFrameBounds() {
        Rectangle bounds = new Rectangle(new Point(0, 0), Toolkit.getDefaultToolkit().getScreenSize());
        float factor = 1.0f;
        int width = (int)(factor * 400.0f);
        int height = (int)(factor * 300.0f);
        int deltaX = bounds.width - (width == -1 ? this.getWidth() : width);
        int deltaY = bounds.height - (height == -1 ? this.getHeight() : height);
        bounds.x += deltaX / 2;
        bounds.width -= deltaX;
        bounds.y += deltaY / 2;
        bounds.height -= deltaY;
        if (bounds.x < 0) {
            bounds.translate(-bounds.x, 0);
        }
        if (bounds.y < 0) {
            bounds.translate(0, -bounds.y);
        }
        return bounds;
    }

    private void init(Throwable t) {
        this.throwable = t;
        this.setBackground(UIManager.getColor("control"));
        this.setupControls();
        this.setupComponent();
        this.setupEventHandlers();
    }

    private void setupControls() {
        this.btnOk = new JButton("OK");
        this.dtxa = new DisplayTextArea();
        this.dtxa.setText("An error has occurred during startup:");
        this.txaStackTrace = new JTextArea();
        StringWriter stringWriter = new StringWriter();
        PrintWriter pw = new PrintWriter(stringWriter);
        this.throwable.printStackTrace(pw);
        this.txaStackTrace.setEditable(false);
        this.txaStackTrace.setText(stringWriter.getBuffer().toString());
        this.scpStackTrace = new JScrollPane(this.txaStackTrace);
    }

    private void setupComponent() {
        this.setTitle("Startup Error");
        this.setBounds(this.getFrameBounds());
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.anchor = 10;
        gc.insets = new Insets(7, 7, 7, 7);
        ImageIcon icon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(InternalErrorFrame.class.getResource("error_32.png")));
        contentPane.add((Component)new JLabel(icon), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        gc.fill = 2;
        contentPane.add((Component)this.dtxa, gc);
        gc.gridx = 0;
        gc.gridwidth = 2;
        gc.gridy = 1;
        gc.weighty = 1.0;
        gc.fill = 1;
        gc.insets = new Insets(3, 3, 3, 3);
        contentPane.add((Component)this.scpStackTrace, gc);
        gc.weighty = 0.0;
        gc.fill = 0;
        gc.gridy = 2;
        contentPane.add((Component)this.btnOk, gc);
        this.setDefaultCloseOperation(0);
    }

    private void setupEventHandlers() {
        this.btnOk.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                InternalErrorFrame.this.txaStackTrace.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
            }

            @Override
            public void windowClosed(WindowEvent e) {
                System.exit(1);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(1);
            }
        });
    }
}

