/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.MouseInputAdapter;

public class ScrollPaneOverview
extends JComponent {
    private static final int \u0102 = 400;
    private static final int \u0108 = 20;
    private Component \u0106;
    private JScrollPane \u0104;
    private Component \u010d;
    protected JPopupMenu _popupMenu;
    private BufferedImage \u0109;
    private Rectangle \u010c;
    private Rectangle \u010b;
    private Point \u0103;
    private double \u0107;
    private int \u010a;
    private int \u0105;
    private Color \u0101 = Color.BLACK;

    public ScrollPaneOverview(JScrollPane jScrollPane, Component component) {
        this.\u0104 = jScrollPane;
        this.\u0106 = component;
        this.\u0109 = null;
        this.\u010c = null;
        this.\u010b = null;
        this.\u0103 = null;
        this.\u0107 = 0.0;
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setCursor(Cursor.getPredefinedCursor(13));
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (ScrollPaneOverview.this.\u0103 != null) {
                    Point point = mouseEvent.getPoint();
                    int n2 = (int)((double)(point.x - ((ScrollPaneOverview)ScrollPaneOverview.this).\u0103.x) / ScrollPaneOverview.this.\u0107);
                    int n3 = (int)((double)(point.y - ((ScrollPaneOverview)ScrollPaneOverview.this).\u0103.y) / ScrollPaneOverview.this.\u0107);
                    ScrollPaneOverview.this.\u0102(n2, n3);
                }
                ScrollPaneOverview.this.\u0103 = null;
                ScrollPaneOverview.this.\u010c = ScrollPaneOverview.this.\u010b;
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (ScrollPaneOverview.this.\u0103 == null) {
                    ScrollPaneOverview.this.\u0103 = new Point(((ScrollPaneOverview)ScrollPaneOverview.this).\u010b.x + ((ScrollPaneOverview)ScrollPaneOverview.this).\u010b.width / 2, ((ScrollPaneOverview)ScrollPaneOverview.this).\u010b.y + ((ScrollPaneOverview)ScrollPaneOverview.this).\u010b.height / 2);
                }
                Point point = mouseEvent.getPoint();
                ScrollPaneOverview.this.\u0101(point.x - ((ScrollPaneOverview)ScrollPaneOverview.this).\u0103.x, point.y - ((ScrollPaneOverview)ScrollPaneOverview.this).\u0103.y);
            }
        };
        this.addMouseListener(mouseInputAdapter);
        this.addMouseMotionListener(mouseInputAdapter);
        this._popupMenu = new JPopupMenu();
        this._popupMenu.setLayout(new BorderLayout());
        this._popupMenu.add((Component)this, "Center");
    }

    public void setSelectionBorderColor(Color color) {
        this.\u0101 = color;
    }

    public Color getSelectionBorder() {
        return this.\u0101;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.\u0109 == null || this.\u010b == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Insets insets = this.getInsets();
        int n2 = insets.left;
        int n3 = insets.top;
        graphics.setColor(this.\u0104.getViewport().getView().getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.drawImage(this.\u0109, n2, n3, null);
        int n4 = this.getWidth() - insets.left - insets.right;
        int n5 = this.getHeight() - insets.top - insets.bottom;
        Area area = new Area(new Rectangle(n2, n3, n4, n5));
        area.subtract(new Area(this.\u010b));
        graphics.setColor(new Color(255, 255, 255, 128));
        graphics2D.fill(area);
        Color color = graphics.getColor();
        graphics.setColor(this.\u0101);
        graphics.drawRect(this.\u010b.x, this.\u010b.y, this.\u010b.width, this.\u010b.height);
        graphics.setColor(color);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.\u0109 == null || this.\u010b == null) {
            return new Dimension();
        }
        Insets insets = this.getInsets();
        return new Dimension(this.\u0109.getWidth(null) + insets.left + insets.right, this.\u0109.getHeight(null) + insets.top + insets.bottom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display() {
        this.\u010d = this.\u0104.getViewport().getView();
        if (this.\u010d == null) {
            return;
        }
        int n2 = Math.max(400, Math.max(this.\u0104.getWidth(), this.\u0104.getHeight()) / 2);
        int n3 = Math.min(this.\u010d.getWidth(), this.\u0104.getViewport().getWidth() * 20);
        if (n3 <= 0) {
            return;
        }
        int n4 = Math.min(this.\u010d.getHeight(), this.\u0104.getViewport().getHeight() * 20);
        if (n4 <= 0) {
            return;
        }
        double d2 = (double)n2 / (double)n3;
        double d3 = (double)n2 / (double)n4;
        this.\u0107 = Math.max(0.05, Math.min(d2, d3));
        this.\u0109 = new BufferedImage((int)((double)n3 * this.\u0107), (int)((double)n4 * this.\u0107), 1);
        Graphics2D graphics2D = this.\u0109.createGraphics();
        graphics2D.scale(this.\u0107, this.\u0107);
        graphics2D.setClip(this.\u010a, this.\u0105, n3, n4);
        boolean bl = this.\u010d.isDoubleBuffered();
        try {
            if (this.\u010d instanceof JComponent) {
                ((JComponent)this.\u010d).setDoubleBuffered(false);
            }
            this.\u010d.paint(graphics2D);
        }
        finally {
            if (this.\u010d instanceof JComponent) {
                ((JComponent)this.\u010d).setDoubleBuffered(bl);
            }
            graphics2D.dispose();
        }
        this.\u010c = this.\u0104.getViewport().getViewRect();
        Insets insets = this.getInsets();
        this.\u010c.x = (int)(this.\u0107 * (double)this.\u010c.x + (double)insets.left);
        this.\u010c.y = (int)(this.\u0107 * (double)this.\u010c.y + (double)insets.right);
        this.\u010c.width = (int)((double)this.\u010c.width * this.\u0107);
        this.\u010c.height = (int)((double)this.\u010c.height * this.\u0107);
        this.\u010b = this.\u010c;
        Point point = new Point(this.\u010b.x + this.\u010b.width / 2, this.\u010b.y + this.\u010b.height / 2);
        this.showPopup(-point.x, -point.y, this.\u0106);
    }

    protected void showPopup(int n2, int n3, Component component) {
        this._popupMenu.show(component, n2, n3);
    }

    private void \u0101(int n2, int n3) {
        if (this.\u010c == null) {
            return;
        }
        Insets insets = this.getInsets();
        Rectangle rectangle = new Rectangle(this.\u010c);
        rectangle.x += n2;
        rectangle.y += n3;
        rectangle.x = Math.min(Math.max(rectangle.x, insets.left), this.getWidth() - insets.right - rectangle.width);
        rectangle.y = Math.min(Math.max(rectangle.y, insets.right), this.getHeight() - insets.bottom - rectangle.height);
        Rectangle rectangle2 = new Rectangle();
        Rectangle.union(this.\u010b, rectangle, rectangle2);
        rectangle2.grow(2, 2);
        this.\u010b = rectangle;
        this.paintImmediately(rectangle2);
    }

    private void \u0102(int n2, int n3) {
        JComponent jComponent = (JComponent)this.\u0104.getViewport().getView();
        Rectangle rectangle = jComponent.getVisibleRect();
        rectangle.x += this.\u010a + n2;
        rectangle.y += this.\u0105 + n3;
        jComponent.scrollRectToVisible(rectangle);
        this._popupMenu.setVisible(false);
    }
}

