/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.animation;

import com.jidesoft.animation.Function;
import com.jidesoft.swing.Animator;
import com.jidesoft.swing.AnimatorListener;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.SecurityUtils;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.event.EventListenerList;

public class CustomAnimation
implements Serializable,
Cloneable {
    public static final int TYPE_ENTRANCE = 0;
    public static final int TYPE_EXIT = 1;
    private int \u0113;
    public static final int EFFECT_FLY = 100;
    public static final int EFFECT_ZOOM = 101;
    public static final int EFFECT_FADE = 201;
    private int \u0101 = 100;
    int \u010a = 0;
    public static final int SMOOTHNESS_VERY_SMOOTH = 100;
    public static final int SMOOTHNESS_SMOOTH = 50;
    public static final int SMOOTHNESS_MEDIUM = 20;
    public static final int SMOOTHNESS_ROUGH = 10;
    public static final int SMOOTHNESS_VERY_ROUGH = 5;
    private int \u010f = 20;
    public static final int SPEED_VERY_SLOW = 200;
    public static final int SPEED_SLOW = 100;
    public static final int SPEED_MEDIUM = 50;
    public static final int SPEED_FAST = 25;
    public static final int SPEED_VERY_FAST = 10;
    private int \u010d = 50;
    public static final int IN = 0;
    public static final int OUT = 1;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int CENTER = 0;
    public static final int BOTTOM = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int TOP = 4;
    public static final int BOTTOM_LEFT = 5;
    public static final int BOTTOM_RIGHT = 6;
    public static final int TOP_LEFT = 7;
    public static final int TOP_RIGHT = 8;
    public static final int LEFT_DOWN = 0;
    public static final int LEFT_UP = 1;
    public static final int RIGHT_DOWN = 2;
    public static final int RIGHT_UP = 3;
    private int \u0111 = 1;
    private int \u0110;
    private Point \u010c;
    private Point \u0109;
    private Rectangle \u0102;
    private Animator \u010b;
    private Image \u0105;
    private Callback \u0103;
    private Function \u0108;
    private Function \u0107;
    private Function \u010e;
    private Function \u0112;
    public static Function FUNC_LINEAR = new Function(){

        @Override
        public double calculate(int n2, int n3) {
            return (double)n2 / (double)n3;
        }
    };
    public static Function FUNC_POW_HALF = new Function(){

        @Override
        public double calculate(int n2, int n3) {
            return Math.pow((double)n2 / (double)n3, 0.5);
        }
    };
    public static Function FUNC_POW2 = new Function(){

        @Override
        public double calculate(int n2, int n3) {
            return Math.pow((double)n2 / (double)n3, 2.0);
        }
    };
    public static Function FUNC_POW3 = new Function(){

        @Override
        public double calculate(int n2, int n3) {
            return Math.pow((double)n2 / (double)n3, 3.0);
        }
    };
    public static Function FUNC_LOG = new Function(){

        @Override
        public double calculate(int n2, int n3) {
            return Math.log((double)n2 / (double)n3);
        }
    };
    public static Function FUNC_BOUNCE = new Function(){

        @Override
        public double calculate(int n2, int n3) {
            double d2 = (double)n2 / (double)n3;
            if (d2 == 0.0) {
                return 0.0;
            }
            return 1.0 - Math.abs(Math.sin(d2 * 9.4) / (d2 * 10.0));
        }
    };
    public static Function FUNC_VIBRATE = new Function(){

        @Override
        public double calculate(int n2, int n3) {
            double d2 = (double)n2 / (double)n3;
            if (d2 == 0.0) {
                return 0.0;
            }
            return 1.0 - Math.sin(d2 * 9.4) / (d2 * 10.0);
        }
    };
    private AnimatorListener \u0104;
    private EventListenerList \u0106 = new EventListenerList();

    public CustomAnimation() {
    }

    public CustomAnimation(int n2, int n3, int n4, int n5) {
        this.\u0113 = n2;
        this.\u0101 = n3;
        this.\u010f = n4;
        this.\u010d = n5;
    }

    public int getType() {
        return this.\u0113;
    }

    public void setType(int n2) {
        this.\u0113 = n2;
    }

    public int getEffect() {
        return this.\u0101;
    }

    public void setEffect(int n2) {
        this.\u0101 = n2;
    }

    public int getInitDelay() {
        return this.\u010a;
    }

    public void setInitDelay(int n2) {
        this.\u010a = n2;
    }

    public int getSmoothness() {
        return this.\u010f;
    }

    public void setSmoothness(int n2) {
        this.\u010f = n2;
    }

    public int getSpeed() {
        return this.\u010d;
    }

    public void setSpeed(int n2) {
        this.\u010d = n2;
    }

    public int getDirection() {
        return this.\u0111;
    }

    public void setDirection(int n2) {
        this.\u0111 = n2;
    }

    public int getSecondaryDirection() {
        return this.\u0110;
    }

    public void setSecondaryDirection(int n2) {
        this.\u0110 = n2;
    }

    public Point getStartLocation() {
        return this.\u010c;
    }

    public void setStartLocation(Point point) {
        this.\u010c = point;
    }

    public Point getEndLocation() {
        return this.\u0109;
    }

    public void setEndLocation(Point point) {
        this.\u0109 = point;
    }

    public Rectangle getVisibleBounds() {
        if (this.\u0102 == null) {
            return PortingUtils.getLocalScreenBounds();
        }
        return this.\u0102;
    }

    public void setVisibleBounds(Rectangle rectangle) {
        this.\u0102 = rectangle;
    }

    public void start(Component component) {
        if (this.\u010b != null) {
            this.\u010b.stop();
            this.\u010b = null;
        }
        this.\u010b = new Animator(component, this.getInitDelay(), this.getSpeed(), this.getSmoothness());
        this.customizeAnimator(this.\u010b);
        if (this.\u0106 != null) {
            AnimatorListener[] animatorListenerArray;
            for (AnimatorListener animatorListener : animatorListenerArray = this.getAnimatorListeners()) {
                this.\u010b.addAnimatorListener(animatorListener);
            }
        }
        this.\u010b.start();
    }

    public AnimatorListener getAnimatorListener() {
        return this.\u0104;
    }

    public void setAnimatorListener(AnimatorListener animatorListener) {
        this.\u0104 = animatorListener;
    }

    public void addAnimatorListener(AnimatorListener animatorListener) {
        this.\u0106.add(AnimatorListener.class, animatorListener);
    }

    public void removeAnimatorListener(AnimatorListener animatorListener) {
        this.\u0106.remove(AnimatorListener.class, animatorListener);
    }

    public AnimatorListener[] getAnimatorListeners() {
        return (AnimatorListener[])this.\u0106.getListeners(AnimatorListener.class);
    }

    protected void customizeAnimator(Animator animator) {
        AnimatorListener animatorListener = this.getAnimatorListener();
        if (animatorListener != null) {
            animator.addAnimatorListener(animatorListener);
        } else {
            block0 : switch (this.getEffect()) {
                case 201: {
                    switch (this.getType()) {
                        case 0: {
                            this.\u0101(animator);
                            break;
                        }
                        case 1: {
                            this.\u0105(animator);
                        }
                    }
                    break;
                }
                case 101: {
                    switch (this.getType()) {
                        case 0: {
                            this.\u0102(animator);
                            break;
                        }
                        case 1: {
                            this.\u0104(animator);
                        }
                    }
                    break;
                }
                case 100: {
                    switch (this.getType()) {
                        case 0: {
                            this.\u0106(animator);
                            break block0;
                        }
                        case 1: {
                            this.\u0103(animator);
                        }
                    }
                }
            }
        }
    }

    public void stop() {
        if (this.\u010b != null) {
            this.\u010b.stop();
            this.\u010b = null;
        }
    }

    protected double getPercentX(int n2, int n3) {
        if (this.getFunctionX() == null) {
            return FUNC_LINEAR.calculate(n2, n3);
        }
        return this.getFunctionX().calculate(n2, n3);
    }

    protected double getPercentY(int n2, int n3) {
        if (this.getFunctionY() == null) {
            return FUNC_LINEAR.calculate(n2, n3);
        }
        return this.getFunctionY().calculate(n2, n3);
    }

    protected double getPercentFade(int n2, int n3) {
        if (this.getFunctionFade() == null) {
            return FUNC_LINEAR.calculate(n2, n3);
        }
        return this.getFunctionFade().calculate(n2, n3);
    }

    protected double getPercentZoom(int n2, int n3) {
        if (this.getFunctionZoom() == null) {
            return FUNC_LINEAR.calculate(n2, n3);
        }
        return this.getFunctionZoom().calculate(n2, n3);
    }

    public Image getScreenImage() {
        return this.\u0105;
    }

    public void setScreenImage(Image image) {
        this.\u0105 = image;
    }

    public Callback getCallback() {
        return this.\u0103;
    }

    public void setCallback(Callback callback) {
        this.\u0103 = callback;
    }

    private void \u0102(Animator animator) {
        animator.addAnimatorListener(new AnimatorListener(){
            private Point \u0118;
            private Point \u011c;
            private int \u011a;
            private int \u0119;
            private Dimension \u0117;
            private Dimension \u0115;
            private int \u011b;
            private int \u0116;

            @Override
            public void animationStarts(Component component) {
                this.\u0118 = CustomAnimation.this.getEndLocation() != null ? CustomAnimation.this.getEndLocation() : component.getLocation();
                Dimension dimension = component.getSize();
                if (CustomAnimation.this.getStartLocation() != null) {
                    this.\u011c = CustomAnimation.this.getStartLocation();
                } else {
                    switch (CustomAnimation.this.getDirection()) {
                        case 1: {
                            this.\u011c = new Point(this.\u0118.x, CustomAnimation.this.getVisibleBounds().y + CustomAnimation.this.getVisibleBounds().height);
                            break;
                        }
                        case 5: {
                            this.\u011c = new Point(CustomAnimation.this.getVisibleBounds().x - dimension.width, CustomAnimation.this.getVisibleBounds().y + CustomAnimation.this.getVisibleBounds().height);
                            break;
                        }
                        case 6: {
                            this.\u011c = new Point(CustomAnimation.this.getVisibleBounds().x + CustomAnimation.this.getVisibleBounds().width, CustomAnimation.this.getVisibleBounds().y + CustomAnimation.this.getVisibleBounds().height);
                            break;
                        }
                        case 4: {
                            this.\u011c = new Point(this.\u0118.x, CustomAnimation.this.getVisibleBounds().y - dimension.height);
                            break;
                        }
                        case 7: {
                            this.\u011c = new Point(CustomAnimation.this.getVisibleBounds().x - dimension.width, CustomAnimation.this.getVisibleBounds().y - dimension.height);
                            break;
                        }
                        case 8: {
                            this.\u011c = new Point(CustomAnimation.this.getVisibleBounds().x + CustomAnimation.this.getVisibleBounds().width, CustomAnimation.this.getVisibleBounds().y - dimension.height);
                            break;
                        }
                        case 3: {
                            this.\u011c = new Point(CustomAnimation.this.getVisibleBounds().x + CustomAnimation.this.getVisibleBounds().width, this.\u0118.y);
                            break;
                        }
                        case 2: {
                            this.\u011c = new Point(CustomAnimation.this.getVisibleBounds().x - dimension.width, this.\u0118.y);
                        }
                    }
                }
                this.\u011a = this.\u0118.x - this.\u011c.x;
                this.\u0119 = this.\u0118.y - this.\u011c.y;
                component.setLocation(this.\u011c);
                this.\u0117 = new Dimension(0, 0);
                this.\u0115 = dimension;
                this.\u011b = this.\u0115.width - this.\u0117.width;
                this.\u0116 = this.\u0115.height - this.\u0117.height;
                component.setSize(this.\u0117);
                if (!component.isVisible()) {
                    component.setVisible(true);
                }
            }

            @Override
            public void animationFrame(Component component, int n2, int n3) {
                component.setLocation(this.\u0118.x - (int)((double)this.\u011a * (1.0 - CustomAnimation.this.getPercentX(n3, n2))), this.\u0118.y - (int)((double)this.\u0119 * (1.0 - CustomAnimation.this.getPercentY(n3, n2))));
                component.setSize((int)((double)this.\u011b * CustomAnimation.this.getPercentZoom(n3, n2)), (int)((double)this.\u0116 * CustomAnimation.this.getPercentZoom(n3, n2)));
            }

            @Override
            public void animationEnds(Component component) {
                component.setLocation(this.\u0118);
                component.setSize(this.\u0115);
                if (CustomAnimation.this.getCallback() != null) {
                    CustomAnimation.this.getCallback().performed();
                }
            }
        });
    }

    private void \u0104(Animator animator) {
        animator.addAnimatorListener(new AnimatorListener(){
            private Point \u010f;
            private Point \u0113;
            private int \u0111;
            private int \u0110;
            private Dimension \u010e;
            private Dimension \u010c;
            private int \u0112;
            private int \u010d;

            @Override
            public void animationStarts(Component component) {
                Dimension dimension = component.getSize();
                Point point = this.\u0113 = CustomAnimation.this.getStartLocation() == null ? component.getLocation() : CustomAnimation.this.getStartLocation();
                if (CustomAnimation.this.getEndLocation() != null) {
                    this.\u010f = CustomAnimation.this.getEndLocation();
                } else {
                    switch (CustomAnimation.this.getDirection()) {
                        case 1: {
                            this.\u010f = new Point(this.\u0113.x, CustomAnimation.this.getVisibleBounds().y + CustomAnimation.this.getVisibleBounds().height);
                            break;
                        }
                        case 6: {
                            this.\u010f = new Point(CustomAnimation.this.getVisibleBounds().x + CustomAnimation.this.getVisibleBounds().width, CustomAnimation.this.getVisibleBounds().y + CustomAnimation.this.getVisibleBounds().height);
                            break;
                        }
                        case 5: {
                            this.\u010f = new Point(CustomAnimation.this.getVisibleBounds().x - dimension.width, CustomAnimation.this.getVisibleBounds().y + CustomAnimation.this.getVisibleBounds().height);
                            break;
                        }
                        case 4: {
                            this.\u010f = new Point(this.\u0113.x, CustomAnimation.this.getVisibleBounds().y - dimension.height);
                            break;
                        }
                        case 8: {
                            this.\u010f = new Point(CustomAnimation.this.getVisibleBounds().x + CustomAnimation.this.getVisibleBounds().width, CustomAnimation.this.getVisibleBounds().y - dimension.height);
                            break;
                        }
                        case 7: {
                            this.\u010f = new Point(CustomAnimation.this.getVisibleBounds().x - dimension.width, CustomAnimation.this.getVisibleBounds().y - dimension.height);
                            break;
                        }
                        case 3: {
                            this.\u010f = new Point(CustomAnimation.this.getVisibleBounds().x + CustomAnimation.this.getVisibleBounds().width, this.\u0113.y);
                            break;
                        }
                        case 2: {
                            this.\u010f = new Point(CustomAnimation.this.getVisibleBounds().x - dimension.width, this.\u0113.y);
                        }
                    }
                }
                this.\u0111 = this.\u010f.x - this.\u0113.x;
                this.\u0110 = this.\u010f.y - this.\u0113.y;
                this.\u010e = new Dimension(0, 0);
                this.\u010c = dimension;
                this.\u0112 = this.\u010c.width - this.\u010e.width;
                this.\u010d = this.\u010c.height - this.\u010e.height;
                if (!component.isVisible()) {
                    component.setVisible(true);
                }
            }

            @Override
            public void animationFrame(Component component, int n2, int n3) {
                component.setLocation(this.\u010f.x - (int)((double)this.\u0111 * (1.0 - CustomAnimation.this.getPercentX(n3, n2))), this.\u010f.y - (int)((double)this.\u0110 * (1.0 - CustomAnimation.this.getPercentY(n3, n2))));
                int n4 = (int)((double)this.\u0112 * (1.0 - CustomAnimation.this.getPercentZoom(n3, n2)));
                int n5 = (int)((double)this.\u010d * (1.0 - CustomAnimation.this.getPercentZoom(n3, n2)));
                component.setSize(Math.max(1, n4), Math.max(1, n5));
            }

            @Override
            public void animationEnds(Component component) {
                component.setLocation(this.\u010f);
                component.setSize(this.\u010c);
                if (component.isVisible()) {
                    component.setVisible(false);
                }
                if (CustomAnimation.this.getCallback() != null) {
                    CustomAnimation.this.getCallback().performed();
                }
            }
        });
    }

    private void \u0106(Animator animator) {
        animator.addAnimatorListener(new AnimatorListener(){
            private Point \u012e;
            private Point \u012d;
            private int \u012c;
            private int \u012b;

            @Override
            public void animationStarts(Component component) {
                this.\u012e = CustomAnimation.this.getEndLocation() != null ? CustomAnimation.this.getEndLocation() : component.getLocation();
                Dimension dimension = component.getSize();
                if (CustomAnimation.this.getStartLocation() != null) {
                    this.\u012d = CustomAnimation.this.getStartLocation();
                } else {
                    switch (CustomAnimation.this.getDirection()) {
                        case 1: {
                            this.\u012d = new Point(this.\u012e.x, CustomAnimation.this.getVisibleBounds().y + CustomAnimation.this.getVisibleBounds().height);
                            break;
                        }
                        case 5: {
                            this.\u012d = new Point(CustomAnimation.this.getVisibleBounds().x - dimension.width, CustomAnimation.this.getVisibleBounds().y + CustomAnimation.this.getVisibleBounds().height);
                            break;
                        }
                        case 6: {
                            this.\u012d = new Point(CustomAnimation.this.getVisibleBounds().x + CustomAnimation.this.getVisibleBounds().width, CustomAnimation.this.getVisibleBounds().y + CustomAnimation.this.getVisibleBounds().height);
                            break;
                        }
                        case 4: {
                            this.\u012d = new Point(this.\u012e.x, CustomAnimation.this.getVisibleBounds().y - dimension.height);
                            break;
                        }
                        case 7: {
                            this.\u012d = new Point(CustomAnimation.this.getVisibleBounds().x - dimension.width, CustomAnimation.this.getVisibleBounds().y - dimension.height);
                            break;
                        }
                        case 8: {
                            this.\u012d = new Point(CustomAnimation.this.getVisibleBounds().x + CustomAnimation.this.getVisibleBounds().width, CustomAnimation.this.getVisibleBounds().y - dimension.height);
                            break;
                        }
                        case 3: {
                            this.\u012d = new Point(CustomAnimation.this.getVisibleBounds().x + CustomAnimation.this.getVisibleBounds().width, this.\u012e.y);
                            break;
                        }
                        case 2: {
                            this.\u012d = new Point(CustomAnimation.this.getVisibleBounds().x - dimension.width, this.\u012e.y);
                        }
                    }
                }
                this.\u012c = this.\u012e.x - this.\u012d.x;
                this.\u012b = this.\u012e.y - this.\u012d.y;
                component.setLocation(this.\u012d);
                if (!component.isVisible()) {
                    component.setVisible(true);
                }
            }

            @Override
            public void animationFrame(Component component, int n2, int n3) {
                component.setLocation(this.\u012e.x - (int)((double)this.\u012c * (1.0 - CustomAnimation.this.getPercentX(n3, n2))), this.\u012e.y - (int)((double)this.\u012b * (1.0 - CustomAnimation.this.getPercentY(n3, n2))));
            }

            @Override
            public void animationEnds(Component component) {
                component.setLocation(this.\u012e);
                if (CustomAnimation.this.getCallback() != null) {
                    CustomAnimation.this.getCallback().performed();
                }
            }
        });
    }

    private void \u0103(Animator animator) {
        animator.addAnimatorListener(new AnimatorListener(){
            private Point \u0129;
            private Point \u0128;
            private int \u0127;
            private int \u0126;

            @Override
            public void animationStarts(Component component) {
                Dimension dimension = component.getSize();
                Point point = this.\u0128 = CustomAnimation.this.getStartLocation() == null ? component.getLocation() : CustomAnimation.this.getStartLocation();
                if (CustomAnimation.this.getEndLocation() != null) {
                    this.\u0129 = CustomAnimation.this.getEndLocation();
                } else {
                    switch (CustomAnimation.this.getDirection()) {
                        case 1: {
                            this.\u0129 = new Point(this.\u0128.x, CustomAnimation.this.getVisibleBounds().y + CustomAnimation.this.getVisibleBounds().height);
                            break;
                        }
                        case 6: {
                            this.\u0129 = new Point(CustomAnimation.this.getVisibleBounds().x + CustomAnimation.this.getVisibleBounds().width, CustomAnimation.this.getVisibleBounds().y + CustomAnimation.this.getVisibleBounds().height);
                            break;
                        }
                        case 5: {
                            this.\u0129 = new Point(CustomAnimation.this.getVisibleBounds().x - dimension.width, CustomAnimation.this.getVisibleBounds().y + CustomAnimation.this.getVisibleBounds().height);
                            break;
                        }
                        case 4: {
                            this.\u0129 = new Point(this.\u0128.x, CustomAnimation.this.getVisibleBounds().y - dimension.height);
                            break;
                        }
                        case 8: {
                            this.\u0129 = new Point(CustomAnimation.this.getVisibleBounds().x + CustomAnimation.this.getVisibleBounds().width, CustomAnimation.this.getVisibleBounds().y - dimension.height);
                            break;
                        }
                        case 7: {
                            this.\u0129 = new Point(CustomAnimation.this.getVisibleBounds().x - dimension.width, CustomAnimation.this.getVisibleBounds().y - dimension.height);
                            break;
                        }
                        case 3: {
                            this.\u0129 = new Point(CustomAnimation.this.getVisibleBounds().x + CustomAnimation.this.getVisibleBounds().width, this.\u0128.y);
                            break;
                        }
                        case 2: {
                            this.\u0129 = new Point(CustomAnimation.this.getVisibleBounds().x - dimension.width, this.\u0128.y);
                        }
                    }
                }
                this.\u0127 = this.\u0129.x - this.\u0128.x;
                this.\u0126 = this.\u0129.y - this.\u0128.y;
                if (!component.isVisible()) {
                    component.setVisible(true);
                }
            }

            @Override
            public void animationFrame(Component component, int n2, int n3) {
                component.setLocation(this.\u0129.x - (int)((double)this.\u0127 * (1.0 - CustomAnimation.this.getPercentX(n3, n2))), this.\u0129.y - (int)((double)this.\u0126 * (1.0 - CustomAnimation.this.getPercentY(n3, n2))));
            }

            @Override
            public void animationEnds(Component component) {
                component.setLocation(this.\u0129);
                if (component.isVisible()) {
                    component.setVisible(false);
                }
                if (CustomAnimation.this.getCallback() != null) {
                    CustomAnimation.this.getCallback().performed();
                }
            }
        });
    }

    private void \u0101(final Animator animator) {
        animator.addAnimatorListener(new AnimatorListener(){
            private A \u0123;
            private Window \u0124;

            @Override
            public void animationStarts(final Component component) {
                Rectangle rectangle = new Rectangle();
                Point point = CustomAnimation.this.getEndLocation();
                rectangle.x = point.x;
                rectangle.y = point.y;
                rectangle.width = component.getWidth();
                rectangle.height = component.getHeight();
                if (!SecurityUtils.isTranslucentWindowFeatureDisabled() && component instanceof Window) {
                    this.\u0124 = (Window)component;
                    JideSwingUtilities.setWindowOpacity(this.\u0124, 0.0f);
                    ((RootPaneContainer)((Object)this.\u0124)).getContentPane().addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseEntered(MouseEvent mouseEvent) {
                            animator.stop();
                            JideSwingUtilities.setWindowOpacity(\u0124, 1.0f);
                        }
                    });
                } else if (component instanceof RootPaneContainer) {
                    this.\u0123 = new A();
                    this.\u0123.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseEntered(MouseEvent mouseEvent) {
                            animator.stop();
                            ((RootPaneContainer)((Object)component)).getLayeredPane().remove(\u0123);
                            \u0123 = null;
                            component.repaint();
                        }
                    });
                    Image image = component.isDisplayable() ? component.createImage(rectangle.width, rectangle.height) : new BufferedImage(rectangle.width, rectangle.height, 2);
                    Graphics graphics = image.getGraphics();
                    if (CustomAnimation.this.getScreenImage() != null) {
                        graphics.drawImage(CustomAnimation.this.getScreenImage(), 0, 0, rectangle.width, rectangle.height, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, null, null);
                    }
                    this.\u0123.\u0101(image);
                    this.\u0123.\u0101(1.0);
                    ((RootPaneContainer)((Object)component)).getLayeredPane().add((Component)this.\u0123, JLayeredPane.POPUP_LAYER);
                    this.\u0123.setBounds(0, 0, rectangle.width, rectangle.height);
                }
                if (!component.isVisible()) {
                    component.setVisible(true);
                }
            }

            @Override
            public void animationFrame(Component component, int n2, int n3) {
                double d2 = CustomAnimation.this.getPercentFade(n3, n2);
                if (this.\u0124 != null) {
                    JideSwingUtilities.setWindowOpacity(this.\u0124, (float)d2);
                } else if (this.\u0123 != null) {
                    this.\u0123.\u0101(1.0 - d2);
                    this.\u0123.repaint();
                }
            }

            @Override
            public void animationEnds(Component component) {
                if (!component.isVisible()) {
                    component.setVisible(true);
                }
                if (CustomAnimation.this.getCallback() != null) {
                    CustomAnimation.this.getCallback().performed();
                }
            }
        });
    }

    private void \u0105(final Animator animator) {
        animator.addAnimatorListener(new AnimatorListener(){
            private A \u011f;
            private Window \u0120;

            @Override
            public void animationStarts(final Component component) {
                Rectangle rectangle = new Rectangle();
                Point point = CustomAnimation.this.getStartLocation();
                rectangle.x = point.x;
                rectangle.y = point.y;
                rectangle.width = component.getWidth();
                rectangle.height = component.getHeight();
                if (!SecurityUtils.isTranslucentWindowFeatureDisabled() && component instanceof Window) {
                    this.\u0120 = (Window)component;
                    ((RootPaneContainer)((Object)this.\u0120)).getContentPane().addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseEntered(MouseEvent mouseEvent) {
                            animator.stop();
                            JideSwingUtilities.setWindowOpacity(\u0120, 1.0f);
                        }
                    });
                } else if (component instanceof RootPaneContainer) {
                    this.\u011f = new A();
                    this.\u011f.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseEntered(MouseEvent mouseEvent) {
                            animator.stop();
                            ((RootPaneContainer)((Object)component)).getLayeredPane().remove(\u011f);
                            \u011f = null;
                            component.repaint();
                        }
                    });
                    Image image = component.createImage(rectangle.width, rectangle.height);
                    Graphics graphics = image.getGraphics();
                    if (CustomAnimation.this.getScreenImage() != null) {
                        graphics.drawImage(CustomAnimation.this.getScreenImage(), 0, 0, rectangle.width, rectangle.height, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, null, null);
                    }
                    this.\u011f.\u0101(image);
                    this.\u011f.\u0101(0.0);
                    ((RootPaneContainer)((Object)component)).getLayeredPane().add((Component)this.\u011f, JLayeredPane.POPUP_LAYER);
                    this.\u011f.setBounds(0, 0, rectangle.width, rectangle.height);
                }
            }

            @Override
            public void animationFrame(Component component, int n2, int n3) {
                double d2 = CustomAnimation.this.getPercentFade(n3, n2);
                if (this.\u0120 != null) {
                    JideSwingUtilities.setWindowOpacity(this.\u0120, 1.0f - (float)d2);
                } else if (this.\u011f != null) {
                    this.\u011f.\u0101(d2);
                    this.\u011f.repaint();
                }
            }

            @Override
            public void animationEnds(Component component) {
                if (component.isVisible()) {
                    component.setVisible(false);
                }
                if (CustomAnimation.this.getCallback() != null) {
                    CustomAnimation.this.getCallback().performed();
                }
            }
        });
    }

    public Function getFunctionX() {
        return this.\u0108;
    }

    public void setFunctionX(Function function) {
        this.\u0108 = function;
    }

    public Function getFunctionY() {
        return this.\u0107;
    }

    public void setFunctionY(Function function) {
        this.\u0107 = function;
    }

    public Function getFunctionFade() {
        return this.\u0112;
    }

    public void setFunctionFade(Function function) {
        this.\u0112 = function;
    }

    public Function getFunctionZoom() {
        return this.\u010e;
    }

    public void setFunctionZoom(Function function) {
        this.\u010e = function;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean isRunning() {
        return this.\u010b != null && this.\u010b.isRunning();
    }

    class A
    extends JPanel {
        double \u0103;
        Image \u0102;

        public A() {
            this.setOpaque(false);
        }

        public void \u0101(double d2) {
            this.\u0103 = d2;
        }

        public void \u0101(Image image) {
            this.\u0102 = image;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (this.\u0103 != 0.0) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Composite composite = graphics2D.getComposite();
                graphics2D.setComposite(AlphaComposite.getInstance(3, (float)this.\u0103));
                graphics2D.drawImage(this.\u0102, 0, 0, this.getWidth(), this.getHeight(), this);
                graphics2D.setComposite(composite);
            }
        }
    }

    public static interface Callback {
        public void performed();
    }
}

