/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.misc;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.beans.actions.misc.CloseStrategy;
import com.install4j.runtime.installer.helper.RunningProcessChecker;
import java.io.File;

public class CheckRunningProcessesAction
extends SystemInstallOrUninstallAction {
    private String message = "${i18n:AppRunningError(\"install4j\", \"${compiler:sys.fullName}\")}";
    private CloseStrategy closeStrategy = CloseStrategy.ASK_FOR_CLOSE;
    private int timeOut = 5000;
    private boolean includeLaunchers = true;
    private boolean allowIgnore = false;
    private File[] additionalExecutables;

    public String getMessage() {
        return CheckRunningProcessesAction.replaceVariables(this.message);
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public CloseStrategy getCloseStrategy() {
        return this.closeStrategy;
    }

    public void setCloseStrategy(CloseStrategy closeStrategy) {
        this.closeStrategy = closeStrategy;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(int timeOut) {
        this.timeOut = timeOut;
    }

    public boolean isIncludeLaunchers() {
        return this.includeLaunchers;
    }

    public void setIncludeLaunchers(boolean includeLaunchers) {
        this.includeLaunchers = includeLaunchers;
    }

    public boolean isAllowIgnore() {
        return this.allowIgnore;
    }

    public void setAllowIgnore(boolean allowIgnore) {
        this.allowIgnore = allowIgnore;
    }

    public File[] getAdditionalExecutables() {
        return CheckRunningProcessesAction.replaceVariables(this.additionalExecutables);
    }

    public void setAdditionalExecutables(File[] additionalExecutables) {
        this.additionalExecutables = additionalExecutables;
    }

    @Override
    public boolean execute(Context context) throws UserCanceledException {
        if (!Util.isWindows() && !Util.isMacOS()) {
            return true;
        }
        return RunningProcessChecker.checkRunningProcesses(this.getMessage(), this.getCloseStrategy().getType(), this.getTimeOut(), this.isAllowIgnore(), this.isIncludeLaunchers(), this.getAdditionalExecutables());
    }

    @Override
    public boolean isRollbackSupported() {
        return false;
    }
}

