/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.install4j.api.context.FileOptions;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.OverwriteMode;
import com.install4j.api.context.UninstallMode;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.files.AbstractExtractZipFileAction;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class InstallExternalZipFileAction
extends AbstractExtractZipFileAction {
    private OverwriteMode overwriteMode = OverwriteMode.ALWAYS_ASK_EXCEPT_FOR_UPDATE;
    private boolean shared = false;
    private UninstallMode uninstallMode = UninstallMode.IF_CREATED;
    private boolean delay = false;
    private boolean triggerReboot = true;
    private transient FileInstaller fileInstaller;

    public boolean isDelay() {
        return this.delay;
    }

    public void setDelay(boolean delay) {
        this.delay = delay;
    }

    public boolean isTriggerReboot() {
        return this.triggerReboot;
    }

    public void setTriggerReboot(boolean triggerReboot) {
        this.triggerReboot = triggerReboot;
    }

    public OverwriteMode getOverwriteMode() {
        return this.overwriteMode;
    }

    public void setOverwriteMode(OverwriteMode overwriteMode) {
        this.overwriteMode = overwriteMode;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public UninstallMode getUninstallMode() {
        return this.uninstallMode;
    }

    public void setUninstallMode(UninstallMode uninstallMode) {
        this.uninstallMode = uninstallMode;
    }

    @Override
    public boolean install(InstallerContext context) throws UserCanceledException {
        this.fileInstaller = FileInstaller.getInstance();
        this.fileInstaller.resetCurrentRebootRequired();
        try {
            boolean bl = super.install(context);
            return bl;
        }
        finally {
            if (this.isTriggerReboot() && this.isDelay() && this.fileInstaller.isCurrentRebootRequired()) {
                context.triggerReboot(true);
            }
        }
    }

    @Override
    public boolean uninstall(UninstallerContext context) throws UserCanceledException {
        Logger.getInstance().error(this, "This action does not work in an uninstaller");
        return false;
    }

    @Override
    protected void createFile(File destFile, ZipInputStream zipIn, ZipEntry zipEntry, long currentSize, ProgressAdapter progressAdapter) throws UserCanceledException, IOException {
        FileOptions fileOptions = new FileOptions(zipEntry.getTime(), this.getMode(), this.getOverwriteMode(), this.isShared(), this.isDelay(), this.getUninstallMode());
        this.fileInstaller.install(zipIn, destFile, fileOptions, progressAdapter, currentSize, false);
    }

    @Override
    protected void createDirectory(File directory) throws IOException {
        this.fileInstaller.createDirectory(directory, this.getUninstallMode());
    }
}

