/*
 * Decompiled with CFR 0.152.
 */
package com.ejt.framework.gui;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import org.jetbrains.annotations.NotNull;

public class ScreenSizeUtil {
    private static final boolean DEBUG_SCREEN_SIZE = Boolean.getBoolean("ejt.debugScreenSize");

    private ScreenSizeUtil() {
    }

    @NotNull
    public static Rectangle getFrameBounds(Dimension size, Window parentWindow) {
        return ScreenSizeUtil.getFrameBounds(size.width, size.height, parentWindow);
    }

    @NotNull
    public static Rectangle getFrameBounds(int width, int height, Window parentWindow) {
        Rectangle bounds = parentWindow != null && parentWindow.isVisible() ? parentWindow.getBounds() : new Rectangle(new Point(0, 0), Toolkit.getDefaultToolkit().getScreenSize());
        int deltaX = bounds.width - width;
        int deltaY = bounds.height - height;
        bounds.x += deltaX / 2;
        bounds.width -= deltaX;
        bounds.y += deltaY / 2;
        bounds.height -= deltaY;
        ScreenSizeUtil.adjustBoundsToScreenSize(bounds);
        return bounds;
    }

    public static void adjustBoundsToScreenSize(Rectangle bounds) {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        GraphicsConfiguration graphicsConfiguration = ScreenSizeUtil.getGraphicsConfiguration(bounds);
        Rectangle screenBounds = ScreenSizeUtil.getScreenBoundsWithInsets(graphicsConfiguration);
        if (DEBUG_SCREEN_SIZE) {
            System.err.println("original bounds = " + bounds);
            System.err.println("screen bounds for original bounds = " + screenBounds);
        }
        if (screenBounds.width <= 0 || screenBounds.height <= 0) {
            return;
        }
        if (bounds.x < screenBounds.x) {
            bounds.translate(screenBounds.x - bounds.x, 0);
        }
        if (bounds.y < screenBounds.y) {
            bounds.translate(0, screenBounds.y - bounds.y);
        }
        if (bounds.x + bounds.width > screenBounds.x + screenBounds.width) {
            bounds.translate(screenBounds.x + screenBounds.width - (bounds.x + bounds.width), 0);
        }
        if (bounds.y + bounds.height > screenBounds.y + screenBounds.height) {
            bounds.translate(0, screenBounds.y + screenBounds.height - (bounds.y + bounds.height));
        }
        if (bounds.x < screenBounds.x) {
            bounds.x = screenBounds.x;
            bounds.width = screenBounds.width;
        }
        if (bounds.y < screenBounds.y) {
            bounds.y = screenBounds.y;
            bounds.height = screenBounds.height;
        }
        if (DEBUG_SCREEN_SIZE) {
            System.err.println("corrected bounds = " + bounds);
        }
    }

    public static GraphicsConfiguration getGraphicsConfiguration(Rectangle bounds) {
        GraphicsDevice[] graphicsDevices;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice graphicsDevice : graphicsDevices = graphicsEnvironment.getScreenDevices()) {
            GraphicsConfiguration[] graphicsConfigurations;
            for (GraphicsConfiguration graphicsConfiguration : graphicsConfigurations = graphicsDevice.getConfigurations()) {
                if (!graphicsConfiguration.getBounds().contains(bounds.getLocation())) continue;
                return graphicsConfiguration;
            }
        }
        return graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
    }

    public static Rectangle getScreenBoundsWithInsets(GraphicsConfiguration graphicsConfiguration) {
        if (graphicsConfiguration == null) {
            graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        Rectangle screenBounds = graphicsConfiguration.getBounds();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        screenBounds.x += screenInsets.left;
        screenBounds.y += screenInsets.top;
        screenBounds.width -= screenInsets.left + screenInsets.right;
        screenBounds.height -= screenInsets.bottom + screenInsets.top;
        if (DEBUG_SCREEN_SIZE) {
            System.err.println("screen bounds = " + screenBounds);
            System.err.println("screen insets = " + screenInsets);
        }
        screenBounds.width = Math.max(screenBounds.width, 1000);
        screenBounds.height = Math.max(screenBounds.height, 800);
        return screenBounds;
    }
}

