/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.jdbc.Conversions;
import com.nuodb.jdbc.EncodedDataStream;
import com.nuodb.jdbc.Resources;
import com.nuodb.jdbc.SQLException;
import com.nuodb.jdbc.SQLState;
import com.nuodb.jdbc.Value;
import java.math.BigDecimal;

public class ValueDouble
extends Value {
    private static final float FLOAT_MIN_VALUE = -3.4028235E38f;
    private static final float FLOAT_MAX_VALUE = Float.MAX_VALUE;
    private final double value;

    public ValueDouble(double value) {
        this.value = value;
    }

    public ValueDouble(Object value) {
        this.value = value instanceof Number ? ((Number)value).doubleValue() : (value instanceof Boolean ? (Boolean.TRUE.equals(value) ? 1.0 : 0.0) : Double.parseDouble(value.toString()));
    }

    @Override
    int getType() {
        return 8;
    }

    @Override
    String getString() {
        return String.valueOf(this.value);
    }

    @Override
    byte getByte() throws java.sql.SQLException {
        double value = this.getDouble();
        if (value < -128.0 || value > 127.0) {
            throw new SQLException(Resources.getMessage("error.byte.value.out.of.range", this.getString()), SQLState.NUMERIC_VALUE_OUT_OF_RANGE);
        }
        return (byte)value;
    }

    @Override
    short getShort() throws java.sql.SQLException {
        double value = this.getDouble();
        if (value < -32768.0 || value > 32767.0) {
            throw new SQLException(Resources.getMessage("error.short.value.out.of.range", this.getString()), SQLState.NUMERIC_VALUE_OUT_OF_RANGE);
        }
        return (short)value;
    }

    @Override
    int getInt() throws java.sql.SQLException {
        double value = this.getDouble();
        if (value < -2.147483648E9 || value > 2.147483647E9) {
            throw new SQLException(Resources.getMessage("error.int.value.out.of.range", this.getString()), SQLState.NUMERIC_VALUE_OUT_OF_RANGE);
        }
        return (int)value;
    }

    @Override
    long getLong() throws java.sql.SQLException {
        double value = this.getDouble();
        if (value < -9.223372036854776E18 || value > 9.223372036854776E18) {
            throw new SQLException(Resources.getMessage("error.long.value.out.of.range", this.getString()), SQLState.NUMERIC_VALUE_OUT_OF_RANGE);
        }
        return (long)value;
    }

    @Override
    float getFloat() throws java.sql.SQLException {
        double value = this.getDouble();
        if (value < -3.4028234663852886E38 || value > 3.4028234663852886E38) {
            throw new SQLException(Resources.getMessage("error.float.value.out.of.range", this.getString()), SQLState.NUMERIC_VALUE_OUT_OF_RANGE);
        }
        return (float)value;
    }

    @Override
    double getDouble() throws java.sql.SQLException {
        return this.value;
    }

    @Override
    Object getObject() throws java.sql.SQLException {
        return this.getDouble();
    }

    @Override
    void encodeValue(EncodedDataStream dataStream) throws java.sql.SQLException {
        dataStream.encodeDouble(this.value);
    }

    @Override
    BigDecimal getBigDecimal() throws java.sql.SQLException {
        return new BigDecimal(this.value);
    }

    @Override
    public byte[] getBytes() {
        return Conversions.toBytes(this.value);
    }
}

