/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.impl.concurrent.NamedThreadFactory;
import com.nuodb.impl.net.CryptoInputStream;
import com.nuodb.impl.net.CryptoOutputStream;
import com.nuodb.impl.net.CryptoSocket;
import com.nuodb.impl.security.CipherRC4;
import com.nuodb.impl.security.RemotePassword;
import com.nuodb.impl.util.LengthUnit;
import com.nuodb.impl.util.StringUtils;
import com.nuodb.jdbc.Array;
import com.nuodb.jdbc.Blob;
import com.nuodb.jdbc.Clob;
import com.nuodb.jdbc.Connection;
import com.nuodb.jdbc.EncodedDataStream;
import com.nuodb.jdbc.NuoXid;
import com.nuodb.jdbc.RemCallableStatement;
import com.nuodb.jdbc.RemDatabaseMetaData;
import com.nuodb.jdbc.RemPreparedStatement;
import com.nuodb.jdbc.RemResultSet;
import com.nuodb.jdbc.RemResultSetMetaData;
import com.nuodb.jdbc.RemSQLUtils;
import com.nuodb.jdbc.RemSavepoint;
import com.nuodb.jdbc.RemStatement;
import com.nuodb.jdbc.SQLContext;
import com.nuodb.jdbc.SQLState;
import com.nuodb.jdbc.SQLStateException;
import com.nuodb.jdbc.Struct;
import com.nuodb.jdbc.Utils;
import com.nuodb.jdbc.logger.Logger;
import com.nuodb.jdbc.logger.LoggerManager;
import com.nuodb.xml.Tag;
import com.nuodb.xml.TagFactory;
import com.nuodb.xml.XmlException;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLTransientConnectionException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RemConnection
implements Connection {
    public static final String TIMEZONE_NAME = "TimeZone";
    public static final int BROKER_PORT = 48004;
    public static final int TRANSACTION_ENGINE_PORT = 48006;
    public static final long MAX_MESSAGE_LENGTH = LengthUnit.MEGABYTES.getFactor();
    public static final String DEFAULT_CIPHER = "RC4";
    public static final String LOB_CHUNK_SIZE = "lobChunkSize";
    public static final String LOB_CHUNKING_ENABLED = "lobChunkingEnabled";
    public static final boolean LOB_CHUNKING_ENABLED_DEFAULT = true;
    public static final int LOB_CHUNK_SIZE_DEFAULT = 65536;
    private static ConcurrentHashMap<UUID, ProcessConnection> processConnections = new ConcurrentHashMap();
    private Logger logger;
    private ErrorHandler errorHandler;
    private volatile CryptoSocket socket;
    private CryptoInputStream inputStream;
    private CryptoOutputStream outputStream;
    private EncodedDataStream dataStream;
    int protocolVersion;
    RemDatabaseMetaData metaData;
    private final LinkedList<RemStatement> statements = new LinkedList();
    private final LinkedList<RemResultSet> metaDataResultSets = new LinkedList();
    private String userName;
    private SQLWarning warnings;
    private ProcessConnection processConnection = null;
    private boolean authenticating = false;
    private SQLContext sqlContext;
    private String connectionURL;
    private Boolean isAutoCommit = null;
    private Boolean isReadOnly = null;
    private Integer transactionIsolation = null;
    private boolean clientTrackingSettings = false;
    private final ExecutorService executor;
    private int serverSideConnectionId;
    private boolean isInGlobalTx = false;
    private int xaTransState = 0;
    private int effectivePlatformVersion;
    private UUID connectionDatabaseUUID = null;
    private int connectedNodeId;
    boolean networkErrorOccurred = false;

    protected RemConnection(Logger logger) {
        this(null, logger);
    }

    protected RemConnection(ErrorHandler errorHandler, Logger logger) {
        this.logger = logger;
        this.errorHandler = errorHandler;
        this.protocolVersion = Integer.getInteger("AsProtocolVersion", 21);
        this.sqlContext = new SQLContext();
        this.executor = Executors.newCachedThreadPool(new NamedThreadFactory("jdbc-connection"));
    }

    @Override
    public SQLContext getSQLContext() {
        return this.sqlContext;
    }

    @Override
    public int getServerSideConnectionId() {
        return this.serverSideConnectionId;
    }

    @Override
    public int getEffectivePlatformVersion() {
        return this.effectivePlatformVersion;
    }

    @Override
    public int getConnectedNodeId() {
        return this.connectedNodeId;
    }

    @Override
    public long getGlobalConnectionId() {
        long globalConnectionId = this.connectedNodeId;
        globalConnectionId <<= 32;
        return globalConnectionId |= (long)this.serverSideConnectionId;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    public void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        if (this.socket == null || this.socket.isClosed()) {
            return;
        }
        this.executor.shutdownNow();
        this.closeResultSets();
        this.closeStatements();
        try {
            this.dataStream.startMessage(5);
            this.sendAndReceive(this.dataStream);
        }
        finally {
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException exception) {
                this.connectionErrorOccurred(new SQLException(exception));
            }
            finally {
                this.socket = null;
            }
        }
    }

    protected void closeStatements() {
        ArrayList<RemStatement> statementsCopy = new ArrayList<RemStatement>(this.statements);
        this.statements.clear();
        for (RemStatement statement : statementsCopy) {
            RemSQLUtils.close(statement);
        }
    }

    protected void closeResultSets() {
        ArrayList<RemResultSet> resultSetsCopy = new ArrayList<RemResultSet>(this.metaDataResultSets);
        this.metaDataResultSets.clear();
        for (RemResultSet resultSet : resultSetsCopy) {
            RemSQLUtils.close(resultSet);
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public synchronized void commit() throws SQLException {
        this.dataStream.startMessage(7);
        this.sendAndReceive(this.dataStream);
        long transactionId = this.dataStream.getLong();
        int nodeId = this.dataStream.getInt();
        long commitSequence = this.dataStream.getLong();
        this.processConnection.setLast(transactionId, nodeId, commitSequence);
    }

    public synchronized int prepare(NuoXid nXid) throws SQLException {
        this.dataStream.startMessage(6);
        nXid.encodeDataStream(this.dataStream);
        this.sendAndReceive(this.dataStream);
        return this.dataStream.getInt();
    }

    public synchronized NuoXid[] recover() throws SQLException {
        this.dataStream.startMessage(125);
        this.dataStream.encodeString("get");
        this.sendAndReceive(this.dataStream);
        int numTrans = this.dataStream.getInt();
        if (numTrans == 0) {
            return new NuoXid[0];
        }
        NuoXid[] nXids = new NuoXid[numTrans];
        for (int i = 0; i < numTrans; ++i) {
            nXids[i] = new NuoXid();
            nXids[i].decodeDataStream(this.dataStream);
        }
        return nXids;
    }

    public synchronized void recoverByCommit(long nuodbTransId) throws SQLException {
        this.dataStream.startMessage(125);
        this.dataStream.encodeString("commit");
        this.dataStream.encodeLong(nuodbTransId);
        this.sendAndReceive(this.dataStream);
    }

    public synchronized void recoverByRollback(long nuodbTransId) throws SQLException {
        this.dataStream.startMessage(125);
        this.dataStream.encodeString("rollback");
        this.dataStream.encodeLong(nuodbTransId);
        this.sendAndReceive(this.dataStream);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return new Array(typeName, elements);
    }

    @Override
    public Blob createBlob() throws SQLException {
        return new Blob();
    }

    @Override
    public Clob createClob() throws SQLException {
        return new Clob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public synchronized Statement createStatement() throws SQLException {
        this.dataStream.startMessage(11);
        this.sendAndReceive(this.dataStream);
        int handle = this.dataStream.getInt();
        RemStatement statement = new RemStatement(this, handle);
        this.statements.add(statement);
        return statement;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, 2);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetType != 1003) {
            throw new SQLException(MessageFormat.format("Only ResultSet.TYPE_FORWARD_ONLY result sets are supported. Mode {0} is not supported", resultSetType));
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLException(MessageFormat.format("Only ResultSet.CONCUR_READ_ONLY result sets are supported. Mode {0} is not supported", resultSetConcurrency));
        }
        if (resultSetHoldability != 2) {
            throw new SQLException(MessageFormat.format("Only ResultSet.CLOSE_CURSORS_AT_COMMIT result sets are supported. Mode {0} is not supported", resultSetHoldability));
        }
        return this.createStatement();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return new Struct(typeName, attributes);
    }

    @Override
    public synchronized boolean getAutoCommit() throws SQLException {
        if (this.isAutoCommit == null || !this.isClientTrackingSettings()) {
            this.dataStream.startMessage(59);
            this.sendAndReceive(this.dataStream);
            this.isAutoCommit = this.dataStream.getInt() != 0;
        }
        return this.isAutoCommit;
    }

    @Override
    public synchronized String getCatalog() throws SQLException {
        this.dataStream.startMessage(101);
        this.sendAndReceive(this.dataStream);
        return this.dataStream.getString();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return new Properties();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return null;
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.getMetaData().getResultSetHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.metaData == null) {
            this.metaData = new RemDatabaseMetaData(this);
        }
        return this.metaData;
    }

    @Override
    public synchronized int getTransactionIsolation() throws SQLException {
        if (this.transactionIsolation == null || !this.isClientTrackingSettings()) {
            this.dataStream.startMessage(63);
            this.sendAndReceive(this.dataStream);
            this.transactionIsolation = this.dataStream.getInt();
        }
        return this.transactionIsolation;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.socket == null || !this.socket.isConnected();
    }

    @Override
    public synchronized boolean isReadOnly() throws SQLException {
        if (this.isReadOnly == null || !this.isClientTrackingSettings()) {
            this.dataStream.startMessage(61);
            this.sendAndReceive(this.dataStream);
            this.isReadOnly = this.dataStream.getInt() != 0;
        }
        return this.isReadOnly;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (this.socket == null || this.socket.isClosed()) {
            return false;
        }
        boolean valid = true;
        try {
            FutureTask<Boolean> task = new FutureTask<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    EncodedDataStream dataStream = new EncodedDataStream();
                    dataStream.startMessage(48);
                    RemConnection.this.sendAndReceive(dataStream);
                    return true;
                }
            });
            this.executor.execute(task);
            valid = timeout != 0 ? task.get(timeout, TimeUnit.SECONDS).booleanValue() : task.get().booleanValue();
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new SQLNonTransientConnectionException(exception);
        }
        catch (ExecutionException exception) {
            Throwable cause = exception.getCause();
            if (cause != null && cause instanceof SQLException) {
                throw (SQLException)cause;
            }
            throw new SQLNonTransientConnectionException(exception);
        }
        catch (TimeoutException exception) {
            valid = false;
        }
        return valid;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007, 2);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, 2);
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.protocolVersion < 12) {
            throw new SQLFeatureNotSupportedException(String.format("NuoDB server protocol %d does not support prepareCall", this.protocolVersion));
        }
        if (resultSetType != 1003) {
            throw new SQLException(String.format("Only ResultSet.TYPE_FORWARD_ONLY result sets are supported. Mode %d is not supported", resultSetType));
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLException(String.format("Only ResultSet.CONCUR_READ_ONLY result sets are supported. Mode %d is not supported", resultSetConcurrency));
        }
        if (resultSetHoldability != 2) {
            throw new SQLException(String.format("Only ResultSet.CLOSE_CURSORS_AT_COMMIT result sets are supported. Mode %d is not supported", resultSetHoldability));
        }
        this.dataStream.startMessage(103);
        this.dataStream.encodeString(sql);
        this.sendAndReceive(this.dataStream);
        int handle = this.dataStream.getInt();
        int parameterCount = this.dataStream.getInt();
        RemCallableStatement statement = new RemCallableStatement(this, handle, parameterCount);
        for (int i = 0; i < parameterCount; ++i) {
            int direction = this.dataStream.getInt();
            String name = this.dataStream.getString();
            statement.declareParameter(i + 1, direction, name);
        }
        this.statements.add(statement);
        return statement;
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        this.dataStream.startMessage(9);
        return this.doStatementPrepare(sql, false);
    }

    private synchronized PreparedStatement doStatementPrepare(String sql, boolean generatingKeys) throws SQLException {
        boolean hasMetaData;
        this.dataStream.encodeString(sql);
        this.sendAndReceive(this.dataStream);
        int handle = this.dataStream.getInt();
        int parameterCount = this.dataStream.getInt();
        RemPreparedStatement statement = new RemPreparedStatement(this, handle, parameterCount, generatingKeys);
        this.statements.add(statement);
        if (this.protocolVersion >= 21 && (hasMetaData = this.dataStream.getBoolean())) {
            statement.metaData = new RemResultSetMetaData(this.dataStream);
        }
        return statement;
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        RemConnection.validateAutoGenFlag(autoGeneratedKeys);
        this.dataStream.startMessage(88);
        this.dataStream.encodeInt(autoGeneratedKeys);
        return this.doStatementPrepare(sql, autoGeneratedKeys == 1);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.dataStream.startMessage(90);
        this.dataStream.encodeInt(columnIndexes.length);
        for (int id : columnIndexes) {
            this.dataStream.encodeInt(id);
        }
        return this.doStatementPrepare(sql, true);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.dataStream.startMessage(89);
        this.dataStream.encodeInt(columnNames.length);
        for (String name : columnNames) {
            this.dataStream.encodeString(name);
        }
        return this.doStatementPrepare(sql, true);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, 2);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetType != 1003) {
            throw new SQLException(MessageFormat.format("Only ResultSet.TYPE_FORWARD_ONLY result sets are supported. Mode {0} is not supported", resultSetType));
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLException(MessageFormat.format("Only ResultSet.CONCUR_READ_ONLY result sets are supported. Mode {0} is not supported", resultSetConcurrency));
        }
        if (resultSetHoldability != 2) {
            throw new SQLException(MessageFormat.format("Only ResultSet.CLOSE_CURSORS_AT_COMMIT result sets are supported. Mode {0} is not supported", resultSetHoldability));
        }
        this.dataStream.startMessage(9);
        return this.doStatementPrepare(sql, false);
    }

    @Override
    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (savepoint == null) {
            throw new SQLException("can't release a null savepoint");
        }
        int id = savepoint.getSavepointId();
        this.dataStream.startMessage(98);
        this.dataStream.encodeInt(id);
        this.sendAndReceive(this.dataStream);
    }

    @Override
    public synchronized void rollback() throws SQLException {
        this.dataStream.startMessage(8);
        this.sendAndReceive(this.dataStream);
    }

    @Override
    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        if (savepoint == null) {
            throw new SQLException("can't rollback a null savepoint");
        }
        int id = savepoint.getSavepointId();
        this.dataStream.startMessage(99);
        this.dataStream.encodeInt(id);
        this.sendAndReceive(this.dataStream);
    }

    @Override
    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        if (autoCommit && this.isInGlobalTx()) {
            throw new SQLException("Setting autoCommit on is not allowed with XA transactions");
        }
        if (this.isAutoCommit == null || this.isAutoCommit != autoCommit) {
            this.isAutoCommit = autoCommit;
            this.dataStream.startMessage(60);
            this.dataStream.encodeInt(autoCommit ? 1 : 0);
            this.sendAsync(this.dataStream);
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new SQLClientInfoException("ClientInfo property not supported.", Collections.emptyMap());
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new SQLClientInfoException("ClientInfo property not supported.", Collections.emptyMap());
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        Utils.notYetImplemented();
    }

    @Override
    public synchronized void setReadOnly(boolean readOnly) throws SQLException {
        if (this.isReadOnly == null || this.isReadOnly != readOnly) {
            this.isReadOnly = readOnly;
            this.dataStream.startMessage(62);
            this.dataStream.encodeInt(readOnly ? 1 : 0);
            this.sendAsync(this.dataStream);
        }
    }

    @Override
    public synchronized Savepoint setSavepoint() throws SQLException {
        if (this.getAutoCommit()) {
            throw new SQLException("setSavepoint not allowed when auto commit is on");
        }
        if (this.isInGlobalTx()) {
            throw new SQLException("setSavepoint not allowed with XA transactions");
        }
        this.dataStream.startMessage(97);
        this.sendAndReceive(this.dataStream);
        int id = this.dataStream.getInt();
        return new RemSavepoint(id, null);
    }

    @Override
    public synchronized Savepoint setSavepoint(String name) throws SQLException {
        if (this.getAutoCommit()) {
            throw new SQLException("setSavepoint not allowed when auto commit is on");
        }
        if (this.isInGlobalTx()) {
            throw new SQLException("setSavepoint not allowed with XA transactions");
        }
        this.dataStream.startMessage(97);
        this.sendAndReceive(this.dataStream);
        int id = this.dataStream.getInt();
        return new RemSavepoint(name, id, null);
    }

    @Override
    public synchronized void setTransactionIsolation(int level) throws SQLException {
        if (this.transactionIsolation == null || this.transactionIsolation != level) {
            this.transactionIsolation = level;
            this.dataStream.startMessage(64);
            this.dataStream.encodeInt(level);
            this.sendAndReceive(this.dataStream);
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        Utils.notYetImplemented();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    boolean isClientTrackingSettings() {
        return this.clientTrackingSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void openDatabase(String host, int port, String databaseName, Properties properties, String url) throws SQLException {
        boolean direct = Boolean.parseBoolean(properties.getProperty("direct", Boolean.FALSE.toString()));
        if (port == 0) {
            port = direct ? 48006 : 48004;
        }
        this.connectionURL = url;
        this.dataStream = new EncodedDataStream();
        this.authenticating = false;
        this.clearConnectionError();
        try {
            int maxNodes;
            TimeZone tz;
            int targetPort;
            String targetHost;
            Tag tag = TagFactory.createTag("Connection");
            tag.addAttribute("Service", "SQL2");
            tag.addAttribute("Database", databaseName);
            this.userName = null;
            String password = null;
            String cipher = DEFAULT_CIPHER;
            if (!properties.containsKey(LOB_CHUNKING_ENABLED)) {
                properties.put(LOB_CHUNKING_ENABLED, String.valueOf(true));
            }
            if (!properties.containsKey(LOB_CHUNK_SIZE)) {
                properties.put(LOB_CHUNK_SIZE, String.valueOf(65536));
            }
            Enumeration<Object> e = properties.keys();
            while (e.hasMoreElements()) {
                String property = (String)e.nextElement();
                if (LoggerManager.isLoggerProperty(property)) continue;
                String value = properties.getProperty(property);
                if (property.equals("user")) {
                    this.userName = value;
                    tag.addAttribute("User", this.userName);
                    continue;
                }
                if (property.equals("password")) {
                    password = value;
                    continue;
                }
                if (property.equals("schema")) {
                    tag.addAttribute("Schema", value);
                    continue;
                }
                if (property.equals("cipher")) {
                    cipher = value;
                    continue;
                }
                if (property.equals("client_tracking_settings")) {
                    this.clientTrackingSettings = Boolean.parseBoolean(value);
                    tag.addAttribute("client_tracking_settings", this.clientTrackingSettings);
                    continue;
                }
                tag.addAttribute(property, value);
            }
            if (!cipher.equals(DEFAULT_CIPHER) && !cipher.equals("None")) {
                throw new SQLException("Unknown cipher: " + cipher);
            }
            tag.addAttribute("Cipher", cipher);
            String xml = tag.toString();
            if (direct) {
                targetHost = host;
                targetPort = port;
            } else {
                CryptoSocket brokerSocket = this.createCryptoSocket(host, port);
                try {
                    this.socket = brokerSocket;
                    this.inputStream = brokerSocket.getInputStream();
                    this.outputStream = brokerSocket.getOutputStream();
                    this.dataStream.write(xml);
                    this.dataStream.send(this.outputStream);
                    this.dataStream.getMessage(this.inputStream, MAX_MESSAGE_LENGTH);
                }
                finally {
                    this.socket = null;
                }
                String response = this.dataStream.readString();
                brokerSocket.close();
                Tag responseTag = TagFactory.parseTag(response);
                if (responseTag.getName().equals("Error")) {
                    throw new SQLException(responseTag.getAttribute("text", "error text not found"));
                }
                targetHost = responseTag.getAttribute("Address", null);
                targetPort = responseTag.getIntAttribute("Port", 0);
            }
            if (targetHost == null || targetPort == 0) {
                throw new SQLException("No NuoDB nodes are available for database \"" + databaseName + "\"");
            }
            this.socket = this.createCryptoSocket(targetHost, targetPort);
            this.socket.setTcpNoDelay(true);
            this.inputStream = this.socket.getInputStream();
            this.outputStream = this.socket.getOutputStream();
            this.dataStream.reset();
            this.dataStream.write(xml);
            this.dataStream.send(this.outputStream);
            RemotePassword remotePassword = new RemotePassword();
            String userKey = this.getClientKey(remotePassword);
            this.dataStream.startMessage(3);
            this.dataStream.encodeInt(this.protocolVersion);
            this.dataStream.encodeString(databaseName);
            String timeZone = properties.getProperty(TIMEZONE_NAME);
            if (timeZone == null) {
                tz = TimeZone.getDefault();
                this.sqlContext.setTimeZone(tz);
                this.sqlContext.setTimeZoneId(tz.getID());
                properties.setProperty(TIMEZONE_NAME, tz.getID());
            } else {
                tz = TimeZone.getTimeZone(timeZone);
                this.sqlContext.setTimeZone(tz);
                this.sqlContext.setTimeZoneId(tz.getID());
            }
            int count = properties.size();
            if (password != null) {
                --count;
            }
            this.dataStream.encodeInt(count);
            Enumeration<?> e2 = properties.propertyNames();
            while (e2.hasMoreElements()) {
                String name = (String)e2.nextElement();
                if (name.equals("password")) continue;
                String value = properties.getProperty(name);
                this.dataStream.encodeString(name);
                this.dataStream.encodeString(value);
            }
            this.dataStream.encodeLong(0L);
            this.dataStream.encodeString(userKey);
            this.sendAndReceive(this.dataStream, MAX_MESSAGE_LENGTH);
            this.protocolVersion = this.dataStream.getInt();
            String serverKey = this.dataStream.getString();
            String salt = this.dataStream.getString();
            this.dataStream.setProtocolVersion(this.protocolVersion);
            this.connectionDatabaseUUID = this.dataStream.getUUId();
            if (this.protocolVersion >= 15) {
                this.serverSideConnectionId = this.dataStream.getInt();
            }
            if (this.protocolVersion >= 16) {
                this.effectivePlatformVersion = this.dataStream.getInt();
            }
            if (this.protocolVersion >= 17) {
                this.connectedNodeId = this.dataStream.getInt();
                maxNodes = this.dataStream.getInt();
            } else {
                maxNodes = 128;
            }
            this.processConnection = this.getProcessConnection(this.connectionDatabaseUUID, maxNodes);
            byte[] sessionKey = this.computeSessionKey(remotePassword, this.userName, password, salt, serverKey);
            this.inputStream.encrypt(new CipherRC4(sessionKey));
            this.outputStream.encrypt(new CipherRC4(sessionKey));
            this.dataStream.startMessage(86);
            this.dataStream.encodeString("Success!");
            this.authenticating = true;
            this.sendAndReceive(this.dataStream, MAX_MESSAGE_LENGTH);
            if (cipher.equals("None")) {
                this.inputStream.encrypt(null);
                this.outputStream.encrypt(null);
            }
        }
        catch (SQLTransientConnectionException exception) {
            if (this.authenticating) {
                throw new SQLNonTransientConnectionException(String.format("Authentication failed for database \"%s\"", databaseName));
            }
            throw exception;
        }
        catch (IOException exception) {
            if (this.socket != null && this.socket.isConnected()) {
                try {
                    this.socket.close();
                    this.socket = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.connectionErrorOccurred(new SQLException(exception.toString()));
        }
        catch (XmlException exception) {
            if (this.socket != null && this.socket.isConnected()) {
                try {
                    this.socket.close();
                    this.socket = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new SQLException(exception.toString());
        }
    }

    protected void clearConnectionError() {
    }

    String getClientKey(RemotePassword remotePassword) {
        return remotePassword.genClientKey();
    }

    byte[] computeSessionKey(RemotePassword remotePassword, String userName, String password, String salt, String serverKey) {
        return remotePassword.computeSessionKey(userName.toUpperCase(), password, salt, serverKey);
    }

    CryptoSocket createCryptoSocket(String host, int port) throws IOException {
        return new CryptoSocket(host, port);
    }

    public void sendAndReceive(EncodedDataStream stream) throws SQLException {
        this.sendAndReceive(stream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAndReceive(EncodedDataStream stream, Long maxLength) throws SQLException {
        this.clearConnectionError();
        try {
            RemConnection remConnection = this;
            synchronized (remConnection) {
                stream.send(this.outputStream);
                stream.getMessage(this.inputStream, maxLength);
                int code = stream.getInt();
                if (code != 0) {
                    SQLStateException stateException;
                    String message = stream.getString();
                    String state = stream.getString();
                    if (StringUtils.size(state) == 0) {
                        state = SQLState.getSQLState(code).getState();
                    }
                    String stateClass = state.substring(0, 2);
                    try {
                        stateException = SQLStateException.fromStateClass(stateClass);
                    }
                    catch (IllegalArgumentException exception) {
                        stateException = SQLStateException.SQL_UNKNOWN_EXCEPTION;
                    }
                    stateException.raise(message, state, code);
                }
            }
        }
        catch (IOException exception) {
            this.connectionErrorOccurred(new SQLTransientConnectionException(exception.getMessage(), SQLState.COMMUNICATION_LINK_ERROR.getState()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAsync(EncodedDataStream stream) throws SQLException {
        this.clearConnectionError();
        try {
            RemConnection remConnection = this;
            synchronized (remConnection) {
                stream.send(this.outputStream);
            }
        }
        catch (IOException exception) {
            this.connectionErrorOccurred(new SQLException(exception));
        }
    }

    private void connectionErrorOccurred(SQLException exception) throws SQLException {
        this.networkErrorOccurred = true;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Connection error occurred", exception);
        }
        if (this.errorHandler != null) {
            this.errorHandler.connectionErrorOccurred(exception);
        }
        throw exception;
    }

    RemResultSet createMetaDataResultSet(EncodedDataStream dataStream) throws SQLException {
        int handle = dataStream.getInt();
        if (handle == -1) {
            return null;
        }
        RemResultSet metaDataResultSet = new RemResultSet(this, handle, dataStream, null, true);
        this.metaDataResultSets.add(metaDataResultSet);
        return metaDataResultSet;
    }

    void statementClosed(RemStatement statement) {
        this.statements.remove(statement);
    }

    void metaDataResultSetClosed(RemResultSet resultSet) {
        this.metaDataResultSets.remove(resultSet);
    }

    void setLastTransaction(long transactionId, int nodeId, long commitSequence) {
        this.processConnection.setLast(transactionId, nodeId, commitSequence);
    }

    public int getTimeout() throws SQLException {
        try {
            return this.socket.getSoTimeout() / 1000;
        }
        catch (IOException exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    String getUserName() {
        return this.userName;
    }

    String getConnectionURL() {
        return this.connectionURL;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException("abort is not supported");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }

    @Override
    public String getSchema() throws SQLException {
        EncodedDataStream dataStream = new EncodedDataStream();
        dataStream.startMessage(102);
        this.sendAndReceive(dataStream);
        return dataStream.getString();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNetworkTimeout is not supported");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        try (Statement stmt = this.createStatement();){
            stmt.execute("USE " + schema);
        }
    }

    void encodeCommitInfo(EncodedDataStream datastream) {
        this.processConnection.encodeNodes(datastream);
    }

    private ProcessConnection getProcessConnection(UUID uuid, int maxNodes) {
        ProcessConnection existingConnection;
        ProcessConnection pConnection = processConnections.get(uuid);
        if (pConnection == null && (existingConnection = processConnections.putIfAbsent(uuid, pConnection = new ProcessConnection(uuid, maxNodes))) != null) {
            pConnection = existingConnection;
        }
        return pConnection;
    }

    public boolean isInGlobalTx() {
        return this.isInGlobalTx;
    }

    public void setInGlobalTx(boolean flag) throws SQLException {
        if (this.protocolVersion < 19) {
            throw new SQLFeatureNotSupportedException(String.format("NuoDB server protocol %d does not support XA transactions", this.protocolVersion));
        }
        this.isInGlobalTx = flag;
    }

    public int getXaTransState() {
        return this.xaTransState;
    }

    public void setXaTransState(int state) {
        this.xaTransState = state;
    }

    static void validateAutoGenFlag(int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys != 2 && autoGeneratedKeys != 1) {
            throw new SQLException("Unsupported auto generated key value: " + autoGeneratedKeys, SQLState.RUNTIME_ERROR.getState(), SQLState.RUNTIME_ERROR.getCode());
        }
    }

    public void closeSocket() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class ProcessConnection {
        private UUID databaseUUId;
        private int maxNodes;
        private LastCommitInfo[] infos;
        private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        private final Lock readLock = this.readWriteLock.readLock();
        private final Lock writeLock = this.readWriteLock.writeLock();
        private int activeNodeCount = 0;

        private ProcessConnection(UUID uuid, int maxNodes) {
            this.maxNodes = maxNodes;
            this.databaseUUId = uuid;
            this.infos = new LastCommitInfo[maxNodes];
        }

        public void setLast(long lastTxnId, int nodeId, long commitSequence) {
            if (commitSequence <= 0L || lastTxnId <= 0L || nodeId <= 0) {
                return;
            }
            LastCommitInfo lastCommitInfo = this.getCommitInfo(nodeId);
            lastCommitInfo.setLast(lastTxnId, nodeId, commitSequence);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LastCommitInfo getCommitInfo(int nodeId) {
            int nodeIndex = nodeId % this.maxNodes;
            LastCommitInfo info = null;
            this.readLock.lock();
            try {
                info = this.infos[nodeIndex];
            }
            finally {
                this.readLock.unlock();
            }
            if (info == null) {
                this.writeLock.lock();
                try {
                    info = this.infos[nodeIndex];
                    if (info == null) {
                        this.infos[nodeIndex] = info = new LastCommitInfo();
                        ++this.activeNodeCount;
                    }
                }
                finally {
                    this.writeLock.unlock();
                }
            }
            return info;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void encodeNodes(EncodedDataStream datastream) {
            this.readLock.lock();
            try {
                int nodes = this.activeNodeCount;
                datastream.encodeInt(nodes);
                for (LastCommitInfo info : this.infos) {
                    if (info == null) continue;
                    info.encodeTxn(datastream);
                }
            }
            finally {
                this.readLock.unlock();
            }
        }

        private static class LastCommitInfo {
            private long transactionId;
            private long commitSequence;
            private int nodeId;
            private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
            private final Lock readLock = this.readWriteLock.readLock();
            private final Lock writeLock = this.readWriteLock.writeLock();

            private LastCommitInfo() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void setLast(long lastTxnId, int nodeId, long commitSequence) {
                this.writeLock.lock();
                try {
                    if (commitSequence > this.commitSequence || nodeId != this.nodeId) {
                        this.transactionId = lastTxnId;
                        this.commitSequence = commitSequence;
                        this.nodeId = nodeId;
                    }
                }
                finally {
                    this.writeLock.unlock();
                }
            }

            void encodeTxn(EncodedDataStream datastream) {
                this.readLock.lock();
                try {
                    datastream.encodeInt(this.nodeId);
                    datastream.encodeLong(this.transactionId);
                    datastream.encodeLong(this.commitSequence);
                }
                finally {
                    this.readLock.unlock();
                }
            }
        }
    }

    public static interface ErrorHandler {
        public void connectionErrorOccurred(SQLException var1);
    }
}

