/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.SQLType;
import java.util.Collections;
import java.util.List;

public class ShardingMetadata {
    public static final int SUPER_SHARDING_KEY_LEVEL = 0;
    public static final int SHARDING_KEY_LEVEL = 1;
    private final int version;
    private final ShardingType shardingType;
    private final ShardingType superShardingType;
    private final List<SubKeyMetadata> shardingKeyColumns;
    private final List<SubKeyMetadata> superShardingKeyColumns;

    public ShardingMetadata(int n2, ShardingType shardingType, ShardingType shardingType2, List<SubKeyMetadata> list, List<SubKeyMetadata> list2) {
        this.version = n2;
        this.shardingType = shardingType;
        this.superShardingType = shardingType2;
        if (list != null) {
            Collections.sort(list);
            this.shardingKeyColumns = Collections.unmodifiableList(list);
        } else {
            this.shardingKeyColumns = null;
        }
        if (list2 != null) {
            Collections.sort(list2);
            this.superShardingKeyColumns = Collections.unmodifiableList(list2);
        } else {
            this.superShardingKeyColumns = null;
        }
    }

    public int getVersion() {
        return this.version;
    }

    public ShardingType getShardingType() {
        return this.shardingType;
    }

    public ShardingType getSuperShardingType() {
        return this.superShardingType;
    }

    public List<SubKeyMetadata> getShardingKeyColumns() {
        return this.shardingKeyColumns;
    }

    public List<SubKeyMetadata> getSuperShardingKeyColumns() {
        return this.superShardingKeyColumns;
    }

    public static class SubKeyMetadata
    implements Comparable<SubKeyMetadata> {
        private final int colIndex;
        private final SQLType dataType;
        private final int charSet;

        public SubKeyMetadata(int n2, SQLType sQLType, int n3) {
            this.dataType = sQLType;
            this.charSet = n3;
            this.colIndex = n2;
        }

        SQLType getDataType() {
            return this.dataType;
        }

        int getCharSet() {
            return this.charSet;
        }

        @Override
        public int compareTo(SubKeyMetadata subKeyMetadata) {
            if (this == subKeyMetadata) {
                return 0;
            }
            if (this.colIndex == subKeyMetadata.colIndex) {
                throw new IllegalStateException("Illegal Shard Column index in Metadata");
            }
            if (this.colIndex < subKeyMetadata.colIndex) {
                return -1;
            }
            return 1;
        }
    }

    public static enum ShardingType {
        HASH("HASH"),
        LIST("LIST"),
        RANGE("RANGE"),
        NONE("NONE");

        String typeStr;

        private ShardingType(String string2) {
            this.typeStr = string2;
        }

        static ShardingType toShardType(String string) {
            if (string == null) {
                return NONE;
            }
            for (ShardingType shardingType : ShardingType.values()) {
                if (!shardingType.typeStr.equals(string)) continue;
                return shardingType;
            }
            return NONE;
        }
    }
}

