/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jycombobox;

import de.javasoft.swing.jycombobox.ColorPopupPanel;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class ColorComboBoxRenderer
implements ListCellRenderer {
    private ListCellRenderer defaultRenderer;
    private boolean hexadecimal;
    private boolean includeAlphaValue;

    public ColorComboBoxRenderer(ListCellRenderer listCellRenderer) {
        this(listCellRenderer, false, false);
    }

    public ColorComboBoxRenderer(ListCellRenderer listCellRenderer, boolean bl, boolean bl2) {
        this.defaultRenderer = listCellRenderer;
        this.hexadecimal = bl;
        this.includeAlphaValue = bl2;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        JLabel jLabel = (JLabel)this.defaultRenderer.getListCellRendererComponent(jList, object, n, bl, bl2);
        Color color = (Color)object;
        jLabel.setIcon(new ColorPopupPanel.ColorIcon(color, 16, 12));
        if (color == null) {
            jLabel.setText(UIManager.getString("JYComboBox.colorPopup.noColor"));
        } else {
            jLabel.setText(ColorPopupPanel.colorAsText(color, this.hexadecimal, this.includeAlphaValue));
        }
        return jLabel;
    }

    public boolean isAlphaValueIncluded() {
        return this.includeAlphaValue;
    }
}

