/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.Util;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.formcomponents.FormComponent;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.CompoundComponentHandler;
import com.install4j.runtime.beans.formcomponents.CoupledComponentsHolder;
import com.install4j.runtime.beans.formcomponents.CoupledComponentsUtil;
import com.install4j.runtime.beans.formcomponents.LeadingLabelComponent;
import com.install4j.runtime.installer.helper.Logger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JRadioButton;

public class SingleRadiobuttonComponent
extends LeadingLabelComponent
implements CoupledComponentsHolder,
CompoundComponentHandler,
ActionListener {
    private static final Object INHIBIT_SELECTION_SCRIPT = "inhibitSelectionScript";
    private String variableName = "";
    private String variableValue = "";
    private String radioButtonLabel;
    private boolean initiallySelected = false;
    private List<String> coupledComponentIds = new ArrayList<String>();
    private boolean inverseCoupling = false;
    private ScriptProperty selectionScript;
    private JRadioButton radioButton;
    private ButtonGroup buttonGroup;
    private List<SingleRadiobuttonComponent> radioButtonFormComponents;

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String getVariableValue() {
        return this.variableValue;
    }

    public void setVariableValue(String variableValue) {
        this.variableValue = variableValue;
    }

    public String getRadioButtonLabel() {
        return this.replaceFormVariables(this.radioButtonLabel, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE);
    }

    public void setRadioButtonLabel(String radioButtonLabel) {
        this.radioButtonLabel = radioButtonLabel;
    }

    public boolean isInitiallySelected() {
        return this.initiallySelected;
    }

    public void setInitiallySelected(boolean initiallySelected) {
        this.initiallySelected = initiallySelected;
    }

    public ScriptProperty getSelectionScript() {
        return this.selectionScript;
    }

    public void setSelectionScript(ScriptProperty selectionScript) {
        this.selectionScript = selectionScript;
    }

    @Override
    public List<String> getCoupledComponentIds() {
        return this.coupledComponentIds;
    }

    @Override
    public void setCoupledComponentIds(List<String> coupledComponentIds) {
        this.coupledComponentIds = coupledComponentIds;
    }

    @Override
    public boolean isInverseCoupling() {
        return this.inverseCoupling;
    }

    @Override
    public void setInverseCoupling(boolean inverseCoupling) {
        this.inverseCoupling = inverseCoupling;
    }

    @Override
    public Boolean isEnableCoupledComponents() {
        if (this.radioButton == null) {
            return null;
        }
        return this.radioButton.isSelected();
    }

    @Override
    public void migrateIds(Map<String, String> oldIdToNewId) {
        super.migrateIds(oldIdToNewId);
        CoupledComponentsUtil.migrateCoupledIds(this, oldIdToNewId);
    }

    @Override
    public void formWillActivate() {
        super.formWillActivate();
        if (this.buttonGroup != null) {
            this.updateSelectedComponent();
            this.enableCoupledComponents();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        CoupledComponentsUtil.enableCoupledComponents(this);
    }

    @Override
    public void setFormEnvironment(FormEnvironment formEnvironment) {
        super.setFormEnvironment(formEnvironment);
        if (formEnvironment != null) {
            int i;
            if (this.radioButton != null) {
                this.radioButton.setName(formEnvironment.getId(this));
            }
            if (this.buttonGroup != null) {
                JRadioButton[] buttons = new JRadioButton[this.buttonGroup.getButtonCount()];
                Enumeration<AbstractButton> en = this.buttonGroup.getElements();
                int count = 0;
                while (en.hasMoreElements()) {
                    buttons[count++] = (JRadioButton)en.nextElement();
                }
                for (JRadioButton button : buttons) {
                    this.buttonGroup.remove(button);
                }
            }
            this.radioButtonFormComponents = new ArrayList<SingleRadiobuttonComponent>();
            FormComponent[] formComponents = formEnvironment.getFormComponents();
            int thisIndex = -1;
            for (i = 0; i < formComponents.length; ++i) {
                if (this != formComponents[i]) continue;
                thisIndex = i;
                break;
            }
            if (thisIndex == -1) {
                return;
            }
            for (i = 0; i < formComponents.length; ++i) {
                SingleRadiobuttonComponent radiobuttonComponent;
                FormComponent formComponent = formComponents[i];
                if (!(formComponent instanceof SingleRadiobuttonComponent) || !Objects.equals((radiobuttonComponent = (SingleRadiobuttonComponent)formComponent).getVariableName(), this.variableName)) continue;
                if (i < thisIndex) {
                    return;
                }
                this.radioButtonFormComponents.add(radiobuttonComponent);
            }
            this.buttonGroup = new ButtonGroup();
            for (SingleRadiobuttonComponent component : this.radioButtonFormComponents) {
                JRadioButton radioButton = (JRadioButton)component.getConfigurationObject();
                if (radioButton == null) continue;
                this.buttonGroup.add(radioButton);
                radioButton.removeActionListener(this);
                radioButton.addActionListener(this);
            }
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.radioButton.setText(this.getRadioButtonLabel());
    }

    @Override
    public JComponent createCenterComponent() {
        this.radioButton = new JRadioButton();
        this.radioButton.setActionCommand(this.variableValue);
        this.radioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!Objects.equals(SingleRadiobuttonComponent.this.radioButton.getClientProperty(INHIBIT_SELECTION_SCRIPT), Boolean.TRUE) && SingleRadiobuttonComponent.this.getFormEnvironment().isInitialized() && e.getStateChange() == 1) {
                    SingleRadiobuttonComponent.this.executeSelectionScript();
                }
            }
        });
        String initValue = (String)this.getInitValue(null, this.getVariableName(), String.class);
        if (this.variableValue.equals(initValue) || initValue == null && this.initiallySelected) {
            this.radioButton.setSelected(true);
        }
        return this.radioButton;
    }

    private void executeSelectionScript() {
        try {
            this.getContext().runScript(this.selectionScript, this, this.getFormEnvironment());
        }
        catch (Exception e) {
            Util.printAnnotatedStackTrace(e);
            Logger.getInstance().log(e);
        }
    }

    @Override
    public boolean isFillCenterHorizontal() {
        return false;
    }

    @Override
    public Object getConfigurationObject() {
        return this.radioButton;
    }

    @Override
    public Class getConfigurationObjectClass() {
        return JRadioButton.class;
    }

    @Override
    public boolean checkCompleted() {
        if (this.radioButton.isSelected()) {
            this.getContext().setVariable(this.getVariableName(), this.variableValue);
        }
        if (this.buttonGroup != null) {
            this.getContext().registerResponseFileVariable(this.getVariableName());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        if (this.buttonGroup != null) {
            ArrayList<String> descriptions = new ArrayList<String>();
            ArrayList<JRadioButton> buttons = new ArrayList<JRadioButton>();
            int defaultValue = -1;
            ButtonModel selection = this.buttonGroup.getSelection();
            String defaultActionCommand = selection == null ? null : selection.getActionCommand();
            Enumeration<AbstractButton> elements = this.buttonGroup.getElements();
            int i = 0;
            while (elements.hasMoreElements()) {
                SingleRadiobuttonComponent singleRadiobuttonComponent;
                JRadioButton radioButton = (JRadioButton)elements.nextElement();
                if (Objects.equals(radioButton.getActionCommand(), defaultActionCommand)) {
                    defaultValue = buttons.size();
                }
                if ((singleRadiobuttonComponent = this.radioButtonFormComponents.get(i)).isVisible() && singleRadiobuttonComponent.isEnabled()) {
                    buttons.add(radioButton);
                    descriptions.add(radioButton.getText());
                }
                ++i;
            }
            if (buttons.size() > 0) {
                int newValue = console.askOption(this.getConsoleLabelText(false), descriptions.toArray(new String[0]), null, defaultValue);
                JRadioButton selectedButton = (JRadioButton)buttons.get(newValue);
                selectedButton.putClientProperty(INHIBIT_SELECTION_SCRIPT, true);
                try {
                    selectedButton.setSelected(true);
                }
                finally {
                    selectedButton.putClientProperty(INHIBIT_SELECTION_SCRIPT, null);
                }
                for (SingleRadiobuttonComponent component : this.radioButtonFormComponents) {
                    JRadioButton radioButton = (JRadioButton)component.getConfigurationObject();
                    if (radioButton == selectedButton) {
                        component.executeSelectionScript();
                    }
                    component.enableCoupledComponents();
                }
            }
        }
        return true;
    }

    @Override
    public boolean handleUnattended() {
        if (this.buttonGroup != null) {
            this.enableCoupledComponents();
        }
        return super.handleUnattended();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.enableCoupledComponents();
    }

    private void updateSelectedComponent() {
        String contextVariableValue = (String)this.getContext().getVariable(this.variableName);
        for (SingleRadiobuttonComponent component : this.radioButtonFormComponents) {
            if (!Objects.equals(contextVariableValue, component.getVariableValue())) continue;
            ((JRadioButton)component.getConfigurationObject()).setSelected(true);
        }
    }

    private void enableCoupledComponents() {
        SingleRadiobuttonComponent selectedComponent = null;
        for (SingleRadiobuttonComponent component : this.radioButtonFormComponents) {
            if (((JRadioButton)component.getConfigurationObject()).isSelected()) {
                selectedComponent = component;
                continue;
            }
            CoupledComponentsUtil.enableCoupledComponents(component);
        }
        if (selectedComponent != null) {
            CoupledComponentsUtil.enableCoupledComponents(selectedComponent);
        }
    }
}

