/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.support.channels;

import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.channels.ISocketChannelReadCallback;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.ExceptionBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractSocketChannel
implements Closeable {
    protected static final ExceptionBuilder EXCEPTION_BUILDER = new ExceptionBuilder(8);
    protected static final int SERVER_CLOSED_CONNECTION = -1;
    protected final SocketChannel m_internal;
    protected final ILogger m_log;
    private final AtomicBoolean m_closed = new AtomicBoolean(false);
    protected final ISocketChannelReadCallback m_readCallback;

    public AbstractSocketChannel(SocketChannel socketChannel, ISocketChannelReadCallback iSocketChannelReadCallback, ILogger iLogger) throws ErrorException {
        this.m_internal = socketChannel;
        this.m_readCallback = iSocketChannelReadCallback;
        this.m_log = iLogger;
    }

    public SocketChannel getSocketChannel() {
        return this.m_internal;
    }

    public abstract int getReadBufferCapacity();

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        try {
            this.m_closed.set(true);
            this.m_internal.close();
        }
        catch (IOException iOException) {
            LogUtilities.logFatal(iOException, this.m_log);
        }
    }

    public boolean isClosed() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        return this.m_closed.get();
    }

    public abstract boolean write(ByteBuffer var1) throws ErrorException;

    public abstract boolean write(ByteBuffer[] var1, int var2, int var3) throws ErrorException;

    public abstract void read() throws ErrorException;

    public boolean arrayHasRemaining(ByteBuffer[] byteBufferArray, int n) {
        for (int i = 0; i < n; ++i) {
            if (!byteBufferArray[i].hasRemaining()) continue;
            return true;
        }
        return false;
    }

    protected void readCallback(ByteBuffer byteBuffer) throws ErrorException {
        byteBuffer.flip();
        byteBuffer.rewind();
        this.m_readCallback.read(byteBuffer);
    }
}

