/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor;

import com.amazon.dsi.dataengine.utilities.CursorType;
import com.amazon.dsi.dataengine.utilities.ExecutionContext;
import com.amazon.dsi.dataengine.utilities.ExecutionResult;
import com.amazon.dsi.dataengine.utilities.ParameterInputValue;
import com.amazon.dsi.exceptions.DefaultParamException;
import com.amazon.dsi.exceptions.ParamAlreadyPushedException;
import com.amazon.sqlengine.aeprocessor.aetree.statement.AEQuery;
import com.amazon.sqlengine.aeprocessor.aetree.statement.IAEStatement;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.executor.ETResultSet;
import com.amazon.sqlengine.executor.ETRowCountResult;
import com.amazon.sqlengine.executor.IStatementExecutor;
import com.amazon.sqlengine.executor.etree.ETCancelState;
import com.amazon.sqlengine.executor.etree.ETResourceManager;
import com.amazon.sqlengine.executor.etree.statement.ETQuery;
import com.amazon.sqlengine.executor.etree.statement.IETStatement;
import com.amazon.sqlengine.executor.etree.statement.RowCountStatement;
import com.amazon.sqlengine.executor.etree.util.RegisterWarningListenerUtil;
import com.amazon.sqlengine.executor.etree.value.ETParameter;
import com.amazon.support.IWarningListener;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Map;

public class StatementExecutor
implements IStatementExecutor {
    private IETStatement m_etStatement;
    private IAEStatement m_aeStatement;
    private ETResourceManager m_rscManager;
    private final ETCancelState m_cancelState;
    private Object m_cancelLock;
    private boolean m_isCanceled;

    public StatementExecutor(IETStatement iETStatement, IAEStatement iAEStatement, ETResourceManager eTResourceManager, ETCancelState eTCancelState) {
        if (!(iETStatement instanceof ETQuery) && !(iETStatement instanceof RowCountStatement)) {
            throw new IllegalArgumentException("Unknown ETree type.");
        }
        this.m_etStatement = iETStatement;
        this.m_aeStatement = iAEStatement;
        this.m_rscManager = eTResourceManager;
        this.m_cancelState = eTCancelState;
        this.m_isCanceled = false;
        this.m_cancelLock = new Object();
    }

    @Override
    public void close() {
        if (this.m_etStatement instanceof RowCountStatement) {
            try {
                ((RowCountStatement)this.m_etStatement).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_etStatement = null;
            if (null != this.m_rscManager) {
                try {
                    this.m_rscManager.free();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.m_rscManager = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelExecution() {
        Object object = this.m_cancelLock;
        synchronized (object) {
            this.m_isCanceled = true;
            this.m_cancelState.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionResult execute(ExecutionContext executionContext) throws ErrorException {
        ExecutionResult executionResult;
        Object object = this.m_cancelLock;
        synchronized (object) {
            if (this.m_isCanceled) {
                throw SQLEngineExceptionFactory.operationCanceledException();
            }
            this.m_cancelState.clearCancel();
        }
        if (this.m_etStatement.isResultSet()) {
            object = (ETQuery)this.m_etStatement;
            if (executionContext.getInputs().size() != 0) {
                if (((ETQuery)object).getOperand().isOpen()) {
                    throw SQLEngineExceptionFactory.featureNotImplementedException("Multiple active open result sets is not supported.");
                }
                this.pushParameters(executionContext);
            }
            ETResultSet eTResultSet = new ETResultSet((ETQuery)object, (AEQuery)this.m_aeStatement, this.m_rscManager, this.m_cancelState);
            eTResultSet.setCursorType(CursorType.FORWARD_ONLY);
            executionResult = new ExecutionResult(eTResultSet);
        } else {
            try {
                this.pushParameters(executionContext);
                object = (RowCountStatement)this.m_etStatement;
                this.m_rscManager.allocate();
                ((RowCountStatement)this.m_etStatement).setGeneratedParameters(executionContext.getGeneratedParameters());
                ((RowCountStatement)object).execute();
                ETRowCountResult eTRowCountResult = new ETRowCountResult();
                eTRowCountResult.setRowCount(((RowCountStatement)object).getRowCount());
                executionResult = new ExecutionResult(eTRowCountResult);
                if (executionContext.getGeneratedParameters() != null) {
                    executionResult.setGeneratedResult(((RowCountStatement)object).getGeneratedResult());
                }
            }
            finally {
                this.m_rscManager.free();
            }
        }
        return executionResult;
    }

    @Override
    public void registerWarningListener(IWarningListener iWarningListener) {
        RegisterWarningListenerUtil.registerWarningListener(iWarningListener, this.m_etStatement);
    }

    private void pushParameters(ExecutionContext executionContext) {
        ArrayList<ParameterInputValue> arrayList = executionContext.getInputs();
        for (Map.Entry<Integer, ETParameter> entry : this.m_etStatement.getInputParameters().entrySet()) {
            int n = entry.getKey();
            if (n < 0 || n > arrayList.size()) {
                throw new IllegalStateException("Parameter index in the ETree does not match execution context.");
            }
            ParameterInputValue parameterInputValue = arrayList.get(n - 1);
            try {
                entry.getValue().setInputData(parameterInputValue.getData());
            }
            catch (ParamAlreadyPushedException paramAlreadyPushedException) {
                throw new IllegalStateException("pushed parameter encountered during execution.");
            }
            catch (DefaultParamException defaultParamException) {
                throw new IllegalStateException("Default parameter encountered during execution.");
            }
        }
    }

    @Override
    public void startBatch() throws ErrorException {
        if (this.m_etStatement instanceof RowCountStatement) {
            ((RowCountStatement)this.m_etStatement).startBatch();
        }
    }

    @Override
    public void endBatch() throws ErrorException {
        if (this.m_etStatement instanceof RowCountStatement) {
            ((RowCountStatement)this.m_etStatement).endBatch();
        }
    }
}

