/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.common;

import com.amazon.dsi.core.utilities.ConnSettingRequestMap;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class CommonCoreUtils {
    protected static final String HOST_DELIMITER = "//";
    protected static final String PORT_DELIMITER = ":";
    protected static final String SCHEMA_DELIMITER = "/";
    protected static final String KEY_VALUE_DELIMITER = ";";
    protected static final String VALUE_DELIMITER = "=";

    public static boolean parseSubName(String subname, Properties properties) {
        if (null == subname || 0 == subname.length() || !subname.startsWith(HOST_DELIMITER)) {
            return false;
        }
        String keyValueStr = subname.trim().substring(HOST_DELIMITER.length());
        if (0 == keyValueStr.length()) {
            return false;
        }
        TreeMap<String, String> map = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        String[] keyValuePairs = keyValueStr.split(KEY_VALUE_DELIMITER);
        for (int i = 0; i < keyValuePairs.length; ++i) {
            if (i == 0) {
                String[] Conn_Type = new String[]{"Host", "Port", "ConnSchema"};
                String connectionInfo = keyValuePairs[0];
                String host = null;
                String port = null;
                String schema = null;
                int portIndex = connectionInfo.indexOf(PORT_DELIMITER);
                int schemaIndex = connectionInfo.indexOf(SCHEMA_DELIMITER);
                if (-1 == portIndex) {
                    if (-1 != schemaIndex) {
                        host = connectionInfo.substring(0, schemaIndex);
                        schema = connectionInfo.substring(schemaIndex + 1, connectionInfo.length());
                        map.put(Conn_Type[2], schema);
                    } else {
                        host = connectionInfo;
                    }
                    map.put(Conn_Type[0], host);
                    continue;
                }
                host = connectionInfo.substring(0, portIndex);
                map.put(Conn_Type[0], host);
                if (-1 != schemaIndex) {
                    port = connectionInfo.substring(portIndex + 1, schemaIndex);
                    map.put(Conn_Type[1], port);
                    schema = connectionInfo.substring(schemaIndex + 1, connectionInfo.length());
                    map.put(Conn_Type[2], schema);
                    continue;
                }
                port = connectionInfo.substring(portIndex + 1, connectionInfo.length());
                map.put(Conn_Type[1], port);
                continue;
            }
            String[] keyValue = keyValuePairs[i].split(VALUE_DELIMITER);
            if (2 > keyValue.length) {
                map.put(keyValue[0], "");
                continue;
            }
            map.put(keyValue[0], keyValue[1]);
        }
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (map.containsKey(key)) continue;
            map.put(key, properties.getProperty(key));
        }
        properties.clear();
        properties.putAll((Map<?, ?>)map);
        return true;
    }

    @Deprecated
    public static void logConnectionFunctionEntrance(ILogger logger, ConnSettingRequestMap requestMap, int majorVersion, int minorVersion, int hotFixVersion, int driverBuildNumber) {
        CommonCoreUtils.logConnectionFunctionEntrance(logger, requestMap, String.valueOf(majorVersion), String.valueOf(minorVersion), String.valueOf(hotFixVersion), String.valueOf(driverBuildNumber));
    }

    public static void logConnectionFunctionEntrance(ILogger logger, ConnSettingRequestMap requestMap, String majorVersion, String minorVersion, String hotFixVersion, String driverBuildNumber) {
        if (logger.isEnabled()) {
            StringBuffer classPathStr = new StringBuffer();
            classPathStr.append("URLClassLoader.getURLs(): ");
            try {
                ClassLoader cl = ClassLoader.getSystemClassLoader();
                if (cl instanceof URLClassLoader) {
                    URL[] urls = ((URLClassLoader)cl).getURLs();
                    boolean isFirst = true;
                    for (URL url : urls) {
                        if (!isFirst) {
                            classPathStr.append(", ");
                        }
                        isFirst = false;
                        classPathStr.append(url.getFile());
                    }
                } else {
                    classPathStr.append("No URLClassLoader available.");
                }
            }
            catch (SecurityException ex) {
                LogUtilities.logError(ex, logger);
                classPathStr.append("SecurityException thrown: " + ex.getMessage());
            }
            catch (IllegalStateException ex) {
                LogUtilities.logError(ex, logger);
                classPathStr.append("IllegalStateException thrown: " + ex.getMessage());
            }
            catch (Error ex) {
                classPathStr.append("Error thrown: " + ex.getMessage());
            }
            try {
                LogUtilities.logFunctionEntrance(logger, requestMap, "Major Version: " + majorVersion, "Minor Version: " + minorVersion, "Hot Fix Version: " + hotFixVersion, "Build Number: " + driverBuildNumber, "java.vendor:" + System.getProperty("java.vendor"), "java.version:" + System.getProperty("java.version"), "os.arch:" + System.getProperty("os.arch"), "os.name:" + System.getProperty("os.name"), "os.version:" + System.getProperty("os.version"), "Runtime.totalMemory:" + Runtime.getRuntime().totalMemory(), "Runtime.maxMemory:" + Runtime.getRuntime().maxMemory(), "Runtime.avaialableProcessors:" + Runtime.getRuntime().availableProcessors(), classPathStr);
            }
            catch (Exception e) {
                LogUtilities.logError(e, logger);
                LogUtilities.logFunctionEntrance(logger, requestMap, "Major Version: " + majorVersion, "Minor Version: " + minorVersion, "Hot Fix Version: " + hotFixVersion, "Build Number: " + driverBuildNumber, "Runtime.totalMemory:" + Runtime.getRuntime().totalMemory(), "Runtime.maxMemory:" + Runtime.getRuntime().maxMemory(), "Runtime.avaialableProcessors:" + Runtime.getRuntime().availableProcessors(), classPathStr);
            }
        }
    }
}

