/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.update;

import com.exe4j.runtime.util.FileUtil;
import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallAction;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.launcher.integration.AutomaticUpdate;
import com.install4j.runtime.launcher.integration.UpdateConfig;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;

public class ScheduleUpdateAction
extends SystemInstallAction {
    private File installerFile;
    private String version = "";
    private int maxTries = 3;
    private int maxCancelCount = 10;
    private String[] arguments = new String[0];

    @Override
    public boolean install(final InstallerContext context) throws UserCanceledException {
        UpdateConfig.withConfig(true, new UpdateConfig.ConfigConsumer(){

            @Override
            public boolean handleConfig(UpdateConfig updateConfig) throws IOException {
                updateConfig.clear();
                updateConfig.setFile(ScheduleUpdateAction.this.getInstallerFile().getAbsolutePath());
                updateConfig.setVersion(ScheduleUpdateAction.this.getVersion());
                updateConfig.setMaxTries(ScheduleUpdateAction.this.getMaxTries());
                updateConfig.setMaxCancelCount(ScheduleUpdateAction.this.getMaxCancelCount());
                if (InstallerConfig.isInstaller()) {
                    updateConfig.setInstallationDirectory(FileUtil.getCanonicalPath(context.getInstallationDirectory()));
                } else {
                    File installationDir = null;
                    File singleBundle = AutomaticUpdate.getCurrentSingleBundle();
                    if (singleBundle != null) {
                        installationDir = singleBundle.getParentFile();
                    } else {
                        File runtimeDir = ResourceHelper.getRuntimeDir();
                        if (runtimeDir != null) {
                            installationDir = runtimeDir.getParentFile();
                        }
                    }
                    if (installationDir != null) {
                        updateConfig.setInstallationDirectory(FileUtil.getCanonicalPath(installationDir));
                    }
                }
                updateConfig.setLanguageId(context.getLanguageId());
                updateConfig.setArguments(Arrays.asList(ScheduleUpdateAction.this.getArguments()));
                return true;
            }
        });
        return true;
    }

    public int getMaxTries() {
        return this.maxTries;
    }

    public void setMaxTries(int maxTries) {
        this.maxTries = maxTries;
    }

    public int getMaxCancelCount() {
        return this.maxCancelCount;
    }

    public void setMaxCancelCount(int maxCancelCount) {
        this.maxCancelCount = maxCancelCount;
    }

    public String[] getArguments() {
        return ScheduleUpdateAction.replaceVariables(this.arguments);
    }

    public void setArguments(String[] arguments) {
        this.arguments = arguments;
    }

    public File getInstallerFile() {
        return ScheduleUpdateAction.replaceVariables(this.installerFile);
    }

    public void setInstallerFile(File installerFile) {
        this.installerFile = installerFile;
    }

    public String getVersion() {
        return ScheduleUpdateAction.replaceVariables(this.version);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public boolean isRollbackSupported() {
        return false;
    }
}

