/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.exasol.model.ExasolObject;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class ExasolDataType
extends ExasolObject<DBSObject>
implements DBSDataType,
DBPQualifiedObject {
    private static final Log LOG = Log.getLog(ExasolDataType.class);
    private DBSObject parentNode;
    private ExasolSchema exasolSchema;
    private TypeDesc typeDesc;
    private long exasolTypeId;
    private Integer length;
    private Integer scale;
    private String name;

    protected ExasolDataType(DBSObject parent, String name, boolean persisted) {
        super(parent, name, persisted);
    }

    public ExasolDataType(DBSObject owner, ResultSet dbResult) throws DBException {
        super(owner, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TYPE_NAME"), true);
        this.exasolTypeId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"TYPE_ID");
        this.length = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"PRECISION");
        this.scale = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"MINIMUM_SCALE");
        TypeDesc tempTypeDesc = null;
        String typeName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TYPE_NAME");
        int precision = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"PRECISION");
        int minimumScale = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"MINIMUM_SCALE");
        int maximumScale = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"MAXIMUM_SCALE");
        switch (this.name = typeName) {
            case "BIGINT": {
                tempTypeDesc = new TypeDesc(DBPDataKind.NUMERIC, -5, precision, minimumScale, maximumScale, typeName);
                break;
            }
            case "INTEGER": {
                tempTypeDesc = new TypeDesc(DBPDataKind.NUMERIC, 4, precision, minimumScale, maximumScale, typeName);
                break;
            }
            case "DECIMAL": {
                tempTypeDesc = new TypeDesc(DBPDataKind.NUMERIC, 3, precision, minimumScale, maximumScale, typeName);
                break;
            }
            case "DOUBLE PRECISION": {
                tempTypeDesc = new TypeDesc(DBPDataKind.NUMERIC, 8, precision, minimumScale, maximumScale, typeName);
                break;
            }
            case "FLOAT": {
                tempTypeDesc = new TypeDesc(DBPDataKind.NUMERIC, 6, precision, minimumScale, maximumScale, typeName);
                break;
            }
            case "INTERVAL DAY TO SECOND": {
                tempTypeDesc = new TypeDesc(DBPDataKind.STRING, 12, precision, minimumScale, maximumScale, typeName);
                break;
            }
            case "INTERVAL YEAR TO MONTH": {
                tempTypeDesc = new TypeDesc(DBPDataKind.STRING, 12, precision, minimumScale, maximumScale, typeName);
                break;
            }
            case "SMALLINT": {
                tempTypeDesc = new TypeDesc(DBPDataKind.NUMERIC, 5, precision, minimumScale, maximumScale, typeName);
                break;
            }
            case "TINYINT": {
                tempTypeDesc = new TypeDesc(DBPDataKind.NUMERIC, -6, precision, minimumScale, maximumScale, typeName);
                break;
            }
            case "GEOMETRY": {
                tempTypeDesc = new TypeDesc(DBPDataKind.STRING, 12, precision, minimumScale, maximumScale, typeName);
                break;
            }
            case "BOOLEAN": {
                tempTypeDesc = new TypeDesc(DBPDataKind.BOOLEAN, 16, precision, minimumScale, maximumScale, typeName);
                break;
            }
            case "CHAR": {
                tempTypeDesc = new TypeDesc(DBPDataKind.STRING, 1, precision, minimumScale, maximumScale, typeName);
                break;
            }
            case "VARCHAR": {
                tempTypeDesc = new TypeDesc(DBPDataKind.STRING, 12, precision, minimumScale, maximumScale, typeName);
                break;
            }
            case "LONG VARCHAR": {
                tempTypeDesc = new TypeDesc(DBPDataKind.STRING, -16, precision, minimumScale, maximumScale, typeName);
                break;
            }
            case "DATE": {
                tempTypeDesc = new TypeDesc(DBPDataKind.DATETIME, 91, precision, minimumScale, maximumScale, typeName);
                break;
            }
            case "TIMESTAMP": {
                tempTypeDesc = new TypeDesc(DBPDataKind.DATETIME, 93, precision, minimumScale, maximumScale, typeName);
                break;
            }
            case "TIMESTAMP WITH LOCAL TIME ZONE": {
                tempTypeDesc = new TypeDesc(DBPDataKind.DATETIME, 2014, precision, minimumScale, maximumScale, typeName);
                break;
            }
            case "HASHTYPE": {
                tempTypeDesc = new TypeDesc(DBPDataKind.STRING, -2, precision, minimumScale, maximumScale, typeName);
                break;
            }
            default: {
                LOG.error((Object)("DataType '" + this.name + "' is unknown to DBeaver"));
            }
        }
        this.typeDesc = tempTypeDesc;
    }

    @Override
    public DBSObject getParentObject() {
        return this.parentNode;
    }

    public String getTypeName() {
        return this.name;
    }

    public String getFullTypeName() {
        return DBUtils.getFullTypeName((DBSTypedObject)this);
    }

    public int getEquivalentSqlType() {
        return this.typeDesc.sqlType;
    }

    public Integer getPrecision() {
        if (this.typeDesc.precision != null) {
            return this.typeDesc.precision;
        }
        return 0;
    }

    @Nullable
    public DBSDataType getComponentType(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public int getMinScale() {
        if (this.typeDesc.minScale != null) {
            return this.typeDesc.minScale;
        }
        return 0;
    }

    public int getMaxScale() {
        if (this.typeDesc.maxScale != null) {
            return this.typeDesc.maxScale;
        }
        return 0;
    }

    @NotNull
    public DBCLogicalOperator[] getSupportedOperators(DBSTypedObject attribute) {
        return DBUtils.getDefaultOperators((DBSTypedObject)this);
    }

    @Override
    @Property(viewable=true, editable=false, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, editable=false, order=2)
    public ExasolSchema getSchema() {
        return this.exasolSchema;
    }

    @Property(viewable=true, editable=false, order=4)
    public DBPDataKind getDataKind() {
        if (this.typeDesc == null) {
            return DBPDataKind.UNKNOWN;
        }
        return this.typeDesc.dataKind;
    }

    @Property(viewable=true, editable=false, order=5)
    public long getMaxLength() {
        return this.length.intValue();
    }

    public long getTypeModifiers() {
        return 0L;
    }

    @Property(viewable=true, editable=false, order=6)
    public Integer getScale() {
        return this.scale;
    }

    @Property(viewable=false, editable=false, order=10)
    public int getTypeID() {
        return this.typeDesc.sqlType;
    }

    @Property(viewable=false, editable=false, order=11)
    public long getExasolTypeId() {
        return this.exasolTypeId;
    }

    @Override
    @Property(viewable=false, editable=false, multiline=true)
    @Nullable
    public String getDescription() {
        return null;
    }

    @Override
    public boolean isPersisted() {
        return true;
    }

    public Object geTypeExtension() {
        return null;
    }

    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return this.name;
    }

    private static final class TypeDesc {
        private final DBPDataKind dataKind;
        private final Integer sqlType;
        private final Integer precision;
        private final Integer minScale;
        private final Integer maxScale;
        private final String name;

        private TypeDesc(DBPDataKind dataKind, Integer sqlType, Integer precision, Integer minScale, Integer maxScale, String name) {
            this.name = name;
            this.dataKind = dataKind;
            this.sqlType = sqlType;
            this.precision = precision;
            this.minScale = minScale;
            this.maxScale = maxScale;
        }
    }
}

