/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverActivator;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.navigator.DBNBrowseSettings;
import org.jkiss.dbeaver.registry.DataSourceNavigatorSettings;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.dialogs.connection.NewConnectionWizard;
import org.jkiss.dbeaver.ui.dialogs.connection.ProjectSelectorPanel;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverSelectViewer;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverTreeViewer;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.utils.CommonUtils;

class ConnectionPageDriver
extends ActiveWizardPage
implements ISelectionChangedListener,
IDoubleClickListener {
    private static final String DEFAULT_NAVIGATOR_SETTINGS_RESET = "navigator.settings.preset.default";
    private NewConnectionWizard wizard;
    private DBPDriver selectedDriver;
    private DataSourceNavigatorSettings.Preset navigatorPreset;
    private DriverSelectViewer driverSelectViewer;
    private ProjectSelectorPanel projectSelector;

    ConnectionPageDriver(NewConnectionWizard wizard) {
        super("newConnectionDrivers");
        this.wizard = wizard;
        this.setTitle(CoreMessages.dialog_new_connection_wizard_start_title);
        this.setDescription(CoreMessages.dialog_new_connection_wizard_start_description);
        String defPreset = DBeaverActivator.getInstance().getPreferences().getString(DEFAULT_NAVIGATOR_SETTINGS_RESET);
        if (CommonUtils.isEmpty((String)defPreset)) {
            defPreset = DataSourceNavigatorSettings.PRESET_FULL.getId();
        }
        for (DataSourceNavigatorSettings.Preset p : DataSourceNavigatorSettings.PRESETS.values()) {
            if (!p.getId().equals(defPreset)) continue;
            this.navigatorPreset = p;
            break;
        }
        if (this.navigatorPreset == null) {
            this.navigatorPreset = DataSourceNavigatorSettings.PRESET_FULL;
        }
    }

    public void createControl(Composite parent) {
        Composite placeholder = UIUtils.createComposite((Composite)parent, (int)1);
        this.setControl((Control)placeholder);
        Composite controlsGroup = UIUtils.createComposite((Composite)placeholder, (int)5);
        controlsGroup.setLayoutData((Object)new GridData(768));
        Composite presetComposite = new Composite(controlsGroup, 0);
        presetComposite.setLayout((Layout)new RowLayout());
        new Label(presetComposite, 0).setImage(DBeaverIcons.getImage((DBPImage)UIIcon.CONFIGURATION));
        new Label(presetComposite, 0).setText("Connection view:  ");
        for (final DataSourceNavigatorSettings.Preset p : DataSourceNavigatorSettings.PRESETS.values()) {
            if (p == DataSourceNavigatorSettings.PRESET_CUSTOM) continue;
            final Button pButton = new Button(presetComposite, 16);
            pButton.setText(p.getName());
            pButton.setToolTipText(p.getDescription());
            if (p == this.navigatorPreset) {
                pButton.setSelection(true);
            }
            pButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (pButton.getSelection()) {
                        ConnectionPageDriver.this.navigatorPreset = p;
                        DBeaverActivator.getInstance().getPreferences().setValue(ConnectionPageDriver.DEFAULT_NAVIGATOR_SETTINGS_RESET, ConnectionPageDriver.this.navigatorPreset.getId());
                    }
                }
            });
        }
        this.createPanelDivider(controlsGroup);
        Composite orderGroup = new Composite(controlsGroup, 0);
        orderGroup.setLayoutData((Object)new GridData(64));
        orderGroup.setLayout((Layout)new RowLayout());
        new Label(orderGroup, 0).setImage(DBeaverIcons.getImage((DBPImage)UIIcon.SORT));
        new Label(orderGroup, 0).setText("Sort by: ");
        DriverSelectViewer.OrderBy defaultOrderBy = DriverSelectViewer.getDefaultOrderBy();
        DriverSelectViewer.OrderBy[] orderByArray = DriverSelectViewer.OrderBy.values();
        int n = orderByArray.length;
        int n2 = 0;
        while (n2 < n) {
            DriverSelectViewer.OrderBy ob = orderByArray[n2];
            final Button obScoreButton = new Button(orderGroup, 16);
            obScoreButton.setText(ob.getLabel());
            obScoreButton.setToolTipText(ob.getDescription());
            obScoreButton.setData((Object)ob);
            if (ob == defaultOrderBy) {
                obScoreButton.setSelection(true);
            }
            obScoreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConnectionPageDriver.this.driverSelectViewer.setOrderBy((DriverSelectViewer.OrderBy)obScoreButton.getData());
                }
            });
            ++n2;
        }
        this.createPanelDivider(controlsGroup);
        this.projectSelector = new ProjectSelectorPanel(controlsGroup, NavigatorUtils.getSelectedProject());
        if (this.projectSelector.getSelectedProject() == null) {
            this.setErrorMessage("You need to create a project first");
        }
        this.driverSelectViewer = new DriverSelectViewer(placeholder, (Object)this, this.wizard.getAvailableProvides(), true);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        this.driverSelectViewer.getControl().setLayoutData((Object)gd);
        UIUtils.setHelp((Control)placeholder, (String)"con-wizard-driver");
        UIUtils.asyncExec(() -> {
            boolean bl = this.driverSelectViewer.getControl().setFocus();
        });
    }

    public void createPanelDivider(Composite controlsGroup) {
        Composite filler = UIUtils.createComposite((Composite)controlsGroup, (int)3);
        filler.setLayoutData((Object)new GridData(768));
        new Label(filler, 0).setLayoutData((Object)new GridData(768));
        new Label(filler, 0).setImage(DBeaverIcons.getImage((DBPImage)UIIcon.SEPARATOR_V));
        new Label(filler, 0).setLayoutData((Object)new GridData(768));
    }

    public DBPDriver getSelectedDriver() {
        return this.selectedDriver;
    }

    public void setSelectedDriver(DBPDriver selectedDriver) {
        this.selectedDriver = selectedDriver;
    }

    public DBPProject getConnectionProject() {
        return this.projectSelector.getSelectedProject();
    }

    public DBNBrowseSettings getNavigatorSettings() {
        return this.navigatorPreset.getSettings();
    }

    public boolean canFlipToNextPage() {
        return this.projectSelector.getSelectedProject() != null && this.selectedDriver != null;
    }

    public boolean isPageComplete() {
        return this.canFlipToNextPage();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectedDriver = null;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object selectedObject = ((IStructuredSelection)selection).getFirstElement();
            if (selectedObject instanceof DBPDriver) {
                this.selectedDriver = (DriverDescriptor)selectedObject;
            } else if (!(selectedObject instanceof DataSourceProviderDescriptor)) {
                boolean cfr_ignored_0 = selectedObject instanceof DriverTreeViewer.DriverCategory;
            }
        }
        this.getWizard().getContainer().updateButtons();
    }

    public void doubleClick(DoubleClickEvent event) {
        if (this.selectedDriver != null) {
            this.wizard.getContainer().showPage(this.wizard.getNextPage((IWizardPage)this));
        }
    }

    public void activatePage() {
    }

    public void deactivatePage() {
    }
}

