/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.common;

import java.util.UUID;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetSelection;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetValueController;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectBase;

public class GenerateUUIDHandler
extends NavigatorHandlerObjectBase {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart == null) {
            return null;
        }
        IResultSetController rsc = (IResultSetController)activePart.getAdapter(IResultSetController.class);
        if (rsc != null && UIUtils.hasFocus((Control)rsc.getControl())) {
            IResultSetSelection selection = rsc.getSelection();
            if (selection != null && !selection.isEmpty()) {
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object cell = objectArray[n2];
                    DBDAttributeBinding attr = selection.getElementAttribute(cell);
                    ResultSetRow row = selection.getElementRow(cell);
                    if (row != null && attr != null) {
                        ResultSetValueController valueController = new ResultSetValueController(rsc, attr, row, IValueController.EditType.NONE, null);
                        valueController.getValueHandler();
                        String uuid = GenerateUUIDHandler.generateUUID();
                        valueController.updateValue((Object)uuid, false);
                    }
                    ++n2;
                }
                rsc.redrawData(false, false);
                rsc.updateEditControls();
            }
        } else {
            ISelection selection;
            ITextViewer textViewer = (ITextViewer)activePart.getAdapter(ITextViewer.class);
            if (textViewer != null && (selection = textViewer.getSelectionProvider().getSelection()) instanceof TextSelection) {
                try {
                    int offset = ((TextSelection)selection).getOffset();
                    int length = ((TextSelection)selection).getLength();
                    String uuid = GenerateUUIDHandler.generateUUID();
                    textViewer.getDocument().replace(offset, length, uuid);
                    textViewer.getSelectionProvider().setSelection((ISelection)new TextSelection(offset + uuid.length(), 0));
                }
                catch (BadLocationException e) {
                    DBWorkbench.getPlatformUI().showError("Insert UUID", "Error inserting UUID in text editor", (Throwable)e);
                }
            }
        }
        return null;
    }

    private static String generateUUID() {
        return UUID.randomUUID().toString();
    }
}

