/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.registry;

import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.impl.AbstractContextDescriptor;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.sql.generator.SQLGenerator;
import org.jkiss.utils.CommonUtils;

public class SQLGeneratorDescriptor
extends AbstractContextDescriptor {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.sqlGenerator";
    private final String id;
    private final String label;
    private final String description;
    private final int order;
    private final boolean multiObject;
    private final AbstractDescriptor.ObjectType generatorImplClass;

    SQLGeneratorDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.label = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.generatorImplClass = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.order = CommonUtils.toInt((Object)config.getAttribute("order"));
        this.multiObject = CommonUtils.toBoolean((Object)config.getAttribute("multiObject"));
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isMultiObject() {
        return this.multiObject;
    }

    @NotNull
    public <T> SQLGenerator<T> createGenerator(List<T> objects) throws DBException {
        SQLGenerator instance = (SQLGenerator)((Object)this.generatorImplClass.createInstance(SQLGenerator.class));
        instance.initGenerator(objects);
        return instance;
    }

    public String toString() {
        return this.id;
    }
}

