/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.exporter;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.exporter.StreamExporterAbstract;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DataExporterTXT
extends StreamExporterAbstract {
    private static final String PROP_BATCH_SIZE = "batchSize";
    private static final String PROP_MIN_COLUMN_LENGTH = "minColumnLength";
    private static final String PROP_MAX_COLUMN_LENGTH = "maxColumnLength";
    private static final String PROP_SHOW_NULLS = "showNulls";
    private static final String PROP_DELIM_LEADING = "delimLeading";
    private static final String PROP_DELIM_HEADER = "delimHeader";
    private static final String PROP_DELIM_TRAILING = "delimTrailing";
    private int batchSize = 200;
    private int maxColumnSize = 0;
    private int minColumnSize = 3;
    private boolean showNulls;
    private boolean delimLeading;
    private boolean delimHeader;
    private boolean delimTrailing;
    private Deque<String[]> batchQueue;
    private DBDAttributeBinding[] columns;
    private int[] colWidths;

    @Override
    public void init(IStreamDataExporterSite site) throws DBException {
        super.init(site);
        Map<String, Object> properties = site.getProperties();
        this.batchSize = Math.max(CommonUtils.toInt((Object)properties.get(PROP_BATCH_SIZE), (int)200), 200);
        this.minColumnSize = Math.max(CommonUtils.toInt((Object)properties.get(PROP_MIN_COLUMN_LENGTH), (int)3), 3);
        this.maxColumnSize = Math.max(CommonUtils.toInt((Object)properties.get(PROP_MAX_COLUMN_LENGTH), (int)0), 0);
        this.showNulls = CommonUtils.getBoolean((Object)properties.get(PROP_SHOW_NULLS), (boolean)false);
        this.delimLeading = CommonUtils.getBoolean((Object)properties.get(PROP_DELIM_LEADING), (boolean)true);
        this.delimHeader = CommonUtils.getBoolean((Object)properties.get(PROP_DELIM_HEADER), (boolean)true);
        this.delimTrailing = CommonUtils.getBoolean((Object)properties.get(PROP_DELIM_TRAILING), (boolean)true);
        this.batchQueue = new ArrayDeque<String[]>(this.batchSize);
    }

    @Override
    public void exportHeader(DBCSession session) throws DBException, IOException {
        this.columns = this.getSite().getAttributes();
        this.colWidths = new int[this.columns.length];
        if (this.maxColumnSize > 0) {
            this.maxColumnSize = Math.max(this.maxColumnSize, this.minColumnSize);
            Arrays.fill(this.colWidths, this.maxColumnSize);
        } else {
            Arrays.fill(this.colWidths, this.minColumnSize);
        }
        Object[] header = new String[this.columns.length];
        int index = 0;
        while (index < this.columns.length) {
            header[index] = DataExporterTXT.getAttributeName(this.columns[index]);
            ++index;
        }
        this.appendRow(header);
    }

    @Override
    public void exportRow(DBCSession session, DBCResultSet resultSet, Object[] row) throws DBException, IOException {
        this.appendRow(row);
    }

    @Override
    public void exportFooter(DBRProgressMonitor monitor) throws DBException, IOException {
        this.writeQueue();
    }

    private void appendRow(Object[] row) {
        if (this.batchQueue.size() == this.batchSize) {
            this.writeQueue();
        }
        String[] values = new String[this.columns.length];
        int index = 0;
        while (index < this.columns.length) {
            String cell = this.getCellString(this.columns[index], row[index]);
            if (this.maxColumnSize > 0 && cell.length() > this.maxColumnSize) {
                cell = CommonUtils.truncateString((String)cell, (int)this.maxColumnSize);
            }
            values[index] = cell;
            ++index;
        }
        this.batchQueue.add(values);
    }

    private void writeQueue() {
        if (this.batchQueue.isEmpty()) {
            return;
        }
        if (this.maxColumnSize == 0) {
            for (String[] row : this.batchQueue) {
                int index = 0;
                while (index < this.columns.length) {
                    String cell = row[index];
                    if (cell.length() > this.colWidths[index]) {
                        this.colWidths[index] = cell.length();
                    }
                    ++index;
                }
            }
        }
        while (!this.batchQueue.isEmpty()) {
            if (this.delimHeader) {
                this.delimHeader = false;
                this.writeRow(this.batchQueue.poll(), ' ', false);
                this.writeRow(null, '-', true);
                continue;
            }
            this.writeRow(this.batchQueue.poll(), ' ', true);
        }
        this.getWriter().flush();
    }

    private void writeRow(String[] values, char fill, boolean separator) {
        StringBuilder sb = new StringBuilder();
        if (separator) {
            sb.append(CommonUtils.getLineSeparator());
        }
        int index = 0;
        while (index < this.columns.length) {
            String cell;
            String string = cell = ArrayUtils.isEmpty((Object[])values) ? "" : values[index];
            if (this.delimLeading && index == 0) {
                sb.append('|');
            }
            sb.append(cell);
            int width = cell.length();
            while (width < this.colWidths[index]) {
                sb.append(fill);
                ++width;
            }
            if (this.delimTrailing) {
                sb.append('|');
            }
            ++index;
        }
        this.getWriter().write(sb.toString());
    }

    private String getCellString(DBDAttributeBinding attr, Object value) {
        String displayString = attr.getValueHandler().getValueDisplayString((DBSTypedObject)attr, value, DBDDisplayFormat.EDIT);
        if (this.showNulls && displayString.isEmpty() && DBUtils.isNullValue((Object)value)) {
            return "[NULL]";
        }
        return CommonUtils.getSingleLineString((String)displayString);
    }

    private static String getAttributeName(DBDAttributeBinding attr) {
        if (CommonUtils.isEmpty((String)attr.getLabel())) {
            return attr.getName();
        }
        return attr.getLabel();
    }
}

