/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.task;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObjectLocalized;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.struct.DBSEntityElement;
import org.jkiss.dbeaver.model.task.DBTTaskCategory;
import org.jkiss.dbeaver.model.task.DBTTaskHandler;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.registry.DataSourceBindingDescriptor;
import org.jkiss.dbeaver.registry.task.TaskCategoryDescriptor;
import org.jkiss.utils.CommonUtils;

public class TaskTypeDescriptor
extends DataSourceBindingDescriptor
implements DBTTaskType,
DBPNamedObjectLocalized {
    private final TaskCategoryDescriptor category;
    private final IConfigurationElement config;
    private final AbstractDescriptor.ObjectType handlerImplType;
    private final DBPPropertyDescriptor[] properties;
    private Boolean matchesEntityElements;

    TaskTypeDescriptor(TaskCategoryDescriptor category, IConfigurationElement config) {
        super(config);
        this.category = category;
        this.category.addTask(this);
        this.config = config;
        this.handlerImplType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config, "handler");
        this.properties = PropertyDescriptor.extractPropertyGroups((IConfigurationElement)config);
    }

    @NotNull
    public String getId() {
        return this.config.getAttribute("id");
    }

    @NotNull
    public String getName() {
        return this.config.getAttribute("name");
    }

    public String getLocalizedName(String locale) {
        return this.config.getAttribute("label", locale);
    }

    public String getDescription() {
        return this.config.getAttribute("description");
    }

    public DBPImage getIcon() {
        return this.iconToImage(this.config.getAttribute("icon"));
    }

    @NotNull
    public DBTTaskCategory getCategory() {
        return this.category;
    }

    @NotNull
    public DBPPropertyDescriptor[] getConfigurationProperties() {
        return this.properties;
    }

    @NotNull
    public Class<?>[] getInputTypes() {
        ArrayList<Class> objClasses = new ArrayList<Class>();
        AbstractDescriptor.ObjectType[] objectTypeArray = this.getObjectTypes();
        int n = objectTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractDescriptor.ObjectType objectType = objectTypeArray[n2];
            Class aClass = objectType.getObjectClass();
            if (aClass != null) {
                objClasses.add(aClass);
            }
            ++n2;
        }
        return objClasses.toArray(new Class[0]);
    }

    public boolean supportsVariables() {
        return CommonUtils.toBoolean((Object)this.config.getAttribute("supportsVariables"));
    }

    @NotNull
    public DBTTaskHandler createHandler() throws DBException {
        return (DBTTaskHandler)this.handlerImplType.createInstance(DBTTaskHandler.class);
    }

    public Class<? extends DBTTaskHandler> getHandlerClass() {
        return this.handlerImplType.getObjectClass(DBTTaskHandler.class);
    }

    public boolean isObjectApplicable(Object object) {
        return object instanceof DBPObject && this.appliesTo((DBPObject)object);
    }

    public synchronized boolean matchesEntityElements() {
        if (this.matchesEntityElements != null) {
            return this.matchesEntityElements;
        }
        AbstractDescriptor.ObjectType[] objectTypeArray = this.getObjectTypes();
        int n = objectTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractDescriptor.ObjectType ot = objectTypeArray[n2];
            if (DBSEntityElement.class.isAssignableFrom(ot.getObjectClass())) {
                this.matchesEntityElements = true;
                break;
            }
            ++n2;
        }
        if (this.matchesEntityElements == null) {
            this.matchesEntityElements = false;
        }
        return this.matchesEntityElements;
    }

    public String toString() {
        return this.getId();
    }
}

