/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mysql.MySQLServerHome;
import org.jkiss.dbeaver.ext.mysql.MySQLUtils;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocationManager;
import org.jkiss.dbeaver.model.connection.NativeClientLocationUtils;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSourceProvider;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.OSDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class MySQLDataSourceProvider
extends JDBCDataSourceProvider
implements DBPNativeClientLocationManager {
    private static final Log log = Log.getLog(MySQLDataSourceProvider.class);
    private static final String REGISTRY_ROOT_MYSQL_32 = "SOFTWARE\\MySQL AB";
    private static final String REGISTRY_ROOT_MYSQL_64 = "SOFTWARE\\Wow6432Node\\MYSQL AB";
    private static final String REGISTRY_ROOT_MARIADB = "SOFTWARE\\Monty Program AB";
    private static final String SERER_LOCATION_KEY = "Location";
    private static final String INSTALLDIR_KEY = "INSTALLDIR";
    private static Map<String, MySQLServerHome> localServers = null;
    private static Map<String, String> connectionsProps = new HashMap<String, String>();

    static {
        connectionsProps.put("characterEncoding", GeneralUtils.UTF8_ENCODING);
        connectionsProps.put("tinyInt1isBit", "false");
        connectionsProps.put("interactiveClient", "true");
    }

    public static Map<String, String> getConnectionsProps() {
        return connectionsProps;
    }

    protected String getConnectionPropertyDefaultValue(String name, String value) {
        String ovrValue = connectionsProps.get(name);
        return ovrValue != null ? ovrValue : super.getConnectionPropertyDefaultValue(name, value);
    }

    public long getFeatures() {
        return 1L;
    }

    public String getConnectionURL(DBPDriver driver, DBPConnectionConfiguration connectionInfo) {
        StringBuilder url = new StringBuilder();
        url.append("jdbc:mysql://").append(connectionInfo.getHostName());
        if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
            url.append(":").append(connectionInfo.getHostPort());
        }
        url.append("/");
        if (!CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
            url.append(connectionInfo.getDatabaseName());
        }
        return url.toString();
    }

    @NotNull
    public DBPDataSource openDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        return new MySQLDataSource(monitor, container);
    }

    public List<DBPNativeClientLocation> findLocalClientLocations() {
        MySQLDataSourceProvider.findLocalClients();
        return new ArrayList<MySQLServerHome>(localServers.values());
    }

    public DBPNativeClientLocation getDefaultLocalClientLocation() {
        MySQLDataSourceProvider.findLocalClients();
        return localServers.isEmpty() ? null : (DBPNativeClientLocation)localServers.values().iterator().next();
    }

    public String getProductName(DBPNativeClientLocation location) {
        return "MySQL/MariaDB";
    }

    public String getProductVersion(DBPNativeClientLocation location) {
        return MySQLDataSourceProvider.getFullServerVersion(location.getPath());
    }

    public static MySQLServerHome getServerHome(String homeId) {
        MySQLDataSourceProvider.findLocalClients();
        MySQLServerHome home = localServers.get(homeId);
        return home == null ? new MySQLServerHome(homeId, homeId) : home;
    }

    public static synchronized void findLocalClients() {
        block15: {
            OSDescriptor localSystem;
            Object homeId;
            if (localServers != null) {
                return;
            }
            localServers = new LinkedHashMap<String, MySQLServerHome>();
            String path = System.getenv("PATH");
            if (path != null && GeneralUtils.isWindows()) {
                String[] stringArray = path.split(System.getProperty("path.separator"));
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File binFolder;
                    String token = stringArray[n2];
                    File mysqlFile = new File(token = CommonUtils.removeTrailingSlash((String)token), MySQLUtils.getMySQLConsoleBinaryName());
                    if (mysqlFile.exists() && (binFolder = mysqlFile.getAbsoluteFile().getParentFile()).getName().equalsIgnoreCase("bin")) {
                        homeId = CommonUtils.removeTrailingSlash((String)binFolder.getParentFile().getAbsolutePath());
                        localServers.put((String)homeId, new MySQLServerHome((String)homeId, null));
                    }
                    ++n2;
                }
            }
            if ((localSystem = DBWorkbench.getPlatform().getLocalSystem()).isWindows()) {
                try {
                    String[] homeKeys;
                    String[] homeKeys2;
                    String registryRoot;
                    String string = registryRoot = localSystem.is64() ? REGISTRY_ROOT_MYSQL_64 : REGISTRY_ROOT_MYSQL_32;
                    if (Advapi32Util.registryKeyExists((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)registryRoot) && (homeKeys2 = Advapi32Util.registryGetKeys((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)registryRoot)) != null) {
                        homeId = homeKeys2;
                        int binFolder = homeKeys2.length;
                        int mysqlFile = 0;
                        while (mysqlFile < binFolder) {
                            String homeKey = homeId[mysqlFile];
                            TreeMap valuesMap = Advapi32Util.registryGetValues((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)(String.valueOf(registryRoot) + "\\" + homeKey));
                            for (Object key : valuesMap.keySet()) {
                                String serverPath;
                                if (!SERER_LOCATION_KEY.equalsIgnoreCase((String)key) || !new File(serverPath = CommonUtils.removeTrailingSlash((String)CommonUtils.toString(valuesMap.get(key))), "bin").exists()) continue;
                                localServers.put(serverPath, new MySQLServerHome(serverPath, homeKey));
                            }
                            ++mysqlFile;
                        }
                    }
                    if (!Advapi32Util.registryKeyExists((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)REGISTRY_ROOT_MARIADB) || (homeKeys = Advapi32Util.registryGetKeys((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)REGISTRY_ROOT_MARIADB)) == null) break block15;
                    String[] binFolder = homeKeys;
                    int mysqlFile = homeKeys.length;
                    int n = 0;
                    while (n < mysqlFile) {
                        String homeKey = binFolder[n];
                        TreeMap valuesMap = Advapi32Util.registryGetValues((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)("SOFTWARE\\Monty Program AB\\" + homeKey));
                        for (String key : valuesMap.keySet()) {
                            String serverPath;
                            if (!INSTALLDIR_KEY.equalsIgnoreCase(key) || !new File(serverPath = CommonUtils.removeTrailingSlash((String)CommonUtils.toString(valuesMap.get(key))), "bin").exists()) continue;
                            localServers.put(serverPath, new MySQLServerHome(serverPath, homeKey));
                        }
                        ++n;
                    }
                }
                catch (Throwable e) {
                    log.warn((Object)"Error reading Windows registry", e);
                }
            } else if (GeneralUtils.isMacOS()) {
                ArrayList mysqlDirs = new ArrayList();
                Collections.addAll(mysqlDirs, NativeClientLocationUtils.getSubdirectoriesWithNamesStartingWith((String)"mysql", (File[])new File[]{new File("/usr/local/")}));
                Collections.addAll(mysqlDirs, NativeClientLocationUtils.getSubdirectories((File[])NativeClientLocationUtils.getSubdirectoriesWithNamesStartingWith((String)"mysql", (File[])new File[]{new File("/usr/local/Cellar/")})));
                Collections.addAll(mysqlDirs, NativeClientLocationUtils.getSubdirectories((File[])NativeClientLocationUtils.getSubdirectoriesWithNamesStartingWith((String)"mariadb", (File[])new File[]{new File("/usr/local/Cellar/")})));
                for (File dir : mysqlDirs) {
                    String canonicalPath;
                    String version;
                    File bin = new File(dir, "bin");
                    File binary = new File(bin, MySQLUtils.getMySQLConsoleBinaryName());
                    if (!bin.exists() || !bin.isDirectory() || !binary.exists() || !binary.canExecute() || (version = MySQLDataSourceProvider.getFullServerVersion(dir)) == null || (canonicalPath = NativeClientLocationUtils.getCanonicalPath((File)dir)).isEmpty()) continue;
                    MySQLServerHome home = new MySQLServerHome(canonicalPath, "MySQL " + version);
                    localServers.put(canonicalPath, home);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String getFullServerVersion(File path) {
        File binPath = path;
        File binSubfolder = new File(binPath, "bin");
        if (binSubfolder.exists()) {
            binPath = binSubfolder;
        }
        String cmd = new File(binPath, MySQLUtils.getMySQLConsoleBinaryName()).getAbsolutePath();
        try {
            Process p = GeneralUtils.isWindows() ? Runtime.getRuntime().exec(new String[]{cmd, "-V"}) : Runtime.getRuntime().exec(new String[]{cmd, "--version"});
            try {
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                try {
                    String line;
                    int pos;
                    do {
                        if ((line = input.readLine()) != null) continue;
                        return null;
                    } while ((pos = line.indexOf("Distrib ")) == -1);
                    int pos2 = line.indexOf(",", pos += 8);
                    String string = line.substring(pos, pos2);
                    return string;
                }
                finally {
                    IOUtils.close((Closeable)input);
                }
            }
            finally {
                p.destroy();
            }
        }
        catch (Exception ex) {
            log.warn((Object)("Error reading MySQL server version from " + cmd), (Throwable)ex);
        }
        return null;
    }
}

