/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.Arrays;
import java.util.Map;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObjectPrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeGrant;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeOwner;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedureKind;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRolePrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class PostgreCommandGrantPrivilege
extends DBECommandAbstract<PostgrePrivilegeOwner> {
    private boolean grant;
    private PostgrePrivilege permission;
    private PostgrePrivilegeType[] privilege;
    private DBSObject privilegeOwner;

    public PostgreCommandGrantPrivilege(PostgrePrivilegeOwner user, boolean grant, DBSObject privilegeOwner, PostgrePrivilege permission, PostgrePrivilegeType[] privilege) {
        super((DBPObject)user, grant ? "Grant" : "Revoke");
        this.grant = grant;
        this.privilegeOwner = privilegeOwner;
        this.permission = permission;
        this.privilege = privilege;
    }

    public void updateModel() {
    }

    public DBEPersistAction[] getPersistActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, Map<String, Object> options) {
        String objectType;
        String objectName;
        String roleName;
        boolean withGrantOption = false;
        StringBuilder privName = new StringBuilder();
        if (this.privilege == null) {
            privName = new StringBuilder(PostgrePrivilegeType.ALL.name());
        } else {
            PostgrePrivilegeType[] postgrePrivilegeTypeArray = this.privilege;
            int n = this.privilege.length;
            int n2 = 0;
            while (n2 < n) {
                PostgrePrivilegeType pn = postgrePrivilegeTypeArray[n2];
                if (privName.length() > 0) {
                    privName.append(", ");
                }
                privName.append(pn.name());
                if ((this.permission.getPermission(pn) & 2) != 0) {
                    withGrantOption = true;
                }
                ++n2;
            }
        }
        PostgrePrivilegeOwner object = (PostgrePrivilegeOwner)this.getObject();
        if (object instanceof PostgreRole) {
            roleName = DBUtils.getQuotedIdentifier((DBSObject)object);
            objectName = this.privilegeOwner instanceof PostgreProcedure ? ((PostgreProcedure)this.privilegeOwner).getFullQualifiedSignature() : ((PostgreRolePrivilege)this.permission).getFullObjectName();
        } else {
            PostgreObjectPrivilege permission = (PostgreObjectPrivilege)this.permission;
            roleName = permission.getGrantee() == null ? null : DBUtils.getQuotedIdentifier((DBPDataSource)object.getDataSource(), (String)permission.getGrantee());
            objectName = PostgreUtils.getObjectUniqueName(object);
        }
        if (roleName == null) {
            return new DBEPersistAction[0];
        }
        if (this.permission instanceof PostgreRolePrivilege) {
            if (this.privilegeOwner instanceof PostgreProcedure && ((PostgreProcedure)this.privilegeOwner).getKind() == PostgreProcedureKind.p) {
                ((PostgreRolePrivilege)this.permission).setKind(PostgrePrivilegeGrant.Kind.PROCEDURE);
            }
            objectType = ((PostgreRolePrivilege)this.permission).getKind().name();
        } else {
            objectType = PostgreUtils.getObjectTypeName(object);
        }
        String grantedCols = "";
        String grantedTypedObject = "";
        if (object instanceof PostgreTableColumn) {
            grantedCols = "(" + DBUtils.getQuotedIdentifier((DBSObject)object) + ")";
            grantedTypedObject = ((PostgreTableBase)((PostgreTableColumn)object).getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL);
        } else {
            grantedTypedObject = String.valueOf(objectType) + " " + objectName;
        }
        String grantScript = String.valueOf(this.grant ? "GRANT " : "REVOKE ") + privName + grantedCols + " ON " + grantedTypedObject + (this.grant ? " TO " : " FROM ") + roleName;
        if (this.grant && withGrantOption) {
            grantScript = String.valueOf(grantScript) + " WITH GRANT OPTION";
        }
        return new DBEPersistAction[]{new SQLDatabasePersistAction("Grant", grantScript)};
    }

    public DBECommand<?> merge(DBECommand<?> prevCommand, Map<Object, Object> userParams) {
        if (prevCommand instanceof PostgreCommandGrantPrivilege) {
            PostgreCommandGrantPrivilege prevGrant = (PostgreCommandGrantPrivilege)prevCommand;
            if (prevGrant.permission == this.permission && Arrays.equals((Object[])prevGrant.privilege, (Object[])this.privilege)) {
                if (prevGrant.grant == this.grant) {
                    return prevCommand;
                }
                return null;
            }
        }
        return super.merge(prevCommand, userParams);
    }
}

