/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.core.internal.runtime.Activator;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.dbeaver.ui.ICompositeDialogPage;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class WizardPrefPage
extends WizardPage
implements ICompositeDialogPage {
    private final IPreferencePage preferencePage;
    private final List<WizardPrefPage> subPages = new ArrayList<WizardPrefPage>();

    public WizardPrefPage(IPreferencePage preferencePage, String title, String description) {
        super(preferencePage.getClass().getName());
        this.preferencePage = preferencePage;
        this.setTitle(title);
        this.setDescription(description);
    }

    public IPreferencePage getPreferencePage() {
        return this.preferencePage;
    }

    public boolean isPageComplete() {
        return this.getControl() == null || this.preferencePage.isValid();
    }

    public void createControl(Composite parent) {
        if (this.preferencePage instanceof AbstractPrefPage) {
            ((AbstractPrefPage)this.preferencePage).disableButtons();
        }
        this.preferencePage.createControl(parent);
    }

    public void dispose() {
        this.preferencePage.dispose();
        super.dispose();
    }

    public Control getControl() {
        return this.preferencePage.getControl();
    }

    public String getDescription() {
        if (!CommonUtils.isEmpty((String)this.preferencePage.getDescription())) {
            return this.preferencePage.getDescription();
        }
        return super.getDescription();
    }

    public String getErrorMessage() {
        return this.preferencePage.getErrorMessage();
    }

    public Image getImage() {
        return this.preferencePage.getImage();
    }

    public String getMessage() {
        return this.preferencePage.getMessage();
    }

    public String getTitle() {
        if (!CommonUtils.isEmpty((String)this.preferencePage.getTitle())) {
            return this.preferencePage.getTitle();
        }
        return super.getTitle();
    }

    public void performHelp() {
        this.preferencePage.performHelp();
    }

    public void setVisible(boolean visible) {
        this.preferencePage.setVisible(visible);
    }

    public void performFinish() {
        this.preferencePage.performOk();
    }

    public void performCancel() {
        this.preferencePage.performCancel();
    }

    public WizardPrefPage[] getSubPages(boolean extrasOnly, boolean forceCreate) {
        if (this.subPages.isEmpty()) {
            return null;
        }
        return this.subPages.toArray(new WizardPrefPage[0]);
    }

    public WizardPrefPage addSubPage(IPreferencePage page, String title, String description) {
        WizardPrefPage wizardPrefPage = new WizardPrefPage(page, title, description);
        this.subPages.add(wizardPrefPage);
        if (this.preferencePage instanceof IWorkbenchPropertyPage && page instanceof IWorkbenchPropertyPage) {
            ((IWorkbenchPropertyPage)page).setElement(((IWorkbenchPropertyPage)this.preferencePage).getElement());
        }
        return wizardPrefPage;
    }

    public WizardPrefPage addSubPage(String pageId, IPreferencePage page) {
        return this.addSubPage(pageId, page.getClass(), page);
    }

    public WizardPrefPage addSubPage(String pageId, Class<?> ownerBundleClass, IPreferencePage page) {
        String pageName = pageId;
        String pageDescription = pageId;
        try {
            Bundle pageBundle = FrameworkUtil.getBundle(ownerBundleClass);
            ResourceBundle resourceBundle = Activator.getDefault().getLocalization(pageBundle, Locale.getDefault().getLanguage());
            try {
                pageName = resourceBundle.getString("page." + pageId + ".name");
            }
            catch (Exception exception) {
                pageName = pageId;
            }
            try {
                pageDescription = resourceBundle.getString("page." + pageId + ".description");
            }
            catch (Exception exception) {
                pageDescription = pageName;
            }
        }
        catch (Exception exception) {}
        WizardPrefPage wizardPrefPage = new WizardPrefPage(page, pageName, pageDescription);
        this.subPages.add(wizardPrefPage);
        if (this.preferencePage instanceof IWorkbenchPropertyPage && page instanceof IWorkbenchPropertyPage) {
            ((IWorkbenchPropertyPage)page).setElement(((IWorkbenchPropertyPage)this.preferencePage).getElement());
        }
        return wizardPrefPage;
    }
}

