/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mssql.SQLServerConstants;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataType;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDatabase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObject;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObjectClass;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObjectType;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerProcedure;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerProcedureParameter;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSequence;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSynonym;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTable;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableBase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableColumn;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableForeignKey;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableForeignKeyColumn;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableIndex;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableIndexColumn;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableTrigger;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableType;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableUniqueKey;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerView;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObjectStatisticsCollector;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCCompositeCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectLookupCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructLookupCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSObjectWithScript;
import org.jkiss.dbeaver.model.struct.DBStructUtils;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.utils.CommonUtils;

public class SQLServerSchema
implements DBSSchema,
DBPSaveableObject,
DBPQualifiedObject,
DBPRefreshableObject,
DBPSystemObject,
SQLServerObject,
DBSObjectWithScript,
DBPObjectStatisticsCollector {
    private static final Log log = Log.getLog(SQLServerSchema.class);
    private final SQLServerDatabase database;
    private boolean persisted;
    private final long schemaId;
    private String name;
    private String description;
    private TableCache tableCache = new TableCache();
    private IndexCache indexCache = new IndexCache(this.tableCache);
    private UniqueConstraintCache uniqueConstraintCache = new UniqueConstraintCache(this.tableCache);
    private ForeignKeyCache foreignKeyCache = new ForeignKeyCache();
    private SequenceCache sequenceCache = new SequenceCache();
    private SynonymCache synonymCache = new SynonymCache();
    private ProcedureCache procedureCache = new ProcedureCache();
    private TriggerCache triggerCache = new TriggerCache();
    private volatile boolean hasTableStatistics;

    SQLServerSchema(SQLServerDatabase database, JDBCResultSet resultSet) {
        this.database = database;
        this.name = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"name");
        this.schemaId = this.getDataSource().isServerVersionAtLeast(9, 0) ? JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"schema_id") : JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"uid");
        this.description = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"description");
        this.persisted = true;
    }

    public TableCache getTableCache() {
        return this.tableCache;
    }

    public IndexCache getIndexCache() {
        return this.indexCache;
    }

    public UniqueConstraintCache getUniqueConstraintCache() {
        return this.uniqueConstraintCache;
    }

    public ForeignKeyCache getForeignKeyCache() {
        return this.foreignKeyCache;
    }

    public ProcedureCache getProcedureCache() {
        return this.procedureCache;
    }

    public TriggerCache getTriggerCache() {
        return this.triggerCache;
    }

    @Override
    @NotNull
    public SQLServerDataSource getDataSource() {
        return this.database.getDataSource();
    }

    @Property(viewable=false, editable=true, order=10)
    public SQLServerDatabase getDatabase() {
        return this.database;
    }

    @Property(viewable=true, editable=true, order=1)
    public String getName() {
        return this.name;
    }

    @Property(viewable=false, editable=false, order=5)
    public long getObjectId() {
        return this.schemaId;
    }

    @Property(viewable=true, editable=true, updatable=true, multiline=true, order=100)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public DBSObject getParentObject() {
        return this.database;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public boolean isSystem() {
        return this.name.equalsIgnoreCase("sys") || this.name.equalsIgnoreCase("information_schema");
    }

    public String getFullyQualifiedName(DBPEvaluationContext context) {
        if (!SQLServerUtils.supportsCrossDatabaseQueries(this.getDataSource())) {
            return DBUtils.getQuotedIdentifier((DBSObject)this);
        }
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getDatabase(), this});
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.tableCache.clearCache();
        this.indexCache.clearCache();
        this.uniqueConstraintCache.clearCache();
        this.foreignKeyCache.clearCache();
        this.sequenceCache.clearCache();
        this.synonymCache.clearCache();
        this.procedureCache.clearCache();
        this.database.refreshDataTypes();
        this.hasTableStatistics = false;
        return this;
    }

    @Association
    public List<SQLServerDataType> getDataTypes(DBRProgressMonitor monitor) throws DBException {
        if ("sys".equals(this.getName())) {
            return this.getDataSource().getLocalDataTypes();
        }
        ArrayList<SQLServerDataType> result = new ArrayList<SQLServerDataType>();
        for (SQLServerDataType dt : this.database.getDataTypes(monitor)) {
            if (dt.getSchemaId() != this.getObjectId()) continue;
            result.add(dt);
        }
        return result;
    }

    @Association
    public Collection<SQLServerTable> getTables(DBRProgressMonitor monitor) throws DBException {
        return this.tableCache.getTypedObjects(monitor, this, SQLServerTable.class);
    }

    public SQLServerTable getTable(DBRProgressMonitor monitor, long tableId) throws DBException {
        for (SQLServerTableBase table : this.tableCache.getAllObjects(monitor, this)) {
            if (table.getObjectId() != tableId || !(table instanceof SQLServerTable)) continue;
            return (SQLServerTable)table;
        }
        log.debug((Object)("Table '" + tableId + "' not found in schema " + this.getName()));
        return null;
    }

    public SQLServerTableBase getTable(DBRProgressMonitor monitor, String name) throws DBException {
        return (SQLServerTableBase)this.tableCache.getObject(monitor, this, name);
    }

    @Association
    public Collection<SQLServerView> getViews(DBRProgressMonitor monitor) throws DBException {
        return this.tableCache.getTypedObjects(monitor, this, SQLServerView.class);
    }

    @Association
    public Collection<SQLServerTableType> getTablesType(DBRProgressMonitor monitor) throws DBException {
        return this.tableCache.getTypedObjects(monitor, this, SQLServerTableType.class);
    }

    public SQLServerTableType getTableType(DBRProgressMonitor monitor, long tableId) throws DBException {
        for (SQLServerTableBase table : this.tableCache.getAllObjects(monitor, this)) {
            if (table.getObjectId() != tableId || !(table instanceof SQLServerTableType)) continue;
            return (SQLServerTableType)table;
        }
        log.debug((Object)("Table type '" + tableId + "' not found in schema " + this.getName()));
        return null;
    }

    public List<SQLServerObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        ArrayList<SQLServerObject> result = new ArrayList<SQLServerObject>();
        result.addAll(this.tableCache.getAllObjects(monitor, this));
        result.addAll(this.synonymCache.getAllObjects(monitor, this));
        return result;
    }

    public SQLServerTableBase getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return (SQLServerTableBase)this.tableCache.getObject(monitor, this, childName);
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return SQLServerTable.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        if ((scope & 1) == 1) {
            this.tableCache.getAllObjects(monitor, this);
            this.synonymCache.getAllObjects(monitor, this);
        }
        if ((scope & 2) == 2) {
            this.tableCache.getChildren(monitor, this, null);
        }
        if ((scope & 4) == 4) {
            this.indexCache.getAllObjects(monitor, this);
            this.uniqueConstraintCache.getAllObjects(monitor, this);
            this.foreignKeyCache.getAllObjects(monitor, this);
        }
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        StringBuilder sql = new StringBuilder();
        sql.append("-- DROP SCHEMA ").append(DBUtils.getQuotedIdentifier((DBSObject)this)).append(";\n\n");
        sql.append("CREATE SCHEMA ").append(DBUtils.getQuotedIdentifier((DBSObject)this));
        sql.append(";\n");
        if (!monitor.isCanceled()) {
            List tablesOrViews = this.tableCache.getAllObjects(monitor, this);
            DBStructUtils.generateTableListDDL((DBRProgressMonitor)monitor, (StringBuilder)sql, (Collection)tablesOrViews, options, (boolean)false);
            monitor.done();
        }
        return sql.toString();
    }

    public void setObjectDefinitionText(String source) {
        throw new IllegalStateException("Can't change schema definition");
    }

    public boolean isStatisticsCollected() {
        return this.hasTableStatistics;
    }

    void resetTableStatistics() {
        this.hasTableStatistics = false;
    }

    public void collectObjectStatistics(DBRProgressMonitor monitor, boolean totalSizeOnly, boolean forceRefresh) throws DBException {
        if (this.hasTableStatistics && !forceRefresh) {
            return;
        }
        try {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load table statistics");){
                    Throwable throwable2 = null;
                    Object var8_12 = null;
                    try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT t.name, p.rows, SUM(a.total_pages) * 8 AS totalSize, SUM(a.used_pages) * 8 AS usedSize\nFROM " + SQLServerUtils.getSystemTableName(this.getDatabase(), "tables") + " t\n" + "INNER JOIN " + SQLServerUtils.getSystemTableName(this.getDatabase(), "indexes") + " i ON t.OBJECT_ID = i.object_id\n" + "INNER JOIN " + SQLServerUtils.getSystemTableName(this.getDatabase(), "partitions") + " p ON i.object_id = p.OBJECT_ID AND i.index_id = p.index_id\n" + "INNER JOIN " + SQLServerUtils.getSystemTableName(this.getDatabase(), "allocation_units") + " a ON p.partition_id = a.container_id\n" + "LEFT OUTER JOIN " + SQLServerUtils.getSystemTableName(this.getDatabase(), "schemas") + " s ON t.schema_id = s.schema_id\n" + "WHERE t.schema_id = ?\n" + "GROUP BY t.name, p.rows");){
                        dbStat.setLong(1, this.getObjectId());
                        Throwable throwable3 = null;
                        Iterator iterator = null;
                        try (JDBCResultSet dbResult = dbStat.executeQuery();){
                            while (dbResult.next()) {
                                String tableName = dbResult.getString("name");
                                SQLServerTableBase table = this.getTable(monitor, tableName);
                                if (!(table instanceof SQLServerTable)) continue;
                                ((SQLServerTable)table).fetchTableStats(dbResult);
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                        for (SQLServerTableBase table : this.tableCache.getCachedObjects()) {
                            if (!(table instanceof SQLServerTable) || ((SQLServerTable)table).hasStatistics()) continue;
                            ((SQLServerTable)table).setDefaultTableStats();
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBCException("Error reading table statistics", (Throwable)e);
            }
        }
        finally {
            this.hasTableStatistics = true;
        }
    }

    @Association
    public List<SQLServerTableIndex> getIndexes(DBRProgressMonitor monitor) throws DBException {
        ArrayList<SQLServerTableIndex> allIndexes = new ArrayList<SQLServerTableIndex>();
        for (SQLServerTableBase sQLServerTableBase : this.getTables(monitor)) {
            allIndexes.addAll(CommonUtils.safeCollection(sQLServerTableBase.getIndexes(monitor)));
        }
        return allIndexes;
    }

    @Association
    public Collection<SQLServerSequence> getSequences(DBRProgressMonitor monitor) throws DBException {
        return this.sequenceCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<SQLServerSynonym> getSynonyms(DBRProgressMonitor monitor) throws DBException {
        return this.synonymCache.getAllObjects(monitor, this);
    }

    public SQLServerSynonym getSynonym(DBRProgressMonitor monitor, String name) throws DBException {
        return (SQLServerSynonym)this.synonymCache.getObject(monitor, this, name);
    }

    @Association
    public Collection<SQLServerProcedure> getProcedures(DBRProgressMonitor monitor) throws DBException {
        return this.procedureCache.getAllObjects(monitor, this);
    }

    public SQLServerProcedure getProcedure(DBRProgressMonitor monitor, String name) throws DBException {
        return (SQLServerProcedure)this.procedureCache.getObject(monitor, this, name);
    }

    @Association
    public Collection<SQLServerTableTrigger> getTriggers(DBRProgressMonitor monitor) throws DBException {
        return this.triggerCache.getAllObjects(monitor, this);
    }

    public String toString() {
        return this.getFullyQualifiedName(DBPEvaluationContext.UI);
    }

    class ForeignKeyCache
    extends JDBCCompositeCache<SQLServerSchema, SQLServerTableBase, SQLServerTableForeignKey, SQLServerTableForeignKeyColumn> {
        ForeignKeyCache() {
            super((JDBCStructCache)SQLServerSchema.this.tableCache, SQLServerTableBase.class, (Object)"table_name", (Object)"name");
        }

        protected void loadObjects(DBRProgressMonitor monitor, SQLServerSchema schema, SQLServerTableBase forParent) throws DBException {
            if (forParent == null) {
                SQLServerSchema.this.indexCache.getAllObjects(monitor, schema);
            }
            super.loadObjects(monitor, (DBSObject)schema, (DBSObject)forParent);
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(JDBCSession session, SQLServerSchema owner, SQLServerTableBase forTable) throws SQLException {
            StringBuilder sql = new StringBuilder(500);
            sql.append("SELECT t.name as table_name,fk.name,fk.key_index_id,fk.is_disabled,fk.delete_referential_action,fk.update_referential_action,fkc.*,tr.schema_id referenced_schema_id\nFROM ").append(SQLServerUtils.getSystemTableName(owner.getDatabase(), "tables")).append(" t,").append(SQLServerUtils.getSystemTableName(owner.getDatabase(), "foreign_keys")).append(" fk,").append(SQLServerUtils.getSystemTableName(owner.getDatabase(), "foreign_key_columns")).append(" fkc, ").append(SQLServerUtils.getSystemTableName(owner.getDatabase(), "tables")).append(" tr").append("\nWHERE t.object_id = fk.parent_object_id AND fk.object_id=fkc.constraint_object_id AND tr.object_id=fk.referenced_object_id");
            if (forTable != null) {
                sql.append(" AND t.object_id=?");
            } else {
                sql.append(" AND t.schema_id=?");
            }
            sql.append("\nORDER BY fkc.constraint_object_id, fkc.constraint_column_id");
            JDBCPreparedStatement dbStat = session.prepareStatement(sql.toString());
            if (forTable != null) {
                dbStat.setLong(1, forTable.getObjectId());
            } else {
                dbStat.setLong(1, owner.getObjectId());
            }
            return dbStat;
        }

        @Nullable
        protected SQLServerTableForeignKey fetchObject(JDBCSession session, SQLServerSchema owner, SQLServerTableBase parent, String indexName, JDBCResultSet dbResult) throws SQLException, DBException {
            long refSchemaId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"referenced_schema_id");
            DBRProgressMonitor monitor = session.getProgressMonitor();
            SQLServerSchema refSchema = owner.getDatabase().getSchema(monitor, refSchemaId);
            if (refSchema == null) {
                log.debug((Object)("Ref schema " + refSchemaId + " not found"));
                return null;
            }
            long refTableId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"referenced_object_id");
            SQLServerTable refTable = refSchema.getTable(monitor, refTableId);
            if (refTable == null) {
                log.debug((Object)("Ref table " + refTableId + " not found in schema " + refSchema.getName()));
                return null;
            }
            long refIndexId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"key_index_id");
            SQLServerTableIndex index = refTable.getIndex(monitor, refIndexId);
            if (index == null) {
                log.debug((Object)("Ref index " + refIndexId + " not found in table " + refTable.getFullyQualifiedName(DBPEvaluationContext.UI)));
                return null;
            }
            Object refConstraint = index;
            for (SQLServerTableUniqueKey refPK : refTable.getConstraints(monitor)) {
                if (refPK.getIndex() != index) continue;
                refConstraint = refPK;
                break;
            }
            String fkName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"name");
            DBSForeignKeyModifyRule deleteRule = SQLServerUtils.getForeignKeyModifyRule(JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"delete_referential_action"));
            DBSForeignKeyModifyRule updateRule = SQLServerUtils.getForeignKeyModifyRule(JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"update_referential_action"));
            return new SQLServerTableForeignKey((SQLServerTable)parent, fkName, null, (DBSEntityConstraint)refConstraint, deleteRule, updateRule, true);
        }

        @Nullable
        protected SQLServerTableForeignKeyColumn[] fetchObjectRow(JDBCSession session, SQLServerTableBase parent, SQLServerTableForeignKey object, JDBCResultSet dbResult) throws SQLException, DBException {
            DBRProgressMonitor monitor = session.getProgressMonitor();
            int columnId = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"constraint_column_id");
            SQLServerTableBase fkTable = (SQLServerTableBase)object.getParentObject();
            SQLServerTableBase refTable = (SQLServerTableBase)object.getReferencedTable();
            SQLServerTableColumn fkColumn = fkTable.getAttribute(monitor, JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"parent_column_id"));
            SQLServerTableColumn refColumn = refTable.getAttribute(monitor, JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"referenced_column_id"));
            if (fkColumn == null || refColumn == null) {
                return null;
            }
            return new SQLServerTableForeignKeyColumn[]{new SQLServerTableForeignKeyColumn(object, fkColumn, columnId, refColumn)};
        }

        protected void cacheChildren(DBRProgressMonitor monitor, SQLServerTableForeignKey foreignKey, List<SQLServerTableForeignKeyColumn> rows) {
            foreignKey.setColumns(rows);
        }
    }

    static class IndexCache
    extends JDBCCompositeCache<SQLServerSchema, SQLServerTableBase, SQLServerTableIndex, SQLServerTableIndexColumn> {
        IndexCache(TableCache tableCache) {
            super((JDBCStructCache)tableCache, SQLServerTableBase.class, (Object)"table_name", (Object)"name");
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(JDBCSession session, SQLServerSchema owner, SQLServerTableBase forTable) throws SQLException {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT i.*,ic.index_column_id,ic.column_id,ic.key_ordinal,ic.is_descending_key,t.name as table_name\nFROM ").append(SQLServerUtils.getSystemTableName(owner.getDatabase(), "indexes")).append(" i, ").append(SQLServerUtils.getSystemTableName(owner.getDatabase(), "index_columns")).append(" ic, ").append(SQLServerUtils.getSystemTableName(owner.getDatabase(), "all_objects")).append(" t").append("\n");
            sql.append("WHERE t.object_id = i.object_id AND ic.object_id=i.object_id AND ic.index_id=i.index_id");
            if (forTable != null) {
                sql.append(" AND t.object_id = ?");
            } else {
                sql.append(" AND t.schema_id = ?");
            }
            sql.append("\nORDER BY i.object_id,i.index_id,ic.index_column_id");
            JDBCPreparedStatement dbStat = session.prepareStatement(sql.toString());
            if (forTable != null) {
                dbStat.setLong(1, forTable.getObjectId());
            } else {
                dbStat.setLong(1, owner.getObjectId());
            }
            return dbStat;
        }

        @Nullable
        protected SQLServerTableIndex fetchObject(JDBCSession session, SQLServerSchema owner, SQLServerTableBase parent, String indexName, JDBCResultSet dbResult) throws SQLException, DBException {
            DBSIndexType indexType;
            int indexTypeNum = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"type");
            switch (indexTypeNum) {
                case 0: {
                    indexType = SQLServerConstants.INDEX_TYPE_HEAP;
                    break;
                }
                case 1: 
                case 5: {
                    indexType = DBSIndexType.CLUSTERED;
                    break;
                }
                case 2: 
                case 6: {
                    indexType = SQLServerConstants.INDEX_TYPE_NON_CLUSTERED;
                    break;
                }
                default: {
                    indexType = DBSIndexType.OTHER;
                }
            }
            return new SQLServerTableIndex(parent, indexName, indexType, (ResultSet)dbResult);
        }

        @Nullable
        protected SQLServerTableIndexColumn[] fetchObjectRow(JDBCSession session, SQLServerTableBase parent, SQLServerTableIndex object, JDBCResultSet dbResult) throws SQLException, DBException {
            long indexColumnId = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"index_column_id");
            long columnId = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"column_id");
            SQLServerTableColumn tableColumn = columnId == 0L ? null : parent.getAttribute(session.getProgressMonitor(), columnId);
            int ordinal = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"key_ordinal");
            boolean ascending = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"is_descending_key") == 0;
            return new SQLServerTableIndexColumn[]{new SQLServerTableIndexColumn(object, indexColumnId, tableColumn, ordinal, ascending)};
        }

        protected void cacheChildren(DBRProgressMonitor monitor, SQLServerTableIndex index, List<SQLServerTableIndexColumn> rows) {
            index.setColumns(rows);
        }
    }

    static class ProcedureCache
    extends JDBCStructLookupCache<SQLServerSchema, SQLServerProcedure, SQLServerProcedureParameter> {
        public ProcedureCache() {
            super((Object)"proc_name");
        }

        @NotNull
        public JDBCStatement prepareLookupStatement(JDBCSession session, SQLServerSchema schema, SQLServerProcedure object, String objectName) throws SQLException {
            String sql = "SELECT p.*,ep.value as description\nFROM " + SQLServerUtils.getSystemTableName(schema.getDatabase(), "all_objects") + " p" + "\nLEFT OUTER JOIN " + SQLServerUtils.getExtendedPropsTableName(schema.getDatabase()) + " ep ON ep.class=" + SQLServerObjectClass.OBJECT_OR_COLUMN.getClassId() + " AND ep.major_id=p.object_id AND ep.minor_id=0 AND ep.name='" + "MS_Description" + "'" + "\nWHERE p.type IN ('P','PC','X','TF','FN','IF') AND p.schema_id=?" + (object != null || objectName != null ? " AND p.name=?" : "") + "\nORDER BY p.name";
            JDBCPreparedStatement dbStat = session.prepareStatement(sql);
            dbStat.setLong(1, schema.getObjectId());
            if (object != null || objectName != null) {
                dbStat.setString(2, object != null ? object.getName() : objectName);
            }
            return dbStat;
        }

        protected SQLServerProcedure fetchObject(@NotNull JDBCSession session, @NotNull SQLServerSchema schema, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new SQLServerProcedure(schema, (ResultSet)resultSet);
        }

        protected JDBCStatement prepareChildrenStatement(@NotNull JDBCSession session, @NotNull SQLServerSchema schema, SQLServerProcedure forObject) throws SQLException {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT p.name as proc_name,pp.* FROM \n").append(SQLServerUtils.getSystemTableName(schema.getDatabase(), "all_objects")).append(" p, ").append(SQLServerUtils.getSystemTableName(schema.getDatabase(), "all_parameters")).append(" pp\n").append("\nWHERE p.type IN ('P','PC','X','TF','FN','IF') AND p.object_id = pp.object_id AND ");
            if (forObject == null) {
                sql.append("p.schema_id = ?");
            } else {
                sql.append("p.object_id = ?");
            }
            sql.append("\nORDER BY pp.object_id, pp.parameter_id");
            JDBCPreparedStatement dbStat = session.prepareStatement(sql.toString());
            if (forObject == null) {
                dbStat.setLong(1, schema.getObjectId());
            } else {
                dbStat.setLong(1, forObject.getObjectId());
            }
            return dbStat;
        }

        protected SQLServerProcedureParameter fetchChild(@NotNull JDBCSession session, @NotNull SQLServerSchema schema, @NotNull SQLServerProcedure parent, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new SQLServerProcedureParameter(session.getProgressMonitor(), parent, dbResult);
        }
    }

    static class SequenceCache
    extends JDBCObjectCache<SQLServerSchema, SQLServerSequence> {
        SequenceCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull SQLServerSchema schema) throws SQLException {
            StringBuilder sql = new StringBuilder(500);
            sql.append("SELECT * FROM \n").append(SQLServerUtils.getSystemTableName(schema.getDatabase(), "sequences")).append("\n");
            sql.append("WHERE schema_id=?");
            sql.append("\nORDER BY name");
            JDBCPreparedStatement dbStat = session.prepareStatement(sql.toString());
            dbStat.setLong(1, schema.getObjectId());
            return dbStat;
        }

        protected SQLServerSequence fetchObject(@NotNull JDBCSession session, @NotNull SQLServerSchema schema, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new SQLServerSequence(schema, JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"object_id"), JDBCUtils.safeGetString((ResultSet)resultSet, (String)"name"), CommonUtils.toLong((Object)JDBCUtils.safeGetObject((ResultSet)resultSet, (String)"current_value")), CommonUtils.toLong((Object)JDBCUtils.safeGetObject((ResultSet)resultSet, (String)"minimum_value")), CommonUtils.toLong((Object)JDBCUtils.safeGetObject((ResultSet)resultSet, (String)"maximum_value")), CommonUtils.toLong((Object)JDBCUtils.safeGetObject((ResultSet)resultSet, (String)"increment")), true);
        }
    }

    static class SynonymCache
    extends JDBCObjectCache<SQLServerSchema, SQLServerSynonym> {
        SynonymCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull SQLServerSchema schema) throws SQLException {
            StringBuilder sql = new StringBuilder(500);
            sql.append("SELECT * FROM \n").append(SQLServerUtils.getSystemTableName(schema.getDatabase(), "synonyms")).append("\n");
            sql.append("WHERE schema_id=?");
            sql.append("\nORDER BY name");
            JDBCPreparedStatement dbStat = session.prepareStatement(sql.toString());
            dbStat.setLong(1, schema.getObjectId());
            return dbStat;
        }

        protected SQLServerSynonym fetchObject(@NotNull JDBCSession session, @NotNull SQLServerSchema schema, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new SQLServerSynonym(schema, JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"object_id"), JDBCUtils.safeGetString((ResultSet)resultSet, (String)"name"), JDBCUtils.safeGetString((ResultSet)resultSet, (String)"base_object_name"), true);
        }
    }

    public static class TableCache
    extends JDBCStructLookupCache<SQLServerSchema, SQLServerTableBase, SQLServerTableColumn> {
        TableCache() {
            super((Object)"table_name");
            this.setListOrderComparator(DBUtils.nameComparator());
        }

        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull SQLServerSchema owner, @Nullable SQLServerTableBase object, @Nullable String objectName) throws SQLException {
            StringBuilder sql = new StringBuilder();
            SQLServerDataSource dataSource = owner.getDataSource();
            sql.append("SELECT o.*,ep.value as description FROM ").append(SQLServerUtils.getSystemTableName(owner.getDatabase(), "all_objects")).append(" o");
            sql.append("\nLEFT OUTER JOIN ").append(SQLServerUtils.getExtendedPropsTableName(owner.getDatabase())).append(" ep ON ep.class=").append(SQLServerObjectClass.OBJECT_OR_COLUMN.getClassId()).append(" AND ep.major_id=o.object_id AND ep.minor_id=0 AND ep.name='").append("MS_Description").append("'");
            sql.append("\nWHERE o.type IN ('U','S','V','TT') AND o.schema_id = ").append(owner.getObjectId());
            if (object != null || objectName != null) {
                sql.append(" AND o.name = ").append(SQLUtils.quoteString((DBPDataSource)session.getDataSource(), (String)(object != null ? object.getName() : objectName)));
            } else {
                DBSObjectFilter tableFilters = dataSource.getContainer().getObjectFilter(SQLServerTableBase.class, (DBSObject)owner, false);
                if (tableFilters != null && !tableFilters.isEmpty()) {
                    sql.append(" AND (");
                    boolean hasCond = false;
                    for (String incName : CommonUtils.safeCollection((Collection)tableFilters.getInclude())) {
                        if (hasCond) {
                            sql.append(" OR ");
                        }
                        hasCond = true;
                        sql.append(" o.name LIKE ").append(SQLUtils.quoteString((DBPDataSource)session.getDataSource(), (String)incName));
                    }
                    hasCond = false;
                    for (String incName : CommonUtils.safeCollection((Collection)tableFilters.getExclude())) {
                        if (hasCond) {
                            sql.append(" OR ");
                        }
                        hasCond = true;
                        sql.append(" o.name NOT LIKE ").append(SQLUtils.quoteString((DBPDataSource)session.getDataSource(), (String)incName));
                    }
                    sql.append(")");
                }
            }
            return session.prepareStatement(sql.toString());
        }

        protected SQLServerTableBase fetchObject(@NotNull JDBCSession session, @NotNull SQLServerSchema owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            String type = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"type");
            if (SQLServerObjectType.U.name().equals(type) || SQLServerObjectType.S.name().equals(type)) {
                return new SQLServerTable(owner, (ResultSet)dbResult);
            }
            if (SQLServerObjectType.TT.name().equals(type)) {
                return new SQLServerTableType(owner, (ResultSet)dbResult);
            }
            return new SQLServerView(owner, (ResultSet)dbResult);
        }

        protected JDBCStatement prepareChildrenStatement(@NotNull JDBCSession session, @NotNull SQLServerSchema owner, @Nullable SQLServerTableBase forTable) throws SQLException {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT c.*,t.name as table_name,t.schema_id");
            if (owner.getDataSource().supportsColumnProperty()) {
                sql.append(", COLUMNPROPERTY(c.object_id, c.name, 'charmaxlen') as char_max_length");
            }
            sql.append(", dc.definition as default_definition,ep.value as description\nFROM ").append(SQLServerUtils.getSystemTableName(owner.getDatabase(), "all_columns")).append(" c").append("\nJOIN ").append(SQLServerUtils.getSystemTableName(owner.getDatabase(), "all_objects")).append(" t ON t.object_id=c.object_id").append("\nLEFT OUTER JOIN ").append(SQLServerUtils.getSystemTableName(owner.getDatabase(), "default_constraints")).append(" dc ON dc.parent_object_id=t.object_id AND dc.parent_column_id=c.column_id").append("\nLEFT OUTER JOIN ").append(SQLServerUtils.getExtendedPropsTableName(owner.getDatabase())).append(" ep ON ep.class=").append(SQLServerObjectClass.OBJECT_OR_COLUMN.getClassId()).append(" AND ep.major_id=t.object_id AND ep.minor_id=c.column_id AND ep.name='").append("MS_Description").append("'");
            sql.append("WHERE ");
            if (forTable != null) {
                sql.append("t.object_id=?");
            } else {
                sql.append("t.schema_id=?");
            }
            sql.append("\nORDER BY c.object_id,c.column_id");
            JDBCPreparedStatement dbStat = session.prepareStatement(sql.toString());
            if (forTable != null) {
                dbStat.setLong(1, forTable.getObjectId());
            } else {
                dbStat.setLong(1, owner.getObjectId());
            }
            return dbStat;
        }

        protected SQLServerTableColumn fetchChild(@NotNull JDBCSession session, @NotNull SQLServerSchema owner, @NotNull SQLServerTableBase table, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new SQLServerTableColumn(session.getProgressMonitor(), table, (ResultSet)dbResult);
        }
    }

    class TriggerCache
    extends JDBCObjectLookupCache<SQLServerSchema, SQLServerTableTrigger> {
        TriggerCache() {
        }

        @NotNull
        public JDBCStatement prepareLookupStatement(JDBCSession session, SQLServerSchema schema, SQLServerTableTrigger object, String objectName) throws SQLException {
            StringBuilder sql = new StringBuilder(500);
            sql.append("SELECT t.* FROM \n").append(SQLServerUtils.getSystemTableName(schema.getDatabase(), "triggers")).append(" t,").append(SQLServerUtils.getSystemTableName(schema.getDatabase(), "all_objects")).append(" o").append("\n");
            sql.append("WHERE o.object_id=t.object_id AND o.schema_id=?");
            if (object != null || objectName != null) {
                sql.append(" AND t.name=?");
            }
            sql.append("\nORDER BY t.name");
            JDBCPreparedStatement dbStat = session.prepareStatement(sql.toString());
            dbStat.setLong(1, schema.getObjectId());
            if (object != null || objectName != null) {
                dbStat.setString(2, object != null ? object.getName() : objectName);
            }
            return dbStat;
        }

        protected SQLServerTableTrigger fetchObject(@NotNull JDBCSession session, @NotNull SQLServerSchema schema, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            long tableId = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"parent_id");
            SQLServerTable table = SQLServerSchema.this.getTable(session.getProgressMonitor(), tableId);
            if (table == null) {
                log.debug((Object)("Trigger owner " + tableId + " not found"));
                return null;
            }
            return new SQLServerTableTrigger(table, (ResultSet)resultSet);
        }
    }

    static class UniqueConstraintCache
    extends JDBCCompositeCache<SQLServerSchema, SQLServerTableBase, SQLServerTableUniqueKey, SQLServerTableIndexColumn> {
        UniqueConstraintCache(TableCache tableCache) {
            super((JDBCStructCache)tableCache, SQLServerTableBase.class, (Object)"table_name", (Object)"name");
        }

        protected JDBCStatement prepareObjectsStatement(JDBCSession session, SQLServerSchema schema, SQLServerTableBase forParent) throws SQLException {
            StringBuilder sql = new StringBuilder(500);
            sql.append("SELECT kc.*,t.name as table_name FROM \n").append(SQLServerUtils.getSystemTableName(schema.getDatabase(), "key_constraints")).append(" kc,").append(SQLServerUtils.getSystemTableName(schema.getDatabase(), "all_objects")).append(" t\n");
            sql.append("WHERE kc.parent_object_id=t.object_id AND kc.schema_id=?");
            if (forParent != null) {
                sql.append(" AND kc.parent_object_id=?");
            }
            sql.append("\nORDER BY kc.name");
            JDBCPreparedStatement dbStat = session.prepareStatement(sql.toString());
            dbStat.setLong(1, schema.getObjectId());
            if (forParent != null) {
                dbStat.setLong(2, forParent.getObjectId());
            }
            return dbStat;
        }

        protected SQLServerTableUniqueKey fetchObject(JDBCSession session, SQLServerSchema schema, SQLServerTableBase table, String childName, JDBCResultSet resultSet) throws SQLException, DBException {
            String name = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"name");
            String type = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"type");
            long indexId = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"unique_index_id");
            JDBCUtils.safeGetInt((ResultSet)resultSet, (String)"is_system_named");
            SQLServerTableIndex index = table.getIndex(session.getProgressMonitor(), indexId);
            if (index == null) {
                return null;
            }
            DBSEntityConstraintType cType = "PK".equals(type) ? DBSEntityConstraintType.PRIMARY_KEY : DBSEntityConstraintType.UNIQUE_KEY;
            return new SQLServerTableUniqueKey(table, name, null, cType, index, true);
        }

        protected SQLServerTableIndexColumn[] fetchObjectRow(JDBCSession session, SQLServerTableBase table, SQLServerTableUniqueKey forObject, JDBCResultSet resultSet) throws SQLException, DBException {
            return new SQLServerTableIndexColumn[0];
        }

        protected void cacheChildren(DBRProgressMonitor monitor, SQLServerTableUniqueKey object, List<SQLServerTableIndexColumn> children) {
        }
    }
}

