/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageDatabaseEditors
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.editors";
    private Button syncEditorDataSourceWithNavigator;
    private Button showGeneralToolbarEverywhere;
    private Button showEditToolbar;
    private Button keepEditorsOnRestart;
    private Button refreshEditorOnOpen;
    private Button editorFullName;
    private Button showTableGrid;
    private Button showPreviewOnSave;

    public PrefPageDatabaseEditors() {
        this.setPreferenceStore((IPreferenceStore)new PreferenceStoreDelegate(DBWorkbench.getPlatform().getPreferenceStore()));
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)5);
        Group toolbarsGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_database_general_group_toolbars, (int)2, (int)0, (int)0);
        this.syncEditorDataSourceWithNavigator = UIUtils.createCheckbox((Composite)toolbarsGroup, (String)CoreMessages.pref_page_database_general_label_sync_editor_connection_with_navigator, (String)CoreMessages.pref_page_database_general_label_sync_editor_connection_with_navigator_tip, (boolean)false, (int)2);
        this.showGeneralToolbarEverywhere = UIUtils.createCheckbox((Composite)toolbarsGroup, (String)CoreMessages.pref_page_database_general_label_show_general_toolbar_everywhere, (String)CoreMessages.pref_page_database_general_label_show_general_toolbar_everywhere_tip, (boolean)false, (int)2);
        this.showEditToolbar = UIUtils.createCheckbox((Composite)toolbarsGroup, (String)CoreMessages.pref_page_database_general_label_show_edit_toolbar, (String)CoreMessages.pref_page_database_general_label_show_edit_toolbar_tip, (boolean)false, (int)2);
        Group groupEditors = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_ui_general_group_editors, (int)1, (int)2, (int)0);
        this.keepEditorsOnRestart = UIUtils.createCheckbox((Composite)groupEditors, (String)CoreMessages.pref_page_ui_general_keep_database_editors, (boolean)false);
        this.keepEditorsOnRestart.setToolTipText(CoreMessages.pref_page_ui_general_keep_database_editors_tip);
        this.refreshEditorOnOpen = UIUtils.createCheckbox((Composite)groupEditors, (String)CoreMessages.pref_page_ui_general_refresh_editor_on_open, (boolean)false);
        this.refreshEditorOnOpen.setToolTipText(CoreMessages.pref_page_ui_general_refresh_editor_on_open_tip);
        this.editorFullName = UIUtils.createCheckbox((Composite)groupEditors, (String)CoreMessages.pref_page_ui_general_show_full_name_in_editor, (boolean)false);
        this.showTableGrid = UIUtils.createCheckbox((Composite)groupEditors, (String)CoreMessages.pref_page_ui_general_show_table_grid, (boolean)false);
        this.showPreviewOnSave = UIUtils.createCheckbox((Composite)groupEditors, (String)CoreMessages.pref_page_ui_general_show_preview_on_save, (boolean)false);
        this.performDefaults();
        return composite;
    }

    protected void performDefaults() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        this.syncEditorDataSourceWithNavigator.setSelection(store.getBoolean("navigator.sync.editor.datasource"));
        this.showGeneralToolbarEverywhere.setSelection(store.getBoolean("toolbars.show.general.always"));
        this.showEditToolbar.setSelection(store.getBoolean("toolbars.show.edit"));
        this.keepEditorsOnRestart.setSelection(store.getBoolean("ui.editors.reopen-after-restart"));
        this.refreshEditorOnOpen.setSelection(store.getBoolean("navigator.refresh.editor.open"));
        this.editorFullName.setSelection(store.getBoolean("navigator.editor.full-name"));
        this.showTableGrid.setSelection(store.getBoolean("navigator.editor.showGrid"));
        this.showPreviewOnSave.setSelection(store.getBoolean("navigator.editor.show.preview"));
    }

    public boolean performOk() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        store.setValue("navigator.sync.editor.datasource", this.syncEditorDataSourceWithNavigator.getSelection());
        store.setValue("toolbars.show.general.always", this.showGeneralToolbarEverywhere.getSelection());
        store.setValue("toolbars.show.edit", this.showEditToolbar.getSelection());
        store.setValue("ui.editors.reopen-after-restart", this.keepEditorsOnRestart.getSelection());
        store.setValue("navigator.refresh.editor.open", this.refreshEditorOnOpen.getSelection());
        store.setValue("navigator.editor.full-name", this.editorFullName.getSelection());
        store.setValue("navigator.editor.showGrid", this.showTableGrid.getSelection());
        store.setValue("navigator.editor.show.preview", this.showPreviewOnSave.getSelection());
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
        return true;
    }

    public void applyData(Object data) {
        super.applyData(data);
    }

    @Nullable
    public IAdaptable getElement() {
        return null;
    }

    public void setElement(IAdaptable element) {
    }
}

