/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectBase;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorObjectsDeleter;
import org.jkiss.utils.CommonUtils;

public class NavigatorHandlerObjectDelete
extends NavigatorHandlerObjectBase
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        List selectedObjects = ((IStructuredSelection)selection).toList();
        NavigatorObjectsDeleter deleter = NavigatorObjectsDeleter.of(selectedObjects, window);
        this.makeDeletionAttempt(window, selectedObjects, deleter);
        return null;
    }

    private void makeDeletionAttempt(IWorkbenchWindow window, List<Object> selectedObjects, NavigatorObjectsDeleter deleter) {
        if (deleter.hasNodesFromDifferentDataSources()) {
            DBWorkbench.getPlatformUI().showError(UINavigatorMessages.error_deleting_multiple_objects_from_different_datasources_title, UINavigatorMessages.error_deleting_multiple_objects_from_different_datasources_message);
            return;
        }
        ConfirmationDialog dialog = ConfirmationDialog.of(window.getShell(), selectedObjects, deleter.getShowCascade(), deleter.getShowViewScript());
        int result = dialog.open();
        deleter.setCheckCascade(dialog.cascadeCheck);
        if (result == 2) {
            deleter.delete();
        } else if (result == 13) {
            boolean persistCheck = deleter.showScriptWindow();
            if (persistCheck) {
                deleter.delete();
            } else {
                this.makeDeletionAttempt(window, selectedObjects, deleter);
            }
        }
    }

    public void updateElement(UIElement element, Map parameters) {
    }

    private static class ConfirmationDialog
    extends MessageDialog {
        private final List<Object> selectedObjects;
        private final boolean showCascade;
        private final boolean showViewScript;
        private boolean cascadeCheck;

        private ConfirmationDialog(Shell shell, String title, String message, List<Object> selectedObjects, boolean showCascade, boolean showViewScript) {
            super(shell, title, DBeaverIcons.getImage((DBPImage)UIIcon.REJECT), message, 4, null, 0);
            this.selectedObjects = selectedObjects;
            this.showCascade = showCascade;
            this.showViewScript = showViewScript;
        }

        static ConfirmationDialog of(Shell shell, List<Object> selectedObjects, boolean showCascade, boolean showViewScript) {
            if (selectedObjects.size() > 1) {
                return new ConfirmationDialog(shell, UINavigatorMessages.confirm_deleting_multiple_objects_title, UINavigatorMessages.confirm_deleting_multiple_objects_message, selectedObjects, showCascade, showViewScript);
            }
            DBNNode node = (DBNNode)selectedObjects.get(0);
            String title = NLS.bind((String)(node instanceof DBNLocalFolder ? UINavigatorMessages.confirm_local_folder_delete_title : UINavigatorMessages.confirm_entity_delete_title), (Object)node.getNodeType(), (Object)node.getNodeName());
            String message = NLS.bind((String)(node instanceof DBNLocalFolder ? UINavigatorMessages.confirm_local_folder_delete_message : UINavigatorMessages.confirm_entity_delete_message), (Object)node.getNodeType(), (Object)node.getNodeName());
            return new ConfirmationDialog(shell, title, message, selectedObjects, showCascade, showViewScript);
        }

        protected Control createCustomArea(Composite parent) {
            if (this.selectedObjects.size() > 1) {
                this.setUpObjectsTable(parent);
            }
            this.setUpCascadeButton(parent);
            return super.createCustomArea(parent);
        }

        private void setUpObjectsTable(Composite parent) {
            Composite placeholder = UIUtils.createComposite((Composite)parent, (int)1);
            placeholder.setLayoutData((Object)new GridData(1808));
            Group tableGroup = UIUtils.createControlGroup((Composite)placeholder, (String)UINavigatorMessages.confirm_deleting_multiple_objects_table_group_name, (int)1, (int)1808, (int)0);
            tableGroup.setLayoutData((Object)new GridData(1808));
            Table objectsTable = new Table((Composite)tableGroup, 67584);
            objectsTable.setHeaderVisible(false);
            objectsTable.setLinesVisible(true);
            objectsTable.setLayoutData((Object)new GridData(1808));
            UIUtils.createTableColumn((Table)objectsTable, (int)131072, (String)UINavigatorMessages.confirm_deleting_multiple_objects_column_name);
            UIUtils.createTableColumn((Table)objectsTable, (int)131072, (String)UINavigatorMessages.confirm_deleting_multiple_objects_column_description);
            for (Object obj : this.selectedObjects) {
                if (!(obj instanceof DBNNode)) continue;
                DBNNode node = (DBNNode)obj;
                TableItem item = new TableItem(objectsTable, 0);
                item.setImage(DBeaverIcons.getImage((DBPImage)node.getNodeIcon()));
                item.setText(0, node.getNodeFullName());
                item.setText(1, CommonUtils.toString((Object)node.getNodeDescription()));
            }
            UIUtils.asyncExec(() -> UIUtils.packColumns((Table)objectsTable, (boolean)true));
        }

        private void setUpCascadeButton(Composite parent) {
            if (!this.showCascade) {
                return;
            }
            Composite ph = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)5);
            final Button cascadeCheckButton = UIUtils.createCheckbox((Composite)ph, (String)UINavigatorMessages.confirm_deleting_multiple_objects_cascade_checkbox, (String)UINavigatorMessages.confirm_deleting_multiple_objects_cascade_checkbox_tooltip, (boolean)false, (int)0);
            cascadeCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    cascadeCheck = cascadeCheckButton.getSelection();
                }
            });
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 2, IDialogConstants.YES_LABEL, false);
            this.createButton(parent, 3, IDialogConstants.NO_LABEL, true);
            if (this.showViewScript) {
                this.createButton(parent, 13, UINavigatorMessages.actions_navigator_view_script_button, false);
            }
        }
    }
}

