/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorView;

public class NavigatorHandlerConnectionFilter
extends AbstractHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof DatabaseNavigatorView) {
            DatabaseNavigatorTree navigatorTree;
            navigatorTree.setFilterShowConnected(!(navigatorTree = ((DatabaseNavigatorView)activePart).getNavigatorTree()).isFilterShowConnected());
            navigatorTree.getViewer().getControl().setRedraw(false);
            try {
                navigatorTree.getViewer().refresh();
            }
            finally {
                navigatorTree.getViewer().getControl().setRedraw(true);
            }
        }
        ActionUtils.fireCommandRefresh((String)"org.jkiss.dbeaver.navigator.filter.connected");
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        IWorkbenchPartSite partSite = UIUtils.getWorkbenchPartSite((IServiceLocator)element.getServiceLocator());
        if (partSite != null && partSite.getPart() instanceof DatabaseNavigatorView) {
            DatabaseNavigatorTree navigatorTree = ((DatabaseNavigatorView)partSite.getPart()).getNavigatorTree();
            element.setIcon(DBeaverIcons.getImageDescriptor((DBPImage)(navigatorTree.isFilterShowConnected() ? UIIcon.FILTER_RESET : UIIcon.FILTER_APPLY)));
            String actionName = navigatorTree.isFilterShowConnected() ? "Show all" : "Show connected only";
            element.setText(actionName);
            element.setTooltip(actionName);
        }
    }
}

