/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.ui.editors;

import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreScriptObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreViewBase;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.editors.sql.SQLSourceViewer;
import org.jkiss.utils.CommonUtils;

public class PostgreSourceViewEditor
extends SQLSourceViewer<PostgreScriptObject> {
    protected boolean isReadOnly() {
        PostgreScriptObject sourceObject = (PostgreScriptObject)this.getSourceObject();
        return !(sourceObject instanceof PostgreProcedure) && !(sourceObject instanceof PostgreViewBase);
    }

    protected boolean isAnnotationRulerVisible() {
        return this.getSourceObject() instanceof PostgreProcedure;
    }

    protected void setSourceText(DBRProgressMonitor monitor, String sourceText) {
        this.getInputPropertySource().setPropertyValue(monitor, "objectDefinitionText", (Object)sourceText);
    }

    protected void contributeEditorCommands(IContributionManager contributionManager) {
        super.contributeEditorCommands(contributionManager);
        PostgreScriptObject sourceObject = (PostgreScriptObject)this.getSourceObject();
        if (sourceObject instanceof PostgreProcedure) {
            contributionManager.add((IContributionItem)new Separator());
            contributionManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new Action("Show header", 2){
                {
                    this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TREE_PROCEDURE));
                    this.setToolTipText("Shows auto-generated function header");
                    this.setChecked(!PostgreSourceViewEditor.this.isInDebugMode());
                }

                public void run() {
                    PostgreSourceViewEditor.this.getDatabaseEditorInput().setAttribute("debugger.source", (Object)(!this.isChecked() ? 1 : 0));
                    PostgreSourceViewEditor.this.refreshPart((Object)PostgreSourceViewEditor.this, true);
                }
            }, (boolean)true));
        }
    }

    protected Map<String, Object> getSourceOptions() {
        Map options = super.getSourceOptions();
        options.put("debugger.source", this.isInDebugMode());
        return options;
    }

    private boolean isInDebugMode() {
        return CommonUtils.getBoolean((Object)this.getDatabaseEditorInput().getAttribute("debugger.source"), (boolean)false);
    }
}

