/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceConfigurationStorage;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPEventListener;
import org.jkiss.dbeaver.model.access.DBAAuthProfile;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.connection.DBPAuthModelDescriptor;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderRegistry;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.net.DBWNetworkProfile;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.ProxyProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.virtual.DBVModel;
import org.jkiss.dbeaver.registry.DataSourceConfigurationStorageDescriptor;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceFolder;
import org.jkiss.dbeaver.registry.DataSourceOrigin;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.DataSourceSerializer;
import org.jkiss.dbeaver.registry.DataSourceSerializerLegacy;
import org.jkiss.dbeaver.registry.DataSourceSerializerModern;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DataSourceRegistry
implements DBPDataSourceRegistry {
    @Deprecated
    public static final String DEFAULT_AUTO_COMMIT = "default.autocommit";
    @Deprecated
    public static final String DEFAULT_ISOLATION = "default.isolation";
    @Deprecated
    public static final String DEFAULT_ACTIVE_OBJECT = "default.activeObject";
    private static final long DISCONNECT_ALL_TIMEOUT = 5000L;
    private static final Log log = Log.getLog(DataSourceRegistry.class);
    public static final String OLD_CONFIG_FILE_NAME = "data-sources.xml";
    private final DBPPlatform platform;
    private final DBPProject project;
    private final Map<File, DataSourceOrigin> origins = new LinkedHashMap<File, DataSourceOrigin>();
    private final Map<String, DataSourceDescriptor> dataSources = new LinkedHashMap<String, DataSourceDescriptor>();
    private final List<DBPEventListener> dataSourceListeners = new ArrayList<DBPEventListener>();
    private final List<DataSourceFolder> dataSourceFolders = new ArrayList<DataSourceFolder>();
    private final List<DBSObjectFilter> savedFilters = new ArrayList<DBSObjectFilter>();
    private final List<DBWNetworkProfile> networkProfiles = new ArrayList<DBWNetworkProfile>();
    private final Map<String, DBAAuthProfile> authProfiles = new LinkedHashMap<String, DBAAuthProfile>();
    private volatile boolean saveInProgress = false;
    private final DBVModel.ModelChangeListener modelChangeListener = new DBVModel.ModelChangeListener();
    private volatile ConfigSaver configSaver;

    public DataSourceRegistry(DBPPlatform platform, DBPProject project) {
        this.platform = platform;
        this.project = project;
        this.loadDataSources(true);
        DataSourceProviderRegistry.getInstance().fireRegistryChange(this, true);
        this.addDataSourceListener((DBPEventListener)this.modelChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.removeDataSourceListener((DBPEventListener)this.modelChangeListener);
        DataSourceProviderRegistry.getInstance().fireRegistryChange(this, false);
        Object object = this.dataSourceListeners;
        synchronized (object) {
            if (!this.dataSourceListeners.isEmpty()) {
                log.warn((Object)("Some data source listeners are still registered: " + this.dataSourceListeners));
            }
            this.dataSourceListeners.clear();
        }
        this.closeConnections(5000L);
        object = this.dataSources;
        synchronized (object) {
            for (DataSourceDescriptor dataSourceDescriptor : this.dataSources.values()) {
                dataSourceDescriptor.dispose();
            }
            this.dataSources.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnections(long waitTime) {
        boolean hasConnections = false;
        Map<String, DataSourceDescriptor> map = this.dataSources;
        synchronized (map) {
            for (DataSourceDescriptor dataSource : this.dataSources.values()) {
                if (!dataSource.isConnected()) continue;
                hasConnections = true;
                break;
            }
        }
        if (!hasConnections) {
            return;
        }
        DisconnectTask disconnectTask = new DisconnectTask();
        if (!RuntimeUtils.runTask((DBRRunnableWithProgress)disconnectTask, (String)"Disconnect from data sources", (long)waitTime)) {
            log.warn((Object)("Some data source connections wasn't closed on shutdown in " + waitTime + "ms. Probably network timeout occurred."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataSourceOrigin getDefaultOrigin() {
        Map<File, DataSourceOrigin> map = this.origins;
        synchronized (map) {
            File legacyFile;
            for (DataSourceOrigin origin : this.origins.values()) {
                if (!origin.isDefault()) continue;
                return origin;
            }
            File defFile = this.getModernConfigFile();
            if (!defFile.exists() && (legacyFile = this.getLegacyConfigFile()).exists()) {
                defFile = legacyFile;
            }
            DataSourceOrigin origin = new DataSourceOrigin(defFile, true);
            this.origins.put(defFile, origin);
            return origin;
        }
    }

    private File getLegacyConfigFile() {
        return new File(this.project.getAbsolutePath(), ".dbeaver-data-sources.xml");
    }

    private File getModernConfigFile() {
        return new File(this.project.getMetadataFolder(false), "data-sources.json");
    }

    @NotNull
    public DBPPlatform getPlatform() {
        return this.platform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DataSourceDescriptor getDataSource(String id) {
        Map<String, DataSourceDescriptor> map = this.dataSources;
        synchronized (map) {
            return this.dataSources.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DataSourceDescriptor getDataSource(DBPDataSource dataSource) {
        Map<String, DataSourceDescriptor> map = this.dataSources;
        synchronized (map) {
            for (DataSourceDescriptor dsd : this.dataSources.values()) {
                if (dsd.getDataSource() != dataSource) continue;
                return dsd;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DataSourceDescriptor findDataSourceByName(String name) {
        Map<String, DataSourceDescriptor> map = this.dataSources;
        synchronized (map) {
            for (DataSourceDescriptor dsd : this.dataSources.values()) {
                if (!dsd.getName().equals(name)) continue;
                return dsd;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<? extends DBPDataSourceContainer> getDataSourcesByProfile(@NotNull DBWNetworkProfile profile) {
        List dsCopy;
        Map<String, DataSourceDescriptor> map = this.dataSources;
        synchronized (map) {
            dsCopy = CommonUtils.copyList(this.dataSources.values());
        }
        dsCopy.removeIf(ds -> !CommonUtils.equalObjects((Object)ds.getConnectionConfiguration().getConfigProfileName(), (Object)profile.getProfileName()));
        return dsCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<DataSourceDescriptor> getDataSources() {
        List dsCopy;
        Map<String, DataSourceDescriptor> map = this.dataSources;
        synchronized (map) {
            dsCopy = CommonUtils.copyList(this.dataSources.values());
        }
        dsCopy.sort((o1, o2) -> ((String)CommonUtils.notNull((Object)o1.getName(), (Object)o1.getId())).compareToIgnoreCase((String)CommonUtils.notNull((Object)o2.getName(), (Object)o2.getId())));
        return dsCopy;
    }

    @NotNull
    public DBPDataSourceContainer createDataSource(DBPDriver driver, DBPConnectionConfiguration connConfig) {
        return new DataSourceDescriptor(this, DataSourceDescriptor.generateNewId(driver), driver, connConfig);
    }

    @NotNull
    public DBPDataSourceContainer createDataSource(DBPDataSourceContainer source) {
        DataSourceDescriptor newDS = new DataSourceDescriptor((DataSourceDescriptor)source, this);
        newDS.setId(DataSourceDescriptor.generateNewId(source.getDriver()));
        return newDS;
    }

    @NotNull
    public List<DataSourceFolder> getAllFolders() {
        return this.dataSourceFolders;
    }

    @NotNull
    public List<DataSourceFolder> getRootFolders() {
        ArrayList<DataSourceFolder> rootFolders = new ArrayList<DataSourceFolder>();
        for (DataSourceFolder folder : this.dataSourceFolders) {
            if (folder.getParent() != null) continue;
            rootFolders.add(folder);
        }
        return rootFolders;
    }

    public DataSourceFolder addFolder(DBPDataSourceFolder parent, String name) {
        DataSourceFolder folder = new DataSourceFolder(this, (DataSourceFolder)parent, name, null);
        this.dataSourceFolders.add(folder);
        return folder;
    }

    public void removeFolder(DBPDataSourceFolder folder, boolean dropContents) {
        DataSourceFolder folderImpl = (DataSourceFolder)folder;
        DataSourceFolder[] dataSourceFolderArray = folderImpl.getChildren();
        int n = dataSourceFolderArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataSourceFolder child = dataSourceFolderArray[n2];
            this.removeFolder(child, dropContents);
            ++n2;
        }
        DBPDataSourceFolder parent = folder.getParent();
        if (parent != null) {
            folderImpl.setParent(null);
        }
        for (DataSourceDescriptor ds : this.dataSources.values()) {
            if (ds.getFolder() != folder) continue;
            if (dropContents) {
                this.removeDataSource(ds);
                continue;
            }
            ds.setFolder(parent);
        }
        this.dataSourceFolders.remove(folderImpl);
    }

    private DataSourceFolder findRootFolder(String name) {
        for (DataSourceFolder root : this.getRootFolders()) {
            if (!root.getName().equals(name)) continue;
            return root;
        }
        return null;
    }

    public DBPDataSourceFolder getFolder(String path) {
        return this.findFolderByPath(path, true);
    }

    DataSourceFolder findFolderByPath(String path, boolean create) {
        DataSourceFolder parent = null;
        String[] stringArray = path.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataSourceFolder folder;
            String name = stringArray[n2];
            DataSourceFolder dataSourceFolder = folder = parent == null ? this.findRootFolder(name) : parent.getChild(name);
            if (folder == null) {
                if (!create) {
                    log.warn((Object)("Folder '" + path + "' not found"));
                    break;
                }
                folder = this.addFolder(parent, name);
            }
            parent = folder;
            ++n2;
        }
        return parent;
    }

    void addDataSourceFolder(DataSourceFolder folder) {
        this.dataSourceFolders.add(folder);
    }

    @Nullable
    public DBSObjectFilter getSavedFilter(String name) {
        for (DBSObjectFilter filter : this.savedFilters) {
            if (!CommonUtils.equalObjects((Object)filter.getName(), (Object)name)) continue;
            return filter;
        }
        return null;
    }

    @NotNull
    public List<DBSObjectFilter> getSavedFilters() {
        return this.savedFilters;
    }

    public void updateSavedFilter(DBSObjectFilter filter) {
        DBSObjectFilter filterCopy = new DBSObjectFilter(filter);
        int i = 0;
        while (i < this.savedFilters.size()) {
            if (CommonUtils.equalObjects((Object)this.savedFilters.get(i).getName(), (Object)filter.getName())) {
                this.savedFilters.set(i, filterCopy);
                return;
            }
            ++i;
        }
        this.savedFilters.add(filterCopy);
    }

    public void removeSavedFilter(String filterName) {
        int i = 0;
        while (i < this.savedFilters.size()) {
            if (CommonUtils.equalObjects((Object)this.savedFilters.get(i).getName(), (Object)filterName)) {
                this.savedFilters.remove(i);
                continue;
            }
            ++i;
        }
    }

    void addSavedFilter(DBSObjectFilter filter) {
        this.savedFilters.add(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DBWNetworkProfile getNetworkProfile(String name) {
        List<DBWNetworkProfile> list = this.networkProfiles;
        synchronized (list) {
            return this.networkProfiles.stream().filter(profile -> CommonUtils.equalObjects((Object)profile.getProfileName(), (Object)name)).findFirst().orElse(null);
        }
    }

    @NotNull
    public List<DBWNetworkProfile> getNetworkProfiles() {
        return this.networkProfiles;
    }

    public void updateNetworkProfile(DBWNetworkProfile profile) {
        int i = 0;
        while (i < this.networkProfiles.size()) {
            if (CommonUtils.equalObjects((Object)this.networkProfiles.get(i).getProfileName(), (Object)profile.getProfileName())) {
                this.networkProfiles.set(i, profile);
                return;
            }
            ++i;
        }
        this.networkProfiles.add(profile);
    }

    public void removeNetworkProfile(DBWNetworkProfile profile) {
        this.networkProfiles.remove(profile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DBAAuthProfile getAuthProfile(String id) {
        Map<String, DBAAuthProfile> map = this.authProfiles;
        synchronized (map) {
            return this.authProfiles.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<DBAAuthProfile> getAllAuthProfiles() {
        Map<String, DBAAuthProfile> map = this.authProfiles;
        synchronized (map) {
            return new ArrayList<DBAAuthProfile>(this.authProfiles.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<DBAAuthProfile> getApplicableAuthProfiles(@Nullable DBPDriver driver) {
        DBPDataSourceProviderRegistry dspRegistry = DBWorkbench.getPlatform().getDataSourceProviderRegistry();
        Map<String, DBAAuthProfile> map = this.authProfiles;
        synchronized (map) {
            return this.authProfiles.values().stream().filter(p -> {
                DBPAuthModelDescriptor authModel = dspRegistry.getAuthModel(p.getAuthModelId());
                return authModel != null && authModel.isApplicableTo(driver);
            }).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAuthProfile(DBAAuthProfile profile) {
        Map<String, DBAAuthProfile> map = this.authProfiles;
        synchronized (map) {
            this.authProfiles.put(profile.getProfileId(), profile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAuthProfile(DBAAuthProfile profile) {
        Map<String, DBAAuthProfile> map = this.authProfiles;
        synchronized (map) {
            this.authProfiles.remove(profile.getProfileId());
        }
    }

    public void addDataSource(@NotNull DBPDataSourceContainer dataSource) {
        DataSourceDescriptor descriptor = (DataSourceDescriptor)dataSource;
        this.addDataSourceToList(descriptor);
        if (!descriptor.isDetached()) {
            this.saveDataSources();
        }
        this.notifyDataSourceListeners(new DBPEvent(DBPEvent.Action.OBJECT_ADD, (DBSObject)descriptor, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDataSourceToList(@NotNull DataSourceDescriptor descriptor) {
        Map<String, DataSourceDescriptor> map = this.dataSources;
        synchronized (map) {
            this.dataSources.put(descriptor.getId(), descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataSource(@NotNull DBPDataSourceContainer dataSource) {
        DataSourceDescriptor descriptor = (DataSourceDescriptor)dataSource;
        Map<String, DataSourceDescriptor> map = this.dataSources;
        synchronized (map) {
            this.dataSources.remove(descriptor.getId());
        }
        if (!descriptor.isDetached()) {
            this.saveDataSources();
        }
        try {
            this.fireDataSourceEvent(DBPEvent.Action.OBJECT_REMOVE, (DBSObject)dataSource);
        }
        finally {
            descriptor.dispose();
        }
    }

    public void updateDataSource(@NotNull DBPDataSourceContainer dataSource) {
        if (!(dataSource instanceof DataSourceDescriptor)) {
            return;
        }
        if (!this.dataSources.containsKey(dataSource.getId())) {
            this.addDataSource(dataSource);
        } else {
            if (!((DataSourceDescriptor)dataSource).isDetached()) {
                this.saveDataSources();
            }
            this.fireDataSourceEvent(DBPEvent.Action.OBJECT_UPDATE, (DBSObject)dataSource);
        }
    }

    public void flushConfig() {
        if (this.project.isInMemory()) {
            return;
        }
        if (this.configSaver == null) {
            this.configSaver = new ConfigSaver();
        }
        this.configSaver.schedule(100L);
    }

    public void refreshConfig() {
        if (!this.saveInProgress) {
            this.loadDataSources(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataSourceListener(@NotNull DBPEventListener listener) {
        List<DBPEventListener> list = this.dataSourceListeners;
        synchronized (list) {
            this.dataSourceListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDataSourceListener(@NotNull DBPEventListener listener) {
        List<DBPEventListener> list = this.dataSourceListeners;
        synchronized (list) {
            return this.dataSourceListeners.remove(listener);
        }
    }

    private void fireDataSourceEvent(DBPEvent.Action action, DBSObject object) {
        this.notifyDataSourceListeners(new DBPEvent(action, object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDataSourceListeners(final DBPEvent event) {
        ArrayList<DBPEventListener> listeners;
        List<DBPEventListener> list = this.dataSourceListeners;
        synchronized (list) {
            if (this.dataSourceListeners.isEmpty()) {
                return;
            }
            listeners = new ArrayList<DBPEventListener>(this.dataSourceListeners);
        }
        new Job("Notify datasource events"){
            {
                super($anonymous0);
                this.setSystem(true);
            }

            protected IStatus run(IProgressMonitor monitor) {
                for (DBPEventListener listener : listeners) {
                    listener.handleDataSourceEvent(event);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    @NotNull
    public ISecurePreferences getSecurePreferences() {
        return this.platform.getApplication().getSecureStorage().getSecurePreferences().node("datasources");
    }

    public static boolean isProjectsInitialized() {
        for (DBPProject project : DBWorkbench.getPlatform().getWorkspace().getProjects()) {
            if (!project.isRegistryLoaded()) continue;
            return true;
        }
        return false;
    }

    public static List<DBPDataSourceContainer> getAllDataSources() {
        ArrayList<DBPDataSourceContainer> result = new ArrayList<DBPDataSourceContainer>();
        DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
        for (DBPProject project : workspace.getProjects()) {
            if (!project.isOpen() || !project.isRegistryLoaded()) continue;
            result.addAll(project.getDataSourceRegistry().getDataSources());
        }
        return result;
    }

    public List<? extends DBPDataSourceContainer> loadDataSourcesFromFile(@NotNull DBPDataSourceConfigurationStorage configurationStorage, @NotNull File fromFile) {
        ParseResults parseResults = new ParseResults();
        this.loadDataSources(fromFile, false, true, parseResults, configurationStorage);
        return new ArrayList<DBPDataSourceContainer>(parseResults.addedDataSources);
    }

    private void loadDataSources(boolean refresh) {
        int n;
        int n2;
        File[] fileArray;
        File[] mdFiles;
        if (!this.project.isOpen() || this.project.isInMemory()) {
            return;
        }
        this.savedFilters.clear();
        ParseResults parseResults = new ParseResults();
        boolean modernFormat = false;
        File metadataFolder = this.project.getMetadataFolder(false);
        if (metadataFolder.exists() && (mdFiles = metadataFolder.listFiles()) != null) {
            fileArray = mdFiles;
            n2 = mdFiles.length;
            n = 0;
            while (n < n2) {
                File file = fileArray[n];
                if (!file.isDirectory() && file.exists() && file.getName().startsWith("data-sources") && file.getName().endsWith(".json")) {
                    this.loadDataSources(file, refresh, true, parseResults);
                    modernFormat = true;
                }
                ++n;
            }
        }
        if (!modernFormat) {
            mdFiles = this.project.getAbsolutePath().listFiles();
            if (mdFiles != null) {
                fileArray = mdFiles;
                n2 = mdFiles.length;
                n = 0;
                while (n < n2) {
                    File file = fileArray[n];
                    if (!file.isDirectory() && file.exists() && file.getName().startsWith(".dbeaver-data-sources") && file.getName().endsWith(".xml")) {
                        this.loadDataSources(file, refresh, false, parseResults);
                    }
                    ++n;
                }
            }
            if (!this.origins.isEmpty()) {
                this.flushConfig();
            }
        }
        LinkedHashMap searchOptions = new LinkedHashMap();
        for (DataSourceConfigurationStorageDescriptor dataSourceConfigurationStorageDescriptor : DataSourceProviderRegistry.getInstance().getDataSourceConfigurationStorages()) {
            try {
                List loadedDS = dataSourceConfigurationStorageDescriptor.getInstance().loadDataSources((DBPDataSourceRegistry)this, searchOptions);
                if (loadedDS.isEmpty()) continue;
                parseResults.addedDataSources.addAll(loadedDS);
            }
            catch (Exception e) {
                log.error((Object)("Error loading data sources from storage '" + dataSourceConfigurationStorageDescriptor.getName() + "'"), (Throwable)e);
            }
        }
        if (refresh) {
            for (DBPDataSourceContainer ds : parseResults.updatedDataSources) {
                this.fireDataSourceEvent(DBPEvent.Action.OBJECT_UPDATE, (DBSObject)ds);
            }
            for (DBPDataSourceContainer ds : parseResults.addedDataSources) {
                this.fireDataSourceEvent(DBPEvent.Action.OBJECT_ADD, (DBSObject)ds);
            }
            ArrayList<DataSourceDescriptor> removedDataSource = new ArrayList<DataSourceDescriptor>();
            for (DataSourceDescriptor dataSourceDescriptor : this.dataSources.values()) {
                if (parseResults.addedDataSources.contains(dataSourceDescriptor) || parseResults.updatedDataSources.contains(dataSourceDescriptor) || dataSourceDescriptor.isProvided() || dataSourceDescriptor.getOrigin().isDynamic() || dataSourceDescriptor.isDetached()) continue;
                removedDataSource.add(dataSourceDescriptor);
            }
            for (DataSourceDescriptor dataSourceDescriptor : removedDataSource) {
                this.dataSources.remove(dataSourceDescriptor.getId());
                this.fireDataSourceEvent(DBPEvent.Action.OBJECT_REMOVE, (DBSObject)dataSourceDescriptor);
                dataSourceDescriptor.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDataSources(@NotNull File fromFile, boolean refresh, boolean modern, @NotNull ParseResults parseResults) {
        DataSourceOrigin origin;
        boolean extraConfig = !fromFile.getName().equalsIgnoreCase(modern ? "data-sources.json" : ".dbeaver-data-sources.xml");
        Map<File, DataSourceOrigin> map = this.origins;
        synchronized (map) {
            origin = this.origins.get(fromFile);
            if (origin == null) {
                origin = new DataSourceOrigin(fromFile, !extraConfig);
                this.origins.put(fromFile, origin);
            }
        }
        this.loadDataSources(fromFile, refresh, modern, parseResults, origin);
    }

    private void loadDataSources(@NotNull File fromFile, boolean refresh, boolean modern, @NotNull ParseResults parseResults, @NotNull DBPDataSourceConfigurationStorage configurationStorage) {
        if (!fromFile.exists()) {
            return;
        }
        try {
            DataSourceSerializer serializer = modern ? new DataSourceSerializerModern(this) : new DataSourceSerializerLegacy(this);
            serializer.parseDataSources(fromFile, configurationStorage, refresh, parseResults);
            this.updateProjectNature();
        }
        catch (Exception ex) {
            log.error((Object)("Error loading datasource config from " + fromFile.getAbsolutePath()), (Throwable)ex);
        }
    }

    private void saveDataSources() {
        if (this.project.isInMemory()) {
            return;
        }
        this.updateProjectNature();
        VoidProgressMonitor monitor = new VoidProgressMonitor();
        this.saveInProgress = true;
        try {
            for (DataSourceOrigin origin : this.origins.values()) {
                List<DataSourceDescriptor> localDataSources = this.getDataSources(origin);
                File configFile = origin.getSourceFile();
                if (origin.isDefault()) {
                    configFile = this.project.isModernProject() ? this.getModernConfigFile() : this.getLegacyConfigFile();
                } else {
                    String configFileName = configFile.getName();
                    if (configFileName.startsWith(".dbeaver-data-sources") && configFileName.endsWith(".xml")) {
                        String newFileName = "data-sources" + configFileName.substring(".dbeaver-data-sources".length());
                        int divPos = newFileName.lastIndexOf(".");
                        newFileName = String.valueOf(newFileName.substring(0, divPos)) + ".json";
                        configFile = new File(this.project.getMetadataFolder(false), newFileName);
                    }
                }
                try {
                    ContentUtils.makeFileBackup((File)configFile);
                    if (localDataSources.isEmpty()) {
                        if (configFile.exists() && !configFile.delete()) {
                            log.error((Object)("Error deleting file '" + configFile.getAbsolutePath() + "'"));
                        }
                    } else {
                        DataSourceSerializer serializer = !this.project.isModernProject() ? new DataSourceSerializerLegacy(this) : new DataSourceSerializerModern(this);
                        this.project.getMetadataFolder(true);
                        serializer.saveDataSources((DBRProgressMonitor)monitor, origin, localDataSources, configFile);
                    }
                    try {
                        this.getSecurePreferences().flush();
                    }
                    catch (Throwable e) {
                        log.error((Object)"Error saving secured preferences", e);
                    }
                }
                catch (Exception ex) {
                    log.error((Object)"Error saving datasources configuration", (Throwable)ex);
                }
            }
        }
        finally {
            this.saveInProgress = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DataSourceDescriptor> getDataSources(DataSourceOrigin origin) {
        ArrayList<DataSourceDescriptor> result = new ArrayList<DataSourceDescriptor>();
        Map<String, DataSourceDescriptor> map = this.dataSources;
        synchronized (map) {
            for (DataSourceDescriptor ds : this.dataSources.values()) {
                if (ds.getOrigin() != origin) continue;
                result.add(ds);
            }
        }
        return result;
    }

    private void updateProjectNature() {
        try {
            IProject eclipseProject = this.project.getEclipseProject();
            IProjectDescription description = eclipseProject.getDescription();
            if (description != null) {
                Object[] natureIds = description.getNatureIds();
                if (this.dataSources.isEmpty()) {
                    if (ArrayUtils.contains((Object[])natureIds, (Object)"org.jkiss.dbeaver.DBeaverNature")) {
                        description.setNatureIds((String[])ArrayUtils.remove(String.class, (Object[])natureIds, (Object)"org.jkiss.dbeaver.DBeaverNature"));
                        eclipseProject.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
                    }
                } else if (!ArrayUtils.contains((Object[])natureIds, (Object)"org.jkiss.dbeaver.DBeaverNature")) {
                    description.setNatureIds((String[])ArrayUtils.add(String.class, (Object[])natureIds, (Object)"org.jkiss.dbeaver.DBeaverNature"));
                    try {
                        eclipseProject.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        log.debug((Object)"Can't set project nature", (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
    }

    private void clearSecuredPasswords(DataSourceDescriptor dataSource) {
        try {
            dataSource.getSecurePreferences().removeNode();
        }
        catch (Throwable throwable) {
            log.debug((Object)("Error clearing '" + dataSource.getId() + "' secure storage"));
        }
    }

    public DBPProject getProject() {
        return this.project;
    }

    public String toString() {
        return String.valueOf(this.project.getName()) + " (" + this.getClass().getSimpleName() + ")";
    }

    private class ConfigSaver
    extends AbstractJob {
        ConfigSaver() {
            super("Datasource configuration save");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(DBRProgressMonitor monitor) {
            DataSourceRegistry dataSourceRegistry = DataSourceRegistry.this;
            synchronized (dataSourceRegistry) {
                DataSourceRegistry.this.saveDataSources();
            }
            return Status.OK_STATUS;
        }
    }

    private class DisconnectTask
    implements DBRRunnableWithProgress {
        boolean disconnected;

        private DisconnectTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            List dsSnapshot;
            monitor = new ProxyProgressMonitor((DBRProgressMonitor)monitor){

                public boolean isCanceled() {
                    return false;
                }
            };
            Map map = DataSourceRegistry.this.dataSources;
            synchronized (map) {
                dsSnapshot = CommonUtils.copyList(DataSourceRegistry.this.dataSources.values());
            }
            monitor.beginTask("Disconnect all databases", dsSnapshot.size());
            try {
                for (DataSourceDescriptor dataSource : dsSnapshot) {
                    if (monitor.isCanceled()) {
                        break;
                    }
                    if (dataSource.isConnected()) {
                        try {
                            monitor.subTask("Disconnect from [" + dataSource.getName() + "]");
                            this.disconnected = dataSource.disconnect((DBRProgressMonitor)monitor);
                        }
                        catch (Exception ex) {
                            log.error((Object)("Can't shutdown data source '" + dataSource.getName() + "'"), (Throwable)ex);
                        }
                    }
                    monitor.worked(1);
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    static class ParseResults {
        Set<DBPDataSourceContainer> updatedDataSources = new LinkedHashSet<DBPDataSourceContainer>();
        Set<DBPDataSourceContainer> addedDataSources = new LinkedHashSet<DBPDataSourceContainer>();

        ParseResults() {
        }
    }
}

