/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.xml;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.jkiss.dbeaver.Log;
import org.jkiss.utils.CommonUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLFormattingStrategy
extends ContextBasedFormattingStrategy {
    private static final Log log = Log.getLog(XMLFormattingStrategy.class);

    XMLFormattingStrategy() {
    }

    public void formatterStarts(String initialIndentation) {
    }

    public String format(String content, boolean isLineStart, String indentation, int[] positions) {
        if (CommonUtils.isEmpty((String)content)) {
            return content;
        }
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(content)));
            XPath xPath = XPathFactory.newInstance().newXPath();
            NodeList nodeList = (NodeList)xPath.evaluate("//text()[normalize-space()='']", document, XPathConstants.NODESET);
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                node.getParentNode().removeChild(node);
                ++i;
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", 2);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            if (!content.contains("<?xml")) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new StringWriter());
            transformer.transform(source, result);
            return result.getWriter().toString();
        }
        catch (Throwable e) {
            log.debug((Object)("Error formatting XML: " + e.getMessage()));
            return content;
        }
    }

    public void formatterStops() {
    }
}

