/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.TasksJob;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectBase;
import org.jkiss.utils.CommonUtils;

public class NavigatorHandlerObjectRename
extends NavigatorHandlerObjectBase {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection structSelection;
        Object element;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (element = (structSelection = (IStructuredSelection)selection).getFirstElement()) instanceof DBNNode) {
            NavigatorHandlerObjectRename.renameNode(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event), HandlerUtil.getActiveShell((ExecutionEvent)event), (DBNNode)element, null);
        }
        return null;
    }

    public static boolean renameNode(IWorkbenchWindow workbenchWindow, Shell shell, DBNNode node, String newName) {
        String oldName;
        String string = oldName = node instanceof DBNDatabaseNode ? ((DBNDatabaseNode)node).getPlainNodeName(true, false) : node.getNodeName();
        if (oldName == null) {
            oldName = "?";
        }
        if (newName == null) {
            newName = EnterNameDialog.chooseName((Shell)shell, (String)("Rename " + node.getNodeType()), (String)oldName);
        }
        if (CommonUtils.isEmpty((String)newName) || newName.equals(oldName)) {
            return false;
        }
        if (node.supportsRename()) {
            try {
                node.rename((DBRProgressMonitor)new VoidProgressMonitor(), newName);
                return true;
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Rename", "Can't rename object '" + oldName + "'", (Throwable)e);
            }
        }
        if (node instanceof DBNDatabaseNode) {
            return NavigatorHandlerObjectRename.renameDatabaseObject(workbenchWindow, (DBNDatabaseNode)node, CommonUtils.toString((Object)UIUtils.normalizePropertyValue((Object)newName)));
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean renameDatabaseObject(IWorkbenchWindow workbenchWindow, DBNDatabaseNode node, String newName) {
        try {
            if (!(node.getParentNode() instanceof DBNContainer)) return false;
            DBSObject object = node.getObject();
            if (object == null) return false;
            DBEObjectRenamer objectRenamer = (DBEObjectRenamer)DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(object.getClass(), DBEObjectRenamer.class);
            if (objectRenamer == null) return false;
            NavigatorHandlerObjectBase.CommandTarget commandTarget = NavigatorHandlerObjectRename.getCommandTarget(workbenchWindow, node.getParentNode(), object.getClass(), false);
            objectRenamer.renameObject(commandTarget.getContext(), object, newName);
            if (object.isPersisted() && commandTarget.getEditor() == null) {
                Map options = DBPScriptObject.EMPTY_OPTIONS;
                if (!NavigatorHandlerObjectRename.showScript(workbenchWindow, commandTarget.getContext(), options, "Rename script")) {
                    commandTarget.getContext().resetChanges(true);
                    return false;
                }
                NavigatorHandlerObjectBase.ObjectSaver renamer = new NavigatorHandlerObjectBase.ObjectSaver(commandTarget.getContext(), options);
                TasksJob.runTask((String)("Rename object '" + object.getName() + "'"), (DBRRunnableWithProgress)renamer);
                return true;
            }
            Iterator iterator = commandTarget.getContext().getFinalCommands().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return true;
                }
                DBECommand cfr_ignored_0 = (DBECommand)iterator.next();
            }
        }
        catch (Throwable e) {
            DBWorkbench.getPlatformUI().showError("Rename object", "Can't rename object '" + node.getNodeName() + "'", e);
            return false;
        }
    }
}

