/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.ui.tipoftheday;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

public class ShowTipOfTheDayDialog
extends BaseDialog {
    private static final Log log = Log.getLog(ShowTipOfTheDayDialog.class);
    private static final String DIALOG_ID = "DBeaver." + ShowTipOfTheDayDialog.class.getSimpleName();
    private List<String> tips = new ArrayList<String>();
    private boolean displayShowOnStartup;
    private boolean showOnStartup;
    private FormText formText;
    private int tipIndex;

    public ShowTipOfTheDayDialog(Shell parentShell) {
        super(parentShell, "Tip of the day", (DBPImage)DBIcon.TREE_INFO);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    public void addTip(String tip) {
        this.tips.add(tip);
    }

    protected Control createContents(Composite parent) {
        Composite contents = (Composite)super.createContents(parent);
        return contents;
    }

    protected Composite createDialogArea(Composite parent) {
        this.getShell().setText("Tip of the day");
        this.setTitle("Tip of the day");
        if (this.tips.isEmpty()) {
            this.tips.add("Empty tip list");
        }
        this.tipIndex = new Random(System.currentTimeMillis()).nextInt(this.tips.size());
        Font dialogFont = JFaceResources.getDialogFont();
        FontData[] fontData = dialogFont.getFontData();
        int i = 0;
        while (i < fontData.length) {
            FontData fd = fontData[i];
            fontData[i] = new FontData(fd.getName(), fd.getHeight() + 1, 0);
            ++i;
        }
        Font largeFont = new Font(dialogFont.getDevice(), fontData);
        parent.addDisposeListener(e -> largeFont.dispose());
        Composite dialogArea = super.createDialogArea(parent);
        Composite tipArea = new Composite(dialogArea, 2048);
        tipArea.setLayoutData((Object)new GridData(1808));
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        tipArea.setLayout((Layout)gl);
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        toolkit.setBorderStyle(0);
        Form form = toolkit.createForm(tipArea);
        form.setLayoutData((Object)new GridData(1808));
        form.setLayout((Layout)new GridLayout(1, true));
        form.getBody().setLayoutData((Object)new GridData(1808));
        form.getBody().setLayout((Layout)new GridLayout(1, true));
        this.formText = new FormText(form.getBody(), 524352);
        this.formText.marginWidth = 1;
        this.formText.marginHeight = 0;
        this.formText.setHyperlinkSettings((HyperlinkSettings)toolkit.getHyperlinkGroup());
        toolkit.adapt((Control)this.formText, false, false);
        this.formText.setMenu(form.getBody().getMenu());
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        gd.heightHint = 100;
        this.formText.setLayoutData((Object)gd);
        this.formText.setFont(largeFont);
        this.formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ShowTipOfTheDayDialog.this.navigateLink(e);
            }
        });
        this.showTip();
        if (this.displayShowOnStartup) {
            final Button showTipButton = toolkit.createButton(form.getBody(), "Show tips on startup", 32);
            showTipButton.setSelection(this.showOnStartup);
            showTipButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ShowTipOfTheDayDialog.this.showOnStartup = showTipButton.getSelection();
                }
            });
            form.getBody().setTabList(new Control[]{showTipButton});
        }
        return dialogArea;
    }

    private void navigateLink(HyperlinkEvent e) {
        Object href = e.getHref();
        if (href != null) {
            String linkURL = href.toString();
            if (linkURL.startsWith("http:") || linkURL.startsWith("https:")) {
                UIUtils.launchProgram((String)linkURL);
            } else if (linkURL.startsWith("prefs:")) {
                String prefPageId = linkURL.substring(linkURL.indexOf("//") + 2);
                this.buttonPressed(0);
                UIUtils.asyncExec(() -> UIUtils.showPreferencesFor((Shell)UIUtils.getActiveWorkbenchShell(), null, (String[])new String[]{prefPageId}));
            } else if (linkURL.startsWith("view:")) {
                String viewId = linkURL.substring(linkURL.indexOf("//") + 2);
                this.buttonPressed(0);
                UIUtils.asyncExec(() -> {
                    try {
                        UIUtils.getActiveWorkbenchWindow().getActivePage().showView(viewId);
                    }
                    catch (PartInitException e1) {
                        DBWorkbench.getPlatformUI().showError("Open view", "Error opening view " + viewId, (Throwable)e1);
                    }
                });
            }
        }
    }

    private void showTip() {
        String tipText = "<form><p>" + this.tips.get(this.tipIndex) + "</p></form>";
        try {
            this.formText.setText(tipText, true, false);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 14, IDialogConstants.BACK_LABEL, false);
        this.createButton(parent, 15, IDialogConstants.NEXT_LABEL, false);
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
        UIUtils.asyncExec(() -> {
            boolean bl = this.getButton(0).setFocus();
        });
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 14: {
                this.tipIndex = this.tipIndex == 0 ? this.tips.size() - 1 : this.tipIndex - 1;
                this.showTip();
                return;
            }
            case 15: {
                this.tipIndex = this.tipIndex == this.tips.size() - 1 ? 0 : this.tipIndex + 1;
                this.showTip();
                return;
            }
        }
        super.buttonPressed(buttonId);
    }

    public boolean isDisplayShowOnStartup() {
        return this.displayShowOnStartup;
    }

    public void setDisplayShowOnStartup(boolean displayShowOnStartup) {
        this.displayShowOnStartup = displayShowOnStartup;
    }

    public boolean isShowOnStartup() {
        return this.showOnStartup;
    }

    public void setShowOnStartup(boolean showOnStartup) {
        this.showOnStartup = showOnStartup;
    }
}

