/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.ui.console;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAPasswordChangeInfo;
import org.jkiss.dbeaver.model.connection.DBPAuthInfo;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverDependencies;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProcessDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.LoggingProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class ConsoleUserInterface
implements DBPPlatformUI {
    private static final Log log = Log.getLog(ConsoleUserInterface.class);

    @Override
    public DBPPlatformUI.UserResponse showError(@NotNull String title, @Nullable String message, @NotNull IStatus status) {
        System.out.println(String.valueOf(title) + (message == null ? "" : ": " + message));
        this.printStatus(status, 0);
        return DBPPlatformUI.UserResponse.OK;
    }

    @Override
    public DBPPlatformUI.UserResponse showError(@NotNull String title, @Nullable String message, @NotNull Throwable e) {
        System.out.println(String.valueOf(title) + (message == null ? "" : ": " + message));
        e.printStackTrace(System.out);
        return DBPPlatformUI.UserResponse.OK;
    }

    @Override
    public DBPPlatformUI.UserResponse showError(@NotNull String title, @Nullable String message) {
        System.out.println(String.valueOf(title) + (message == null ? "" : ": " + message));
        return DBPPlatformUI.UserResponse.OK;
    }

    @Override
    public void showMessageBox(String title, String message, boolean error) {
        System.out.println(String.valueOf(title) + (message == null ? "" : ": " + message));
    }

    @Override
    public void showWarningMessageBox(@NotNull String title, @Nullable String message) {
        System.out.println(String.valueOf(title) + (message == null ? "" : ": " + message));
    }

    @Override
    public boolean confirmAction(String title, String message) {
        return false;
    }

    @Override
    public DBPPlatformUI.UserResponse showErrorStopRetryIgnore(String task, Throwable error, boolean queue) {
        System.out.println(task);
        error.printStackTrace(System.out);
        return DBPPlatformUI.UserResponse.IGNORE;
    }

    @Override
    public long getLongOperationTimeout() {
        return 0L;
    }

    @Override
    public void notifyAgent(String message, int status) {
    }

    private void printStatus(@NotNull IStatus status, int level) {
        char[] indent = new char[level * 4];
        int i = 0;
        while (i < indent.length) {
            indent[i] = 32;
            ++i;
        }
        if (status.getMessage() != null) {
            System.out.println(indent + status.getMessage());
        }
        if (status.getException() != null) {
            status.getException().printStackTrace(System.out);
        }
    }

    @Override
    public DBPAuthInfo promptUserCredentials(String prompt, String userName, String userPassword, boolean passwordOnly, boolean showSavePassword) {
        return null;
    }

    @Override
    public DBAPasswordChangeInfo promptUserPasswordChange(String prompt, String userName, String oldPassword) {
        return null;
    }

    @Override
    public boolean acceptLicense(String message, String licenseText) {
        return true;
    }

    @Override
    public boolean downloadDriverFiles(DBPDriver driverDescriptor, DBPDriverDependencies dependencies) {
        return false;
    }

    @Override
    public DBNNode selectObject(@NotNull Object parentShell, String title, DBNNode rootNode, DBNNode selectedNode, Class<?>[] allowedTypes, Class<?>[] resultTypes, Class<?>[] leafTypes) {
        return null;
    }

    @Override
    public void openEntityEditor(@NotNull DBSObject object) {
    }

    @Override
    public void openEntityEditor(@NotNull DBNNode selectedNode, String defaultPageId) {
    }

    @Override
    public void openConnectionEditor(@NotNull DBPDataSourceContainer dataSourceContainer) {
    }

    @Override
    public void executeProcess(@NotNull DBRProcessDescriptor processDescriptor) {
        try {
            processDescriptor.execute();
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Execute process", processDescriptor.getName(), e);
        }
    }

    @Override
    public void executeWithProgress(@NotNull Runnable runnable) {
        runnable.run();
    }

    @Override
    public void executeWithProgress(@NotNull DBRRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        runnable.run(new LoggingProgressMonitor());
    }

    @Override
    @NotNull
    public <RESULT> Job createLoadingService(final ILoadService<RESULT> loadingService, final ILoadVisualizer<RESULT> visualizer) {
        return new AbstractJob(loadingService.getServiceName()){

            @Override
            protected IStatus run(DBRProgressMonitor monitor) {
                try {
                    Object result = loadingService.evaluate(monitor);
                    visualizer.completeLoading(result);
                    return Status.OK_STATUS;
                }
                catch (InvocationTargetException e) {
                    return GeneralUtils.makeExceptionStatus(e.getTargetException());
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
            }
        };
    }

    @Override
    public void refreshPartState(Object part) {
    }

    @Override
    public void copyTextToClipboard(String text, boolean htmlFormat) {
    }

    @Override
    public void executeShellProgram(String shellCommand) {
        File filePath = new File(shellCommand);
        if (filePath.exists() && filePath.isDirectory()) {
            System.out.println("Open directory '" + shellCommand + "'");
            return;
        }
        try {
            Runtime.getRuntime().exec(shellCommand);
        }
        catch (Exception e) {
            log.error(e);
        }
    }

    @Override
    public boolean readAndDispatchEvents() {
        return false;
    }
}

