/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.jobs;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.jobs.InvalidateJob;

class KeepAlivePingJob
extends AbstractJob {
    private static final Log log = Log.getLog(KeepAlivePingJob.class);
    private final DBPDataSource dataSource;

    KeepAlivePingJob(DBPDataSource dataSource) {
        super("Connection ping (" + dataSource.getContainer().getName() + ")");
        this.setUser(false);
        this.setSystem(true);
        this.dataSource = dataSource;
    }

    @Override
    protected IStatus run(DBRProgressMonitor monitor) {
        for (DBSInstance dBSInstance : this.dataSource.getAvailableInstances()) {
            DBCExecutionContext[] dBCExecutionContextArray = dBSInstance.getAllContexts();
            int n = dBCExecutionContextArray.length;
            int n2 = 0;
            while (n2 < n) {
                block4: {
                    DBCExecutionContext context = dBCExecutionContextArray[n2];
                    try {
                        context.checkContextAlive(monitor);
                    }
                    catch (Exception e) {
                        List<InvalidateJob.ContextInvalidateResult> results;
                        log.debug("Context [" + this.dataSource.getName() + "::" + context.getContextName() + "] check failed: " + e.getMessage());
                        if (!(e instanceof DBException) || !this.isSuccess(results = InvalidateJob.invalidateDataSource(monitor, this.dataSource, false, false, () -> DBWorkbench.getPlatformUI().openConnectionEditor(this.dataSource.getContainer())))) break block4;
                        log.debug("Connection invalidated: " + results);
                    }
                }
                ++n2;
            }
        }
        return Status.OK_STATUS;
    }

    private boolean isSuccess(List<InvalidateJob.ContextInvalidateResult> results) {
        for (InvalidateJob.ContextInvalidateResult result : results) {
            switch (result.result) {
                case CONNECTED: 
                case RECONNECTED: 
                case ALIVE: {
                    return true;
                }
            }
        }
        return false;
    }
}

