/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.runtime;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRBlockingObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.ArrayUtils;

public class DefaultProgressMonitor
implements DBRProgressMonitor {
    private static final Log log = Log.getLog(DefaultProgressMonitor.class);
    private IProgressMonitor nestedMonitor;
    private List<DBRBlockingObject> blocks = null;
    private ProgressState[] states = new ProgressState[0];

    public DefaultProgressMonitor(IProgressMonitor nestedMonitor) {
        this.nestedMonitor = nestedMonitor;
    }

    @Override
    public IProgressMonitor getNestedMonitor() {
        return this.nestedMonitor;
    }

    @Override
    public void beginTask(String name, int totalWork) {
        ProgressState state = new ProgressState(name, totalWork);
        this.states = (ProgressState[])ArrayUtils.add(ProgressState.class, (Object[])this.states, (Object)state);
        this.nestedMonitor.beginTask(name, totalWork);
    }

    @Override
    public void done() {
        if (this.states.length == 0) {
            log.debug(new DBCException("Progress ended without start"));
        } else {
            ArrayUtils.remove(ProgressState.class, (Object[])this.states, (int)(this.states.length - 1));
        }
        this.nestedMonitor.done();
        if (this.states.length > 0) {
            ProgressState lastState = this.states[this.states.length - 1];
            this.nestedMonitor.beginTask(lastState.taskName, lastState.totalWork);
            if (lastState.subTask != null) {
                this.nestedMonitor.subTask(lastState.subTask);
            }
            if (lastState.progress > 0) {
                this.nestedMonitor.worked(lastState.progress);
            }
        }
    }

    @Override
    public void subTask(String name) {
        if (this.states.length == 0) {
            log.debug(new DBCException("Progress sub task without start"));
        } else {
            this.states[this.states.length - 1].subTask = name;
        }
        this.nestedMonitor.subTask(name);
    }

    @Override
    public void worked(int work) {
        if (this.states.length == 0) {
            log.debug(new DBCException("Progress info without start"));
        } else {
            this.states[this.states.length - 1].progress += work;
        }
        this.nestedMonitor.worked(work);
    }

    @Override
    public boolean isCanceled() {
        return this.nestedMonitor.isCanceled() || DBWorkbench.getPlatform().isShuttingDown();
    }

    @Override
    public synchronized void startBlock(DBRBlockingObject object, String taskName) {
        if (taskName != null) {
            this.subTask(taskName);
        }
        if (this.blocks == null) {
            this.blocks = new ArrayList<DBRBlockingObject>();
        }
        this.blocks.add(object);
    }

    @Override
    public synchronized void endBlock() {
        if (this.blocks == null || this.blocks.isEmpty()) {
            log.warn("End block invoked while no blocking objects are in stack");
            return;
        }
        this.blocks.remove(this.blocks.size() - 1);
    }

    @Override
    public synchronized List<DBRBlockingObject> getActiveBlocks() {
        return this.blocks == null || this.blocks.isEmpty() ? null : new ArrayList<DBRBlockingObject>(this.blocks);
    }

    private static class ProgressState {
        final String taskName;
        final int totalWork;
        int progress;
        String subTask;

        ProgressState(String taskName, int totalWork) {
            this.taskName = taskName;
            this.totalWork = totalWork;
        }
    }
}

