/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.ui;

import javax.net.ssl.SSLSocketFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.registry.driver.DriverClassFindJob;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpen;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.ui.dialogs.net.SSLConfiguratorAbstractUI;
import org.jkiss.utils.CommonUtils;

public class PostgreSSLConfigurator
extends SSLConfiguratorAbstractUI {
    private static final boolean ENABLE_PROXY = false;
    public static final String[] SSL_MODES = new String[]{"", "disable", "allow", "prefer", "require", "verify-ca", "verify-full"};
    private TextWithOpen rootCertText;
    private TextWithOpen clientCertText;
    private TextWithOpen clientKeyText;
    private Combo sslModeCombo;
    private Combo sslFactoryCombo;
    private Button useProxyService;
    private boolean sslClassesResolved;

    public void createControl(Composite parent, Runnable propertyChangeListener) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(1808);
        gd.minimumHeight = 200;
        composite.setLayoutData((Object)gd);
        this.createSSLConfigHint(composite, true, 1);
        Group certGroup = UIUtils.createControlGroup((Composite)composite, (String)PostgreMessages.dialog_connection_network_postgres_ssl_certificates, (int)2, (int)768, (int)-1);
        UIUtils.createControlLabel((Composite)certGroup, (String)PostgreMessages.dialog_connection_network_postgres_ssl_certificates_root);
        gd = new GridData(768);
        gd.minimumWidth = 130;
        this.rootCertText = new TextWithOpenFile((Composite)certGroup, PostgreMessages.dialog_connection_network_postgres_ssl_certificates_ca, new String[]{"*.*", "*.crt", "*.cert", "*.pem", "*"});
        this.rootCertText.setLayoutData((Object)new GridData(768));
        UIUtils.createControlLabel((Composite)certGroup, (String)PostgreMessages.dialog_connection_network_postgres_ssl_certificates_ssl);
        gd = new GridData(768);
        gd.minimumWidth = 130;
        this.clientCertText = new TextWithOpenFile((Composite)certGroup, PostgreMessages.dialog_connection_network_postgres_ssl_certificates_ssl, new String[]{"*.*", "*.cert", "*.pem", "*"});
        this.clientCertText.setLayoutData((Object)new GridData(768));
        UIUtils.createControlLabel((Composite)certGroup, (String)PostgreMessages.dialog_connection_network_postgres_ssl_certificates_ssl_key);
        gd = new GridData(768);
        gd.minimumWidth = 130;
        this.clientKeyText = new TextWithOpenFile((Composite)certGroup, PostgreMessages.dialog_connection_network_postgres_ssl_certificates_ssl, new String[]{"*.*", "*.cert", "*.pem", "*"});
        this.clientKeyText.setLayoutData((Object)new GridData(768));
        Group advGroup = UIUtils.createControlGroup((Composite)composite, (String)PostgreMessages.dialog_connection_network_postgres_ssl_advanced, (int)2, (int)768, (int)-1);
        this.sslModeCombo = UIUtils.createLabelCombo((Composite)advGroup, (String)PostgreMessages.dialog_connection_network_postgres_ssl_advanced_ssl_mode, (int)12);
        this.sslModeCombo.setLayoutData((Object)new GridData(32));
        String[] stringArray = SSL_MODES;
        int n = SSL_MODES.length;
        int n2 = 0;
        while (n2 < n) {
            String mode = stringArray[n2];
            this.sslModeCombo.add(mode);
            ++n2;
        }
        this.sslFactoryCombo = UIUtils.createLabelCombo((Composite)advGroup, (String)PostgreMessages.dialog_connection_network_postgres_ssl_advanced_ssl_factory, (int)4);
    }

    public void loadSettings(final DBWHandlerConfiguration configuration) {
        this.clientCertText.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("clientCert")));
        this.clientKeyText.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("clientKey")));
        this.rootCertText.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("rootCert")));
        UIUtils.setComboSelection((Combo)this.sslModeCombo, (String)CommonUtils.notEmpty((String)configuration.getStringProperty("sslMode")));
        if (!this.sslClassesResolved) {
            this.sslClassesResolved = true;
            Job resolveJob = new Job("Find factories"){
                {
                    super($anonymous0);
                    this.setUser(true);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    DriverClassFindJob finder = new DriverClassFindJob(configuration.getDriver(), SSLSocketFactory.class.getName(), false);
                    finder.run((DBRProgressMonitor)new DefaultProgressMonitor(monitor));
                    UIUtils.syncExec(() -> {
                        PostgreSSLConfigurator.this.sslFactoryCombo.removeAll();
                        for (String cn : finder.getDriverClassNames()) {
                            PostgreSSLConfigurator.this.sslFactoryCombo.add(cn);
                        }
                        String factoryValue = configuration.getStringProperty("sslFactory");
                        if (!CommonUtils.isEmpty((String)factoryValue)) {
                            PostgreSSLConfigurator.this.sslFactoryCombo.setText(factoryValue);
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            resolveJob.schedule();
        }
    }

    public void saveSettings(DBWHandlerConfiguration configuration) {
        configuration.setProperty("rootCert", (Object)this.rootCertText.getText().trim());
        configuration.setProperty("clientCert", (Object)this.clientCertText.getText().trim());
        configuration.setProperty("clientKey", (Object)this.clientKeyText.getText().trim());
        configuration.setProperty("sslMode", (Object)this.sslModeCombo.getText());
        configuration.setProperty("sslFactory", (Object)this.sslFactoryCombo.getText());
    }
}

