/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tools;

import java.util.Collection;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreDatabaseBackupInfo;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreDatabaseBackupSettings;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreBackupRestoreWizard;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreBackupWizardPageObjects;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreBackupWizardPageSettings;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.registry.task.TaskPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

class PostgreBackupWizard
extends PostgreBackupRestoreWizard<PostgreDatabaseBackupSettings, PostgreDatabaseBackupInfo>
implements IExportWizard {
    private PostgreBackupWizardPageObjects objectsPage;
    private PostgreBackupWizardPageSettings settingsPage;

    PostgreBackupWizard(DBTTask task) {
        super(task);
    }

    PostgreBackupWizard(Collection<DBSObject> objects) {
        super(objects, PostgreMessages.wizard_backup_title);
        ((PostgreDatabaseBackupSettings)this.getSettings()).fillExportObjectsFromInput();
    }

    public String getTaskTypeId() {
        return "pgDatabaseBackup";
    }

    public void saveTaskState(DBRRunnableContext runnableContext, DBTTask task, Map<String, Object> state) {
        this.objectsPage.saveState();
        this.settingsPage.saveState();
        ((PostgreDatabaseBackupSettings)this.getSettings()).saveSettings(runnableContext, (DBPPreferenceStore)new TaskPreferenceStore(state));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.objectsPage = new PostgreBackupWizardPageObjects(this);
        this.settingsPage = new PostgreBackupWizardPageSettings(this);
    }

    public void addPages() {
        this.addTaskConfigPages();
        this.addPage((IWizardPage)this.objectsPage);
        this.addPage((IWizardPage)this.settingsPage);
        super.addPages();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.settingsPage) {
            return null;
        }
        return super.getNextPage(page);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.logPage) {
            return this.settingsPage;
        }
        return super.getPreviousPage(page);
    }

    public void onSuccess(long workTime) {
        UIUtils.showMessageBox((Shell)this.getShell(), (String)PostgreMessages.wizard_backup_msgbox_success_title, (String)NLS.bind((String)PostgreMessages.wizard_backup_msgbox_success_description, (Object)CommonUtils.truncateString((String)this.getObjectsName(), (int)255)), (int)2);
        UIUtils.launchProgram((String)((PostgreDatabaseBackupSettings)this.getSettings()).getOutputFolder().getAbsolutePath());
    }

    protected PostgreDatabaseBackupSettings createSettings() {
        return new PostgreDatabaseBackupSettings();
    }
}

